/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.objectstorage;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.dbtools.core.oci.AuthenticationProvider;
import oracle.dbtools.core.oci.objectstorage.OCIObjectStorageClient;
import oracle.dbtools.core.oci.objectstorage.ObjectGetOptions;
import oracle.dbtools.core.oci.objectstorage.ObjectGetResult;
import oracle.dbtools.core.oci.objectstorage.ObjectStorageException;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageCommandException;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageMessages;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageModel;
import oracle.dbtools.net.commands.objectstorage.ObjectStorageOptions;

public class ObjectGet {
    private final String avoidEtag;
    private final String bucketName;
    private String eTag;
    private final Path filePath;
    private final String namespace;
    private final String objectName;
    private final ObjectStorageModel model;
    private static final String NEW_LINE = System.getProperty("line.separator");

    public ObjectGet(ObjectStorageModel model) throws ObjectStorageCommandException {
        this.validate(model);
        this.model = model;
        this.namespace = model.namespace();
        this.bucketName = model.bucketName();
        this.objectName = model.optionValue(ObjectStorageOptions.Symbol.OBJECT_NAME);
        this.filePath = model.filePath();
        this.eTag = model.optionValue(ObjectStorageOptions.Symbol.ETAG);
        this.avoidEtag = model.optionValue(ObjectStorageOptions.Symbol.AVOID_ETAG_MATCH);
    }

    public void execute() {
        try {
            OCIObjectStorageClient client = OCIObjectStorageClient.builder((AuthenticationProvider)this.model.profile()).build();
            ObjectGetOptions options = ObjectGetOptions.builder((String)this.namespace, (String)this.bucketName, (String)this.objectName, (Path)this.filePath).eTag(this.eTag).avoidEtag(this.avoidEtag).build();
            ObjectGetResult result = client.getObject(options);
            if (result != null) {
                int httpStatusCode = result.getStatusCode();
                if (httpStatusCode == 200 || httpStatusCode == 206) {
                    if (result.getFilePath() != null && Files.exists(result.getFilePath(), new LinkOption[0])) {
                        this.model.context().writeln(ObjectStorageMessages.format("OBJECT_GET_SUCCESS", this.objectName, this.filePath));
                    } else {
                        this.model.context().writeln(ObjectStorageMessages.format("ERR_DOWNLOAD_FILE", this.objectName, this.filePath));
                    }
                } else {
                    String objectETag;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ObjectStorageMessages.format("ERR_DOWNLOAD_FILE", this.objectName, this.filePath));
                    sb.append(NEW_LINE);
                    if (this.avoidEtag != null && (objectETag = result.getETag()) != null && this.avoidEtag.equals(objectETag)) {
                        sb.append(ObjectStorageMessages.format("ERR_AVOID_ETAG_MATCH", objectETag));
                        sb.append(NEW_LINE);
                    }
                    sb.append(ObjectStorageMessages.format("STATUS_CODE", httpStatusCode));
                    this.model.context().writeln(sb.toString());
                }
            }
        }
        catch (ObjectStorageException e) {
            this.model.context().writeln(e.getLocalizedMessage());
        }
    }

    private void validate(ObjectStorageModel model) throws ObjectStorageCommandException {
        StringBuilder sb = new StringBuilder();
        if (ObjectGet.isEmpty(model.namespace())) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_NAMESPACE")).append(NEW_LINE);
        }
        if (ObjectGet.isEmpty(model.bucketName())) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_BUCKETNAME")).append(NEW_LINE);
        }
        if (ObjectGet.isEmpty(model.optionValue(ObjectStorageOptions.Symbol.OBJECT_NAME))) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_OBJECTNAME")).append(NEW_LINE);
        }
        if (ObjectGet.isEmpty(model.optionValue(ObjectStorageOptions.Symbol.FILE))) {
            sb.append(ObjectStorageMessages.get("ERR_REQUIRE_OPTION_FILE")).append(NEW_LINE);
        }
        if (!ObjectGet.isEmpty(model.optionValue(ObjectStorageOptions.Symbol.AVOID_ETAG_MATCH)) && !ObjectGet.isEmpty(model.optionValue(ObjectStorageOptions.Symbol.ETAG))) {
            sb.append(ObjectStorageMessages.format("ERR_OPTION_ETAG_AND_AVOID_ETAG", model.optionValue(ObjectStorageOptions.Symbol.ETAG), model.optionValue(ObjectStorageOptions.Symbol.AVOID_ETAG_MATCH))).append(NEW_LINE);
        }
        if (sb.length() > 0) {
            throw new ObjectStorageCommandException(sb.toString());
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }
}

