/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands.completers;

import java.io.IOException;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.net.commands.completers.CompartmentCompleter;
import oracle.dbtools.net.commands.completers.CompartmentPathMapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.util.Logger;

public class CompartmentTransformer
implements Transformer<String, String> {
    private final CompartmentPathMapper compartmentPathMapper;
    private final CompartmentCompleter compartmentCompleter;

    public CompartmentTransformer(CompartmentPathMapper compartmentPathMapper) {
        this(compartmentPathMapper, CompartmentCompleter.ofDisplayNames(compartmentPathMapper));
    }

    public CompartmentTransformer(CompartmentPathMapper compartmentPathMapper, CompartmentCompleter compartmentCompleter) {
        this.compartmentPathMapper = compartmentPathMapper;
        this.compartmentCompleter = compartmentCompleter;
    }

    public String transform(String rawValue, TransformContext context, Environment environment) {
        ScriptRunnerContext ctx;
        String profileName;
        if (!rawValue.isBlank() && (profileName = (ctx = environment.getCtx()).getStringProperty("oci.profile.name", null)) != null) {
            try {
                OCIProfile profile = this.compartmentCompleter.getProfile(null, profileName);
                return this.compartmentPathMapper.pathToOcid(profile, rawValue).orElse(rawValue);
            }
            catch (IOException | RuntimeException e) {
                Logger.warn(this.getClass(), (String)e.getMessage(), (Throwable)e);
            }
        }
        return rawValue;
    }
}

