/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.net.commands;

import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.net.commands.CommandMessages;
import oracle.dbtools.raptor.deployment.DbmsCloudAPI;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.transfer.location.Location;
import oracle.dbtools.transfer.location.OracleDbDirectoryLocation;
import oracle.dbtools.transfer.location.OracleDbmsCloudStorageLocation;
import oracle.dbtools.transfer.location.OracleOciStorageLocation;
import oracle.dbtools.util.Logger;

public class CSCommon {
    public static final String CLOUD_STORAGE = "cloud.storage";
    public static final String TRANSFER = "transfer";
    public static final String CLOUD_STORAGE_TRANSFER = "cloud.storage.transfer";
    public static final String TRANSFER_OCI = "transfer.oci";
    public static final String TRANSFER_DBMS_CLOUD = "transfer.dbms_cloud";
    public static final String CLOUD_URL = "cloud_url";
    public static final String DBMS_CLOUD_CREDENTIAL = "dbms.cloud.credential";
    public static final String OCI_PROFILE_NAME = "oci.profile.name";
    public static final String DBMS_CLOUD = "dbms_cloud";
    public static final String DBCC = "dbcc";
    public static final String DBC_CRED = "dbc_cred";
    public static final String DBCCRED = "dbccred";
    public static final String DBC = "dbc";
    public static final String OCI = "oci";
    public static final String SWIFT = "swift";
    public static final String CREDENTIAL = "credential";
    public static final String CREDENTIALS = "credentials";
    public static final String CRED = "cred";
    public static final String PROFILE = "profile";
    public static final String SECTION = "section";
    public static final String QUALIFIER = "qualifier";
    public static final String Q = "q";
    public static final String CLEAR = "clear";
    public static final String HELP = "help";
    public static final String SHOW = "show";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String DQUOTE = "\"";
    private static final String SQUOTE = "'";
    private static final String NL = "\n";
    private static final String SPACE = " ";
    private static final Class<?> clazz = CSCommon.class;

    public static String getCredential(String cred) {
        if (cred != null && !cred.startsWith(DQUOTE) && !cred.endsWith(DQUOTE)) {
            return cred.toUpperCase();
        }
        return cred;
    }

    public static String checkCredential(ScriptRunnerContext ctx) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        String cred = (String)props.get(DBMS_CLOUD_CREDENTIAL);
        if (cred == null) {
            ctx.write(CommandMessages.getString("DBC_MISSING_CRED"));
        }
        return cred;
    }

    public static void setCredential(String cred) {
        CSCommon.setCredentialAndWarn(null, cred, false);
    }

    public static void setCredentialAndWarn(ScriptRunnerContext ctx, String cred) {
        CSCommon.setCredentialAndWarn(ctx, cred, true);
    }

    public static void setCredentialAndWarn(ScriptRunnerContext ctx, String cred, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        props.put(DBMS_CLOUD_CREDENTIAL, cred);
        if (warn && ctx != null) {
            ctx.write(CommandMessages.format("CSCREDSET", cred) + NL);
        }
        CSCommon.setTransferAndWarn(ctx, TRANSFER_DBMS_CLOUD, warn);
    }

    public static void resetCredential(String cred) {
        CSCommon.resetCredentialAndWarn(null, cred, false);
    }

    public static void resetCredentialAndWarn(ScriptRunnerContext ctx, String cred) {
        CSCommon.resetCredentialAndWarn(ctx, cred, true);
    }

    public static void resetCredentialAndWarn(ScriptRunnerContext ctx, String cred, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        props.remove(DBMS_CLOUD_CREDENTIAL);
        if (warn && ctx != null) {
            ctx.write(CommandMessages.format("CSCREDCLR", cred) + NL);
        }
        CSCommon.resetTransferAndWarn(ctx, TRANSFER_DBMS_CLOUD, warn);
    }

    public static void setProfile(String profile) {
        CSCommon.setCredentialAndWarn(null, profile, false);
    }

    public static void setProfileAndWarn(ScriptRunnerContext ctx, String profile) {
        CSCommon.setCredentialAndWarn(ctx, profile, true);
    }

    public static void setProfileAndWarn(ScriptRunnerContext ctx, String profile, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        ctx.putProperty(OCI_PROFILE_NAME, (Object)profile);
        props.put(OCI_PROFILE_NAME, profile);
        if (warn && ctx != null) {
            ctx.write(CommandMessages.format("CSPROFSET", profile) + NL);
        }
        CSCommon.setTransferAndWarn(ctx, TRANSFER_OCI, warn);
    }

    public static void resetProfile(String profile) {
        CSCommon.resetProfileAndWarn(null, profile, false);
    }

    public static void resetProfileAndWarn(ScriptRunnerContext ctx, String profile) {
        CSCommon.resetProfileAndWarn(ctx, profile, true);
    }

    public static void resetProfileAndWarn(ScriptRunnerContext ctx, String profile, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        ctx.removeProperty(OCI_PROFILE_NAME);
        props.remove(OCI_PROFILE_NAME);
        if (warn && ctx != null) {
            ctx.write(CommandMessages.format("CSPROFCLR", profile) + NL);
        }
        CSCommon.resetTransferAndWarn(ctx, TRANSFER_OCI);
    }

    public static void setTransfer(String transfer) {
        CSCommon.setTransferAndWarn(null, transfer, false);
    }

    public static void setTransferAndWarn(ScriptRunnerContext ctx, String transfer) {
        CSCommon.setTransferAndWarn(ctx, transfer, true);
    }

    public static void setTransferAndWarn(ScriptRunnerContext ctx, String transfer, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        props.put(TRANSFER, transfer);
        if (warn && ctx != null) {
            ctx.write(CommandMessages.format("CSTRANSFERSET", transfer.substring(9)) + NL);
        }
    }

    public static void resetTransfer(String transfer) {
        CSCommon.resetTransferAndWarn(null, transfer, false);
    }

    public static void resetTransferAndWarn(ScriptRunnerContext ctx, String transfer) {
        CSCommon.resetTransferAndWarn(ctx, transfer, true);
    }

    public static void resetTransferAndWarn(ScriptRunnerContext ctx, String transfer, boolean warn) {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        if ((String)props.get(TRANSFER) != null && ((String)props.get(TRANSFER)).equals(transfer)) {
            props.remove(TRANSFER);
            if (warn && ctx != null) {
                ctx.write(CommandMessages.format("CSTRANSFERCLR", transfer) + NL);
            }
        }
    }

    public static CloudStorageUrl getCloudStorageUrl(ScriptRunnerContext ctx, String qualifier) throws MalformedURLException {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        CloudStorageUrl csUrl = (CloudStorageUrl)props.get(CLOUD_URL);
        if (csUrl == null) {
            if (qualifier == null) {
                return null;
            }
            csUrl = new CloudStorageUrl(qualifier);
        } else if (qualifier != null) {
            csUrl = new CloudStorageUrl(csUrl.getFinalUrl());
            csUrl.qualifiedUrl(qualifier);
        }
        return csUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsCredential(ScriptRunnerContext ctx, Connection conn, String credential) {
        DbmsCloudAPI dcApi = new DbmsCloudAPI();
        boolean exists = false;
        try {
            dcApi.startService(null, conn);
            exists = dcApi.existsCredential(credential);
        }
        catch (Exception e) {
            Logger.info(clazz, (String)e.getLocalizedMessage());
            ctx.write(e.getLocalizedMessage() + NL);
            boolean bl = false;
            return bl;
        }
        finally {
            dcApi.finishService();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCredential(ScriptRunnerContext ctx, Connection conn, String cred, String attribute, String value) {
        DbmsCloudAPI dcApi = new DbmsCloudAPI();
        try {
            dcApi.startService(null, conn);
            dcApi.updateCredential(cred, attribute, value);
            ctx.write(CommandMessages.format("DBC_CRED_UPDATED", cred) + NL);
            CSCommon.setCredentialAndWarn(ctx, cred);
        }
        catch (Exception e) {
            ctx.write(CommandMessages.getString("DBC_CRED_CR8_OCI") + SPACE + cred + SPACE + value + SPACE + e.getLocalizedMessage() + NL);
        }
        finally {
            dcApi.finishService();
        }
    }

    public static Location getLocation(ScriptRunnerContext ctx, Connection conn) throws IOException {
        return CSCommon.getLocation(ctx, conn, null);
    }

    public static Location getLocation(ScriptRunnerContext ctx, Connection conn, String qualifier) throws IOException {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        return CSCommon.getLocation(props, conn, qualifier);
    }

    public static Location getLocation(Map<String, Object> props, Connection conn) throws IOException {
        return CSCommon.getLocation(props, conn, (String)props.get(QUALIFIER));
    }

    public static Location getLocation(Map<String, Object> props, Connection conn, String qualifier) throws IOException {
        String transfer = CSCommon.getTransfer(props);
        if (transfer == null) {
            throw new IOException(CommandMessages.getString("CS_PROFILE_OR_CRED_REQ") + NL);
        }
        switch (transfer) {
            case "transfer.oci": {
                return CSCommon.getOciLocation(props, qualifier);
            }
            case "transfer.dbms_cloud": {
                return CSCommon.getDbmsCloudLocation(props, conn, qualifier);
            }
        }
        return null;
    }

    public static Location getOciLocation(Map<String, Object> props) throws IOException {
        return CSCommon.getOciLocation(props, null);
    }

    public static Location getOciLocation(Map<String, Object> props, String qualifier) throws IOException {
        CloudStorageUrl csUrl = (CloudStorageUrl)props.get(CLOUD_URL);
        if (qualifier != null && csUrl != null) {
            csUrl = new CloudStorageUrl(csUrl.getFinalUrl());
            csUrl.qualifiedUrl(qualifier);
        } else if (qualifier != null) {
            csUrl = new CloudStorageUrl(qualifier);
        }
        if (csUrl == null) {
            throw new IOException(CommandMessages.getString("CSMISSING_URL") + "\n\n");
        }
        String profile = (String)props.get(OCI_PROFILE_NAME);
        if (profile == null || profile.isEmpty()) {
            throw new IOException(CommandMessages.getString("CSMISSING_PROFILE") + "\n\n");
        }
        return new OracleOciStorageLocation(csUrl, profile);
    }

    private static OracleDbmsCloudStorageLocation getDbmsCloudLocation(Map<String, Object> props, Connection conn) throws IOException {
        return CSCommon.getDbmsCloudLocation(props, conn, null);
    }

    public static OracleDbmsCloudStorageLocation getDbmsCloudLocation(Map<String, Object> props, Connection conn, String qualifier) throws IOException {
        CloudStorageUrl csUrl = (CloudStorageUrl)props.get(CLOUD_URL);
        if (qualifier != null && csUrl != null) {
            csUrl = new CloudStorageUrl(csUrl.getFinalUrl());
            csUrl.qualifiedUrl(qualifier);
        } else if (qualifier != null) {
            csUrl = new CloudStorageUrl(qualifier);
        }
        if (csUrl == null) {
            throw new IOException(CommandMessages.getString("CSMISSING_URL") + "\n\n");
        }
        String credential = (String)props.get(DBMS_CLOUD_CREDENTIAL);
        if (credential == null || credential.isEmpty()) {
            throw new IOException(CommandMessages.getString("DBC_MISSING_CRED") + "\n\n");
        }
        return new OracleDbmsCloudStorageLocation(csUrl, credential, conn);
    }

    public static OracleDbDirectoryLocation getDbDirectoryLocation(Connection conn) throws IOException {
        return new OracleDbDirectoryLocation(conn);
    }

    private static String getTransfer(ScriptRunnerContext ctx) throws IOException {
        Map props = (Map)ctx.getProperty(CLOUD_STORAGE);
        return CSCommon.getTransfer(props);
    }

    private static String getTransfer(Map<String, Object> props) throws IOException {
        String transfer = (String)props.get(TRANSFER);
        String profile = (String)props.get(OCI_PROFILE_NAME);
        String cred = (String)props.get(DBMS_CLOUD_CREDENTIAL);
        if (transfer == null) {
            if (profile != null && cred != null) {
                throw new IOException(CommandMessages.getString("CS_PROFILE_AND_CRED"));
            }
            if (profile != null) {
                transfer = TRANSFER_OCI;
            } else if (cred != null) {
                transfer = TRANSFER_DBMS_CLOUD;
            } else {
                throw new IOException(CommandMessages.getString("CS_PROFILE_OR_CRED_REQ"));
            }
        }
        return transfer;
    }

    public static void writeFormatMissing(ScriptRunnerContext ctx, String option) {
        ctx.write(CommandMessages.format("CSMISSINGVALUE", option) + NL);
    }

    public static void writeFormatBad(ScriptRunnerContext ctx, String option) {
        ctx.write(CommandMessages.format("CSFORMATBAD", option) + NL);
    }

    public static void writeFormatUnX(ScriptRunnerContext ctx, String option) {
        ctx.write(CommandMessages.format("DBC_UNEXPECTED", option) + NL);
    }

    public static String unQuote(String word) {
        if (word.startsWith(SQUOTE) && word.endsWith(SQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        if (word.startsWith(DQUOTE) && word.endsWith(DQUOTE)) {
            return word.substring(1, word.length() - 1);
        }
        return word;
    }

    public String[] splitObjectName(String object) {
        String[] parts = new String[2];
        parts[0] = this.getObjectOwner(object);
        if (parts[0] != null && !parts[0].startsWith(DQUOTE) && !parts[0].endsWith(DQUOTE)) {
            parts[0] = parts[0].toUpperCase();
        }
        parts[1] = this.getObjectName(object);
        if (parts[1] != null && !parts[1].startsWith(DQUOTE) && !parts[1].endsWith(DQUOTE)) {
            parts[1] = parts[1].toUpperCase();
        }
        return parts;
    }

    private String getObjectName(String object) {
        if (object == null) {
            return null;
        }
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return names[0];
        }
        if (names.length == 2) {
            return names[1];
        }
        return object;
    }

    private String getObjectOwner(String object) {
        if (object == null) {
            return null;
        }
        String[] names = object.split("\\.");
        if (names.length == 1) {
            return null;
        }
        if (names.length == 2) {
            return names[0];
        }
        return null;
    }

    protected static IOException asIOException(Throwable t) {
        if (t instanceof IOException) {
            return (IOException)t;
        }
        Throwable c = t.getCause();
        if (c instanceof IOException) {
            return (IOException)c;
        }
        return new IOException(t);
    }
}

