/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.readers;

import java.io.FileInputStream;
import java.io.InputStream;
import oracle.dbtools.cmdline.Messages;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.XLSReader;
import oracle.dbtools.util.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSXReader
extends XLSReader {
    public static String NAME = Messages.getString("XLSXReader.0");
    public static final String FORMAT = "XLSX".toLowerCase();
    public static final String EXT = "XLSX".toUpperCase();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getType() {
        return EXT;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    protected XSSFWorkbook newWorkbook(FileInputStream reader) throws DataReaderException {
        try {
            return new XSSFWorkbook((InputStream)reader);
        }
        catch (Throwable e) {
            Logger.severe(XLSReader.class, (Throwable)e);
            throw new DataReaderException(e.getMessage());
        }
    }
}

