/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.importer.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.data.formattors.CharFormattor;
import oracle.dbtools.data.formattors.ITypeFormattor;
import oracle.dbtools.data.loadservice.ExitCode;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.model.GenericTable;
import oracle.dbtools.data.model.LoadField;
import oracle.dbtools.data.model.LoadFile;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.importer.ImportResources;
import oracle.dbtools.importer.core.CloudStorageUtils;
import oracle.dbtools.importer.core.ConfigException;
import oracle.dbtools.importer.core.ImportDataFormat;
import oracle.dbtools.importer.core.ImportKeys;
import oracle.dbtools.importer.core.ImportProperties;
import oracle.dbtools.importer.formattors.DataTypeFormatterRegistry;
import oracle.dbtools.importer.readers.DataReaderException;
import oracle.dbtools.importer.readers.DataReaderRegistry;
import oracle.dbtools.importer.readers.DataReaderUtils;
import oracle.dbtools.importer.readers.IDataReadable;
import oracle.dbtools.raptor.format.IFormatOptions;
import oracle.dbtools.raptor.utils.MessageHandler;
import oracle.dbtools.raptor.utils.XLIFFHelper;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportXMLUtil {
    private static String _term = "\n";
    Boolean _import = false;
    boolean _isLoaded = false;
    private DOMParser _parser;
    boolean _cancel = false;
    private ImportDataFormat _dataFormat;
    GenericTable _table;
    private ImportProperties _iProps;
    private String _rootNodeName;
    private OutputStreamWriter _out;
    private IDataReadable _datareader;

    private DOMParser getParser() {
        if (this._parser == null) {
            this._parser = new DOMParser();
        } else {
            this._parser.reset();
        }
        return this._parser;
    }

    public void parseXML(InputStreamReader xml, boolean editable, String pkg) {
        DOMParser parser = this.getParser();
        parser.setPreserveWhitespace(false);
        this._iProps = new ImportProperties();
        try {
            parser.parse((Reader)xml);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        XMLDocument doc = parser.getDocument();
        this.processNode((Node)doc, editable);
        this._isLoaded = true;
    }

    public void parseXML(InputStream xml, boolean editable) {
        DOMParser parser = this.getParser();
        parser.setPreserveWhitespace(false);
        this._iProps = new ImportProperties();
        try {
            parser.parse(xml);
            XMLDocument doc = parser.getDocument();
            this.processNode((Node)doc, editable);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        this._isLoaded = true;
    }

    public void parseXML(InputStreamReader xml, boolean editable) {
        DOMParser parser = this.getParser();
        parser.setPreserveWhitespace(false);
        this._iProps = new ImportProperties();
        try {
            parser.parse((Reader)xml);
            XMLDocument doc = parser.getDocument();
            this.processNode((Node)doc, editable);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        this._isLoaded = true;
    }

    public String getNodeValue(Node node, XML_KEYS key) {
        return XMLHelper.getNodeValue((Node)node, (String)key.toString());
    }

    public String getNodeValue(Node node, ImportKeys key) {
        return XMLHelper.getNodeValue((Node)node, (String)key.toString());
    }

    public ImportProperties getProperties() {
        return this._iProps;
    }

    public String getPropertyValue(ImportKeys key) {
        return (String)this._iProps.get(key);
    }

    public int getPropertyValueInt(ImportKeys key) {
        return this._iProps.get(key) == null ? -1 : (Integer)this._iProps.get(key);
    }

    public boolean getPropertyValueBoolean(ImportKeys key) {
        return this._iProps.get(key) == null ? false : (Boolean)this._iProps.get(key);
    }

    public Object getPropertyValueObject(ImportKeys key) {
        return this._iProps.get(key);
    }

    public String getTool() {
        return this._rootNodeName;
    }

    private void processNode(Node node, boolean editable) {
        NodeList children = node.getChildNodes();
        if (this._rootNodeName == null) {
            this._rootNodeName = children.item(0).getNodeName();
            if (!children.item(0).getNodeName().equals(XML_KEYS.IMPORT_TOOL.toString())) {
                return;
            }
        }
        for (int i = 0; i < children.getLength() && !this._cancel; ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.DBOBJECT.toString())) {
                this.processDbObject(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.CONNECTION_SETTINGS.toString())) {
                this.processConnection(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FILE_SETTINGS.toString())) {
                this.processFileObject(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.IMPORT_DATA_FORMAT.toString())) {
                this.processDataFormat(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FILE_FIELDS.toString())) {
                this.processFileFields(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.FILE_COLUMNS.toString())) {
                this.processFileColumns(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.TABLE_COLUMNS.toString())) {
                this.processTableColumns(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.SELECTED_COLUMNS.toString())) {
                this.processSelectedColumns(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(ImportKeys.SELECTABLE_COLUMNS.toString())) {
                this.processSelectableColumns(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.LOAD_METHOD_SETTINGS.toString())) {
                this.processLoadMethod(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.MATCH.toString())) {
                this.processMatch(children.item(i), editable);
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString())) {
                this.processExternalOptions(children.item(i), editable);
                continue;
            }
            if (!children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.IMPORT_TOOL.toString())) continue;
            this.processNode(children.item(i), editable);
        }
    }

    private void processConnection(Node node, boolean editable) {
        if (node != null) {
            this._iProps.put(ImportKeys.CONNECTION_NAME, this.notNull(this.getNodeValue(node, ImportKeys.CONNECTION_NAME)));
            this._iProps.put(ImportKeys.CONNECTION_USER, this.notNull(this.getNodeValue(node, ImportKeys.CONNECTION_USER)));
            this._iProps.put(ImportKeys.IS_DWCS, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_DWCS)));
        }
    }

    public void processDbObject(Node node, boolean editable) {
        if (node != null) {
            String sourceConnName = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_CONNECTION));
            String objectType = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_TYPE));
            String schema = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_SCHEMA));
            String name = this.notNull(this.getNodeValue(node, ImportKeys.OBJECT_NAME));
            BasicDBObject dbo = BasicDBObject.builder().connName(sourceConnName).schema(schema).objectType(objectType).objectName(name).build();
            this._iProps.put(ImportKeys.DBOBJECT, dbo);
        }
    }

    public void processFileObject(Node node, boolean editable) {
        if (node != null) {
            boolean isOss = this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_SOURCE_OSS));
            this._iProps.put(ImportKeys.IS_SOURCE_OSS, isOss);
            LoadFile loadFile = null;
            if (isOss) {
                this._iProps.put(ImportKeys.OSS_PATH, this.notNull(this.getNodeValue(node, ImportKeys.OSS_PATH)));
                this._iProps.put(ImportKeys.OSS_CREDENTIAL, this.notNull(this.getNodeValue(node, ImportKeys.OSS_CREDENTIAL)));
                loadFile = new LoadFile(this.notNull(this.getNodeValue(node, ImportKeys.OSS_PATH)));
            } else {
                this._iProps.put(ImportKeys.FILE_PATH, this.notNull(this.getNodeValue(node, ImportKeys.FILE_PATH)));
                loadFile = new LoadFile(this.notNull(this.getNodeValue(node, ImportKeys.FILE_PATH)));
            }
            this._iProps.put(ImportKeys.LOAD_FILE, loadFile);
        }
    }

    public void processDataFormat(Node node, boolean editable) {
        if (node != null) {
            this._dataFormat = new ImportDataFormat(BaseDataFormat.IMPORT_WIZARD, this.notNull(this.getNodeValue(node, ImportKeys.DATA_FORMAT)));
            this._dataFormat.setEncoding(this.notNull(this.getNodeValue(node, ImportKeys.ENCODING)));
            this._dataFormat.setUsePreviewLimit(this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_PREVIEW_LIMIT)));
            this._dataFormat.setPreviewLimit(this.convertPosInt(this.getNodeValue(node, ImportKeys.PREVIEW_LIMIT)));
            this._dataFormat.setUseMaxLength(this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_MAX_LENGTH)));
            this._dataFormat.setMaxLength(this.convertPosInt(this.getNodeValue(node, ImportKeys.MAX_LENGTH)));
            this._dataFormat.setPageId(this.convertPosInt(this.getNodeValue(node, ImportKeys.PAGEID)));
            this._dataFormat.setWorksheet(this.notNull(this.getNodeValue(node, ImportKeys.WORKSHEET_NAME)));
            IFormatOptions options = this._dataFormat.getOptions();
            if (options.isHeaderOptionSupported()) {
                this._dataFormat.isHeader(this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_HEADER)));
                this._dataFormat.setHeaderLocation(this.convertPosInt(this.getNodeValue(node, ImportKeys.HEADER_LOCATION)));
            }
            this._dataFormat.setSkipRows(this.convertPosInt(this.getNodeValue(node, ImportKeys.SKIP_ROWS)));
            if (options.isDelimiterSupported()) {
                String delimiter = ImportDataFormat.getDelimiterFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.DELIMITER)));
                if (delimiter == null || delimiter.isEmpty()) {
                    delimiter = ",";
                }
                this._dataFormat.setDelimiter(delimiter);
            }
            if (options.isEnclosuresSupported()) {
                this._dataFormat.setEnclosureLeft(ImportDataFormat.getEnclosureFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.ENCLOSURE_LEFT))));
                this._dataFormat.setEnclosureRight(ImportDataFormat.getEnclosureFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.ENCLOSURE_RIGHT))));
                this._dataFormat.isEnclosureRightDouble(this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_ENCLOSURE_RIGHT_DOUBLE)));
            }
            if (options.isLineTerminatorSupported()) {
                this._dataFormat.setRecordTerminator(ImportDataFormat.getRecordTerminatorFromConfigValue(this.notNull(this.getNodeValue(node, ImportKeys.RECORD_TERMINATOR))));
            }
            this._iProps.put(ImportKeys.IMPORT_DATA_FORMAT, this._dataFormat);
        }
    }

    public void processFileFields(Node node, boolean editable) {
        LoadFile loadFile = (LoadFile)this._iProps.get(ImportKeys.LOAD_FILE);
        if (loadFile != null) {
            loadFile.setFields(this.getFields(node.getChildNodes()));
        }
    }

    public void processFileColumns(Node node, boolean editable) {
        this._iProps.put(ImportKeys.FILE_COLUMNS, this.getColumns(node.getChildNodes()));
    }

    public void processTableColumns(Node node, boolean editable) {
        this._iProps.put(ImportKeys.TABLE_COLUMNS, this.getColumns(node.getChildNodes()));
    }

    public void processSelectedColumns(Node node, boolean editable) {
        this._iProps.put(ImportKeys.SELECTED_COLUMNS, this.getColumnsFromReference(node.getChildNodes()));
    }

    public void processSelectableColumns(Node node, boolean editable) {
        this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, this.getColumnsFromReference(node.getChildNodes()));
    }

    private LoadField[] getFields(NodeList children) {
        LoadField[] fields = new LoadField[children.getLength()];
        for (int i = 0; i < children.getLength() && !this._cancel; ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FIELD.toString())) continue;
            LoadField field = new LoadField();
            field.setName(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.FIELD_NAME)));
            field.setLength(Integer.parseInt(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.FIELD_LENGTH))));
            fields[i] = field;
        }
        return fields;
    }

    private Column[] getColumns(NodeList children) {
        Column[] columns = new Column[children.getLength()];
        for (int i = 0; i < children.getLength() && !this._cancel; ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.COLUMN.toString())) continue;
            Column col = new Column();
            col.setName(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.TABLE_COL_NAME)));
            col.setSourceColumnName(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.SOURCE_COL_NAME)));
            col.setSourceColID(Integer.parseInt(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.SOURCE_COL_ID))));
            col.setType(this.getNodeValue(children.item(i), XML_KEYS.TYPE));
            col.setPrecision(Integer.parseInt(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.PRECISION))));
            col.setScale(Integer.parseInt(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.SCALE))));
            col.setDefault(this.getNodeValue(children.item(i), XML_KEYS.DEFAULT));
            col.setFormat(this.getNodeValue(children.item(i), XML_KEYS.FORMAT));
            col.setComment(this.getNodeValue(children.item(i), XML_KEYS.COMMENT));
            col.setNullable(Boolean.parseBoolean(this.notNull(this.getNodeValue(children.item(i), XML_KEYS.NULLABLE))));
            col.setEditable(Boolean.parseBoolean(this.notNullBooleanDefaultTrue(this.getNodeValue(children.item(i), XML_KEYS.EDITABLE))));
            columns[i] = col;
        }
        return columns;
    }

    private Column[] getColumnsFromReference(NodeList children) {
        Column[] columns = new Column[children.getLength()];
        block0: for (int i = 0; i < children.getLength() && !this._cancel; ++i) {
            String childSourceColName = this.notNull(this.getNodeValue(children.item(i), XML_KEYS.SOURCE_COL_NAME));
            Column[] fileColumns = (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS);
            if (!children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.COLUMN_REFERENCE.toString()) || fileColumns == null) continue;
            for (Column col : (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS)) {
                String sourceColName = col.getSourceColumnName();
                if (sourceColName == null || !sourceColName.equals(childSourceColName)) continue;
                columns[i] = col;
                continue block0;
            }
        }
        return columns;
    }

    public void processLoadMethod(Node node, boolean editable) {
        if (node != null) {
            this._iProps.put(ImportKeys.LOAD_METHOD, this.convertPosInt(this.getNodeValue(node, ImportKeys.LOAD_METHOD)));
            this._iProps.put(ImportKeys.STAGING_TABLE_NAME, this.notNull(this.getNodeValue(node, ImportKeys.STAGING_TABLE_NAME)));
            this._iProps.put(ImportKeys.DROP_STAGING_TABLE, this.convertBoolean(this.getNodeValue(node, ImportKeys.DROP_STAGING_TABLE)));
            this._iProps.put(ImportKeys.IS_EXISTING_TABLE, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_EXISTING_TABLE)));
            this._iProps.put(ImportKeys.TABLE_NAME, this.notNull(this.getNodeValue(node, ImportKeys.TABLE_NAME)));
            this._iProps.put(ImportKeys.USE_LOAD_LIMIT, this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_LOAD_LIMIT)));
            this._iProps.put(ImportKeys.LOAD_LIMIT, this.convertPosInt(this.getNodeValue(node, ImportKeys.LOAD_LIMIT)));
            this._iProps.put(ImportKeys.SEND_TO_WORKSHEET, this.convertBoolean(this.getNodeValue(node, ImportKeys.SEND_TO_WORKSHEET)));
        }
    }

    public void processMatch(Node node, boolean editable) {
        if (node != null) {
            this._iProps.put(ImportKeys.MATCH_BY_TYPE, this.convertPosInt(this.getNodeValue(node, ImportKeys.MATCH_BY_TYPE)));
        }
    }

    private void processExternalOptions(Node node, boolean editable) {
        boolean isOss = this._iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
        boolean isCart = this._iProps.getValueBoolean(ImportKeys.IS_CART);
        this._iProps.put(ImportKeys.CONVERSION_ERRORS, this.convertPosInt(this.getNodeValue(node, ImportKeys.CONVERSION_ERRORS)));
        this._iProps.put(ImportKeys.DATE_MASK_DATE, this.notNull(this.getNodeValue(node, ImportKeys.DATE_MASK_DATE)));
        this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMP, this.notNull(this.getNodeValue(node, ImportKeys.DATE_MASK_TIMESTAMP)));
        this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPTZ, this.notNull(this.getNodeValue(node, ImportKeys.DATE_MASK_TIMESTAMPTZ)));
        this._iProps.put(ImportKeys.DATE_MASK_TIMESTAMPLTZ, this.notNull(this.getNodeValue(node, ImportKeys.DATE_MASK_TIMESTAMPLTZ)));
        this._iProps.put(ImportKeys.IS_BLANK_COLS, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_BLANK_COLS)));
        this._iProps.put(ImportKeys.IS_TRUNCATE_COLS, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_TRUNCATE_COLS)));
        this._iProps.put(ImportKeys.MISSING_FIELDS, this.convertPosInt(this.getNodeValue(node, ImportKeys.MISSING_FIELDS)));
        this._iProps.put(ImportKeys.NULL_ROWS, this.convertPosInt(this.getNodeValue(node, ImportKeys.NULL_ROWS)));
        this._iProps.put(ImportKeys.USE_REJECT_LIMIT, this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_REJECT_LIMIT)));
        this._iProps.put(ImportKeys.REJECT_LIMIT, this.convertPosInt(this.getNodeValue(node, ImportKeys.REJECT_LIMIT)));
        this._iProps.put(ImportKeys.TRIM, this.convertPosInt(this.getNodeValue(node, ImportKeys.TRIM)));
        this._iProps.put(ImportKeys.IS_COPY_LOG, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_COPY_LOG)));
        this._iProps.put(ImportKeys.IS_COPY_BAD, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_COPY_BAD)));
        this._iProps.put(ImportKeys.IS_DROP_BAD_AND_LOG, this.convertBoolean(this.getNodeValue(node, ImportKeys.IS_DROP_BAD_AND_LOG)));
        this._iProps.put(ImportKeys.USE_VALIDATE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_VALIDATE)));
        this._iProps.put(ImportKeys.USE_VALIDATE_LIMIT, this.convertBoolean(this.getNodeValue(node, ImportKeys.USE_VALIDATE_LIMIT)));
        this._iProps.put(ImportKeys.VALIDATE_LIMIT, this.convertPosInt(this.getNodeValue(node, ImportKeys.VALIDATE_LIMIT)));
        if (!isOss) {
            this._iProps.put(ImportKeys.DIRPATH, this.notNull(this.getNodeValue(node, ImportKeys.DIRPATH)));
            this._iProps.put(ImportKeys.ORADIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORADIRNAME)));
            this._iProps.put(ImportKeys.USEBADFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEBADFILE)));
            this._iProps.put(ImportKeys.ORABADDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORABADDIRNAME)));
            this._iProps.put(ImportKeys.USELOGFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USELOGFILE)));
            this._iProps.put(ImportKeys.ORALOGDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORALOGDIRNAME)));
            this._iProps.put(ImportKeys.USEDISCARDFILE, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEDISCARDFILE)));
            this._iProps.put(ImportKeys.ORADISCARDDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.ORADISCARDDIRNAME)));
            this._iProps.put(ImportKeys.BADDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.BADDIRNAME)));
            this._iProps.put(ImportKeys.LOGDIRNAME, this.notNull(this.getNodeValue(node, ImportKeys.LOGDIRNAME)));
            this._iProps.put(ImportKeys.USEGENDIR, this.convertBoolean(this.getNodeValue(node, ImportKeys.USEGENDIR)));
            this._iProps.put(ImportKeys.GENDIR, this.notNull(this.getNodeValue(node, ImportKeys.GENDIR)));
            this._iProps.put(ImportKeys.FILEOUTNEWLINE, this.notNull(this.getNodeValue(node, ImportKeys.FILEOUTNEWLINE)));
        }
        this._iProps.put(ImportKeys.CHARNUMCHARACTERS, this.getNodeValue(node, ImportKeys.CHARNUMCHARACTERS));
        this._iProps.put(ImportKeys.CHARSETVAL, this.notNull(this.getNodeValue(node, ImportKeys.CHARSETVAL)));
        String value = this.getNodeValue(node, ImportKeys.IS_GENERATE_CHARSET);
        if (value == null || value.equals("null") || value.isEmpty()) {
            this._iProps.put(ImportKeys.IS_GENERATE_CHARSET, !this.notNull(this.getNodeValue(node, ImportKeys.CHARSETVAL)).isEmpty());
        } else {
            this._iProps.put(ImportKeys.IS_GENERATE_CHARSET, this.convertBoolean(value));
        }
    }

    public String notNull(String value) {
        if (value == null || value.equals("null")) {
            return "";
        }
        return value;
    }

    public String notNullBoolean(String value) {
        if (value == null || value.equals("null") || value.equals("false") || value.isEmpty()) {
            return "false";
        }
        return "true";
    }

    public String notNullBooleanDefaultTrue(String value) {
        if (value == null || value.equals("null") || value.equals("true") || value.isEmpty()) {
            return "true";
        }
        return "false";
    }

    public boolean convertBoolean(String value) {
        return value != null && !value.equals("null") && !value.equals("false") && !value.isEmpty();
    }

    public int convertPosInt(String value) {
        if (value == null || value.equals("null") || value.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public void setImport(Boolean _import) {
        this._import = _import;
    }

    public void parseXML(InputStreamReader userXml, boolean b, String pkg, XLIFFHelper xliffHelper) {
        this.parseXML(userXml, b, pkg);
    }

    public void saveConfigOptions(File configFile, ImportProperties iProps, String encoding) {
        try {
            FileOutputStream fout = new FileOutputStream(configFile);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            this._out = new OutputStreamWriter((OutputStream)bout, encoding);
            this._out.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>" + _term);
            this.outStartGroup(XML_KEYS.IMPORT_TOOL.toString(), 0);
            boolean isCart = iProps.getValueBoolean(ImportKeys.IS_CART);
            boolean isOss = iProps.getValueBoolean(ImportKeys.IS_SOURCE_OSS);
            boolean isDwcs = iProps.getValueBoolean(ImportKeys.IS_DWCS);
            LoadFile loadFile = (LoadFile)iProps.get(ImportKeys.LOAD_FILE);
            this.outStartGroup(XML_KEYS.FILE_SETTINGS.toString(), 0);
            this.outBool(ImportKeys.IS_SOURCE_OSS.toString(), isOss, 1);
            if (!isOss) {
                this.outString(ImportKeys.FILE_PATH.toString(), loadFile.getName(), 1);
            } else {
                this.outString(ImportKeys.OSS_PATH.toString(), (String)iProps.get(ImportKeys.OSS_PATH), 1);
                this.outString(ImportKeys.OSS_CREDENTIAL.toString(), (String)iProps.get(ImportKeys.OSS_CREDENTIAL), 1);
            }
            this.outEndGroup(XML_KEYS.FILE_SETTINGS.toString(), 0);
            this.outStartGroup(XML_KEYS.CONNECTION_SETTINGS.toString(), 0);
            this.outString(ImportKeys.CONNECTION_NAME.toString(), (String)iProps.get(ImportKeys.CONNECTION_NAME), 1);
            if (isDwcs) {
                this.outBool(ImportKeys.IS_DWCS.toString(), isDwcs, 1);
            }
            this.outEndGroup(XML_KEYS.CONNECTION_SETTINGS.toString(), 0);
            if (!isCart || ((Boolean)iProps.get(ImportKeys.IS_EXISTING_TABLE)).booleanValue()) {
                BasicDBObject dbo = (BasicDBObject)iProps.get(ImportKeys.DBOBJECT);
                this.outStartGroup(ImportKeys.DBOBJECT.toString(), 0);
                this.outString(ImportKeys.OBJECT_CONNECTION.toString(), dbo != null ? dbo.getConnectionName() : "", 1);
                this.outString(ImportKeys.OBJECT_TYPE.toString(), dbo != null ? dbo.getObjectType() : "", 1);
                this.outString(ImportKeys.OBJECT_SCHEMA.toString(), dbo != null ? dbo.getSchemaName() : "", 1);
                this.outString(ImportKeys.OBJECT_NAME.toString(), dbo != null ? dbo.getObjectName() : "", 1);
                this.outEndGroup(ImportKeys.DBOBJECT.toString(), 0);
            } else if (isOss) {
                // empty if block
            }
            ImportDataFormat dataFormat = (ImportDataFormat)iProps.get(ImportKeys.IMPORT_DATA_FORMAT);
            this.outStartGroup(ImportKeys.IMPORT_DATA_FORMAT.toString(), 0);
            this.outString(ImportKeys.DATA_FORMAT.toString(), dataFormat.getFormat(), 1);
            this.outString(ImportKeys.ENCODING.toString(), dataFormat.getEncoding(), 1);
            this.outBool(ImportKeys.USE_PREVIEW_LIMIT.toString(), dataFormat.getUsePreviewLimit(), 1);
            this.outInt(ImportKeys.PREVIEW_LIMIT.toString(), dataFormat.getPreviewLimit(), 1);
            this.outBool(ImportKeys.USE_MAX_LENGTH.toString(), dataFormat.getUseMaxLength(), 1);
            this.outInt(ImportKeys.MAX_LENGTH.toString(), dataFormat.getMaxLength(), 1);
            this.outInt(ImportKeys.PAGEID.toString(), dataFormat.getPageId(), 1);
            this.outString(ImportKeys.WORKSHEET_NAME.toString(), dataFormat.getWorksneet(), 1);
            IFormatOptions options = dataFormat.getOptions();
            if (options.isHeaderOptionSupported()) {
                this.outBool(ImportKeys.IS_HEADER.toString(), dataFormat.isHeader(), 1);
                this.outInt(ImportKeys.HEADER_LOCATION.toString(), dataFormat.getHeaderLocation(), 2);
            }
            this.outInt(ImportKeys.SKIP_ROWS.toString(), dataFormat.getSkipRows(), 1);
            if (options.isDelimiterSupported()) {
                this.outString(ImportKeys.DELIMITER.toString(), ImportDataFormat.getDelimiterForConfigValue(dataFormat.getDelimiter()), 1);
            }
            if (options.isEnclosuresSupported()) {
                this.outString(ImportKeys.ENCLOSURE_LEFT.toString(), ImportDataFormat.getEnclosureForConfigValue(dataFormat.getEnclosureLeftValue()), 1);
                this.outString(ImportKeys.ENCLOSURE_RIGHT.toString(), ImportDataFormat.getEnclosureForConfigValue(dataFormat.getEnclosureRightValue()), 1);
                this.outBool(ImportKeys.IS_ENCLOSURE_RIGHT_DOUBLE.toString(), dataFormat.isEnclosureRightDouble(), 1);
            }
            if (options.isLineTerminatorSupported()) {
                this.outString(ImportKeys.RECORD_TERMINATOR.toString(), ImportDataFormat.getRecordTerminatorForConfigValue(dataFormat.getRecordTerminator()), 1);
            }
            this.outEndGroup(ImportKeys.IMPORT_DATA_FORMAT.toString(), 0);
            Locale locale = (Locale)iProps.get(ImportKeys.LOCALE);
            this.outStartGroup(XML_KEYS.LOCALE.toString(), 0);
            this.outString(ImportKeys.LANGUAGE.toString(), locale.getLanguage(), 1);
            this.outString(ImportKeys.COUNTRY.toString(), locale.getCountry(), 1);
            this.outString(ImportKeys.VARIANT.toString(), locale.getVariant(), 1);
            this.outEndGroup(XML_KEYS.LOCALE.toString(), 0);
            this.outStartGroup(XML_KEYS.FILE_FIELDS.toString(), 0);
            this.outFields((LoadFile)iProps.get(ImportKeys.LOAD_FILE), 1);
            this.outEndGroup(XML_KEYS.FILE_FIELDS.toString(), 0);
            this.outStartGroup(ImportKeys.FILE_COLUMNS.toString(), 0);
            this.outColumns((Column[])iProps.get(ImportKeys.FILE_COLUMNS), 1);
            this.outEndGroup(ImportKeys.FILE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.TABLE_COLUMNS.toString(), 0);
            this.outColumns(((GenericTable)iProps.get(ImportKeys.TABLE)).getColumns(), 1);
            this.outEndGroup(ImportKeys.TABLE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.SELECTABLE_COLUMNS.toString(), 0);
            this.outColumnReference((Column[])iProps.get(ImportKeys.SELECTABLE_COLUMNS), 1);
            this.outEndGroup(ImportKeys.SELECTABLE_COLUMNS.toString(), 0);
            this.outStartGroup(ImportKeys.SELECTED_COLUMNS.toString(), 0);
            this.outColumnReference((Column[])iProps.get(ImportKeys.SELECTED_COLUMNS), 1);
            this.outEndGroup(ImportKeys.SELECTED_COLUMNS.toString(), 0);
            this.outStartGroup(XML_KEYS.LOAD_METHOD_SETTINGS.toString(), 0);
            int loadMethod = (Integer)iProps.get(ImportKeys.LOAD_METHOD);
            this.outInt(ImportKeys.LOAD_METHOD.toString(), loadMethod, 1);
            if (loadMethod == 3) {
                this.outString(ImportKeys.STAGING_TABLE_NAME.toString(), (String)iProps.get(ImportKeys.STAGING_TABLE_NAME), 1);
                this.outBool(ImportKeys.DROP_STAGING_TABLE.toString(), (Boolean)iProps.get(ImportKeys.DROP_STAGING_TABLE), 1);
            }
            this.outBool(ImportKeys.IS_EXISTING_TABLE.toString(), (Boolean)iProps.get(ImportKeys.IS_EXISTING_TABLE), 1);
            this.outString(ImportKeys.TABLE_NAME.toString(), (String)iProps.get(ImportKeys.TABLE_NAME), 1);
            if (!isOss) {
                Boolean useLoadLimit = (Boolean)iProps.get(ImportKeys.USE_LOAD_LIMIT);
                this.outBool(ImportKeys.USE_LOAD_LIMIT.toString(), useLoadLimit, 1);
                int loadLimit = (Integer)iProps.get(ImportKeys.LOAD_LIMIT);
                if (useLoadLimit.booleanValue()) {
                    this.outInt(ImportKeys.LOAD_LIMIT.toString(), loadLimit, 1);
                } else {
                    this.outInt(ImportKeys.LOAD_LIMIT.toString(), 0, 1);
                }
                if ((Boolean)iProps.get(ImportKeys.SEND_TO_WORKSHEET) != null) {
                    this.outBool(ImportKeys.SEND_TO_WORKSHEET.toString(), (Boolean)iProps.get(ImportKeys.SEND_TO_WORKSHEET), 1);
                } else {
                    this.outBool(ImportKeys.SEND_TO_WORKSHEET.toString(), false, 1);
                }
            }
            this.outEndGroup(XML_KEYS.LOAD_METHOD_SETTINGS.toString(), 0);
            this.outStartGroup(XML_KEYS.MATCH.toString(), 0);
            this.outInt(ImportKeys.MATCH_BY_TYPE.toString(), iProps.getValueInteger(ImportKeys.MATCH_BY_TYPE), 1);
            this.outEndGroup(XML_KEYS.MATCH.toString(), 0);
            this.outStartGroup(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString(), 0);
            if (!isOss && !isCart) {
                if (loadMethod == 2 || loadMethod == 3) {
                    this.outString(ImportKeys.DIRPATH.toString(), this.getString(ImportKeys.DIRPATH, iProps), 1);
                    this.outString(ImportKeys.ORADIRNAME.toString(), this.getString(ImportKeys.ORADIRNAME, iProps), 1);
                    this.outBool(ImportKeys.USEBADFILE.toString(), (Boolean)iProps.get(ImportKeys.USEBADFILE), 1);
                    this.outString(ImportKeys.ORABADDIRNAME.toString(), this.getString(ImportKeys.ORABADDIRNAME, iProps), 1);
                    this.outBool(ImportKeys.USELOGFILE.toString(), (Boolean)iProps.get(ImportKeys.USELOGFILE), 1);
                    this.outString(ImportKeys.ORALOGDIRNAME.toString(), this.getString(ImportKeys.ORALOGDIRNAME, iProps), 1);
                    this.outBool(ImportKeys.USEDISCARDFILE.toString(), (Boolean)iProps.get(ImportKeys.USEDISCARDFILE), 1);
                    this.outString(ImportKeys.ORADISCARDDIRNAME.toString(), this.getString(ImportKeys.ORADISCARDDIRNAME, iProps), 1);
                } else if (loadMethod == 4 && !isCart) {
                    this.outString(ImportKeys.BADDIRNAME.toString(), this.getString(ImportKeys.BADDIRNAME, iProps), 1);
                    this.outString(ImportKeys.LOGDIRNAME.toString(), this.getString(ImportKeys.LOGDIRNAME, iProps), 1);
                    this.outBool(ImportKeys.USEGENDIR.toString(), (Boolean)iProps.get(ImportKeys.USEGENDIR), 1);
                    this.outString(ImportKeys.GENDIR.toString(), this.getString(ImportKeys.GENDIR, iProps), 1);
                    this.outString(ImportKeys.FILEOUTNEWLINE.toString(), this.getString(ImportKeys.FILEOUTNEWLINE, iProps), 1);
                }
            } else {
                this.outInt(ImportKeys.CONVERSION_ERRORS.toString(), iProps.getValueInteger(ImportKeys.CONVERSION_ERRORS), 1);
                this.outString(ImportKeys.DATE_MASK_DATE.toString(), (String)iProps.get(ImportKeys.DATE_MASK_DATE), 1);
                this.outString(ImportKeys.DATE_MASK_TIMESTAMP.toString(), (String)iProps.get(ImportKeys.DATE_MASK_TIMESTAMP), 1);
                this.outString(ImportKeys.DATE_MASK_TIMESTAMPTZ.toString(), (String)iProps.get(ImportKeys.DATE_MASK_TIMESTAMPTZ), 1);
                this.outString(ImportKeys.DATE_MASK_TIMESTAMPLTZ.toString(), (String)iProps.get(ImportKeys.DATE_MASK_TIMESTAMPLTZ), 1);
                this.outBool(ImportKeys.IS_BLANK_COLS.toString(), iProps.getValueBoolean(ImportKeys.IS_BLANK_COLS), 1);
                this.outBool(ImportKeys.IS_TRUNCATE_COLS.toString(), iProps.getValueBoolean(ImportKeys.IS_TRUNCATE_COLS), 1);
                this.outInt(ImportKeys.MISSING_FIELDS.toString(), iProps.getValueInteger(ImportKeys.MISSING_FIELDS), 1);
                this.outInt(ImportKeys.NULL_ROWS.toString(), iProps.getValueInteger(ImportKeys.NULL_ROWS), 1);
                int rejectLimit = iProps.getValueInteger(ImportKeys.REJECT_LIMIT);
                this.outBool(ImportKeys.USE_REJECT_LIMIT.toString(), iProps.getValueBoolean(ImportKeys.USE_REJECT_LIMIT), 1);
                this.outInt(ImportKeys.REJECT_LIMIT.toString(), rejectLimit, 1);
                this.outInt(ImportKeys.TRIM.toString(), iProps.getValueInteger(ImportKeys.TRIM), 1);
                this.outBool(ImportKeys.IS_COPY_LOG.toString(), iProps.getValueBoolean(ImportKeys.IS_COPY_LOG), 1);
                this.outBool(ImportKeys.IS_COPY_BAD.toString(), iProps.getValueBoolean(ImportKeys.IS_COPY_BAD), 1);
                this.outBool(ImportKeys.IS_DROP_BAD_AND_LOG.toString(), iProps.getValueBoolean(ImportKeys.IS_DROP_BAD_AND_LOG), 1);
                this.outBool(ImportKeys.USE_VALIDATE.toString(), iProps.getValueBoolean(ImportKeys.USE_VALIDATE), 1);
                this.outBool(ImportKeys.USE_VALIDATE_LIMIT.toString(), iProps.getValueBoolean(ImportKeys.USE_VALIDATE_LIMIT), 1);
                int validateLimit = iProps.getValueInteger(ImportKeys.VALIDATE_LIMIT);
                if (validateLimit > 0) {
                    this.outInt(ImportKeys.VALIDATE_LIMIT.toString(), validateLimit, 1);
                } else {
                    this.outInt(ImportKeys.VALIDATE_LIMIT.toString(), 0, 1);
                }
            }
            this.outBool(ImportKeys.IS_GENERATE_CHARSET.toString(), iProps.getValueBoolean(ImportKeys.IS_GENERATE_CHARSET), 1);
            this.outString(ImportKeys.CHARNUMCHARACTERS.toString(), this.getString(ImportKeys.CHARNUMCHARACTERS, iProps), 1);
            this.outString(ImportKeys.CHARSETVAL.toString(), this.getString(ImportKeys.CHARSETVAL, iProps), 1);
            this.outEndGroup(XML_KEYS.EXTERNAL_OPTIONS_SETTINGS.toString(), 0);
            this.outEndGroup(XML_KEYS.IMPORT_TOOL.toString(), 0);
            this._out.flush();
            this._out.close();
        }
        catch (IOException e) {
            MessageHandler.error(null, (String)ImportResources.getString("OPEN_FILE_ERR"), null, (String)"f1_exportbadfile_html");
        }
    }

    private void outStartGroup(String name, int indent) throws IOException {
        if (indent > 0) {
            this._out.append(this.getIndent(indent));
        }
        this._out.append("<" + name + ">\n");
    }

    private void outInt(String name, int value, int indent) throws IOException {
        this.outString(name, Integer.toString(value), indent);
    }

    private void outBool(String name, boolean value, int indent) throws IOException {
        this.outString(name, value ? "true" : "false", indent);
    }

    private void outString(String name, String value, int indent) throws IOException {
        if (indent > 0) {
            this._out.append(this.getIndent(indent));
        }
        if (value == null) {
            value = "";
        }
        this._out.append("<" + name + "><![CDATA[" + value + "]]></" + name + ">\n");
    }

    private void outEndGroup(String name, int indent) throws IOException {
        if (indent > 0) {
            this._out.append(this.getIndent(indent));
        }
        this._out.append("</" + name + ">\n");
    }

    private String getIndent(int idx) {
        char[] indent = new char[idx];
        for (int i = 0; i < idx; ++i) {
            indent[i] = 9;
        }
        return new String(indent);
    }

    private void outFields(LoadFile loadFile, int indent) throws IOException {
        for (LoadField field : loadFile.getFields()) {
            this.outStartGroup(XML_KEYS.FIELD.toString(), indent);
            this.outString(XML_KEYS.FIELD_NAME.toString(), field.getName(), indent + 1);
            this.outInt(XML_KEYS.FIELD_LENGTH.toString(), field.getLength(), indent + 1);
            this.outEndGroup(XML_KEYS.FIELD.toString(), indent);
        }
    }

    private void outColumns(Column[] columns, int indent) throws IOException {
        for (Column col : columns) {
            this.outStartGroup(XML_KEYS.COLUMN.toString(), indent);
            this.outString(XML_KEYS.TABLE_COL_NAME.toString(), col.getName(), indent + 1);
            this.outString(XML_KEYS.SOURCE_COL_NAME.toString(), col.getSourceColumnName(), indent + 1);
            this.outInt(XML_KEYS.SOURCE_COL_ID.toString(), col.getSourceColID(), indent + 1);
            this.outString(XML_KEYS.TYPE.toString(), col.getType(), indent + 1);
            this.outInt(XML_KEYS.PRECISION.toString(), col.getPrecision(), indent + 1);
            this.outInt(XML_KEYS.SCALE.toString(), col.getScale(), indent + 1);
            this.outString(XML_KEYS.DEFAULT.toString(), col.getDefault(), indent + 1);
            this.outString(XML_KEYS.FORMAT.toString(), col.getFormat(), indent + 1);
            this.outString(XML_KEYS.COMMENT.toString(), col.getComment(), indent + 1);
            this.outBool(XML_KEYS.NULLABLE.toString(), col.isNullable(), indent + 1);
            this.outBool(XML_KEYS.EDITABLE.toString(), col.isEditable(), indent + 1);
            this.outEndGroup(XML_KEYS.COLUMN.toString(), indent);
        }
    }

    private void outColumnReference(Column[] columns, int indent) throws IOException {
        for (Column col : columns) {
            this.outStartGroup(XML_KEYS.COLUMN_REFERENCE.toString(), indent);
            this.outString(XML_KEYS.TABLE_COL_NAME.toString(), col.getName(), indent + 1);
            this.outString(XML_KEYS.SOURCE_COL_NAME.toString(), col.getSourceColumnName(), indent + 1);
            this.outInt(XML_KEYS.SOURCE_COL_ID.toString(), col.getSourceColID(), indent + 1);
            this.outEndGroup(XML_KEYS.COLUMN_REFERENCE.toString(), indent);
        }
    }

    private String getString(ImportKeys name, ImportProperties iProps) {
        return iProps.get(name) == null ? "" : (String)iProps.get(name);
    }

    public ExitCode reconcileConfig(String configFileName) {
        return this.reconcileConfig(configFileName, (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE), this.getPropertyValue(ImportKeys.CONNECTION_NAME), (BasicDBObject)this.getPropertyValueObject(ImportKeys.DBOBJECT), this.getPropertyValue(ImportKeys.FILE_PATH));
    }

    public ExitCode reconcileConfig(String configFileName, String importLoadFileName, boolean isInit, boolean isCart) {
        return this.reconcileConfig(configFileName, (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE), this.getPropertyValue(ImportKeys.CONNECTION_NAME), (BasicDBObject)this.getPropertyValueObject(ImportKeys.DBOBJECT), importLoadFileName, isInit, isCart);
    }

    public ExitCode reconcileConfig(String configFileName, boolean isImportExistingTable, String importConnName, BasicDBObject importDbo, String importLoadFileName) {
        return this.reconcileConfig(configFileName, isImportExistingTable, importConnName, importDbo, importLoadFileName, false);
    }

    public ExitCode reconcileConfig(String configFileName, boolean isImportExistingTable, String importConnName, BasicDBObject importDbo, String importLoadFileName, boolean isInit) {
        return this.reconcileConfig(configFileName, isImportExistingTable, importConnName, importDbo, importLoadFileName, isInit, false);
    }

    public ExitCode reconcileConfig(String configFileName, boolean isImportExistingTable, String importConnName, BasicDBObject importDbo, String importLoadFileName, boolean isInit, boolean isCart) {
        String nl = _term;
        StringBuffer eMessages = new StringBuffer();
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        try {
            String importObj;
            String configObj;
            if (!this._isLoaded) {
                exitCode = ExitCode.EXIT_SEVERE;
                String msg = ImportResources.getString("CONFIG_OPEN_ERROR19");
                eMessages.append(msg);
                throw new ConfigException(msg, exitCode);
            }
            if (this._rootNodeName == null) {
                exitCode = ExitCode.EXIT_SEVERE;
                String msg = ImportResources.format("XML_FILE_ERROR_MESSAGE", configFileName, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", ImportResources.getString("XML_FILE_NO_KEY"));
                eMessages.append(msg);
                throw new ConfigException(msg, exitCode, true);
            }
            if (!this._rootNodeName.equals(XML_KEYS.IMPORT_TOOL.toString())) {
                exitCode = ExitCode.EXIT_SEVERE;
                String msg = ImportResources.format("XML_FILE_ERROR_MESSAGE", configFileName, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", this._rootNodeName);
                eMessages.append(msg);
                throw new ConfigException(msg, exitCode, true);
            }
            String connName = this.getPropertyValue(ImportKeys.CONNECTION_NAME);
            boolean isConfigExistingTable = (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE);
            BasicDBObject dbo = (BasicDBObject)this.getPropertyValueObject(ImportKeys.DBOBJECT);
            String string = dbo == null ? "" : (configObj = dbo.getSchemaName() + (String)(isConfigExistingTable ? "." + dbo.getObjectName() : ""));
            Object object = importDbo != null ? importDbo.getSchemaName() + (String)(isImportExistingTable ? "." + importDbo.getObjectName() : "") : (importObj = "");
            if (!isInit && !isCart) {
                if (isImportExistingTable && !isConfigExistingTable) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    String msg = ImportResources.format("CONFIG_OPEN_ERROR0", importObj);
                    eMessages.append(msg);
                    throw new ConfigException(msg, exitCode);
                }
                if (isConfigExistingTable && !isImportExistingTable) {
                    String msg = ImportResources.format("CONFIG_OPEN_ERROR1", configObj);
                    eMessages.append(msg);
                    exitCode = ExitCode.EXIT_SEVERE;
                    throw new ConfigException(msg, exitCode);
                }
                if (importConnName != null && !importConnName.equals(connName)) {
                    exitCode = ExitCode.EXIT_WARNING;
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR2", ConnectionResolver.getDisplayName((String)connName), ConnectionResolver.getDisplayName((String)importConnName)) + nl);
                } else {
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR27", ConnectionResolver.getDisplayName((String)connName)) + nl);
                }
                if (!(!isImportExistingTable || importDbo.getSchemaName().equals(dbo.getSchemaName()) && importDbo.getObjectType().equals(dbo.getObjectType()) && importDbo.getObjectName().equals(dbo.getObjectName()))) {
                    exitCode = ExitCode.EXIT_WARNING;
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR3", configObj, importObj) + nl);
                } else if (!isImportExistingTable && dbo != null && !importDbo.getSchemaName().equals(dbo.getSchemaName())) {
                    exitCode = ExitCode.EXIT_WARNING;
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR30", configObj, importObj) + nl);
                } else {
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR26", configObj) + nl);
                }
            }
            this._iProps.put(ImportKeys.CONNECTION_NAME, importConnName);
            this._iProps.put(ImportKeys.DBOBJECT, importDbo);
            GenericTable importTable = null;
            if (isImportExistingTable) {
                GenericTable configTable = new GenericTable();
                configTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                Column[] tableCols = (Column[])this.getPropertyValueObject(ImportKeys.TABLE_COLUMNS);
                for (int i = 0; i < tableCols.length; ++i) {
                    configTable.addColumn(tableCols[i]);
                }
                try {
                    importTable = new GenericTable(ConnectionResolver.getConnection((String)importDbo.getConnectionName()), importDbo.getSchemaName(), importDbo.getObjectName(), true);
                    if (importTable.getTable() == null) {
                        exitCode = ExitCode.EXIT_ERROR;
                        String msg = ImportResources.format("CONFIG_OPEN_ERROR24", importObj, ConnectionResolver.getDisplayName((String)importConnName));
                        Logger.severe(this.getClass(), (String)msg);
                        eMessages.append(msg);
                        throw new ConfigException(msg, exitCode);
                    }
                    this._iProps.put(ImportKeys.TABLE, importTable);
                }
                catch (Exception e) {
                    exitCode = ExitCode.EXIT_SEVERE;
                    Logger.severe(this.getClass(), (Throwable)e);
                    String msg = ImportResources.format("CONFIG_OPEN_ERROR8", importObj, String.valueOf(eMessages) + e.getMessage());
                    eMessages.append(msg);
                    throw new ConfigException(msg, exitCode);
                }
                Column importCol = null;
                boolean columnTitleWritten = false;
                DataTypeFormatterRegistry.getInstance().registerFormattor("CLOB", CharFormattor.class, false, false, false);
                ITypeFormattor fmtor = null;
                for (Column col : configTable.getColumns()) {
                    importCol = importTable.getTable().getColumnByName(col.getName());
                    if (importCol == null) {
                        if (!columnTitleWritten) {
                            eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                            columnTitleWritten = true;
                        }
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR6", col.getName() + _term));
                        exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                        continue;
                    }
                    if (importCol.getType().equals(col.getType()) && importCol.getPrecision() <= col.getPrecision() && importCol.getScale() <= col.getScale()) continue;
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR5", importCol.getName() + _term));
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                    fmtor = DataTypeFormatterRegistry.getInstance().getFormattor(importCol.getType().toUpperCase());
                    if (fmtor != null) continue;
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR32", importCol.getName(), importCol.getType()));
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                }
                DataTypeFormatterRegistry.getInstance().unregisterFormattor("CLOB");
                Column col = null;
                for (Column impCol : importTable.getColumns()) {
                    col = configTable.getTable().getColumnByName(impCol.getName());
                    if (col != null) continue;
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR4", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR7", impCol.getName() + _term));
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                }
            } else {
                importTable = new GenericTable();
                importTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                this._iProps.put(ImportKeys.TABLE_NAME, this.getPropertyValue(ImportKeys.TABLE_NAME));
                importTable.setColumns((Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            }
            this._iProps.put(ImportKeys.TABLE, importTable);
            LoadFile loadFile = (LoadFile)this.getPropertyValueObject(ImportKeys.LOAD_FILE);
            ArrayList configFields = (ArrayList)loadFile.getFields();
            boolean isOss = this.getPropertyValueBoolean(ImportKeys.IS_SOURCE_OSS);
            if (!isOss) {
                try {
                    URL url = new URL(importLoadFileName);
                    File file = new File(url.toURI());
                    importLoadFileName = file.getPath();
                }
                catch (Exception url) {
                    // empty catch block
                }
            }
            File newFile = new File(loadFile.getName());
            if (!(isOss || newFile != null && !newFile.isDirectory() && newFile.isFile())) {
                eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR10", loadFile.getName() + _term));
                exitCode = ExitCode.EXIT_SEVERE;
            } else if (!(isOss || importLoadFileName == null || importLoadFileName.equals("") || importLoadFileName.equals(loadFile.getName()))) {
                eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR28", loadFile.getName(), importLoadFileName) + _term);
                loadFile = new LoadFile(importLoadFileName);
                this._iProps.put(ImportKeys.LOAD_FILE, loadFile);
                exitCode = ExitCode.EXIT_WARNING;
            } else if (isOss && importLoadFileName != null && !importLoadFileName.equals("") && !importLoadFileName.equals(this.getPropertyValue(ImportKeys.OSS_PATH))) {
                eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR28", loadFile.getName(), importLoadFileName) + _term);
                loadFile = new LoadFile(importLoadFileName);
                this._iProps.put(ImportKeys.LOAD_FILE, loadFile);
                exitCode = ExitCode.EXIT_WARNING;
            } else if (!isCart || importLoadFileName == null || importLoadFileName.isEmpty()) {
                eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR31", loadFile.getName()) + _term);
                importLoadFileName = loadFile.getName();
            }
            if (isOss) {
                byte[] sample = null;
                try {
                    sample = CloudStorageUtils.getSampleBytes(this._iProps, importLoadFileName, (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL));
                }
                catch (Exception e) {
                    String msg = ImportResources.format("OPEN_FILE_CRED_ERROR", importLoadFileName, ConnectionResolver.getDisplayName((String)((String)this._iProps.get(ImportKeys.CONNECTION_NAME))), (String)this._iProps.get(ImportKeys.OSS_CREDENTIAL), e.getLocalizedMessage());
                    eMessages.append(msg);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                    throw new ConfigException(msg, exitCode);
                }
                if (sample != null) {
                    try {
                        String tmpFileName = DataReaderUtils.getTempName("oss");
                        File tmpFile = File.createTempFile(tmpFileName, "." + CloudStorageUtils.getOssTempExtension((String)this._iProps.get(ImportKeys.OSS_PATH)));
                        tmpFile.deleteOnExit();
                        FileOutputStream out = new FileOutputStream(tmpFile);
                        out.write(sample);
                        loadFile = new LoadFile(tmpFile.getPath());
                        this._iProps.put(ImportKeys.LOAD_FILE, loadFile);
                        out.flush();
                        out.close();
                    }
                    catch (Exception e) {
                        Logger.warn(this.getClass(), (Throwable)e);
                    }
                }
            }
            this._datareader = DataReaderRegistry.getReader(this._dataFormat.getFormat());
            try {
                this._datareader.setFileName(loadFile.getName());
                this._datareader.setPage(this._dataFormat.getPageId());
            }
            catch (DataReaderException e) {
                String msg = ImportResources.format("OPEN_FILE_ERROR", loadFile.getName(), e.getMessage());
                eMessages.append(msg);
                exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                throw new ConfigException(msg, exitCode);
            }
            this._datareader.setDataFormat(this._dataFormat);
            this._datareader.createFields(loadFile);
            if (loadFile.getFieldCount() != configFields.size()) {
                String fileCount = Integer.toString(loadFile.getFieldCount());
                String configCount = Integer.toString(configFields.size());
                eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR13", fileCount, configCount) + _term);
                exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
            }
            boolean found = false;
            boolean columnTitleWritten = false;
            for (LoadField configField : configFields) {
                for (Object dataField : loadFile.getFields()) {
                    if (!dataField.getName().equals(configField.getName())) continue;
                    if (dataField.getLength() > configField.getLength()) {
                        if (!columnTitleWritten) {
                            eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                            columnTitleWritten = true;
                        }
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR12", dataField.getName()) + _term);
                        exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_WARNING);
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR11", configField.getName()) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                    continue;
                }
                found = false;
            }
            int colId = 0;
            ArrayList<Object> newFileCols = new ArrayList<Object>();
            Column[] fileCols = (Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS);
            for (LoadField dataField : loadFile.getFields()) {
                for (LoadField configField : configFields) {
                    if (!dataField.getName().equals(configField.getName())) continue;
                    found = true;
                    ++colId;
                    Column fileCol = this.getColumnBySource(dataField.getName(), fileCols);
                    if (fileCol != null) {
                        newFileCols.add(fileCol);
                        dataField.setColumn(fileCol);
                        break;
                    }
                    Column column = new Column();
                    column.setSourceColumnName(dataField.getName());
                    column.setName("");
                    column.setSourceColID(colId++);
                    column.setPrecision(dataField.getLength());
                    column.setType("VARCHAR2");
                    column.setScale(0);
                    column.setNullable(true);
                    column.setEditable(true);
                    newFileCols.add(column);
                    dataField.setColumn(column);
                    break;
                }
                if (!found) {
                    Column[] column = new Column();
                    column.setSourceColumnName(dataField.getName());
                    column.setName("");
                    column.setSourceColID(colId++);
                    column.setPrecision(dataField.getLength());
                    column.setType("VARCHAR2");
                    column.setScale(0);
                    column.setNullable(true);
                    column.setEditable(true);
                    newFileCols.add(column);
                    dataField.setColumn((Column)column);
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR15", dataField.getName()) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                    continue;
                }
                found = false;
            }
            this._iProps.put(ImportKeys.FILE_COLUMNS, newFileCols.toArray(new Column[newFileCols.size()]));
            Column[] selectedCols = (Column[])this.getPropertyValueObject(ImportKeys.SELECTED_COLUMNS);
            ArrayList<Column> newSelected = new ArrayList<Column>();
            if (selectedCols != null) {
                for (Column column : selectedCols) {
                    Column tblCol = importTable.getTable().getColumnByName(column.getName());
                    if (tblCol != null) {
                        newSelected.add(column);
                        tblCol.setFormat(column.getFormat());
                        continue;
                    }
                    if (!columnTitleWritten) {
                        eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR18", new Object[0]) + _term);
                        columnTitleWritten = true;
                    }
                    eMessages.append(ImportResources.format("CONFIG_OPEN_ERROR25", column.getSourceColumnName(), column.getName(), importObj) + _term);
                    exitCode = this.getExitCodeHighest(exitCode, ExitCode.EXIT_ERROR);
                }
            }
            ArrayList<Column> newSelectable = new ArrayList<Column>();
            if (!newSelected.isEmpty()) {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, newSelected.toArray(new Column[newSelected.size()]));
            } else {
                this._iProps.put(ImportKeys.SELECTED_COLUMNS, new Column[0]);
            }
            boolean isExistingTable = this._iProps.getValueBoolean(ImportKeys.IS_EXISTING_TABLE);
            for (Column column : newFileCols) {
                if (this.getColumnBySource(column.getSourceColumnName(), newSelected) != null) continue;
                column.setName(isExistingTable ? "" : column.getSourceColumnName());
                newSelectable.add(column);
            }
            if (!newSelectable.isEmpty()) {
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, newSelectable.toArray(new Column[newSelectable.size()]));
            } else {
                this._iProps.put(ImportKeys.SELECTABLE_COLUMNS, new Column[0]);
            }
            exitCode.setMessage(eMessages.toString());
        }
        catch (ConfigException ce) {
            ce.getExitCode().setMessage(eMessages.toString());
            ce.getExitCode().setShortMessage(ce.getMessage());
        }
        return exitCode;
    }

    public String parseXMLForFile(InputStreamReader xml, boolean editable) {
        DOMParser parser = this.getParser();
        parser.setPreserveWhitespace(false);
        try {
            parser.parse((Reader)xml);
            XMLDocument doc = parser.getDocument();
            return this.processNodeGetFile((Node)doc, editable);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
            return "";
        }
    }

    private String processNodeGetFile(Node node, boolean editable) {
        NodeList children = node.getChildNodes();
        if (this._rootNodeName == null) {
            this._rootNodeName = children.item(0).getNodeName();
            if (!children.item(0).getNodeName().equals(XML_KEYS.IMPORT_TOOL.toString())) {
                return null;
            }
        }
        for (int i = 0; i < children.getLength() && !this._cancel; ++i) {
            if (!children.item(i).getNodeName().equalsIgnoreCase(XML_KEYS.FILE_SETTINGS.toString())) continue;
            return this.getNodeValue(node, ImportKeys.FILE_PATH);
        }
        return null;
    }

    public ExitCode reconcileConfigForShow(String configFileName) {
        ExitCode exitCode = ExitCode.EXIT_SUCCESS;
        try {
            if (!this._isLoaded) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(ImportResources.getString("CONFIG_OPEN_ERROR19"), exitCode);
            }
            if (this._rootNodeName == null) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(ImportResources.format("XML_FILE_ERROR_MESSAGE", configFileName, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", ImportResources.getString("XML_FILE_NO_KEY")), exitCode, true);
            }
            if (!this._rootNodeName.equals(XML_KEYS.IMPORT_TOOL.toString())) {
                exitCode = ExitCode.EXIT_SEVERE;
                throw new ConfigException(ImportResources.format("XML_FILE_ERROR_MESSAGE", configFileName, "\"" + XML_KEYS.IMPORT_TOOL.toString() + "\"", this._rootNodeName), exitCode, true);
            }
            boolean isConfigExistingTable = (Boolean)this.getPropertyValueObject(ImportKeys.IS_EXISTING_TABLE);
            GenericTable configTable = new GenericTable();
            configTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
            if (isConfigExistingTable) {
                configTable.setTableName(this.getPropertyValue(ImportKeys.TABLE_NAME));
                Column[] tableCols = (Column[])this.getPropertyValueObject(ImportKeys.TABLE_COLUMNS);
                for (int i = 0; i < tableCols.length; ++i) {
                    configTable.addColumn(tableCols[i]);
                }
            } else {
                configTable.setColumns((Column[])this.getPropertyValueObject(ImportKeys.FILE_COLUMNS));
            }
            this._iProps.put(ImportKeys.TABLE, configTable);
        }
        catch (ConfigException ce) {
            ce.getExitCode().setMessage(ce.getMessage());
        }
        return exitCode;
    }

    private Column getColumnBySource(String name, Column[] cols) {
        for (Column col : cols) {
            String sourceColName = col.getSourceColumnName();
            if (sourceColName == null || !sourceColName.equals(name)) continue;
            return col;
        }
        return null;
    }

    private Column getColumnBySource(String name, Iterable<Column> cols) {
        for (Column col : cols) {
            if (!col.getSourceColumnName().equals(name)) continue;
            return col;
        }
        return null;
    }

    public IDataReadable getDataReader() {
        return this._datareader;
    }

    private ExitCode getExitCodeHighest(ExitCode exitCode1, ExitCode exitCode2) {
        return exitCode2.getSeverity() > exitCode1.getSeverity() ? exitCode2 : exitCode1;
    }

    private static enum XML_KEYS {
        COLUMN,
        COLUMN_REFERENCE,
        CONVERSION_ERRORS,
        COMMENT,
        CONNECTION_SETTINGS,
        DATE_MASK_DATE,
        DATE_MASK_TIMESTAMP,
        DATE_MASK_TIMESTAMPTZ,
        DATE_MASK_TIMESTAMPLTZ,
        DEFAULT,
        EDITABLE,
        EXTERNAL_OPTIONS_SETTINGS,
        FIELD,
        FIELD_LENGTH,
        FIELD_NAME,
        FILE_COLUMNS,
        FILE_FIELDS,
        FILE_SETTINGS,
        FORMAT,
        IMPORT_TOOL,
        IS_BLANK_COLS,
        IS_CLEANUP_TEST_NEEDED,
        IS_COPY_LOG,
        IS_COPY_BAD,
        IS_DROP_BAD_AND_LOG,
        IS_DWCS,
        IS_SOURCE_OSS,
        IS_TRUNCATE_COLS,
        LOAD_METHOD_SETTINGS,
        LOCALE,
        MATCH,
        MISSING_FIELDS,
        NULL_ROWS,
        NULLABLE,
        OSS_CREDENTIAL,
        OSS_PATH,
        PRECISION,
        REJECT_LIMIT,
        SCALE,
        SOURCE_COL_ID,
        SOURCE_COL_NAME,
        TABLE_COL_NAME,
        TRIM,
        TRUNCATE_COLS,
        TYPE,
        USE_REJECT_LIMIT,
        USE_VALIDATE,
        USE_VALIDATE_LIMIT,
        VALIDATE_LIMIT;

    }
}

