/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.util.LinkedList;
import oracle.xml.jdwp.XSLJDWPCommandSet;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPObjectReference;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPPacketStream;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

public class XSLJDWPStackFrame
extends XSLJDWPCommandSet
implements XSLJDWPConstants {
    XSLTContext context;

    @Override
    XSLJDWPPacket execute(XSLJDWPPacket xSLJDWPPacket) {
        this.cmd = xSLJDWPPacket;
        this.cmdStrm = new XSLJDWPPacketStream(this.cmd);
        XSLJDWPPacket xSLJDWPPacket2 = null;
        switch (this.getCommand()) {
            case 1: {
                xSLJDWPPacket2 = this.getValuesCmd();
                break;
            }
            case 2: {
                xSLJDWPPacket2 = this.setValuesCmd();
                break;
            }
            case 4: {
                xSLJDWPPacket2 = this.popFramesCmd();
                break;
            }
            default: {
                xSLJDWPPacket2 = this.cmd.createErrorReply((short)99);
            }
        }
        return xSLJDWPPacket2;
    }

    synchronized XSLJDWPPacket setValuesCmd() {
        int n = this.cmdStrm.readThreadID();
        int n2 = this.cmdStrm.readFrameID();
        int n3 = this.cmdStrm.readInt();
        try {
            this.setValuesData(n, n2, n3);
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        return this.cmd.createReply();
    }

    XSLJDWPPacket popFramesCmd() {
        int n = this.cmdStrm.readThreadID();
        int n2 = this.cmdStrm.readFrameID();
        XSLJDWPUtil.printTrace(this.jdwpvm.xsl.getXSLDebugProp(), "PopFrames command");
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    XSLJDWPPacket getValuesCmd() {
        int n = this.cmdStrm.readThreadID();
        int n2 = this.cmdStrm.readFrameID();
        int n3 = this.cmdStrm.readInt();
        int[] nArray = new int[n3];
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.cmdStrm.readInt();
            byArray[i] = this.cmdStrm.readByte();
        }
        XSLJDWPPacketStream xSLJDWPPacketStream = new XSLJDWPPacketStream(this.cmd.createReply());
        try {
            int n4 = this.jdwpvm.xsl.getFrameValues().size();
            if (n2 > n4 || n2 <= 0) {
                throw new XSLJDWPException(30);
            }
            XSLJDWPPacketValue[] xSLJDWPPacketValueArray = this.generateGetValuesData(n, n2, n3, nArray, byArray);
            int n5 = xSLJDWPPacketValueArray.length;
            xSLJDWPPacketStream.writeInt(n5);
            if (n5 == 0) {
                xSLJDWPPacketStream.close();
                return xSLJDWPPacketStream.packet();
            }
            XSLJDWPObjectReference xSLJDWPObjectReference = this.jdwpvm.xsl.getJDWPObjectReference();
            xSLJDWPObjectReference.generateIDs(xSLJDWPPacketValueArray);
            for (int i = 0; i < n5; ++i) {
                xSLJDWPPacketStream.writeValue(xSLJDWPPacketValueArray[i]);
            }
        }
        catch (XSLJDWPException xSLJDWPException) {
            return this.cmd.createErrorReply(xSLJDWPException.errorCode());
        }
        xSLJDWPPacketStream.close();
        return xSLJDWPPacketStream.packet();
    }

    public void setXSLTContext(XSLTContext xSLTContext) {
        this.context = xSLTContext;
    }

    private Integer getContextPosData() throws XSLException {
        Integer n = null;
        n = this.context == null ? new Integer(-1) : new Integer(this.context.getContextPosition());
        return n;
    }

    private void setContextPosData(int n) {
        this.context.setContextPosition(n);
    }

    private Integer getContextSizeData() throws XSLException {
        Integer n = null;
        n = this.context == null ? new Integer(-1) : new Integer(this.context.getContextSize());
        return n;
    }

    private void setContextSizeData(int n) {
        this.context.setContextSize(n);
    }

    private XMLNode getContextNodeData() throws XSLException {
        if (this.context == null) {
            return null;
        }
        return this.context.getJDWPContextNode();
    }

    private void setValuesData(int n, int n2, int n3) throws XSLJDWPException {
        LinkedList linkedList = this.jdwpvm.xsl.getFrameValues();
        LinkedList linkedList2 = (LinkedList)linkedList.get(n2 - 1);
        int n4 = -1;
        block4: for (int i = 0; i < n3; ++i) {
            int n5 = this.cmdStrm.readInt();
            if (n5 == 0) {
                n4 = this.cmdStrm.readByte();
                int n6 = this.cmdStrm.readInt();
                this.setContextPosData(n6);
                continue;
            }
            if (n5 == 1) {
                n4 = this.cmdStrm.readByte();
                int n7 = this.cmdStrm.readInt();
                this.setContextSizeData(n7);
                continue;
            }
            if (n5 == 2 || n5 == 3) continue;
            OXMLSequence oXMLSequence = (OXMLSequence)linkedList2.get(n5 - 3);
            n4 = this.cmdStrm.readByte();
            switch (n4) {
                case 90: {
                    boolean bl = this.cmdStrm.readBoolean();
                    XPathSequence.setBooleanValue(oXMLSequence, bl);
                    continue block4;
                }
                case 68: {
                    double d = this.cmdStrm.readDouble();
                    XPathSequence.setNumberValue(oXMLSequence, d);
                }
            }
        }
    }

    private XSLJDWPPacketValue[] generateGetValuesData(int n, int n2, int n3, int[] nArray, byte[] byArray) throws XSLJDWPException {
        LinkedList linkedList = this.jdwpvm.xsl.getFrameValues();
        LinkedList linkedList2 = (LinkedList)linkedList.get(n2 - 1);
        int n4 = 3;
        int n5 = linkedList2.size() + n4;
        XSLJDWPPacketValue[] xSLJDWPPacketValueArray = new XSLJDWPPacketValue[n3];
        XSLJDWPPacketValue xSLJDWPPacketValue = null;
        for (int i = 0; i < n3; ++i) {
            if (i >= n5) {
                xSLJDWPPacketValueArray[i] = xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(null);
                continue;
            }
            int n6 = nArray[i] - n4;
            int n7 = nArray[i];
            try {
                Object object;
                if (n7 == n4 - 3) {
                    xSLJDWPPacketValue = new XSLJDWPPacketValue(73, this.getContextPosData());
                } else if (n7 == n4 - 2) {
                    xSLJDWPPacketValue = new XSLJDWPPacketValue(73, this.getContextSizeData());
                } else if (n7 == n4 - 1) {
                    object = this.jdwpvm.xsl.getJDWPObjectReference();
                    Integer n8 = ((XSLJDWPObjectReference)object).generateUniqueNodeID(this.getContextNodeData());
                    xSLJDWPPacketValue = n8 == 0 ? new XSLJDWPPacketValue(86, null) : new XSLJDWPPacketValue(76, n8);
                } else if (n6 >= linkedList2.size()) {
                    xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue(null);
                } else if (n6 >= 0) {
                    object = (OXMLSequence)linkedList2.get(n6);
                    xSLJDWPPacketValue = XSLJDWPUtil.convertXPathSequence2PacketValue((OXMLSequence)object);
                    xSLJDWPPacketValue.setData((OXMLSequence)object);
                }
                xSLJDWPPacketValueArray[i] = xSLJDWPPacketValue;
                continue;
            }
            catch (XSLException xSLException) {
                throw new XSLJDWPException(xSLException, 20);
            }
        }
        return xSLJDWPPacketValueArray;
    }
}

