/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.commands.ocidbmetrics;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.commands.ocidbmetrics.OCIUtilMessages;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCIUtil {
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static boolean r1 = false;
    private static String homeRegion = null;

    public Iterator<JrsValue> callOCIEndpoint(String profile, String path, ScriptRunnerContext ctx) {
        OCIProfiles p = new OCIProfiles();
        Iterator elements = null;
        try {
            OCIRESTClient client = p.getOciClient(profile);
            Object host = null;
            host = r1 ? "identity.r1.oracleiaas.com" : "identity." + String.valueOf(ctx.getProperty(OCI_REGION_NAME)) + ".oraclecloud.com";
            OCIRequest request = new OCIRequest.Builder().host((String)host).method("get").target(path).contentType("application/json").build();
            CloseableHttpResponse response = client.getResponse(request);
            HttpEntity entity = response.getEntity();
            String entityStr = EntityUtils.toString((HttpEntity)entity);
            try {
                JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
                JrsArray array = (JrsArray)json.treeFrom((Object)entityStr);
                elements = array.elements();
            }
            catch (ClassCastException ex) {
                ctx.write(OCIUtilMessages.get("OCIENDPOINT_JSON_ERROR"));
                throw new IOException(entityStr);
            }
            catch (RuntimeException e) {
                ctx.write(e.getMessage());
            }
        }
        catch (IOException | IllegalArgumentException | GeneralSecurityException | ParseException e) {
            ctx.write(OCIUtilMessages.getString("OCIENDPOINT_CALL_FAILED"));
        }
        return elements;
    }

    public Iterator<JrsValue> getCompartments(String profile, ScriptRunnerContext ctx) {
        String tenancyID = null;
        OCIProfiles p = new OCIProfiles();
        Properties profiles = null;
        try {
            profiles = p.getProperties();
        }
        catch (IOException e) {
            ctx.write(OCIUtilMessages.getString("OCI_PROFILE_PROPERTY_ERROR"));
        }
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/compartments/?compartmentId=" + tenancyID;
        return this.callOCIEndpoint(profile, path, ctx);
    }

    public Iterator<JrsValue> getSubscribedRegions(String profile, ScriptRunnerContext ctx) throws RuntimeException {
        String tenancyID = null;
        OCIProfiles p = new OCIProfiles();
        try {
            Properties profiles = p.getProperties();
            tenancyID = profiles.getProperty(profile + "/tenancy");
        }
        catch (IOException e) {
            ctx.write(OCIUtilMessages.getString("OCI_PROFILE_PROPERTY_ERROR"));
        }
        String path = "/20160918/tenancies/" + tenancyID + "/regionSubscriptions";
        return this.callOCIEndpoint(profile, path, ctx);
    }

    public ArrayList<String> listSubscribedRegionIDs(String profile, ScriptRunnerContext ctx) {
        Iterator<JrsValue> regions = this.getSubscribedRegions(profile, ctx);
        ArrayList<String> regionIDs = new ArrayList<String>();
        while (regions.hasNext()) {
            JrsValue element = regions.next();
            String region = element.get("regionName").asText();
            regionIDs.add(region);
            if (!((JrsBoolean)element.get("isHomeRegion")).booleanValue()) continue;
            homeRegion = region;
        }
        return regionIDs;
    }

    public String getHomeRegion() {
        return homeRegion;
    }

    public Boolean isRegionMatch(String profile, String regionID, ScriptRunnerContext ctx) {
        ArrayList<String> regions = this.listSubscribedRegionIDs(profile, ctx);
        if (regions.contains(regionID)) {
            return true;
        }
        return false;
    }

    public ArrayList<String> getCompartmentValue(String profile, ScriptRunnerContext ctx, String key) {
        Iterator<JrsValue> compartments = this.getCompartments(profile, ctx);
        ArrayList<String> compartmentValues = new ArrayList<String>();
        while (compartments.hasNext()) {
            JrsValue compartment = compartments.next();
            compartmentValues.add(compartment.get(key).asText());
        }
        return compartmentValues;
    }

    public boolean validateCompartment(String profile, String compartmentId, ScriptRunnerContext ctx) {
        String path = "/20160918/compartments/" + compartmentId;
        OCIProfiles p = new OCIProfiles();
        try {
            OCIRESTClient client = p.getOciClient(profile);
            String host = "identity." + String.valueOf(ctx.getProperty(OCI_REGION_NAME)) + ".oraclecloud.com";
            OCIRequest request = new OCIRequest.Builder().host(host).method("get").target(path).contentType("application/json").build();
            CloseableHttpResponse response = client.getResponse(request);
            if (response.getCode() == 200) {
                return true;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        ctx.write(OCIUtilMessages.getString("OCIDBMETRICS_COMPARTMENT_ERROR"));
        return false;
    }

    public boolean checkOCID(String ocid, ScriptRunnerContext ctx, String ocidType, String errorMsg1, String errorMsg2) {
        String profile = (String)ctx.getProperty("oci.profile.name");
        if (ocidType.equalsIgnoreCase("compartment") && ocid.contains(":") && ocid.substring(0, 6).equalsIgnoreCase("ocidv1") || ocid.substring(6, 17).equalsIgnoreCase(ocidType)) {
            return this.validateCompartment(profile, ocid, ctx);
        }
        if (!ocid.contains(":") && ocid.substring(0, 4).equalsIgnoreCase("ocid")) {
            ctx.write(errorMsg1);
            return false;
        }
        String[] parts = ocid.replace("\n", "").split("\\.");
        if (!parts[1].equalsIgnoreCase(ocidType)) {
            ctx.write(errorMsg1 + errorMsg2 + parts[1] + "\n");
            return false;
        }
        return true;
    }
}

