/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.console.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.raptor.console.impl.CompletionProperties;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Completion;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Synonyms;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

class CommandCompleter
implements Completer {
    private final ScriptRunnerContext scriptRunnerContext;
    private final CompletionProperties completionProperties;
    private Map<String, CommandListener> typeLookup;
    private Set<String> primaryTokens;

    CommandCompleter(ScriptRunnerContext scriptRunnerContext, CompletionProperties completionProperties) {
        this.scriptRunnerContext = scriptRunnerContext;
        this.completionProperties = completionProperties;
    }

    public void complete(LineReader reader, ParsedLine parsedLine, List<Candidate> candidates) {
        String line = parsedLine.line().substring(0, parsedLine.cursor());
        if (!line.isEmpty()) {
            this.scriptRunnerContext.runWithStoredContext(() -> {
                CommandListener listener;
                String trimmedLine = line.stripLeading();
                String[] words = trimmedLine.split("\\s");
                String commandToken = words[0].toUpperCase();
                if (commandToken.equals("HELP") && words.length >= 2) {
                    int helpPrefixEnd = trimmedLine.indexOf(words[1]);
                    trimmedLine = trimmedLine.substring(helpPrefixEnd);
                    commandToken = words[1].toUpperCase();
                }
                if ((listener = this.getTypeLookup().get(commandToken)) == null) {
                    for (String primaryToken : this.getPrimaryTokens()) {
                        if (!primaryToken.toUpperCase().startsWith(commandToken)) continue;
                        candidates.add(new Candidate(primaryToken));
                    }
                } else {
                    this.completionProperties.setCommandToken(commandToken);
                    Type type = listener.getParserType();
                    if (type != null) {
                        Parser parser = new Parser(type, this.scriptRunnerContext.getEnvironment());
                        for (Completion completion : parser.getCompletions(trimmedLine)) {
                            candidates.add(new Candidate(completion.getReplacementValue(), completion.getDisplayValue(), null, null, null, null, !completion.getDisplayValue().endsWith(File.separator), 0));
                        }
                    }
                }
                for (String alias : Aliases.getInstance().getAliases()) {
                    if (!alias.toUpperCase().startsWith(commandToken)) continue;
                    candidates.add(new Candidate(alias));
                }
            });
        }
    }

    private Collection<String> getPrimaryTokens() {
        if (this.primaryTokens == null) {
            this.buildTypeLookup();
        }
        return this.primaryTokens;
    }

    private Map<String, CommandListener> getTypeLookup() {
        if (this.typeLookup == null) {
            this.buildTypeLookup();
        }
        return this.typeLookup;
    }

    private void buildTypeLookup() {
        this.typeLookup = new HashMap<String, CommandListener>();
        this.primaryTokens = new HashSet<String>();
        Map<SQLCommand.StmtSubType, List<CommandListener>> listenersMap = CommandRegistry.getListeners(null, this.scriptRunnerContext);
        for (List<CommandListener> listeners : listenersMap.values()) {
            for (CommandListener listener : listeners) {
                Type type = listener.getParserType();
                if (type == null) continue;
                Synonyms synonyms = type.getSynonyms();
                for (String synonym : synonyms.get()) {
                    if (this.typeLookup.containsKey(synonym)) {
                        throw new IllegalStateException("duplicate command symbol '" + synonym + "' provided by listener class '" + listener.getClass().getName() + "'");
                    }
                    this.typeLookup.put(synonym, listener);
                }
                this.primaryTokens.add(synonyms.getPrimaryName().toLowerCase());
            }
        }
    }
}

