/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.save;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.core.connections.util.ConnectionManagementUtil;
import oracle.dbtools.core.oci.connections.OCIStoredConnectionSupport;
import oracle.dbtools.core.oci.search.ResourceQuery;
import oracle.dbtools.core.oci.search.SearchResult;
import oracle.dbtools.core.util.DbtoolsException;
import oracle.dbtools.db.ConnectionSaveHandler;
import oracle.dbtools.net.commands.OCIConnectorType;
import oracle.dbtools.plusplus.connections.db.ConnectionDetailDisplay;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreCommand;
import oracle.dbtools.plusplus.connections.db.ConnectionStoreResources;
import oracle.dbtools.plusplus.connections.db.imp.DatabaseProviderImporter;
import oracle.dbtools.plusplus.connections.db.imp.ImportedConnectionResult;
import oracle.dbtools.plusplus.connections.db.save.DatabaseProviderFactory;
import oracle.dbtools.plusplus.util.CommandContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;

public final class ConnectionSaveHandlerFactory {
    public static ConnectionSaveHandler createPersistor(ScriptRunnerContext ctx, ExistingConnections existingConnections, PropertyValues props, ConnectorType connectorType, Refresher refreshAction) {
        ConnectionSaveHandler persistor = null;
        String name = ConnectionSaveHandler.getName(props);
        if (name != null && !name.isEmpty()) {
            persistor = OCIConnectorType.class.equals(connectorType.getClass()) ? new OCISaveHandler(ctx, name, ConnectionSaveHandler.replace(props), ConnectionSaveHandler.savePwd(props), existingConnections, refreshAction) : new OracleConnectionSaveHandler(ctx, name, ConnectionSaveHandler.replace(props), ConnectionSaveHandler.savePwd(props), existingConnections, connectorType, refreshAction);
        }
        if (persistor == null) {
            persistor = ConnectionSaveHandler.createDefaultHandler(props);
        }
        return persistor;
    }

    private static class OCISaveHandler
    extends StoredConnectionSaveHandler {
        private OCISaveHandler(ScriptRunnerContext ctx, String name, boolean replace, boolean savePwd, ExistingConnections existingConnections, Refresher refresher) {
            super(ctx, name, replace, savePwd, existingConnections, refresher);
        }

        @Override
        protected ImportedConnectionResult importConnection(CommandContext cmdCtx, PropertyValues props, ConnectionDefinition savedConnectionDefinition) {
            ResourceQuery.ResourceQueryConstraint constraint;
            String spec = props.getValueOf(URLProperty.URL);
            if (spec == null) {
                return ImportedConnectionResult.failure(this.name, ConnectionStoreResources.format("ERROR_INVALID_CONNSPEC", new Object[0]));
            }
            OCIStoredConnectionSupport ociSupport = ConnectionStoreCommand.createOciSupport(cmdCtx.getScriptRunnerContext());
            Collection connections = ociSupport.listConnections(constraint = ResourceQuery.matchConstraint((String)"identifier", (String)spec));
            if (connections.isEmpty()) {
                constraint = ResourceQuery.matchConstraint((String)"displayName", (String)spec);
                connections = ociSupport.listConnections(constraint);
            }
            if (connections.isEmpty()) {
                return ImportedConnectionResult.failure(this.name, ConnectionStoreResources.format("ERROR_CANNOT_FIND_CONNECTION", spec));
            }
            if (connections.size() > 1) {
                return ImportedConnectionResult.failure(this.name, ConnectionStoreResources.format("ERROR_DUPLICATE_DBTOOLS_NAME", spec));
            }
            try {
                ociSupport.storeConnection((SearchResult)connections.stream().findFirst().get(), this.name);
            }
            catch (DbtoolsException ex) {
                return ImportedConnectionResult.failure(this.name, ex.getLocalizedMessage());
            }
            return ImportedConnectionResult.success(this.name);
        }
    }

    public static interface ExistingConnections {
        public Collection<String> existingConnections();
    }

    public static interface Refresher {
        public void refresh();
    }

    private static class OracleConnectionSaveHandler
    extends StoredConnectionSaveHandler {
        private final ConnectorType connectorType;

        private OracleConnectionSaveHandler(ScriptRunnerContext ctx, String name, boolean replace, boolean savePwd, ExistingConnections existingConnections, ConnectorType connectorType, Refresher refresher) {
            super(ctx, name, replace, savePwd, existingConnections, refresher);
            this.connectorType = connectorType;
        }

        @Override
        protected void validateConnectionType(Map<ConnectionProperty, String> connectionProperties) {
            if (!DatabaseProviderFactory.hasFactory(this.connectorType)) {
                connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_UNSUPPORTED_TYPE", this.connectorType.getName()));
            }
        }

        @Override
        protected ImportedConnectionResult importConnection(CommandContext cmdCtx, PropertyValues props, ConnectionDefinition savedConnectionDefinition) {
            DatabaseProvider definition = this.createConnectionDefinition(props);
            if (definition == null) {
                return ImportedConnectionResult.failure(this.name, ConnectionStoreResources.getString("ERROR_SAVING_CONNECTION"));
            }
            DatabaseProviderImporter importer = DatabaseProviderImporter.createImporter(cmdCtx);
            return savedConnectionDefinition != null ? importer.importConnection(definition, this.name, savedConnectionDefinition.getIdentifier()) : importer.importConnection(definition, this.name);
        }

        private DatabaseProvider createConnectionDefinition(PropertyValues props) {
            DatabaseProvider definition = null;
            DatabaseProviderFactory factory = DatabaseProviderFactory.getDefinitionFactory(this.ctx, this.connectorType);
            if (factory != null) {
                definition = factory.createDatabaseProvider(this.name, this.savePwd, props);
            }
            return definition;
        }
    }

    private static abstract class StoredConnectionSaveHandler
    implements ConnectionSaveHandler {
        protected final ScriptRunnerContext ctx;
        protected final String name;
        protected final boolean replace;
        protected final boolean savePwd;
        protected final ExistingConnections existingConnections;
        protected final Refresher refresher;

        private StoredConnectionSaveHandler(ScriptRunnerContext ctx, String name, boolean replace, boolean savePwd, ExistingConnections existingConnections, Refresher refresher) {
            this.ctx = ctx;
            this.name = name;
            this.replace = replace;
            this.savePwd = savePwd;
            this.existingConnections = existingConnections;
            this.refresher = refresher;
        }

        protected void validateConnectionType(Map<ConnectionProperty, String> connectionProperties) {
        }

        @Override
        public void validateProperties(PropertyValues props, Map<ConnectionProperty, String> connectionProperties) {
            Collection<String> existingNames;
            this.refresher.refresh();
            this.validateConnectionType(connectionProperties);
            if (!ConnectionManagementUtil.instance().validateConnectionName((CharSequence)this.name)) {
                connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_INVALID_NAME", this.name));
            }
            if (!this.replace && (existingNames = this.existingConnections.existingConnections()).contains(this.name)) {
                connectionProperties.put(ConnectionProperty.ERROR_MESSAGE, ConnectionStoreResources.format("ERROR_EXISTING_CONNECTION", this.name));
            }
        }

        protected abstract ImportedConnectionResult importConnection(CommandContext var1, PropertyValues var2, ConnectionDefinition var3);

        @Override
        public void saveConnectionDetails(PropertyValues props, Connection conn) {
            Optional<ConnectionDefinition> savedConnectionDefinition;
            CommandContext cmdCtx = CommandContext.of(this.ctx, ConnectionSaveHandlerFactory.class);
            ImportedConnectionResult importResult = this.importConnection(cmdCtx, props, (savedConnectionDefinition = this.lookupSavedConnectionDefinition(this.name)).orElse(null));
            if (importResult.getResult() == ImportedConnectionResult.ResultState.SUCCESS) {
                this.refresher.refresh();
                ConnectionDetailDisplay.instance().displayConnectionDetails(cmdCtx, importResult.getName());
            } else {
                cmdCtx.getMessageLogger().logUserMessage(ConnectionStoreResources.getString("ERROR_SAVING_CONNECTION"));
                cmdCtx.getMessageLogger().logUserMessage(importResult.getResultMessage());
            }
        }

        private Optional<ConnectionDefinition> lookupSavedConnectionDefinition(String name) {
            return ConnectionStorage.instance().listConnectionDirectories().stream().map(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).loadConnection(arg_0)).filter(def -> def.getConnectionName().equals(name)).findAny();
        }
    }
}

