/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MetricsSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="backupSpaceUsedInGBs")
    private final Float backupSpaceUsedInGBs;
    @JsonProperty(value="backupSpaceEstimateInGBs")
    private final Float backupSpaceEstimateInGBs;
    @JsonProperty(value="unprotectedWindowInSeconds")
    private final Float unprotectedWindowInSeconds;
    @JsonProperty(value="dbSizeInGBs")
    private final Float dbSizeInGBs;
    @JsonProperty(value="isRedoLogsEnabled")
    private final Boolean isRedoLogsEnabled;
    @JsonProperty(value="retentionPeriodInDays")
    private final Float retentionPeriodInDays;
    @JsonProperty(value="currentRetentionPeriodInSeconds")
    private final Float currentRetentionPeriodInSeconds;
    @JsonProperty(value="minimumRecoveryNeededInDays")
    private final Float minimumRecoveryNeededInDays;

    @Deprecated
    @ConstructorProperties(value={"backupSpaceUsedInGBs", "backupSpaceEstimateInGBs", "unprotectedWindowInSeconds", "dbSizeInGBs", "isRedoLogsEnabled", "retentionPeriodInDays", "currentRetentionPeriodInSeconds", "minimumRecoveryNeededInDays"})
    public MetricsSummary(Float backupSpaceUsedInGBs, Float backupSpaceEstimateInGBs, Float unprotectedWindowInSeconds, Float dbSizeInGBs, Boolean isRedoLogsEnabled, Float retentionPeriodInDays, Float currentRetentionPeriodInSeconds, Float minimumRecoveryNeededInDays) {
        this.backupSpaceUsedInGBs = backupSpaceUsedInGBs;
        this.backupSpaceEstimateInGBs = backupSpaceEstimateInGBs;
        this.unprotectedWindowInSeconds = unprotectedWindowInSeconds;
        this.dbSizeInGBs = dbSizeInGBs;
        this.isRedoLogsEnabled = isRedoLogsEnabled;
        this.retentionPeriodInDays = retentionPeriodInDays;
        this.currentRetentionPeriodInSeconds = currentRetentionPeriodInSeconds;
        this.minimumRecoveryNeededInDays = minimumRecoveryNeededInDays;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getBackupSpaceUsedInGBs() {
        return this.backupSpaceUsedInGBs;
    }

    public Float getBackupSpaceEstimateInGBs() {
        return this.backupSpaceEstimateInGBs;
    }

    public Float getUnprotectedWindowInSeconds() {
        return this.unprotectedWindowInSeconds;
    }

    public Float getDbSizeInGBs() {
        return this.dbSizeInGBs;
    }

    public Boolean getIsRedoLogsEnabled() {
        return this.isRedoLogsEnabled;
    }

    public Float getRetentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Float getCurrentRetentionPeriodInSeconds() {
        return this.currentRetentionPeriodInSeconds;
    }

    public Float getMinimumRecoveryNeededInDays() {
        return this.minimumRecoveryNeededInDays;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricsSummary(");
        sb.append("super=").append(super.toString());
        sb.append("backupSpaceUsedInGBs=").append(String.valueOf(this.backupSpaceUsedInGBs));
        sb.append(", backupSpaceEstimateInGBs=").append(String.valueOf(this.backupSpaceEstimateInGBs));
        sb.append(", unprotectedWindowInSeconds=").append(String.valueOf(this.unprotectedWindowInSeconds));
        sb.append(", dbSizeInGBs=").append(String.valueOf(this.dbSizeInGBs));
        sb.append(", isRedoLogsEnabled=").append(String.valueOf(this.isRedoLogsEnabled));
        sb.append(", retentionPeriodInDays=").append(String.valueOf(this.retentionPeriodInDays));
        sb.append(", currentRetentionPeriodInSeconds=").append(String.valueOf(this.currentRetentionPeriodInSeconds));
        sb.append(", minimumRecoveryNeededInDays=").append(String.valueOf(this.minimumRecoveryNeededInDays));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricsSummary)) {
            return false;
        }
        MetricsSummary other = (MetricsSummary)((Object)o);
        return Objects.equals(this.backupSpaceUsedInGBs, other.backupSpaceUsedInGBs) && Objects.equals(this.backupSpaceEstimateInGBs, other.backupSpaceEstimateInGBs) && Objects.equals(this.unprotectedWindowInSeconds, other.unprotectedWindowInSeconds) && Objects.equals(this.dbSizeInGBs, other.dbSizeInGBs) && Objects.equals(this.isRedoLogsEnabled, other.isRedoLogsEnabled) && Objects.equals(this.retentionPeriodInDays, other.retentionPeriodInDays) && Objects.equals(this.currentRetentionPeriodInSeconds, other.currentRetentionPeriodInSeconds) && Objects.equals(this.minimumRecoveryNeededInDays, other.minimumRecoveryNeededInDays) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.backupSpaceUsedInGBs == null ? 43 : this.backupSpaceUsedInGBs.hashCode());
        result = result * 59 + (this.backupSpaceEstimateInGBs == null ? 43 : this.backupSpaceEstimateInGBs.hashCode());
        result = result * 59 + (this.unprotectedWindowInSeconds == null ? 43 : this.unprotectedWindowInSeconds.hashCode());
        result = result * 59 + (this.dbSizeInGBs == null ? 43 : this.dbSizeInGBs.hashCode());
        result = result * 59 + (this.isRedoLogsEnabled == null ? 43 : this.isRedoLogsEnabled.hashCode());
        result = result * 59 + (this.retentionPeriodInDays == null ? 43 : this.retentionPeriodInDays.hashCode());
        result = result * 59 + (this.currentRetentionPeriodInSeconds == null ? 43 : this.currentRetentionPeriodInSeconds.hashCode());
        result = result * 59 + (this.minimumRecoveryNeededInDays == null ? 43 : this.minimumRecoveryNeededInDays.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="backupSpaceUsedInGBs")
        private Float backupSpaceUsedInGBs;
        @JsonProperty(value="backupSpaceEstimateInGBs")
        private Float backupSpaceEstimateInGBs;
        @JsonProperty(value="unprotectedWindowInSeconds")
        private Float unprotectedWindowInSeconds;
        @JsonProperty(value="dbSizeInGBs")
        private Float dbSizeInGBs;
        @JsonProperty(value="isRedoLogsEnabled")
        private Boolean isRedoLogsEnabled;
        @JsonProperty(value="retentionPeriodInDays")
        private Float retentionPeriodInDays;
        @JsonProperty(value="currentRetentionPeriodInSeconds")
        private Float currentRetentionPeriodInSeconds;
        @JsonProperty(value="minimumRecoveryNeededInDays")
        private Float minimumRecoveryNeededInDays;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder backupSpaceUsedInGBs(Float backupSpaceUsedInGBs) {
            this.backupSpaceUsedInGBs = backupSpaceUsedInGBs;
            this.__explicitlySet__.add("backupSpaceUsedInGBs");
            return this;
        }

        public Builder backupSpaceEstimateInGBs(Float backupSpaceEstimateInGBs) {
            this.backupSpaceEstimateInGBs = backupSpaceEstimateInGBs;
            this.__explicitlySet__.add("backupSpaceEstimateInGBs");
            return this;
        }

        public Builder unprotectedWindowInSeconds(Float unprotectedWindowInSeconds) {
            this.unprotectedWindowInSeconds = unprotectedWindowInSeconds;
            this.__explicitlySet__.add("unprotectedWindowInSeconds");
            return this;
        }

        public Builder dbSizeInGBs(Float dbSizeInGBs) {
            this.dbSizeInGBs = dbSizeInGBs;
            this.__explicitlySet__.add("dbSizeInGBs");
            return this;
        }

        public Builder isRedoLogsEnabled(Boolean isRedoLogsEnabled) {
            this.isRedoLogsEnabled = isRedoLogsEnabled;
            this.__explicitlySet__.add("isRedoLogsEnabled");
            return this;
        }

        public Builder retentionPeriodInDays(Float retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            this.__explicitlySet__.add("retentionPeriodInDays");
            return this;
        }

        public Builder currentRetentionPeriodInSeconds(Float currentRetentionPeriodInSeconds) {
            this.currentRetentionPeriodInSeconds = currentRetentionPeriodInSeconds;
            this.__explicitlySet__.add("currentRetentionPeriodInSeconds");
            return this;
        }

        public Builder minimumRecoveryNeededInDays(Float minimumRecoveryNeededInDays) {
            this.minimumRecoveryNeededInDays = minimumRecoveryNeededInDays;
            this.__explicitlySet__.add("minimumRecoveryNeededInDays");
            return this;
        }

        public MetricsSummary build() {
            MetricsSummary model = new MetricsSummary(this.backupSpaceUsedInGBs, this.backupSpaceEstimateInGBs, this.unprotectedWindowInSeconds, this.dbSizeInGBs, this.isRedoLogsEnabled, this.retentionPeriodInDays, this.currentRetentionPeriodInSeconds, this.minimumRecoveryNeededInDays);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MetricsSummary model) {
            if (model.wasPropertyExplicitlySet("backupSpaceUsedInGBs")) {
                this.backupSpaceUsedInGBs(model.getBackupSpaceUsedInGBs());
            }
            if (model.wasPropertyExplicitlySet("backupSpaceEstimateInGBs")) {
                this.backupSpaceEstimateInGBs(model.getBackupSpaceEstimateInGBs());
            }
            if (model.wasPropertyExplicitlySet("unprotectedWindowInSeconds")) {
                this.unprotectedWindowInSeconds(model.getUnprotectedWindowInSeconds());
            }
            if (model.wasPropertyExplicitlySet("dbSizeInGBs")) {
                this.dbSizeInGBs(model.getDbSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("isRedoLogsEnabled")) {
                this.isRedoLogsEnabled(model.getIsRedoLogsEnabled());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInDays")) {
                this.retentionPeriodInDays(model.getRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("currentRetentionPeriodInSeconds")) {
                this.currentRetentionPeriodInSeconds(model.getCurrentRetentionPeriodInSeconds());
            }
            if (model.wasPropertyExplicitlySet("minimumRecoveryNeededInDays")) {
                this.minimumRecoveryNeededInDays(model.getMinimumRecoveryNeededInDays());
            }
            return this;
        }
    }
}

