/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.recovery;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.recovery.DatabaseRecovery;
import com.oracle.bmc.recovery.DatabaseRecoveryPaginators;
import com.oracle.bmc.recovery.DatabaseRecoveryWaiters;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import com.oracle.bmc.recovery.model.ProtectedDatabaseCollection;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.ProtectionPolicyCollection;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnet;
import com.oracle.bmc.recovery.model.RecoveryServiceSubnetCollection;
import com.oracle.bmc.recovery.model.WorkRequest;
import com.oracle.bmc.recovery.model.WorkRequestErrorCollection;
import com.oracle.bmc.recovery.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.recovery.model.WorkRequestSummaryCollection;
import com.oracle.bmc.recovery.requests.CancelProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectedDatabaseSubscriptionRequest;
import com.oracle.bmc.recovery.requests.ChangeProtectionPolicyCompartmentRequest;
import com.oracle.bmc.recovery.requests.ChangeRecoveryServiceSubnetCompartmentRequest;
import com.oracle.bmc.recovery.requests.CreateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.CreateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.CreateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.DeleteProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.DeleteRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.FetchProtectedDatabaseConfigurationRequest;
import com.oracle.bmc.recovery.requests.GetProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.GetProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.GetRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.requests.GetWorkRequestRequest;
import com.oracle.bmc.recovery.requests.ListProtectedDatabasesRequest;
import com.oracle.bmc.recovery.requests.ListProtectionPoliciesRequest;
import com.oracle.bmc.recovery.requests.ListRecoveryServiceSubnetsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.recovery.requests.ListWorkRequestsRequest;
import com.oracle.bmc.recovery.requests.ScheduleProtectedDatabaseDeletionRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectedDatabaseRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectionPolicyRequest;
import com.oracle.bmc.recovery.requests.UpdateRecoveryServiceSubnetRequest;
import com.oracle.bmc.recovery.responses.CancelProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectedDatabaseSubscriptionResponse;
import com.oracle.bmc.recovery.responses.ChangeProtectionPolicyCompartmentResponse;
import com.oracle.bmc.recovery.responses.ChangeRecoveryServiceSubnetCompartmentResponse;
import com.oracle.bmc.recovery.responses.CreateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.CreateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.CreateRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.DeleteProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.DeleteRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.FetchProtectedDatabaseConfigurationResponse;
import com.oracle.bmc.recovery.responses.GetProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.GetProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.GetRecoveryServiceSubnetResponse;
import com.oracle.bmc.recovery.responses.GetWorkRequestResponse;
import com.oracle.bmc.recovery.responses.ListProtectedDatabasesResponse;
import com.oracle.bmc.recovery.responses.ListProtectionPoliciesResponse;
import com.oracle.bmc.recovery.responses.ListRecoveryServiceSubnetsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.recovery.responses.ListWorkRequestsResponse;
import com.oracle.bmc.recovery.responses.ScheduleProtectedDatabaseDeletionResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectedDatabaseResponse;
import com.oracle.bmc.recovery.responses.UpdateProtectionPolicyResponse;
import com.oracle.bmc.recovery.responses.UpdateRecoveryServiceSubnetResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseRecoveryClient
extends BaseSyncClient
implements DatabaseRecovery {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASERECOVERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://recovery.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseRecoveryClient.class);
    private final DatabaseRecoveryWaiters waiters;
    private final DatabaseRecoveryPaginators paginators;

    DatabaseRecoveryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    DatabaseRecoveryClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DatabaseRecovery-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DatabaseRecoveryWaiters(executorService, this);
        this.paginators = new DatabaseRecoveryPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DatabaseRecoveryClient", (String)"fetchProtectedDatabaseConfiguration"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelProtectedDatabaseDeletionResponse cancelProtectedDatabaseDeletion(CancelProtectedDatabaseDeletionRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return (CancelProtectedDatabaseDeletionResponse)this.clientCall(request, CancelProtectedDatabaseDeletionResponse::builder).logger(LOG, "cancelProtectedDatabaseDeletion").serviceDetails("DatabaseRecovery", "CancelProtectedDatabaseDeletion", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/CancelProtectedDatabaseDeletion").method(Method.POST).requestBuilder(CancelProtectedDatabaseDeletionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("cancelDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelProtectedDatabaseDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProtectedDatabaseCompartmentResponse changeProtectedDatabaseCompartment(ChangeProtectedDatabaseCompartmentRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectedDatabaseCompartmentDetails(), "changeProtectedDatabaseCompartmentDetails is required");
        return (ChangeProtectedDatabaseCompartmentResponse)this.clientCall(request, ChangeProtectedDatabaseCompartmentResponse::builder).logger(LOG, "changeProtectedDatabaseCompartment").serviceDetails("DatabaseRecovery", "ChangeProtectedDatabaseCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ChangeProtectedDatabaseCompartment").method(Method.POST).requestBuilder(ChangeProtectedDatabaseCompartmentRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectedDatabaseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectedDatabaseCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProtectedDatabaseSubscriptionResponse changeProtectedDatabaseSubscription(ChangeProtectedDatabaseSubscriptionRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectedDatabaseSubscriptionDetails(), "changeProtectedDatabaseSubscriptionDetails is required");
        return (ChangeProtectedDatabaseSubscriptionResponse)this.clientCall(request, ChangeProtectedDatabaseSubscriptionResponse::builder).logger(LOG, "changeProtectedDatabaseSubscription").serviceDetails("DatabaseRecovery", "ChangeProtectedDatabaseSubscription", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ChangeProtectedDatabaseSubscription").method(Method.POST).requestBuilder(ChangeProtectedDatabaseSubscriptionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("changeSubscription").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectedDatabaseSubscriptionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectedDatabaseSubscriptionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProtectionPolicyCompartmentResponse changeProtectionPolicyCompartment(ChangeProtectionPolicyCompartmentRequest request) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProtectionPolicyCompartmentDetails(), "changeProtectionPolicyCompartmentDetails is required");
        return (ChangeProtectionPolicyCompartmentResponse)this.clientCall(request, ChangeProtectionPolicyCompartmentResponse::builder).logger(LOG, "changeProtectionPolicyCompartment").serviceDetails("DatabaseRecovery", "ChangeProtectionPolicyCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/ChangeProtectionPolicyCompartment").method(Method.POST).requestBuilder(ChangeProtectionPolicyCompartmentRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProtectionPolicyCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProtectionPolicyCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRecoveryServiceSubnetCompartmentResponse changeRecoveryServiceSubnetCompartment(ChangeRecoveryServiceSubnetCompartmentRequest request) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRecoveryServiceSubnetCompartmentDetails(), "changeRecoveryServiceSubnetCompartmentDetails is required");
        return (ChangeRecoveryServiceSubnetCompartmentResponse)this.clientCall(request, ChangeRecoveryServiceSubnetCompartmentResponse::builder).logger(LOG, "changeRecoveryServiceSubnetCompartment").serviceDetails("DatabaseRecovery", "ChangeRecoveryServiceSubnetCompartment", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/ChangeRecoveryServiceSubnetCompartment").method(Method.POST).requestBuilder(ChangeRecoveryServiceSubnetCompartmentRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeRecoveryServiceSubnetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeRecoveryServiceSubnetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateProtectedDatabaseResponse createProtectedDatabase(CreateProtectedDatabaseRequest request) {
        Objects.requireNonNull(request.getCreateProtectedDatabaseDetails(), "createProtectedDatabaseDetails is required");
        return (CreateProtectedDatabaseResponse)this.clientCall(request, CreateProtectedDatabaseResponse::builder).logger(LOG, "createProtectedDatabase").serviceDetails("DatabaseRecovery", "CreateProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/CreateProtectedDatabase").method(Method.POST).requestBuilder(CreateProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-dry-run", request.getOpcDryRun()).operationUsesDefaultRetries().hasBody().handleBody(ProtectedDatabase.class, CreateProtectedDatabaseResponse.Builder::protectedDatabase).handleResponseHeaderString("location", CreateProtectedDatabaseResponse.Builder::location).handleResponseHeaderString("etag", CreateProtectedDatabaseResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProtectedDatabaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateProtectionPolicyResponse createProtectionPolicy(CreateProtectionPolicyRequest request) {
        Objects.requireNonNull(request.getCreateProtectionPolicyDetails(), "createProtectionPolicyDetails is required");
        return (CreateProtectionPolicyResponse)this.clientCall(request, CreateProtectionPolicyResponse::builder).logger(LOG, "createProtectionPolicy").serviceDetails("DatabaseRecovery", "CreateProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/CreateProtectionPolicy").method(Method.POST).requestBuilder(CreateProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ProtectionPolicy.class, CreateProtectionPolicyResponse.Builder::protectionPolicy).handleResponseHeaderString("location", CreateProtectionPolicyResponse.Builder::location).handleResponseHeaderString("etag", CreateProtectionPolicyResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProtectionPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRecoveryServiceSubnetResponse createRecoveryServiceSubnet(CreateRecoveryServiceSubnetRequest request) {
        Objects.requireNonNull(request.getCreateRecoveryServiceSubnetDetails(), "createRecoveryServiceSubnetDetails is required");
        return (CreateRecoveryServiceSubnetResponse)this.clientCall(request, CreateRecoveryServiceSubnetResponse::builder).logger(LOG, "createRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "CreateRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/CreateRecoveryServiceSubnet").method(Method.POST).requestBuilder(CreateRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RecoveryServiceSubnet.class, CreateRecoveryServiceSubnetResponse.Builder::recoveryServiceSubnet).handleResponseHeaderString("location", CreateRecoveryServiceSubnetResponse.Builder::location).handleResponseHeaderString("etag", CreateRecoveryServiceSubnetResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRecoveryServiceSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProtectedDatabaseResponse deleteProtectedDatabase(DeleteProtectedDatabaseRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return (DeleteProtectedDatabaseResponse)this.clientCall(request, DeleteProtectedDatabaseResponse::builder).logger(LOG, "deleteProtectedDatabase").serviceDetails("DatabaseRecovery", "DeleteProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/DeleteProtectedDatabase").method(Method.DELETE).requestBuilder(DeleteProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendEnumQueryParam("deletionSchedule", (BmcEnum)request.getDeletionSchedule()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProtectedDatabaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProtectionPolicyResponse deleteProtectionPolicy(DeleteProtectionPolicyRequest request) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        return (DeleteProtectionPolicyResponse)this.clientCall(request, DeleteProtectionPolicyResponse::builder).logger(LOG, "deleteProtectionPolicy").serviceDetails("DatabaseRecovery", "DeleteProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/DeleteProtectionPolicy").method(Method.DELETE).requestBuilder(DeleteProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProtectionPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRecoveryServiceSubnetResponse deleteRecoveryServiceSubnet(DeleteRecoveryServiceSubnetRequest request) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        return (DeleteRecoveryServiceSubnetResponse)this.clientCall(request, DeleteRecoveryServiceSubnetResponse::builder).logger(LOG, "deleteRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "DeleteRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/DeleteRecoveryServiceSubnet").method(Method.DELETE).requestBuilder(DeleteRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRecoveryServiceSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public FetchProtectedDatabaseConfigurationResponse fetchProtectedDatabaseConfiguration(FetchProtectedDatabaseConfigurationRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return (FetchProtectedDatabaseConfigurationResponse)this.clientCall(request, FetchProtectedDatabaseConfigurationResponse::builder).logger(LOG, "fetchProtectedDatabaseConfiguration").serviceDetails("DatabaseRecovery", "FetchProtectedDatabaseConfiguration", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/FetchProtectedDatabaseConfiguration").method(Method.POST).requestBuilder(FetchProtectedDatabaseConfigurationRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("getConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(InputStream.class, FetchProtectedDatabaseConfigurationResponse.Builder::inputStream).handleResponseHeaderString("etag", FetchProtectedDatabaseConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", FetchProtectedDatabaseConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-filename", FetchProtectedDatabaseConfigurationResponse.Builder::opcFilename).handleResponseHeaderString("opc-checksum", FetchProtectedDatabaseConfigurationResponse.Builder::opcChecksum).callSync();
    }

    @Override
    public GetProtectedDatabaseResponse getProtectedDatabase(GetProtectedDatabaseRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return (GetProtectedDatabaseResponse)this.clientCall(request, GetProtectedDatabaseResponse::builder).logger(LOG, "getProtectedDatabase").serviceDetails("DatabaseRecovery", "GetProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/GetProtectedDatabase").method(Method.GET).requestBuilder(GetProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectedDatabase.class, GetProtectedDatabaseResponse.Builder::protectedDatabase).handleResponseHeaderString("etag", GetProtectedDatabaseResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectedDatabaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProtectionPolicyResponse getProtectionPolicy(GetProtectionPolicyRequest request) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        return (GetProtectionPolicyResponse)this.clientCall(request, GetProtectionPolicyResponse::builder).logger(LOG, "getProtectionPolicy").serviceDetails("DatabaseRecovery", "GetProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/GetProtectionPolicy").method(Method.GET).requestBuilder(GetProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectionPolicy.class, GetProtectionPolicyResponse.Builder::protectionPolicy).handleResponseHeaderString("etag", GetProtectionPolicyResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProtectionPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRecoveryServiceSubnetResponse getRecoveryServiceSubnet(GetRecoveryServiceSubnetRequest request) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        return (GetRecoveryServiceSubnetResponse)this.clientCall(request, GetRecoveryServiceSubnetResponse::builder).logger(LOG, "getRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "GetRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/GetRecoveryServiceSubnet").method(Method.GET).requestBuilder(GetRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RecoveryServiceSubnet.class, GetRecoveryServiceSubnetResponse.Builder::recoveryServiceSubnet).handleResponseHeaderString("etag", GetRecoveryServiceSubnetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecoveryServiceSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DatabaseRecovery", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListProtectedDatabasesResponse listProtectedDatabases(ListProtectedDatabasesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProtectedDatabasesResponse)this.clientCall(request, ListProtectedDatabasesResponse::builder).logger(LOG, "listProtectedDatabases").serviceDetails("DatabaseRecovery", "ListProtectedDatabases", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabaseCollection/ListProtectedDatabases").method(Method.GET).requestBuilder(ListProtectedDatabasesRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("protectionPolicyId", (Object)request.getProtectionPolicyId()).appendQueryParam("recoveryServiceSubnetId", (Object)request.getRecoveryServiceSubnetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectedDatabaseCollection.class, ListProtectedDatabasesResponse.Builder::protectedDatabaseCollection).handleResponseHeaderString("opc-request-id", ListProtectedDatabasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectedDatabasesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProtectionPoliciesResponse listProtectionPolicies(ListProtectionPoliciesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProtectionPoliciesResponse)this.clientCall(request, ListProtectionPoliciesResponse::builder).logger(LOG, "listProtectionPolicies").serviceDetails("DatabaseRecovery", "ListProtectionPolicies", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicyCollection/ListProtectionPolicies").method(Method.GET).requestBuilder(ListProtectionPoliciesRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("protectionPolicyId", (Object)request.getProtectionPolicyId()).appendEnumQueryParam("owner", (BmcEnum)request.getOwner()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectionPolicyCollection.class, ListProtectionPoliciesResponse.Builder::protectionPolicyCollection).handleResponseHeaderString("opc-request-id", ListProtectionPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectionPoliciesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRecoveryServiceSubnetsResponse listRecoveryServiceSubnets(ListRecoveryServiceSubnetsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListRecoveryServiceSubnetsResponse)this.clientCall(request, ListRecoveryServiceSubnetsResponse::builder).logger(LOG, "listRecoveryServiceSubnets").serviceDetails("DatabaseRecovery", "ListRecoveryServiceSubnets", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnetCollection/ListRecoveryServiceSubnets").method(Method.GET).requestBuilder(ListRecoveryServiceSubnetsRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("vcnId", (Object)request.getVcnId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RecoveryServiceSubnetCollection.class, ListRecoveryServiceSubnetsResponse.Builder::recoveryServiceSubnetCollection).handleResponseHeaderString("opc-request-id", ListRecoveryServiceSubnetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecoveryServiceSubnetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DatabaseRecovery", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestErrorCollection/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DatabaseRecovery", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestLogEntryCollection/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DatabaseRecovery", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/WorkRequestSummaryCollection/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210216").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ScheduleProtectedDatabaseDeletionResponse scheduleProtectedDatabaseDeletion(ScheduleProtectedDatabaseDeletionRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        return (ScheduleProtectedDatabaseDeletionResponse)this.clientCall(request, ScheduleProtectedDatabaseDeletionResponse::builder).logger(LOG, "scheduleProtectedDatabaseDeletion").serviceDetails("DatabaseRecovery", "ScheduleProtectedDatabaseDeletion", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/ScheduleProtectedDatabaseDeletion").method(Method.POST).requestBuilder(ScheduleProtectedDatabaseDeletionRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).appendPathParam("actions").appendPathParam("scheduleDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ScheduleProtectedDatabaseDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScheduleProtectedDatabaseDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProtectedDatabaseResponse updateProtectedDatabase(UpdateProtectedDatabaseRequest request) {
        Validate.notBlank((String)request.getProtectedDatabaseId(), (String)"protectedDatabaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProtectedDatabaseDetails(), "updateProtectedDatabaseDetails is required");
        return (UpdateProtectedDatabaseResponse)this.clientCall(request, UpdateProtectedDatabaseResponse::builder).logger(LOG, "updateProtectedDatabase").serviceDetails("DatabaseRecovery", "UpdateProtectedDatabase", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectedDatabase/UpdateProtectedDatabase").method(Method.PUT).requestBuilder(UpdateProtectedDatabaseRequest::builder).basePath("/20210216").appendPathParam("protectedDatabases").appendPathParam(request.getProtectedDatabaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProtectedDatabaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProtectedDatabaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProtectionPolicyResponse updateProtectionPolicy(UpdateProtectionPolicyRequest request) {
        Validate.notBlank((String)request.getProtectionPolicyId(), (String)"protectionPolicyId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProtectionPolicyDetails(), "updateProtectionPolicyDetails is required");
        return (UpdateProtectionPolicyResponse)this.clientCall(request, UpdateProtectionPolicyResponse::builder).logger(LOG, "updateProtectionPolicy").serviceDetails("DatabaseRecovery", "UpdateProtectionPolicy", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/ProtectionPolicy/UpdateProtectionPolicy").method(Method.PUT).requestBuilder(UpdateProtectionPolicyRequest::builder).basePath("/20210216").appendPathParam("protectionPolicies").appendPathParam(request.getProtectionPolicyId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProtectionPolicyResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProtectionPolicyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRecoveryServiceSubnetResponse updateRecoveryServiceSubnet(UpdateRecoveryServiceSubnetRequest request) {
        Validate.notBlank((String)request.getRecoveryServiceSubnetId(), (String)"recoveryServiceSubnetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecoveryServiceSubnetDetails(), "updateRecoveryServiceSubnetDetails is required");
        return (UpdateRecoveryServiceSubnetResponse)this.clientCall(request, UpdateRecoveryServiceSubnetResponse::builder).logger(LOG, "updateRecoveryServiceSubnet").serviceDetails("DatabaseRecovery", "UpdateRecoveryServiceSubnet", "https://docs.oracle.com/iaas/api/#/en/recovery-service/20210216/RecoveryServiceSubnet/UpdateRecoveryServiceSubnet").method(Method.PUT).requestBuilder(UpdateRecoveryServiceSubnetRequest::builder).basePath("/20210216").appendPathParam("recoveryServiceSubnets").appendPathParam(request.getRecoveryServiceSubnetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRecoveryServiceSubnetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRecoveryServiceSubnetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DatabaseRecoveryWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DatabaseRecoveryPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DatabaseRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DatabaseRecoveryClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DatabaseRecoveryClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DatabaseRecoveryClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DatabaseRecoveryClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseRecoveryClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "recovery";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"recovery");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DatabaseRecoveryClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DatabaseRecoveryClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

