/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Position;
import oracle.apexlang.core.Range;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Group;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangApplicationState;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangDocumentNode;

public class APEXLangDocumentState {
    private final int version;
    private final List<APEXLangDocumentNode> languageNodes;
    private final Integer pageId;
    private final String text;
    private final List<Integer> offsets;
    private APEXLangCompilationResult compilationResult;
    private final Metametadata metaMetaData;
    private APEXLangDocumentNode rootNode;

    public APEXLangDocumentState(String text, int version, URI uri, APEXLangApplicationState applicationState, System.Logger logger) {
        APEXLangDocumentNode node;
        this.text = text;
        this.version = version;
        String[] lines = this.text.split("\n");
        AtomicInteger atomicInteger = new AtomicInteger(0);
        this.offsets = Arrays.stream(lines).map(line -> atomicInteger.getAndAdd(line.length() + 1)).collect(Collectors.toUnmodifiableList());
        this.metaMetaData = applicationState.getMetaMetaData();
        this.compilationResult = applicationState.compile(uri, text, logger);
        APEXLangDocumentNode.Builder builder = APEXLangDocumentNode.builder();
        this.buildNodes(builder, null);
        this.rootNode = builder.build();
        this.languageNodes = new ArrayList<APEXLangDocumentNode>();
        this.addLanguageNodes(this.rootNode);
        Integer pageId = null;
        if (this.rootNode.children().size() == 1 && "page".equals((node = this.rootNode.children().get(0)).name())) {
            String id = node.detail();
            if (id.length() > 1 && id.startsWith("\"") && id.endsWith("\"")) {
                id = node.detail().substring(1, node.detail().length() - 1);
            }
            try {
                Double d = Double.parseDouble(id);
                pageId = d.intValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.pageId = pageId;
    }

    public int getVersion() {
        return this.version;
    }

    public APEXLangSyntaxError[] getErrors() {
        return this.compilationResult.getErrors();
    }

    public Collection<Component> getComponents() {
        return this.compilationResult.getComponentsParameters();
    }

    public List<APEXLangDocumentNode> getLanguageNodes() {
        return Collections.unmodifiableList(this.languageNodes);
    }

    public Integer getPageId() {
        return this.pageId;
    }

    public APEXLangDocumentNode getRootNode() {
        return this.rootNode;
    }

    public Position getPosition(int offset) {
        int line;
        for (line = 0; line < this.offsets.size() - 1 && this.offsets.get(line + 1) <= offset; ++line) {
        }
        int column = offset - this.offsets.get(line);
        return new Position(Integer.valueOf(line + 1), Integer.valueOf(column));
    }

    public int getOffset(int line, int column) {
        return this.offsets.get(line - 1) + column;
    }

    private void buildNodes(APEXLangDocumentNode.Builder parentNode, Component component) {
        if (component != null) {
            List<Component> relatedComponents = this.getAllRelatedComponents(component);
            HashMap<String, APEXLangDocumentNode.Builder> groupNodes = new HashMap<String, APEXLangDocumentNode.Builder>();
            for (Component relatedComponent : relatedComponents) {
                for (ComponentGroup componentGroup : relatedComponent.getComponentGroups()) {
                    String groupName = componentGroup.getName();
                    APEXLangDocumentNode.Builder groupNode = parentNode.newChild().nodeType(APEXLangDocumentNode.NodeType.GROUP).name(groupName).range(componentGroup.getRange()).component(relatedComponent);
                    groupNode.newChild().nodeType(APEXLangDocumentNode.NodeType.GROUP_NAME).name(groupName).range(componentGroup.getNameRange()).component(relatedComponent);
                    groupNodes.put(groupName, groupNode);
                }
            }
            for (Component relatedComponent : relatedComponents) {
                for (Map.Entry entry : relatedComponent.getParameters().entrySet()) {
                    ComponentParameter componentParameter = (ComponentParameter)entry.getValue();
                    if (!componentParameter.isInSource() || componentParameter.isExternalIdentifier().booleanValue()) continue;
                    Property property = componentParameter.getProperty();
                    Group group = (Group)this.metaMetaData.getGroups().get(property.getGroupId());
                    String groupName = group == null ? null : group.getName();
                    APEXLangDocumentNode.Builder propParentNode = componentParameter.isImplicitGroup() ? parentNode : (APEXLangDocumentNode.Builder)groupNodes.get(groupName);
                    if (propParentNode == null) continue;
                    APEXLangDocumentNode.Builder propNode = propParentNode.newChild().component(relatedComponent).componentParameter(componentParameter).property(property).name(property.getName()).range(componentParameter.getRange());
                    Range valueRange = componentParameter.getValueRange();
                    String value = this.text.substring(valueRange.getStart(), valueRange.getEnd());
                    String multiValueDelimiter = property.getMultiValueDelimiter();
                    if (multiValueDelimiter == null) {
                        multiValueDelimiter = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getDefaultMultiValueDelimiter();
                    }
                    propNode.newChild().range(componentParameter.getKeyRange()).component(relatedComponent).componentParameter(componentParameter).property(property).nodeType(APEXLangDocumentNode.NodeType.PROPERTY_NAME).name(property.getName());
                    if (value.startsWith("[") && value.endsWith("]") && multiValueDelimiter != null) {
                        propNode.nodeType(APEXLangDocumentNode.NodeType.ARRAY_PROPERTY);
                        String[] chunks = value.substring(1, value.length() - 1).split(multiValueDelimiter);
                        int additionalOffset = componentParameter.getValueRange().getStart() + 1;
                        for (String chunk : chunks) {
                            Pattern p;
                            Matcher m;
                            if (!chunk.trim().isEmpty() && (m = (p = Pattern.compile("^\\s*(.).*")).matcher(chunk)).matches()) {
                                String name = chunk.trim();
                                int start = additionalOffset + m.start(1);
                                int end = start + name.length();
                                propNode.newChild().nodeType(APEXLangDocumentNode.NodeType.TEXT_PROPERTY).component(relatedComponent).componentParameter(componentParameter).property(property).name(name).range(new Range(Integer.valueOf(start), Integer.valueOf(end)));
                            }
                            additionalOffset = additionalOffset + chunk.length() + multiValueDelimiter.length();
                        }
                        continue;
                    }
                    propNode.nodeType(APEXLangDocumentNode.NodeType.TEXT_PROPERTY).detail(value);
                    if (property.getLov() != null) {
                        propNode.nodeType(APEXLangDocumentNode.NodeType.LOV_PROPERTY);
                    } else {
                        String dataType = ((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getDataType();
                        if ("integer".equals(dataType) || "number".equals(dataType)) {
                            propNode.nodeType(APEXLangDocumentNode.NodeType.NUMERIC_PROPERTY);
                        } else if ("boolean".equals(dataType)) {
                            propNode.nodeType(APEXLangDocumentNode.NodeType.BOOLEAN_PROPERTY);
                        }
                    }
                    propNode.newChild().range(componentParameter.getValueRange()).component(relatedComponent).componentParameter(componentParameter).property(property).language(((PropertyType)this.metaMetaData.getPropertyTypes().get(property.getType())).getLanguage()).nodeType(APEXLangDocumentNode.NodeType.PROPERTY_VALUE).name(componentParameter.getValue());
                }
            }
        }
        this.getComponents().forEach(childComponent -> {
            if (!(childComponent.getParent() != component || component != null && component.getRelatedComponentsFound().contains(childComponent))) {
                APEXLangDocumentNode.Builder componentNode = parentNode.newChild();
                componentNode.component((Component)childComponent);
                componentNode.nodeType(APEXLangDocumentNode.NodeType.COMPONENT);
                String name = ((ComponentType)this.metaMetaData.getComponentTypes().get(childComponent.getTypeId())).getName().getSingular();
                componentNode.name(name);
                Integer start = childComponent.getRange().getStart();
                Integer end = childComponent.getRange().getEnd();
                String fullText = this.text.substring(start, end + 1);
                String compText = fullText.trim();
                start = start + fullText.indexOf(compText);
                end = start + compText.length();
                componentNode.range(new Range(start, end));
                ComponentParameter componentParameter = (ComponentParameter)childComponent.getParameters().get(childComponent.getExternalIdentifierPropertyId());
                if (componentParameter != null) {
                    Range range = componentParameter.getValueRange();
                    componentNode.detail(this.text.substring(range.getStart(), range.getEnd()));
                    componentNode.newChild().range(componentParameter.getKeyRange()).componentParameter(componentParameter).component((Component)childComponent).nodeType(APEXLangDocumentNode.NodeType.COMPONENT_TYPE).name(name);
                    componentNode.newChild().range(componentParameter.getValueRange()).componentParameter(componentParameter).component((Component)childComponent).nodeType(APEXLangDocumentNode.NodeType.COMPONENT_NAME).name(componentParameter.getValue());
                } else {
                    componentNode.detail(childComponent.getExternalIdentifier());
                }
                this.buildNodes(componentNode, (Component)childComponent);
            }
        });
    }

    private List<Component> getAllRelatedComponents(Component component) {
        ArrayList<Component> list = new ArrayList<Component>();
        this.addRelatedComponents(component, list);
        return list;
    }

    private void addRelatedComponents(Component component, List<Component> list) {
        list.add(component);
        component.getRelatedComponentsFound().forEach(c -> this.addRelatedComponents((Component)c, list));
    }

    public APEXLangDocumentNode getNodeAtOffset(int offset) {
        return this.getNodeAtOffset(offset, this.getRootNode());
    }

    private APEXLangDocumentNode getNodeAtOffset(int offset, APEXLangDocumentNode parent) {
        Optional<APEXLangDocumentNode> node = parent.children().stream().filter(n -> n.range().getStart() <= offset && n.range().getEnd() >= offset).findFirst();
        if (node.isPresent()) {
            return this.getNodeAtOffset(offset, node.get());
        }
        return parent;
    }

    private void addLanguageNodes(APEXLangDocumentNode node) {
        String lang = node.language();
        List<APEXLangDocumentNode> children = node.children();
        if (lang != null) {
            this.languageNodes.add(node);
        } else if (children != null && children.size() > 0) {
            children.forEach(c -> this.addLanguageNodes((APEXLangDocumentNode)c));
        }
    }
}

