/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.Range;
import oracle.apexlang.metametadata.Property;

public class APEXLangDocumentNode {
    private final NodeType nodeType;
    private final Component component;
    private final ComponentParameter componentParameter;
    private final Property property;
    private final Range range;
    private final String name;
    private final String detail;
    private final String language;
    private final APEXLangDocumentNode parent;
    private final List<APEXLangDocumentNode> children;

    public NodeType nodeType() {
        return this.nodeType;
    }

    public Component component() {
        return this.component;
    }

    public ComponentParameter componentParameter() {
        return this.componentParameter;
    }

    public Property property() {
        return this.property;
    }

    public Range range() {
        return this.range;
    }

    public String name() {
        return this.name;
    }

    public String detail() {
        return this.detail;
    }

    public String language() {
        return this.language;
    }

    public boolean isOracleSql() {
        return "sql".equals(this.language) || "plsql".equals(this.language);
    }

    public APEXLangDocumentNode parent() {
        return this.parent;
    }

    public List<APEXLangDocumentNode> children() {
        return this.children;
    }

    private APEXLangDocumentNode(Builder builder) {
        this.nodeType = builder.nodeType;
        this.component = builder.component;
        this.componentParameter = builder.componentParameter;
        this.property = builder.property;
        this.range = builder.range;
        this.name = builder.name;
        this.detail = builder.detail;
        this.language = builder.language;
        this.parent = builder.parent;
        ArrayList<APEXLangDocumentNode> children2 = new ArrayList<APEXLangDocumentNode>();
        builder.children.forEach(childBuilder -> children2.add(childBuilder.parent(this).build()));
        children2.sort(Comparator.comparingInt(o -> o.range.getStart()));
        this.children = Collections.unmodifiableList(children2);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum NodeType {
        COMPONENT,
        GROUP,
        TEXT_PROPERTY,
        NUMERIC_PROPERTY,
        BOOLEAN_PROPERTY,
        LOV_PROPERTY,
        ARRAY_PROPERTY,
        COMPONENT_TYPE,
        COMPONENT_NAME,
        GROUP_NAME,
        PROPERTY_NAME,
        PROPERTY_VALUE;

    }

    public static class Builder {
        private NodeType nodeType;
        private Component component;
        private ComponentParameter componentParameter;
        private Property property;
        private Range range;
        private String name;
        private String detail;
        private String language;
        private APEXLangDocumentNode parent;
        private final List<Builder> children = new ArrayList<Builder>();

        private Builder() {
        }

        public APEXLangDocumentNode build() {
            return new APEXLangDocumentNode(this);
        }

        public Builder newChild() {
            Builder childBuilder = new Builder();
            this.children.add(childBuilder);
            return childBuilder;
        }

        private Builder parent(APEXLangDocumentNode parent) {
            this.parent = parent;
            return this;
        }

        public Builder nodeType(NodeType nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder component(Component component) {
            this.component = component;
            return this;
        }

        public Builder componentParameter(ComponentParameter componentParameter) {
            this.componentParameter = componentParameter;
            return this;
        }

        public Builder property(Property property) {
            this.property = property;
            return this;
        }

        public Builder range(Range range) {
            this.range = range;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }
    }
}

