/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.apexlang.APEXApplicationInstallOverrides;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangImporter;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangManifestGenerator;
import oracle.dbtools.extension.apex.core.apexlang.APEXLangTranspiler;
import oracle.dbtools.extension.apex.exceptions.ApexQueryException;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.APEXLangUtils;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;

public class APEXLangHandler {
    private static OutputStream _out;
    private final MutableCommand _command;
    private ScriptRunnerContext _ctx;
    private Connection _gConn;

    public APEXLangHandler(MutableCommand command) {
        this._command = command;
    }

    public void Validate() {
        try {
            if (this.transpile() != null) {
                this._ctx.writeln(ApexMessages.getString("VALIDATION_SUCCESSFUL"));
            }
        }
        catch (IOException | SQLException | ApexQueryException | AppNotInstalledException | InvalidParameterException e) {
            this._ctx.writeln(e.getMessage());
        }
    }

    public void Import() {
        try {
            Version version = new Version(ApexUtil._version.isEmpty() ? ApexUtil.getApexVersion(this._gConn) : ApexUtil._version);
            if (version.compareTo(new Version("25.1")) < 0) {
                this._ctx.writeln(ApexMessages.getString("APEXLANG_IMPORT_NOT_SUPPORTED"));
                return;
            }
            APEXLangCompilationResult compResult = this.transpile();
            if (compResult != null) {
                this.doImport(compResult.getPlsqlOutput());
            }
        }
        catch (IOException | SQLException | ApexQueryException | AppNotInstalledException | InvalidParameterException e) {
            this._ctx.writeln(e.getMessage());
        }
    }

    private APEXLangCompilationResult transpile() throws IOException, InvalidParameterException, SQLException, ApexQueryException, AppNotInstalledException {
        APEXLangCompilationResult compResult;
        Path inputPath = this.getInputPathOption();
        if (inputPath == null && !APEXLangUtils.directoryContainsManifestOrAPEXlang(inputPath = Path.of(FileUtils.getCWD((ScriptRunnerContext)this._ctx), new String[0]))) {
            throw new InvalidParameterException(ApexMessages.getString("DIRECTORY_FILES_ERROR"));
        }
        BigDecimal workspaceId = this.getBigDecimal(ApexOptions.Symbol.WORKSPACEID);
        APEXLangTranspiler transpiler = new APEXLangTranspiler();
        if (APEXLangUtils.isAPEXLangFile(inputPath)) {
            APEXLangManifestGenerator.Builder builder = new APEXLangManifestGenerator.Builder();
            builder.workspaceId(workspaceId);
            builder.setFromConnection(this._gConn);
            APEXLangManifestObject manifest = builder.build().generate();
            compResult = transpiler.transpile(inputPath, manifest);
        } else {
            compResult = transpiler.transpile(inputPath);
        }
        if (compResult.getErrors().length != 0) {
            this._ctx.writeln(transpiler.formatErrors(compResult.getErrors()));
            return null;
        }
        return compResult;
    }

    private void doImport(String plSQL) throws SQLException, IOException {
        if (plSQL == null || plSQL.isEmpty()) {
            this._ctx.writeln(ApexMessages.getString("NO_PLSQL"));
        } else {
            APEXApplicationInstallOverrides overrides = APEXApplicationInstallOverrides.builder().workspaceId(this.getBigDecimal(ApexOptions.Symbol.WORKSPACEID)).applicationId(this.getBigDecimal(ApexOptions.Symbol.ID)).offset(this.getBigDecimal(ApexOptions.Symbol.OFFSET)).schema(this.getString(ApexOptions.Symbol.SCHEMA)).name(this.getString(ApexOptions.Symbol.NAME)).alias(this.getString(ApexOptions.Symbol.ALIAS)).imagePrefix(this.getString(ApexOptions.Symbol.IMAGE_PREFIX)).proxy(this.getString(ApexOptions.Symbol.PROXY)).build();
            ScriptRunnerContext rctx = this._ctx.clone();
            rctx.setSQLPlusBuffer(this._ctx.getSQLPlusBuffer());
            APEXLangImporter importer = new APEXLangImporter(this._gConn, rctx, overrides);
            String impResult = importer.executePLSQL(plSQL).replace(ApexMessages.getString("PLSQL_COMPLETED"), "");
            if (impResult.isEmpty() || impResult.isBlank()) {
                this._ctx.writeln(ApexMessages.getString("IMPORT_SUCCESSFUL"));
            } else {
                this._ctx.writeln(ApexMessages.format("IMPORT_RESULT", impResult));
            }
        }
    }

    private Path getInputPathOption() throws InvalidParameterException {
        return APEXLangUtils.resolveRelativePathOption((String)this._command.getOptionValue(ApexOptions.Symbol.INPUT), FileUtils.getCWD((ScriptRunnerContext)this._ctx));
    }

    private String getString(Id id) {
        return (String)this._command.getOptionValue(id);
    }

    private BigDecimal getBigDecimal(Id id) {
        return (BigDecimal)this._command.getOptionValue(id);
    }

    public void setConnection(Connection conn) {
        this._gConn = conn;
    }

    public void setCtx(ScriptRunnerContext ctx) {
        this._ctx = ctx;
    }

    public void setOutStream(OutputStream out) {
        _out = out;
    }
}

