/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.diff;

import java.util.List;
import oracle.dbtools.extension.project.diff.ObjectDiff;
import oracle.dbtools.extension.project.diff.SchedulerInfo;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.plsql.ParsedSql;

public class SchedulerDiff
extends ObjectDiff {
    SchedulerInfo s1 = null;
    SchedulerInfo s2 = null;

    public SchedulerDiff(ParsedSql parsed1, ParsedSql parsed2) throws Exception {
        super(parsed1, parsed2);
        this.s1 = new SchedulerInfo((Parsed)parsed1);
        this.s2 = new SchedulerInfo((Parsed)parsed2);
    }

    @Override
    public String alters() {
        String name = "";
        if (this.s1.attributes.get("schedule_name") != null) {
            name = this.s1.attributes.get("schedule_name").get(0);
        } else if (this.s1.attributes.get("program_name") != null) {
            name = this.s1.attributes.get("program_name").get(0);
        } else if (this.s1.attributes.get("job_name") != null) {
            name = this.s1.attributes.get("job_name").get(0);
        } else if (this.s1.attributes.get("job_class_name") != null) {
            name = this.s1.attributes.get("job_class_name").get(0);
        }
        List<String> sourceAttributes = this.s1.attributes.get("attribute");
        List<String> currentAttributes = this.s2.attributes.get("attribute");
        List<String> sourceAttributesValues = this.s1.attributes.get("value");
        List<String> currentAttributesValues = this.s2.attributes.get("value");
        Object ret = "BEGIN\n";
        ret = this.s1.attributes.get("job_name") == null ? this.handleNonJobObject(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues) : this.handleJobObject(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        ret = (String)ret + "END;\n/";
        return ret;
    }

    public String setAttribute(String name, String attr, String value) {
        attr = this.normalizeQuotedString(attr);
        return "DBMS_SCHEDULER.set_attribute (\nname      => " + name + ",\nattribute => '" + attr + "',\nvalue     => " + value + ");\n";
    }

    public String nullifyAttribute(String name, String attr) {
        attr = this.normalizeQuotedString(attr);
        return "DBMS_SCHEDULER.set_attribute_null (\nname      => " + name + ",\nattribute => '" + attr + "');\n";
    }

    public String enableObject(String name) {
        return "DBMS_SCHEDULER.enable(" + name + ");\n";
    }

    public String disableObject(String name) {
        return "DBMS_SCHEDULER.disable(" + name + ");\n";
    }

    public String handleNonJobObject(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        ret = this.applyNormalAlterLogic(name, ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        return ret;
    }

    public String handleJobObject(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        boolean sourceIsJobEnabledState = this.s1.isEnabled;
        boolean currentIsJobEnabledState = this.s2.isEnabled;
        if (!sourceIsJobEnabledState && !currentIsJobEnabledState) {
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else if (sourceIsJobEnabledState && currentIsJobEnabledState) {
            ret = (String)ret + this.disableObject(name);
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
            ret = (String)ret + this.enableObject(name);
        } else if (sourceIsJobEnabledState) {
            ret = (String)ret + this.disableObject(name);
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
        } else {
            ret = this.applyNormalAlterLogic(name, (String)ret, currentAttributes, sourceAttributes, currentAttributesValues, sourceAttributesValues);
            ret = (String)ret + this.enableObject(name);
        }
        return ret;
    }

    public String applyNormalAlterLogic(String name, String ret, List<String> currentAttributes, List<String> sourceAttributes, List<String> currentAttributesValues, List<String> sourceAttributesValues) {
        String sourceEnabledState = null;
        String currentEnabledState = null;
        for (String attr : this.s1.attributes.keySet()) {
            String value2;
            if (attr.equals(name) || attr.equals("attribute") || attr.equals("value") || attr.equals("name")) continue;
            if (attr.equals("enabled") && this.s1.attributes.get("job_name") == null) {
                sourceEnabledState = this.s1.attributes.get(attr).get(0);
                currentEnabledState = this.s2.attributes.get(attr).get(0);
                continue;
            }
            String value1 = this.s1.attributes.get(attr).get(0);
            if (value1.equalsIgnoreCase(value2 = this.s2.attributes.get(attr).get(0))) continue;
            if (!value2.equalsIgnoreCase("null")) {
                ret = (String)ret + this.setAttribute(name, attr, value2);
                continue;
            }
            ret = (String)ret + this.nullifyAttribute(name, attr);
        }
        if (currentAttributes != null && !currentAttributes.isEmpty()) {
            for (String attr : currentAttributes) {
                int indexOfAttr = currentAttributes.indexOf(attr);
                String valueOfAttr = currentAttributesValues.get(indexOfAttr);
                if (sourceAttributes != null && !sourceAttributes.isEmpty()) {
                    boolean existsInSource = sourceAttributes.contains(attr);
                    if (!existsInSource) {
                        ret = (String)ret + this.setAttribute(name, attr, currentAttributesValues.get(indexOfAttr));
                        continue;
                    }
                    String sourceValue = sourceAttributesValues.get(sourceAttributes.indexOf(attr));
                    if (sourceValue.equalsIgnoreCase(valueOfAttr)) continue;
                    ret = (String)ret + this.setAttribute(name, attr, valueOfAttr);
                    continue;
                }
                ret = (String)ret + this.setAttribute(name, attr, valueOfAttr);
            }
        }
        if (sourceAttributes != null && !sourceAttributes.isEmpty()) {
            for (String attr : sourceAttributes) {
                if (currentAttributes != null && !currentAttributes.isEmpty()) {
                    boolean existInCurrent = currentAttributes.contains(attr);
                    if (existInCurrent) continue;
                    ret = (String)ret + this.nullifyAttribute(name, attr);
                    continue;
                }
                ret = (String)ret + this.nullifyAttribute(name, attr);
            }
        }
        if (this.s1.attributes.get("job_name") == null && sourceEnabledState != null && currentEnabledState != null && !sourceEnabledState.equalsIgnoreCase(currentEnabledState)) {
            ret = currentEnabledState.equalsIgnoreCase("true") ? (String)ret + this.enableObject(name) : (String)ret + this.disableObject(name);
        }
        return ret;
    }

    public String normalizeQuotedString(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        if (input.startsWith("'") && input.endsWith("'") && input.length() > 1) {
            input = input.substring(1, input.length() - 1);
        }
        return input.replace("'", "''");
    }
}

