/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class StageSoftObjectIsolation
implements VerifyServiceInterface {
    @Override
    public String getName() {
        return "stagesoftobjectisolation";
    }

    @Override
    public String getGroup() {
        return "stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        Path codeFolderPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/next/code");
        Path changesFolderPath = Paths.get(FileUtils.getCWD((ScriptRunnerContext)ScriptRunnerContext.getCurrentContext()), "dist/releases/next/changes");
        if (StageConstants.isReleaseIsolation()) {
            Object message = VerifyMessages.format("SOFTOBJECTISOLATION_VALUE", "Release");
            boolean releaseError = false;
            List<String> subfoldersList = this.subfoldersFromSoftObjects(new File(changesFolderPath.toString()));
            if (!subfoldersList.isEmpty()) {
                String subfoldersListConcatenated = String.join((CharSequence)", ", subfoldersList);
                message = (String)message + "\n" + VerifyMessages.format("SOFTOBJECTISOLATION_CHANGES_SOFTOBJECTS_KO", subfoldersListConcatenated);
                releaseError = true;
            } else {
                message = (String)message + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CHANGES_SOFTOBJECTS_OK");
            }
            if (Files.isDirectory(codeFolderPath, new LinkOption[0])) {
                boolean codeError = false;
                try {
                    File[] codeFolderFiles;
                    String schema = ProjectConfig.getCurrentContext().getCurrentConnection().getSchema();
                    Path schemaFolder = Path.of(codeFolderPath.toString(), schema.toLowerCase());
                    if (Files.isDirectory(schemaFolder, new LinkOption[0]) && (codeFolderFiles = new File(schemaFolder.toString()).listFiles()) != null) {
                        for (File currentFile : codeFolderFiles) {
                            if (!currentFile.isDirectory() || oracle.dbtools.extension.project.commands.stage.transforms.StageConstants.SoftObjects.contains(ObjectTypes.singular(currentFile.getName()).toUpperCase())) continue;
                            codeError = true;
                        }
                    }
                }
                catch (SQLException e) {
                    codeError = true;
                }
                if (codeError) {
                    message = (String)message + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CODE_PRESENT_CONTENT_KO");
                    releaseError = true;
                } else {
                    message = (String)message + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CODE_PRESENT_CONTENT_OK");
                }
            } else {
                message = (String)message + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CODE_ABSENT_ERROR");
                releaseError = true;
            }
            if (releaseError) {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, (String)message);
                return false;
            }
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, (String)message);
            return true;
        }
        if (Files.isDirectory(codeFolderPath, new LinkOption[0])) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, VerifyMessages.format("SOFTOBJECTISOLATION_VALUE", "Change") + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CODE_PRESENT_ERROR"));
            return false;
        }
        this.addMessage(VerifyServiceInterface.MessageLevel.INFO, VerifyMessages.format("SOFTOBJECTISOLATION_VALUE", "Change") + "\n" + VerifyMessages.getString("SOFTOBJECTISOLATION_CODE_ABSENT"));
        return true;
    }

    private List<String> subfoldersFromSoftObjects(File folder) {
        File[] subfiles;
        ArrayList<String> result = new ArrayList<String>();
        if (folder.isDirectory() && (subfiles = folder.listFiles()) != null) {
            for (File subFile : subfiles) {
                if (subFile.isDirectory() && oracle.dbtools.extension.project.commands.stage.transforms.StageConstants.SoftObjects.contains(ObjectTypes.singular(subFile.getName()).toUpperCase())) {
                    result.add(subFile.getName().toUpperCase());
                    continue;
                }
                result.addAll(this.subfoldersFromSoftObjects(subFile));
            }
        }
        return result;
    }
}

