/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.settings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.wnameless.json.flattener.FlattenMode;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.github.wnameless.json.unflattener.JsonUnflattener;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.verify.VerifyMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.SettingSerializer;
import oracle.dbtools.extension.project.core.settings.Settings;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import org.apache.commons.io.FileUtils;

public class ProjectSettings {
    private static final ObjectMapper mapper = new ObjectMapper();
    protected static LinkedHashMap<String, Settings> systemConfigMap = new LinkedHashMap();
    protected static Map<String, Object> userConfigMap = new LinkedHashMap<String, Object>();

    private ProjectSettings() {
    }

    public static String getSettingsType(String key) throws ProjectSettingsException {
        try {
            return ProjectSettings.getSettingsNode(key).getType().toString();
        }
        catch (Exception e) {
            throw new ProjectSettingsException(StageMessages.format("TYPE_NOT_FOUND", key));
        }
    }

    public static String getAllowedValues(String key) {
        return ProjectSettings.getSettingsNode(key).getAllowedVal();
    }

    public static Settings getSettingsNode(String key) {
        return systemConfigMap.get(key);
    }

    public static <T> T getConfigValue(String key) {
        try {
            Object o = userConfigMap.get(key);
            Settings settings = systemConfigMap.get(key);
            if (settings == null) {
                return null;
            }
            if (o == null) {
                o = settings.getDefaultVal();
            }
            switch (settings.getType()) {
                case INTEGER: {
                    if (o instanceof Integer) {
                        return (T)o;
                    }
                    return (T)Integer.valueOf(o.toString());
                }
                case OBJECT: {
                    return (T)o;
                }
                case BOOLEAN: {
                    if (o instanceof Boolean) {
                        return (T)o;
                    }
                    return (T)Boolean.valueOf(o.toString());
                }
                case STRING: {
                    return (T)o.toString();
                }
            }
            return (T)o.toString();
        }
        catch (ClassCastException e) {
            ProjectConfig.getCurrentContext().writeln("Invalid type conversion: " + e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
    }

    public static <T> T getConfigValue(String key, Class<T> clazz) {
        try {
            Object o = userConfigMap.get(key);
            if (o == null) {
                Settings value = systemConfigMap.get(key);
                if (value == null) {
                    return null;
                }
                o = value.getDefaultVal();
            }
            return clazz.isInstance(o) ? (T)clazz.cast(o) : null;
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            return null;
        }
    }

    public static Map<String, Object> getConfigSubMap(String matcher) {
        try {
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            for (String key : userConfigMap.keySet()) {
                if (!key.startsWith(matcher)) continue;
                subMap.put(key, userConfigMap.get(key));
            }
            return subMap;
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            return new HashMap<String, Object>();
        }
    }

    public static String toCamelCase(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder outString = new StringBuilder();
        char[] charString = string.toCharArray();
        boolean uppercaseNext = false;
        for (char letter : charString) {
            if (letter == '-' || letter == '_') {
                uppercaseNext = true;
                continue;
            }
            if (uppercaseNext) {
                outString.append(Character.toUpperCase(letter));
                uppercaseNext = false;
                continue;
            }
            outString.append(letter);
        }
        return outString.toString();
    }

    public static String toKabobCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 1) {
            return string;
        }
        StringBuilder outString = new StringBuilder();
        char[] charString = string.toCharArray();
        for (int i = 0; i < charString.length; ++i) {
            char letter = charString[i];
            if (i == 0) {
                outString.append(Character.toLowerCase(letter));
                continue;
            }
            if (Character.isUpperCase(letter)) {
                outString.append('_').append(Character.toLowerCase(letter));
                continue;
            }
            outString.append(letter);
        }
        return outString.toString();
    }

    public static void loadSystemSettings() throws IOException {
        try {
            if (systemConfigMap.isEmpty()) {
                String json = ProjectFileUtils.getResourcesFileContent(Paths.get("oracle/dbtools/extension/project/commands/init/templates/projectDefaultSettings.json", new String[0]));
                Settings settings = (Settings)mapper.readValue(json, Settings.class);
                SimpleModule simpleModule = new SimpleModule();
                simpleModule.addSerializer(Settings.class, (JsonSerializer)new SettingSerializer());
                mapper.registerModule((Module)simpleModule);
                String userJson = mapper.writeValueAsString((Object)settings);
                Map uMap = new JsonFlattener(userJson).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS).flattenAsMap();
                for (String key : uMap.keySet()) {
                    userConfigMap.put(key.replace("root.", ""), uMap.get(key));
                }
                ProjectSettings.populateSystemSettingsMap("root", settings.getChildren());
            }
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static void loadUserSettings() {
        ProjectSettings.loadUserSettings(ProjectConfig.getCurrentWorkingProjectRoot().toString());
    }

    public static void loadUserSettings(String root) {
        try {
            if (root == null) {
                ProjectConfig.getCurrentContext().writeln(ProjectMessages.getString("NO_ROOT_FOR_CONFIG"));
                return;
            }
            Path jsonPath = Paths.get(root, ".dbtools", "project.config.json");
            String json = FileUtils.readFileToString((File)jsonPath.toFile(), (Charset)StandardCharsets.UTF_8);
            Map tMap = new JsonFlattener(json).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS).flattenAsMap();
            userConfigMap.clear();
            userConfigMap.putAll(tMap);
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugException(e);
        }
    }

    public static void saveValue(String key, String value) throws IOException, ProjectSettingsException {
        ProjectSettings.saveValue(key, value, ProjectSettings.getSettingsType(key), ProjectConfig.getCurrentWorkingProjectRoot().toString());
    }

    public static void saveValue(String key, String value, String type) throws IOException, ProjectSettingsException {
        ProjectSettings.saveValue(key, value, type, ProjectConfig.getCurrentWorkingProjectRoot().toString());
    }

    public static void saveValue(String key, String value, String type, String root) throws IOException, ProjectSettingsException {
        if (!ProjectSettings.isValidSetting(key, value)) {
            throw new ProjectSettingsException(ProjectMessages.format("INVALID_CONFIG_VALUE", key, ProjectSettings.getAllowedValues(key)));
        }
        ProjectSettings.updateValue(key, value, type, root);
        ProjectSettings.writeUserSettings(root);
    }

    public static void updateValue(String key, String value, String type, String root) {
        try {
            if (userConfigMap == null || userConfigMap.isEmpty()) {
                ProjectSettings.loadUserSettings(root);
            }
            switch (type.toUpperCase()) {
                case "STRING": 
                case "OBJECT": {
                    userConfigMap.put(key, value);
                    break;
                }
                case "INTEGER": {
                    userConfigMap.put(key, Integer.parseInt(value));
                    break;
                }
                case "BOOLEAN": {
                    userConfigMap.put(key, Boolean.parseBoolean(value));
                    break;
                }
                case "ARRAY": {
                    if (value.equals("[]")) {
                        ArrayList emptyArray = new ArrayList();
                        userConfigMap.put(key, emptyArray);
                        break;
                    }
                    value = value.replace("[", "");
                    value = value.replace("]", "");
                    List<String> list = Arrays.asList(value.split("\\s*,\\s*"));
                    mapper.convertValue(list, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
                    userConfigMap.put(key, list);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + type.toUpperCase());
                }
            }
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static void writeUserSettings() throws IOException {
        ProjectSettings.writeUserSettings(ProjectConfig.getCurrentWorkingProjectRoot().toString());
    }

    public static boolean isValidSetting(String key, String value) {
        ArrayList<String> vals = new ArrayList<String>();
        String allowed = ProjectSettings.getAllowedValues(key);
        if (allowed == null || allowed.isEmpty()) {
            return true;
        }
        for (String item : allowed.split(",")) {
            vals.add(item.trim());
        }
        return vals.contains(value);
    }

    public static void writeUserSettings(String projectRoot) throws IOException {
        try {
            String json = new JsonUnflattener(userConfigMap).withFlattenMode(FlattenMode.KEEP_PRIMITIVE_ARRAYS).unflatten();
            Path jsonPath = Paths.get(projectRoot, ".dbtools", "project.config.json");
            FileUtils.writeStringToFile((File)jsonPath.toFile(), (String)ProjectSettings.formatJson(json), (Charset)StandardCharsets.UTF_8);
            GeneralMessages.createFileMsg(Paths.get(projectRoot, new String[0]).getParent().relativize(jsonPath).toString());
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private static void populateSystemSettingsMap(@NonNull String parentName, @NonNull List<Settings> children) {
        if (parentName == null) {
            throw new NullPointerException("parentName is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        try {
            for (Settings child : children) {
                String name = parentName + "." + child.getName();
                systemConfigMap.put(name.replace("root.", ""), child);
                if (child.getChildren() == null || child.getChildren().isEmpty()) continue;
                ProjectSettings.populateSystemSettingsMap(parentName + "." + child.getName(), child.getChildren());
            }
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public static List<String> getSettingAsList(String keyPath) {
        Object val = ProjectSettings.getSetting(keyPath);
        if (val instanceof List) {
            return (List)mapper.convertValue(val, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
        }
        if (val instanceof String) {
            List<String> list = Arrays.asList(val.toString().split("\\s*,\\s*"));
            return (List)mapper.convertValue(list, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, String.class));
        }
        return Collections.emptyList();
    }

    public static Boolean getSettingAsBoolean(String keyPath) {
        return (Boolean)mapper.convertValue(ProjectSettings.getSetting(keyPath), Boolean.class);
    }

    public static Number getSettingAsNumber(String keyPath) {
        return (Number)mapper.convertValue(ProjectSettings.getSetting(keyPath), Number.class);
    }

    public static String getSettingAsString(String keyPath) {
        return (String)mapper.convertValue(ProjectSettings.getSetting(keyPath), String.class);
    }

    public static Object getSetting(String keyPath) {
        Object userVal = userConfigMap.get(keyPath);
        Settings value = systemConfigMap.get(keyPath);
        if (userVal == null) {
            if (value == null) {
                return null;
            }
            return value.getDefaultVal();
        }
        if (value.getPub().equals("N")) {
            GeneralMessages.warnMessage(VerifyMessages.format("NON_PUBLIC_SETTINGS", keyPath));
        }
        return userVal;
    }

    @NonNull
    public static String formatJson(@NonNull String jsonString) throws JsonProcessingException {
        if (jsonString == null) {
            throw new NullPointerException("jsonString is marked non-null but is null");
        }
        try {
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            ObjectNode node = (ObjectNode)mapper.readValue(jsonString, ObjectNode.class);
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            return writer.writeValueAsString((Object)node);
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            throw e;
        }
    }

    @Generated
    public static ObjectMapper getMapper() {
        return mapper;
    }

    @Generated
    public static LinkedHashMap<String, Settings> getSystemConfigMap() {
        return systemConfigMap;
    }

    @Generated
    public static Map<String, Object> getUserConfigMap() {
        return userConfigMap;
    }

    static {
        try {
            ProjectSettings.loadSystemSettings();
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(e.getLocalizedMessage());
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

