/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import oracle.arbori.util.DictionaryViews;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.ExportCommand;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.generators.ApexInstallScriptGenerator;
import oracle.dbtools.extension.project.commands.stage.generators.DropDdlGenerator;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.commands.stage.utils.RdbmsSchemaDiffManager;
import oracle.dbtools.extension.project.commands.stage.utils.SqlChangeLogSorter;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.stage.utils.XmlChangeLogSorter;
import oracle.dbtools.extension.project.commands.stage.utils.interfaces.AbstractChangeLogSorter;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ChangelogGenerationException;
import oracle.dbtools.extension.project.core.exceptions.CreateFileException;
import oracle.dbtools.extension.project.core.exceptions.MaterializedViewLogException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.exceptions.ReleaseProcessException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.ProjectFileUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;

public class StageUtils {
    public static final String DROP_CHANGES = "drops";
    public static final String ERROR_CHANGES = "errors";
    protected static final String NEVER = "NEVER";
    protected static final String SINGLE = "single";
    protected static final String MULTIPLE = "multiple";
    public static final String UNCOMMENT_DROP_COMMENT = "/*  Uncomment drop statement after ensuring it is performing the correct actions";
    public Path root;
    public Path distRoot;
    public Path utilRoot;
    public Path installSql;
    public Path preCheckSql;
    public Path compileSql;
    public Path relRoot;
    public Path mainChangeLog;
    public Path nextRoot;
    public Path nextRelChangeLog;
    public Path apexRoot;
    public Path ordsRoot;
    public Path apexChangeLog;
    public Path ordsChangeLog;
    public Path nextCodeRoot;
    public Path nextCodeChangeLog;
    public Path stageRoot;
    public Path branchRoot;
    public Path stageChangeLog;
    public Path customRoot;
    public Path srcRoot;
    public Path dbSrcRoot;
    public String mainCLog;
    public String relCLog;
    public String stageCLog;
    public StringBuilder apexClog = new StringBuilder();
    public StringBuilder ordsClog = new StringBuilder();
    public String codeCLog;
    ScriptRunnerContext _ctx;

    public StageUtils(Path root, ScriptRunnerContext ctx) throws Exception {
        String script;
        this.root = root;
        this._ctx = ctx;
        this.checkDirectories();
        this.installSql = Paths.get(this.distRoot.toString(), "install.sql");
        if (this.installSql.toFile().exists() && !StageConstants.isCorrectInstallFile(script = FileUtils.readFileToString((File)this.installSql.toFile(), (Charset)StandardCharsets.UTF_8), ProjectSettings.getSettingAsString("stage.generatedFormat"))) {
            throw new CreateFileException(StageMessages.format("INVALID_INSTALL_FILE", ProjectSettings.getSettingAsString("stage.generatedFormat")));
        }
        this.createBranchDirs(this.getBranch());
        this.createChangelogFiles();
        this.loadExcludes();
        this.loadChangelogs();
    }

    public Path getDestPath(boolean isSoftObject, String entryAction) {
        if (StageConstants.isReleaseIsolation() && isSoftObject && !"DELETE".equals(entryAction)) {
            return this.nextCodeRoot;
        }
        return this.branchRoot;
    }

    private void loadExcludes() throws ProjectSettingsException {
        StageConstants.excludedSchemas.clear();
        StageConstants.excludedObjects.clear();
        StageConstants.excludedApexs.clear();
        StageConstants.excludedOrds.clear();
        List<String> excludes = ProjectSettings.getSettingAsList("stage.excludeObjects");
        if (excludes == null) {
            return;
        }
        for (String exclude : excludes) {
            String schema;
            if (!exclude.contains(".")) {
                StageConstants.excludedSchemas.add(exclude.toUpperCase());
                continue;
            }
            String[] parts = exclude.split("\\.");
            if (parts.length == 2) {
                schema = parts[0].toUpperCase();
                @NonNull String obj = parts[1].toUpperCase();
                if (obj.equalsIgnoreCase("ORDS")) {
                    StageConstants.excludedOrds.add(parts[0].toUpperCase());
                    continue;
                }
                if (StageConstants.excludedObjects.get(schema) != null) {
                    StageConstants.excludedObjects.get(schema).add(obj);
                    continue;
                }
                StageConstants.excludedObjects.put(schema, new ArrayList());
                StageConstants.excludedObjects.get(schema).add(obj);
                continue;
            }
            if (parts.length == 3) {
                schema = parts[0].toUpperCase();
                @NonNull String apex = parts[1].toUpperCase();
                @NonNull String appid = parts[2].toUpperCase();
                if (apex.equalsIgnoreCase("APEX")) {
                    if (StageConstants.excludedApexs.get(schema) != null) {
                        StageConstants.excludedApexs.get(schema).add(appid);
                        continue;
                    }
                    StageConstants.excludedApexs.put(schema, new ArrayList());
                    StageConstants.excludedApexs.get(schema).add(appid);
                    continue;
                }
                throw new ProjectSettingsException(StageMessages.format("BAD_EXCLUDE_OBJECTS", exclude));
            }
            throw new ProjectSettingsException(StageMessages.format("BAD_EXCLUDE_OBJECTS", exclude));
        }
    }

    private void checkDirectories() throws IOException {
        LinkedList<Path> dirs = new LinkedList<Path>();
        this.srcRoot = Paths.get(this.root.toString(), "src");
        if (!this.srcRoot.toFile().exists()) {
            dirs.add(this.srcRoot);
        }
        this.dbSrcRoot = Paths.get(this.srcRoot.toString(), "database");
        this.distRoot = Paths.get(this.root.toString(), "dist");
        if (!this.distRoot.toFile().exists()) {
            dirs.add(this.distRoot);
        }
        this.relRoot = Paths.get(this.distRoot.toString(), "releases");
        if (!this.relRoot.toFile().exists()) {
            dirs.add(this.relRoot);
        }
        this.utilRoot = Paths.get(this.distRoot.toString(), "utils");
        if (!this.utilRoot.toFile().exists()) {
            dirs.add(this.utilRoot);
        }
        this.nextRoot = Paths.get(this.relRoot.toString(), "next");
        if (!this.nextRoot.toFile().exists()) {
            dirs.add(this.nextRoot);
        }
        this.stageRoot = Paths.get(this.nextRoot.toString(), "changes");
        if (!this.stageRoot.toFile().exists()) {
            dirs.add(this.stageRoot);
        }
        if (StageConstants.isReleaseIsolation()) {
            this.nextCodeRoot = Paths.get(this.nextRoot.toString(), "code");
            if (!this.nextCodeRoot.toFile().exists()) {
                dirs.add(this.nextCodeRoot);
            }
        }
        this.createDirs(dirs);
    }

    private void createBranchDirs(String branchName) throws Exception {
        LinkedList<Path> dirs = new LinkedList<Path>();
        if (branchName == null) {
            branchName = this.getBranch();
        }
        if (branchName != null && !branchName.isEmpty()) {
            String branch = ProjectFileUtils.sanitizeFileName(branchName);
            this.branchRoot = Paths.get(this.stageRoot.toString(), branch);
            if (!this.branchRoot.toFile().exists()) {
                dirs.add(this.branchRoot);
            }
            this.customRoot = Paths.get(this.branchRoot.toString(), "_custom");
            if (!this.customRoot.toFile().exists()) {
                dirs.add(this.customRoot);
            }
        } else {
            this.branchRoot = null;
            this.customRoot = null;
            throw new StageProcessException(StageMessages.get("NULL_BRANCH_NAME"));
        }
        this.createDirs(dirs);
        this.createBranchFiles();
        this.loadChangelogs();
    }

    public String getBranch() throws Exception {
        String branch = StageConstants.getGitBranch();
        if (branch == null || branch.isEmpty()) {
            throw new StageProcessException(StageMessages.get("NULL_BRANCH_NAME"));
        }
        return branch;
    }

    private void createDirs(LinkedList<Path> dirs) throws IOException {
        for (Path dir : dirs) {
            if (dir.toFile().exists()) continue;
            GeneralMessages.createDirMsg(this.root.relativize(dir).toString());
            FileUtils.forceMkdir((File)dir.toFile());
        }
    }

    private void createChangelogFiles() throws CreateFileException {
        this.createMainChangeLog();
        this.createReleaseChangeLog();
        this.createUtilsChangeLog();
        this.createCodeChangeLog();
        this.createInstallChangeLog();
    }

    private void createInstallChangeLog() throws CreateFileException {
        if (this.distRoot != null && this.distRoot.toFile().exists()) {
            this.installSql = StageConstants.createFileUsingTemplate(this.distRoot, "install.sql", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/install_sql.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/install_sql.tmpl");
        }
    }

    private void createCodeChangeLog() throws CreateFileException {
        if (StageConstants.isReleaseIsolation() && this.nextCodeRoot != null && this.nextCodeRoot.toFile().exists()) {
            this.nextCodeChangeLog = StageConstants.createFileUsingTemplate(this.nextCodeRoot, StageConstants.isSqlStage() ? "code.changelog.xml".replace("xml", "sql") : "code.changelog.xml", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/code.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/code.changelog.tmpl");
        }
    }

    private void createUtilsChangeLog() throws CreateFileException {
        if (this.utilRoot != null && this.utilRoot.toFile().exists()) {
            StringBuilder schemasString = new StringBuilder();
            List<String> schemas = ProjectSettings.getSettingAsList("schemas");
            HashMap<String, String> validReplacements = new HashMap<String, String>();
            if (schemas != null && !schemas.isEmpty()) {
                HashMap<String, String> replacements = new HashMap<String, String>();
                for (String schema : schemas) {
                    if (schema == null || schema.isEmpty()) continue;
                    schemasString.append(schema.toLowerCase()).append(",");
                }
                try {
                    replacements.put("%SCHEMAS%", schemasString.substring(0, schemasString.length() - 1));
                }
                catch (Exception e) {
                    throw new IndexOutOfBoundsException(StageMessages.get("INVALID_SCHEMAS"));
                }
                String repSchema = (String)replacements.get("%SCHEMAS%");
                String validSchemas = ProjectUtils.checkValidSchemas(repSchema, this._ctx);
                validReplacements.put("%SCHEMAS%", validSchemas);
            } else {
                validReplacements.put("%SCHEMAS%", "");
            }
            this.compileSql = StageConstants.createFileUsingTemplate(this.utilRoot, StageConstants.isSqlStage() ? "recompile.sql".replace("xml", "sql") : "recompile.sql", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/compile-invalid.sql.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/compile-invalid.sql.tmpl", validReplacements);
            this.preCheckSql = StageConstants.createFileUsingTemplate(this.utilRoot, StageConstants.isSqlStage() ? "prechecks.sql".replace("xml", "sql") : "prechecks.sql", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/pre-checks.sql.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/pre-checks.sql.tmpl");
        }
    }

    private void createReleaseChangeLog() throws CreateFileException {
        if (this.nextRoot != null && this.nextRoot.toFile().exists()) {
            this.nextRelChangeLog = StageConstants.createFileUsingTemplate(this.nextRoot, StageConstants.isSqlStage() ? "release.changelog.xml".replace("xml", "sql") : "release.changelog.xml", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/release.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/release.changelog.tmpl");
        }
    }

    private void createMainChangeLog() throws CreateFileException {
        if (this.relRoot != null && this.relRoot.toFile().exists()) {
            this.mainChangeLog = StageConstants.createFileUsingTemplate(this.relRoot, StageConstants.isSqlStage() ? "main.changelog.xml".replace("xml", "sql") : "main.changelog.xml", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/main.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/main.changelog.tmpl");
        }
    }

    private void createBranchFiles() throws CreateFileException {
        if (this.branchRoot != null && this.branchRoot.toFile().exists()) {
            this.stageChangeLog = StageConstants.createFileUsingTemplate(this.branchRoot, StageConstants.isSqlStage() ? "stage.changelog.xml".replace("xml", "sql") : "stage.changelog.xml", StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/stage.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/stage.changelog.tmpl");
        }
    }

    private void loadChangelogs() throws IOException {
        if (this.nextRelChangeLog != null && this.nextRelChangeLog.toFile().exists()) {
            this.relCLog = FileUtils.readFileToString((File)this.nextRelChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.stageChangeLog != null && this.stageChangeLog.toFile().exists()) {
            this.stageCLog = FileUtils.readFileToString((File)this.stageChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.nextCodeChangeLog != null && this.nextCodeChangeLog.toFile().exists()) {
            this.codeCLog = FileUtils.readFileToString((File)this.nextCodeChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        }
        if (this.apexChangeLog != null && this.apexChangeLog.toFile().exists()) {
            this.apexClog.append(FileUtils.readFileToString((File)this.apexChangeLog.toFile(), (Charset)StandardCharsets.UTF_8));
        }
        if (this.ordsChangeLog != null && this.ordsChangeLog.toFile().exists()) {
            this.ordsClog.append(FileUtils.readFileToString((File)this.ordsChangeLog.toFile(), (Charset)StandardCharsets.UTF_8));
        }
    }

    private boolean excludeObject(@NonNull String type, String name, String schema) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (type.equalsIgnoreCase("APEX")) {
            return StageConstants.excludedApexs.get(schema.toUpperCase()) != null && ProjectUtils.ignoreCaseContains(StageConstants.excludedApexs.get(schema.toUpperCase()), name);
        }
        if (type.equalsIgnoreCase("ORDS")) {
            return ProjectUtils.ignoreCaseContains(StageConstants.excludedOrds, schema);
        }
        if (ProjectUtils.ignoreCaseContains(StageConstants.excludedSchemas, schema)) {
            return true;
        }
        if (StageConstants.excludedObjects.get("ALL") != null && ProjectUtils.ignoreCaseContains(StageConstants.excludedObjects.get("ALL"), name)) {
            return true;
        }
        return StageConstants.excludedObjects.get(schema) != null && ProjectUtils.ignoreCaseContains(StageConstants.excludedObjects.get(schema), name);
    }

    protected void stageHandleController(boolean isReleaseIsolation, String objectType, boolean isDeletion, Path destPath, String action) {
        if (isReleaseIsolation && oracle.dbtools.extension.project.commands.stage.transforms.StageConstants.SoftObjects.contains(objectType) && !isDeletion) {
            String stageString = this.getChangeRow(this.nextCodeRoot, destPath, action);
            if (!this.codeCLog.contains(stageString) && !this.stageCLog.contains(stageString)) {
                this.codeCLog = StageConstants.isSqlStage() ? this.codeCLog + stageString + "\n" : this.codeCLog.replace("</databaseChangeLog>", stageString + "\n</databaseChangeLog>");
                GeneralMessages.updateChangeMsg(this.root.relativize(this.nextCodeChangeLog).toString());
            }
        } else {
            String stageString = this.getChangeRow(this.branchRoot, destPath, action);
            if (!this.stageCLog.contains(stageString)) {
                this.stageCLog = StageConstants.isSqlStage() ? this.stageCLog + stageString + "\n" : this.stageCLog.replace("</databaseChangeLog>", stageString + "\n</databaseChangeLog>");
                GeneralMessages.updateChangeMsg(this.root.relativize(this.stageChangeLog).toString());
            }
        }
    }

    private String computeLogicalPath(boolean isReleaseIsolation, boolean isSoftObject, Path dest) {
        if (isReleaseIsolation && isSoftObject) {
            return Paths.get(this.nextCodeRoot.toString(), new String[0]).relativize(dest).toString();
        }
        return this.stageRoot.relativize(dest).toString();
    }

    protected boolean shouldExclude(String oName, String type, String schema, Path dest) {
        if (oName != null) {
            try {
                if (this.excludeObject(type, oName, schema)) {
                    GeneralMessages.excludeFileMsg(this.root.relativize(dest).toString());
                    return true;
                }
            }
            catch (Exception e) {
                GeneralMessages.debugException(e);
            }
        }
        return false;
    }

    protected void saveAllChangeLogs(Map<String, LinkedList<DbDiffObject>> resMap) throws Exception {
        Matcher customScriptChangesetMatcher;
        String source;
        AbstractChangeLogSorter sorter = StageConstants.isSqlStage() ? new SqlChangeLogSorter() : new XmlChangeLogSorter();
        Pattern customScriptChangesetPattern = Pattern.compile("<include\\s+file=\"_custom/[^\">]+\"\\s*(\\s+[^>]*)?\\s*/?>");
        if (StageConstants.filesAreDifferent(this.stageChangeLog, this.stageCLog)) {
            source = FileUtils.readFileToString((File)this.stageChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
            customScriptChangesetMatcher = customScriptChangesetPattern.matcher(source);
            if (this.stageChangeLog.toFile().exists() && source.contains("include") && !customScriptChangesetMatcher.find()) {
                this.saveChangeLog(this.stageChangeLog, this.stageCLog, true);
            } else {
                this.saveChangeLog(this.stageChangeLog, sorter.sort(this.stageCLog, ProjectConfig.getCurrentContext().getCurrentConnection()), true);
            }
        }
        sorter = StageConstants.isSqlStage() ? new SqlChangeLogSorter() : new XmlChangeLogSorter();
        if (StageConstants.isReleaseIsolation() && StageConstants.filesAreDifferent(this.nextCodeChangeLog, this.codeCLog)) {
            source = FileUtils.readFileToString((File)this.nextCodeChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
            customScriptChangesetMatcher = customScriptChangesetPattern.matcher(source);
            if (this.nextCodeChangeLog.toFile().exists() && source.contains("include") && !customScriptChangesetMatcher.find()) {
                this.saveChangeLog(this.nextCodeChangeLog, this.codeCLog, true);
            } else {
                this.saveChangeLog(this.nextCodeChangeLog, sorter.sort(this.codeCLog, ProjectConfig.getCurrentContext().getCurrentConnection()), true);
            }
        }
        if (this.apexChangeLog != null && this.apexClog != null && StageConstants.filesAreDifferent(this.apexChangeLog, this.apexClog.toString())) {
            this.saveChangeLog(this.apexChangeLog, this.apexClog.toString());
        }
        if (this.ordsChangeLog != null && this.ordsClog != null && StageConstants.filesAreDifferent(this.ordsChangeLog, this.ordsClog.toString())) {
            this.saveChangeLog(this.ordsChangeLog, this.ordsClog.toString());
        }
        if (StageConstants.filesAreDifferent(this.nextRelChangeLog, this.relCLog)) {
            this.saveChangeLog(this.nextRelChangeLog, this.relCLog);
        }
    }

    public void processOrds(Connection connection) throws IOException, CreateFileException, StageProcessException {
        ArrayList<Path> ordsFileList = this.getOrdsFiles(this.dbSrcRoot.toFile().list((FilenameFilter)DirectoryFileFilter.INSTANCE));
        if (ordsFileList.isEmpty()) {
            return;
        }
        this.ordsRoot = Paths.get(this.relRoot.toString(), "ords");
        FileUtils.createParentDirectories((File)Paths.get(this.ordsRoot.toString(), "ords.changelog.xml").toFile());
        String logName = StageConstants.isSqlStage() ? "ords.changelog.xml".replace("xml", "sql") : "ords.changelog.xml";
        this.ordsChangeLog = Paths.get(this.ordsRoot.toString(), logName);
        if (Files.notExists(this.ordsChangeLog, new LinkOption[0])) {
            this.ordsChangeLog = StageConstants.createFileUsingTemplate(this.ordsRoot, this.ordsChangeLog.getFileName().toString(), StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/ords.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/ords.changelog.tmpl");
        }
        this.loadChangelogs();
        LinkedList<Path> releaseFileList = new LinkedList<Path>();
        for (Path sourcePath : ordsFileList) {
            this.processOrdsFile(sourcePath, releaseFileList);
        }
        this.updateOrdsReleaseFiles(connection, releaseFileList, this.ordsChangeLog);
    }

    public void processApex(Connection connection) throws IOException, CreateFileException, StageProcessException, SQLException, NoSuchAlgorithmException {
        ArrayList<Path> apexFileList = this.getApexFiles(this.dbSrcRoot.toFile().list((FilenameFilter)DirectoryFileFilter.INSTANCE));
        if (apexFileList.isEmpty()) {
            return;
        }
        this.apexRoot = Paths.get(this.relRoot.toString(), "apex");
        FileUtils.createParentDirectories((File)Paths.get(this.apexRoot.toString(), "apex.changelog.xml").toFile());
        String logName = StageConstants.isSqlStage() ? "apex.changelog.xml".replace("xml", "sql") : "apex.changelog.xml";
        this.apexChangeLog = Paths.get(this.apexRoot.toString(), logName);
        if (!this.apexChangeLog.toFile().exists()) {
            this.apexChangeLog = StageConstants.createFileUsingTemplate(this.apexRoot, this.apexChangeLog.getFileName().toString(), StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/apex.changelog.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/apex.changelog.tmpl");
            GeneralMessages.createChangeMsg(this.root.relativize(this.apexChangeLog).toString());
        } else {
            GeneralMessages.updateChangeMsg(this.root.relativize(this.apexChangeLog).toString());
        }
        this.loadChangelogs();
        LinkedList<Path> releaseFileList = new LinkedList<Path>();
        for (Path sourcePath : apexFileList) {
            this.processFile(sourcePath, releaseFileList);
        }
        this.updateReleaseFiles(connection, releaseFileList);
    }

    protected void processOrdsFile(Path sourcePath, LinkedList<Path> releaseFileList) throws IOException {
        String[] vals;
        String schema = "";
        Object file = FileUtils.readFileToString((File)sourcePath.toFile(), (Charset)StandardCharsets.UTF_8);
        String sqlHash = ((String)file).substring(((String)file).indexOf("-- sqlcl_snapshot"));
        String hash = sqlHash.substring(sqlHash.indexOf("{") + 1, sqlHash.indexOf("}"));
        for (String val : vals = hash.split(",")) {
            String name = val.split(":")[0];
            if (!name.replace("\"", "").equalsIgnoreCase("schemaName")) continue;
            schema = val.split(":")[1].replace("\"", "");
        }
        Path releasePath = this.constructOrdsReleasePath(sourcePath, schema.toLowerCase());
        if (this.shouldProcessOrdsFile(sourcePath, releasePath, schema)) {
            file = ((String)file).substring(0, ((String)file).indexOf("-- sqlcl_snapshot"));
            file = this.genOrdsChangeLogHeader(schema) + sqlHash + (String)file;
            FileUtils.writeStringToFile((File)releasePath.toFile(), (String)file, (Charset)StandardCharsets.UTF_8, (boolean)false);
            GeneralMessages.createFileMsg(this.root.relativize(releasePath).toString());
            releaseFileList.add(releasePath);
        }
    }

    protected void processFile(Path sourcePath, LinkedList<Path> releaseFileList) throws IOException {
        String schema = sourcePath.getParent().getParent().getParent().getFileName().toString();
        Path releasePath = this.constructReleasePath(sourcePath);
        if (this.shouldProcessFile(sourcePath, releasePath, schema)) {
            FileUtils.copyFile((File)sourcePath.toFile(), (File)releasePath.toFile());
            GeneralMessages.createFileMsg(this.root.relativize(releasePath).toString());
            releaseFileList.add(releasePath);
        }
    }

    protected Path constructOrdsReleasePath(Path sourcePath, String schema) {
        return Paths.get(this.relRoot.toString(), "ords", schema, sourcePath.getFileName().toString());
    }

    protected Path constructReleasePath(Path sourcePath) {
        return Paths.get(this.relRoot.toString(), "apex", sourcePath.getParent().getFileName().toString(), sourcePath.getFileName().toString());
    }

    protected boolean shouldProcessFile(Path sourcePath, Path releasePath, String schema) throws IOException {
        if (sourcePath.toFile().exists() && !releasePath.toFile().exists()) {
            String appId = releasePath.getParent().getFileName().toString().replace("f", "");
            if (this.excludeObject("APEX", appId, schema)) {
                GeneralMessages.excludeFileMsg(this.root.relativize(Paths.get(sourcePath.toString(), new String[0])).toString());
                return false;
            }
            return true;
        }
        return sourcePath.toFile().exists() && releasePath.toFile().exists() && StageConstants.filesAreDifferent(sourcePath, releasePath);
    }

    protected boolean shouldProcessOrdsFile(Path sourcePath, Path releasePath, String schema) throws IOException {
        if (sourcePath.toFile().exists() && !releasePath.toFile().exists()) {
            if (this.excludeObject("ORDS", null, schema)) {
                GeneralMessages.excludeFileMsg(this.root.relativize(Paths.get(sourcePath.toString(), new String[0])).toString());
                return false;
            }
            return true;
        }
        return sourcePath.toFile().exists() && releasePath.toFile().exists() && StageConstants.filesAreDifferent(sourcePath, releasePath);
    }

    private void updateReleaseFiles(Connection connection, LinkedList<Path> releaseFileList) throws IOException, StageProcessException, SQLException, NoSuchAlgorithmException {
        for (Path file : releaseFileList) {
            String apexClogStr;
            Path xmlFile = Paths.get(FilenameUtils.removeExtension((String)file.toString()) + ".xml", new String[0]);
            Path sqlFile = Paths.get(FilenameUtils.removeExtension((String)file.toString()) + ".sql", new String[0]);
            String appId = file.getParent().getFileName().toString().replace("f", "");
            String installer = ApexInstallScriptGenerator.genApexController(appId, sqlFile.getFileName().toString(), connection);
            if (StageConstants.filesAreDifferent(xmlFile, installer)) {
                FileUtils.writeStringToFile((File)xmlFile.toFile(), (String)installer, (Charset)StandardCharsets.UTF_8);
                GeneralMessages.createChangeMsg(this.root.relativize(xmlFile).toString());
            }
            String apexChangeRow = this.getChangeRow(this.apexRoot, xmlFile, null);
            if (this.apexClog.toString().contains(apexChangeRow)) continue;
            if (StageConstants.isSqlStage()) {
                this.apexClog.append(apexChangeRow);
                apexClogStr = this.apexClog.toString();
            } else {
                apexClogStr = this.apexClog.toString().replace("</databaseChangeLog>", apexChangeRow + "\n</databaseChangeLog>");
            }
            this.apexClog = new StringBuilder(apexClogStr);
            this.saveChangeLog(this.apexChangeLog, apexClogStr);
        }
        this.mainChangeLog = StageConstants.isSqlStage() ? Paths.get(this.relRoot.toString(), "main.changelog.xml".replace("xml", "sql")) : Paths.get(this.relRoot.toString(), "main.changelog.xml");
        this.mainCLog = FileUtils.readFileToString((File)this.mainChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        String changelogString = this.getChangeRow(this.relRoot, this.apexChangeLog, null);
        if (!this.mainCLog.contains(changelogString)) {
            this.mainCLog = StageConstants.isSqlStage() ? this.mainCLog + changelogString : this.mainCLog.replace("</databaseChangeLog>", changelogString + "\n</databaseChangeLog>");
            this.saveChangeLog(this.mainChangeLog, this.mainCLog);
        }
    }

    private void createOrdsChange(Path change, Path source) throws CreateFileException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("%ID%", StageConstants.getGuid());
        map.put("%FILE%", "@" + source.getFileName().toString());
        StageConstants.createFileUsingTemplate(change.getParent(), change.getFileName().toString(), "oracle/dbtools/extension/project/commands/stage/templates/xml/ords.change.tmpl", map);
    }

    private void updateOrdsReleaseFiles(Connection connection, LinkedList<Path> releaseFileList, Path ordsClfile) throws IOException, StageProcessException, CreateFileException {
        String ordsClogStr = this.ordsClog.toString();
        for (Path ordsFile : releaseFileList) {
            String ordsChangeRow = this.getChangeRow(this.ordsRoot, ordsFile, null);
            if (ordsClogStr.contains(ordsChangeRow)) continue;
            if (StageConstants.isSqlStage()) {
                this.ordsClog.append(ordsChangeRow);
            } else {
                ordsClogStr = this.ordsClog.toString().replace("</databaseChangeLog>", ordsChangeRow + "\n</databaseChangeLog>");
                this.ordsClog = new StringBuilder(ordsClogStr);
            }
            this.saveChangeLog(this.ordsChangeLog, this.ordsClog.toString());
        }
        this.mainChangeLog = Paths.get(this.relRoot.toString(), StageConstants.isSqlStage() ? "main.changelog.xml".replace("xml", "sql") : "main.changelog.xml");
        this.mainCLog = FileUtils.readFileToString((File)this.mainChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        String changelogString = this.getChangeRow(this.relRoot, this.ordsChangeLog, null);
        if (!this.mainCLog.contains(changelogString)) {
            this.mainCLog = StageConstants.isSqlStage() ? this.mainCLog + changelogString : this.mainCLog.replace("</databaseChangeLog>", changelogString + "\n</databaseChangeLog>");
            this.saveChangeLog(this.mainChangeLog, this.mainCLog);
        }
    }

    private ArrayList<Path> getApexFiles(String[] schemaDirs) {
        ArrayList<Path> apexFiles = new ArrayList<Path>();
        if (schemaDirs != null) {
            for (String schemaDir : schemaDirs) {
                String[] appDirs;
                Path apexShemaRoot;
                if (schemaDir.equals("apex_apps") || !(apexShemaRoot = Paths.get(this.dbSrcRoot.toString(), schemaDir, "apex_apps")).toFile().exists() || (appDirs = apexShemaRoot.toFile().list((FilenameFilter)DirectoryFileFilter.INSTANCE)) == null) continue;
                for (String appDir : appDirs) {
                    Path apexFile = Paths.get(apexShemaRoot.toString(), appDir, appDir + ".sql");
                    if (!apexFile.toFile().exists()) continue;
                    apexFiles.add(apexFile);
                }
            }
        }
        return apexFiles;
    }

    private ArrayList<Path> getOrdsFiles(String[] schemaDirs) {
        ArrayList<Path> ordsFiles = new ArrayList<Path>();
        if (schemaDirs != null) {
            for (String schemaDir : schemaDirs) {
                Path ordsFile;
                Path ordsShemaRoot = Paths.get(this.dbSrcRoot.toString(), schemaDir, "ords");
                if (!ordsShemaRoot.toFile().exists() || !(ordsFile = Paths.get(ordsShemaRoot.toString(), "ords.sql")).toFile().exists()) continue;
                ordsFiles.add(ordsFile);
            }
        }
        return ordsFiles;
    }

    public void release(String version) throws IOException, CreateFileException, ReleaseProcessException, StageProcessException {
        this.loadChangelogs();
        this.mainChangeLog = Paths.get(this.relRoot.toString(), "main.changelog.xml");
        this.mainCLog = FileUtils.readFileToString((File)this.mainChangeLog.toFile(), (Charset)StandardCharsets.UTF_8);
        String nextRow = "<include file=\"next/release.changelog.xml\" relativeToChangelogFile=\"true\"/>";
        String relRow = "<include file=\"" + version + "/release.changelog.xml\" relativeToChangelogFile=\"true\"/>";
        if (this.mainCLog.contains(relRow)) {
            throw new ReleaseProcessException(StageMessages.format("RELEASE_EXISTS", version));
        }
        this.mainCLog = this.mainCLog.replace(nextRow, relRow);
        this.mainCLog = StageConstants.isSqlStage() ? this.mainCLog + nextRow : this.mainCLog.replace("</databaseChangeLog>", nextRow + "\n</databaseChangeLog>");
        this.saveChangeLog(this.mainChangeLog, this.mainCLog);
        String release = this.nextRoot.toString().replace("next", version);
        Path releasePath = Paths.get(release, new String[0]);
        FileUtils.moveDirectory((File)this.nextRoot.toFile(), (File)releasePath.toFile());
        GeneralMessages.moveFolderMsg(this.root.relativize(this.nextRoot).toString(), this.root.relativize(releasePath).toString());
        FileUtils.forceMkdir((File)this.nextRoot.toFile());
        GeneralMessages.createFileMsg(this.root.relativize(this.nextRoot).toString());
        this.nextRelChangeLog = StageConstants.createFileUsingTemplate(this.nextRoot, "release.changelog.xml", "oracle/dbtools/extension/project/commands/stage/templates/xml/release.changelog.tmpl");
        GeneralMessages.createChangeMsg(this.root.relativize(this.nextRelChangeLog).toString());
    }

    private void saveChangeLog(Path log, String data) throws IOException, StageProcessException {
        this.saveChangeLog(log, data, false);
    }

    private void saveChangeLog(Path log, String data, boolean release) throws IOException, StageProcessException {
        if (log == null || data == null || data.isEmpty()) {
            throw new StageProcessException(StageMessages.get("BAD_CHANGELOG_INFO"));
        }
        if (StageConstants.filesAreDifferent(log, data)) {
            FileUtils.writeStringToFile((File)log.toFile(), (String)data, (Charset)StandardCharsets.UTF_8);
            GeneralMessages.updateChangeMsg(this.root.relativize(log).toString());
        } else {
            GeneralMessages.skipChangeMsg(this.root.relativize(log).toString());
        }
        if (release) {
            String relRow = this.getChangeRow(this.nextRoot, log, null);
            String type = relRow.contains("file=\"code") || relRow.contains("@@code") ? "code" : (relRow.contains("file=\"changes") || relRow.contains("@@changes") ? "change" : null);
            if (!this.relCLog.contains(relRow)) {
                this.relCLog = !StageConstants.isSqlStage() ? (type == null || type.equals("code") ? this.relCLog.replace(StageConstants.getChangeEnd(), relRow + "\n" + StageConstants.getChangeEnd()) : this.relCLog.replace("</databaseChangeLog>", relRow + "\n</databaseChangeLog>")) : (type == null || type.equals("code") ? this.relCLog.replace("--CHANGES", relRow + "\n--CHANGES") : this.relCLog + relRow + "\n");
            }
            GeneralMessages.updateChangeMsg(this.root.relativize(this.nextRelChangeLog).toString());
            this.saveChangeLog(this.nextRelChangeLog, this.relCLog);
        }
    }

    private String transformAction(String action) {
        if (action == null) {
            return null;
        }
        if (action.equalsIgnoreCase("add")) {
            return "create";
        }
        if (action.equalsIgnoreCase("modify")) {
            return "modify";
        }
        if (action.equalsIgnoreCase("delete")) {
            return "drop";
        }
        return action;
    }

    protected String getChangeRow(Path root, Path dest, String action) {
        if (StageConstants.isSqlStage()) {
            if (action == null) {
                return "@@" + String.valueOf(root.relativize(dest));
            }
            return "@@" + String.valueOf(root.relativize(dest)) + " -- action=\"" + this.transformAction(action) + "\" ";
        }
        if (action == null) {
            return "<include file=\"" + root.relativize(dest).toString().replace("\\", "/") + "\" relativeToChangelogFile=\"true\"/>";
        }
        return "<include file=\"" + root.relativize(dest).toString().replace("\\", "/") + "\" relativeToChangelogFile=\"true\"/> <!-- action=\"" + this.transformAction(action) + "\" -->";
    }

    public void createCustomFile(String name) throws Exception {
        String fileNameWithExtension = ProjectFileUtils.addExtensionIfDoesNotExist(name, ".sql");
        String fileName = ProjectFileUtils.sanitizeFileName(fileNameWithExtension);
        this.loadChangelogs();
        Path customFile = Paths.get(this.customRoot.toString(), fileName);
        String stageString = this.getChangeRow(this.branchRoot, customFile, "custom");
        if (!this.stageCLog.contains(stageString) && !customFile.toFile().exists()) {
            StageConstants.createFileUsingTemplate(this.customRoot, fileName, StageConstants.isSqlStage() ? "oracle/dbtools/extension/project/commands/stage/templates/xml/add_custom_sql.tmpl".replace("xml", "sql") : "oracle/dbtools/extension/project/commands/stage/templates/xml/add_custom_sql.tmpl");
            String userFile = FileUtils.readFileToString((File)customFile.toFile(), (Charset)StandardCharsets.UTF_8);
            String author = "SqlCl";
            userFile = userFile.replace("<name>", author);
            String id = StageConstants.getGuid();
            userFile = userFile.replace("<id>", id);
            userFile = userFile.replace("<logical>", this.stageRoot.relativize(customFile).toString());
            userFile = userFile.replace("<source>", this.root.relativize(customFile).toString());
            this.saveChangeLog(customFile, userFile);
            if (!this.stageCLog.contains(stageString)) {
                this.stageCLog = StageConstants.isSqlStage() ? this.stageCLog + "\n" + stageString : this.stageCLog.replace("</databaseChangeLog>", stageString + "\n</databaseChangeLog>");
            }
            this.saveChangeLog(this.stageChangeLog, this.stageCLog, true);
        } else {
            if (customFile.toFile().exists()) {
                throw new CreateFileException(StageMessages.format("ADD_CUSTOM_FILE_EXISTS", customFile.toString(), customFile));
            }
            if (this.stageCLog.contains(stageString)) {
                throw new StageProcessException(StageMessages.format("ORPHAN_CHANGELOG_ROW", this.stageChangeLog));
            }
        }
    }

    private LinkedList<DbDiffObject> handleMultipleDropItems(LinkedList<DbDiffObject> entries) {
        LinkedList<DbDiffObject> iterator = new LinkedList<DbDiffObject>(entries);
        block0: for (DbDiffObject entry : iterator) {
            if ("PACKAGE_BODY".equals(entry.getObjectType()) && "DELETE".equals(entry.getAction())) {
                for (DbDiffObject entry2 : iterator) {
                    if (!"PACKAGE_SPEC".equals(entry2.getObjectType()) || !"DELETE".equals(entry2.getAction()) || !entry2.getObjectName().equals(entry.getObjectName())) continue;
                    entries.remove(entry);
                    continue block0;
                }
                continue;
            }
            if (!"TYPE_BODY".equals(entry.getObjectType()) || !"DELETE".equals(entry.getAction())) continue;
            for (DbDiffObject entry2 : iterator) {
                if (!"TYPE_SPEC".equals(entry2.getObjectType()) || !"DELETE".equals(entry2.getAction()) || !entry2.getObjectName().equals(entry.getObjectName())) continue;
                entries.remove(entry);
                continue block0;
            }
        }
        return entries;
    }

    private Map<String, LinkedList<DbDiffObject>> stageGenerateChangelogs(LinkedList<DbDiffObject> entries, String action) throws ChangelogGenerationException, StageProcessException, SQLException, MaterializedViewLogException {
        LinkedList<DbDiffObject> errors = new LinkedList<DbDiffObject>();
        LinkedList<DbDiffObject> drops = new LinkedList<DbDiffObject>();
        LinkedList<DbDiffObject> workList = new LinkedList<DbDiffObject>(entries);
        Map<String, List<String>> rdbmsManagedObjects = RdbmsSchemaDiffManager.loadURIs(RdbmsSchemaDiffManager.getSourceVersion(), RdbmsSchemaDiffManager.getTargetVersion());
        for (DbDiffObject entry : workList) {
            Path objPath = this.getDestPath(entry.isSoftObject(), entry.getAction());
            if (this.isValidSchemaAndType(entry.getSchema(), entry.getObjectType())) {
                entry.setDestPath(StageConstants.getDiffPath(objPath.toString(), entry.getSchema(), entry.getObjectType(), entry.getDestFileName()));
                if (this.shouldExclude(entry.getObjectName(), entry.getObjectType(), entry.getSchema(), entry.getDestPath())) continue;
                entry.setLogicalPath(this.computeLogicalPath(StageConstants.isReleaseIsolation(), entry.isSoftObject(), entry.getDestPath()));
                if (rdbmsManagedObjects != null && rdbmsManagedObjects.containsKey(entry.getObjectName().toLowerCase())) {
                    RdbmsSchemaDiffManager.writeScript(entry, entry.getObjectName().toLowerCase(), rdbmsManagedObjects.get(entry.getObjectName().toLowerCase()));
                    this.stageGenerateChange(entry);
                    this.stageSaveIfChanged(entry);
                    this.stageHandleController(StageConstants.isReleaseIsolation(), entry.getObjectType(), entry.hasDelete(), entry.getDestPath(), action);
                    continue;
                }
                try {
                    if ("ADD".equals(action)) {
                        this.stageProcessAdd(entry);
                    } else if ("MODIFY".equals(action)) {
                        if (entry.getObjectType().equalsIgnoreCase("SQL_DOMAIN")) {
                            this.stageProcessModifyhSqlDomain(entry, errors);
                        } else {
                            this.stageProcessModify(entry);
                        }
                    } else if ("DELETE".equals(action)) {
                        this.stageProcessDelete(entry);
                    }
                    if (!entry.getRawOutput().isBlank()) {
                        this.stageGenerateChange(entry);
                        this.stageSaveIfChanged(entry);
                        this.stageHandleController(StageConstants.isReleaseIsolation(), entry.getObjectType(), entry.hasDelete(), entry.getDestPath(), action);
                    }
                }
                catch (Exception e) {
                    errors.add(entry);
                }
            } else {
                errors.add(entry);
                entries.remove(entry);
            }
            if (!entry.hasDelete()) continue;
            drops.add(entry);
        }
        HashMap<String, LinkedList<DbDiffObject>> resMap = new HashMap<String, LinkedList<DbDiffObject>>();
        resMap.put(DROP_CHANGES, drops);
        resMap.put(ERROR_CHANGES, errors);
        return resMap;
    }

    private void stageProcessModifyhSqlDomain(DbDiffObject entry, LinkedList<DbDiffObject> errors) {
        String msg = "dbms_metadata_diff does not currently support domains, see Bug 37979876 add customer id to existing bug to escalate.\n";
        String old_ddl = entry.getMasterFileContent();
        String new_ddl = entry.getBranchFileContent();
        String output = "/*" + msg + "\nold ddl:\n" + old_ddl + "*/";
        entry.setRawOutput(output);
        this.trimSnapshot(entry);
        output = entry.getRawOutput() + "\nnew ddl: \n" + new_ddl;
        entry.setRawOutput(output);
        errors.add(entry);
        GeneralMessages.errorMessage(ConsoleColors.RED, StageMessages.format("CAN_NOT_DIFF_DOMAIN", entry.getDestFileName()));
    }

    public Map<String, LinkedList<DbDiffObject>> stageStartProcessing(Map<String, LinkedList<DbDiffObject>> diffs, Connection conn) throws Exception {
        this.loadChangelogs();
        Map<String, LinkedList<DbDiffObject>> resMap = new HashMap<String, LinkedList<DbDiffObject>>();
        for (String action : diffs.keySet()) {
            LinkedList<DbDiffObject> entries = diffs.get(action);
            if (action.equalsIgnoreCase("MODIFY") || action.equalsIgnoreCase("ADD")) {
                this.stageValidateSqlHash(entries);
            }
            if (action.equalsIgnoreCase("DELETE")) {
                this.handleMultipleDropItems(entries);
            }
            resMap = this.stageGenerateChangelogs(entries, action);
        }
        this.saveAllChangeLogs(resMap);
        this.processApex(conn);
        this.processOrds(conn);
        return resMap;
    }

    private void stageProcessAdd(DbDiffObject entry) {
        entry.setRawOutput(entry.getSourceFileContent());
    }

    private void stageSaveIfChanged(DbDiffObject entry) throws StageProcessException {
        try {
            if (StageConstants.filesAreDifferent(entry.getDestPath(), entry.getCleanedOutput())) {
                FileUtils.writeStringToFile((File)entry.getDestPath().toFile(), (String)entry.getCleanedOutput(), (Charset)StandardCharsets.UTF_8);
                GeneralMessages.updateFileMsg(ProjectConfig.getCurrentWorkingProjectRoot().relativize(entry.getDestPath()).toString());
            }
        }
        catch (Exception e) {
            throw new StageProcessException(e.getMessage());
        }
    }

    private void stageProcessDelete(DbDiffObject entry) throws MaterializedViewLogException {
        entry.setRawOutput(DropDdlGenerator.getDrop(entry));
        entry.setCleanedOutput(entry.getRawOutput());
        entry.hasDelete(true);
    }

    private boolean containsDelete(String stmt) {
        return new ParsedSql(stmt).contains("'DROP'");
    }

    private void trimSnapshot(DbDiffObject entry) {
        if (entry.getRawOutput() != null && entry.getRawOutput().contains("-- sqlcl_snapshot ")) {
            entry.setRawOutput(entry.getRawOutput().substring(0, entry.getRawOutput().indexOf("-- sqlcl_snapshot ")));
        }
    }

    private String getChangeStyle() {
        String style = ProjectSettings.getSettingAsString("stage.change.changeStyle");
        if (style == null) {
            style = SINGLE;
        }
        if (style.equalsIgnoreCase(SINGLE) || style.equalsIgnoreCase(MULTIPLE)) {
            return style;
        }
        return SINGLE;
    }

    private void stageGenerateChange(DbDiffObject entry) throws StageProcessException {
        try {
            StringBuilder changelog = new StringBuilder();
            this.trimSnapshot(entry);
            String style = this.getChangeStyle();
            List<String> stmts = new ArrayList();
            if (entry.isSoftObject() && !entry.getObjectType().equalsIgnoreCase("trigger") && entry.getRawOutput() != null) {
                stmts.add(entry.getRawOutput());
            } else if (entry.getRawOutput() != null) {
                stmts = SqlRecognizer.getStatements((String)entry.getRawOutput());
            }
            boolean commentedWarning = false;
            boolean top = true;
            for (String stmt : stmts) {
                String change;
                if (!entry.isSoftObject() && this.containsDelete(stmt) || entry.getAction().equalsIgnoreCase("DELETE")) {
                    entry.hasDelete(true);
                    change = this.wrapDropSql(stmt.trim());
                } else {
                    change = stmt.trim();
                    change = this.generateTypeDiffAuthid(entry, change);
                }
                change = StageConstants.applyFormatting(change);
                if (StageConstants.isSqlStage()) {
                    if (!commentedWarning) {
                        commentedWarning = this.potentialTableColumnRename(changelog, entry);
                    }
                    changelog.append(change).append("\n\n");
                    continue;
                }
                if (style.equalsIgnoreCase(SINGLE) && top || style.equalsIgnoreCase(MULTIPLE)) {
                    top = false;
                    changelog.append(this.genChangeLogHeader(entry));
                    changelog.append(this.generateSqlSnapshot(entry, change));
                    changelog.append("\n");
                    if (!commentedWarning) {
                        commentedWarning = this.potentialTableColumnRename(changelog, entry);
                    }
                    changelog.append(change).append("\n\n");
                    continue;
                }
                if (!commentedWarning) {
                    commentedWarning = this.potentialTableColumnRename(changelog, entry);
                }
                changelog.append(change).append("\n\n");
            }
            entry.setCleanedOutput(changelog.toString());
        }
        catch (Exception e) {
            ProjectConfig.getCurrentContext().writeln(StageMessages.format("STAGE_PROCESS_ERROR", entry.getObjectType(), entry.getObjectName(), e.getMessage()));
            throw new StageProcessException(e.getMessage(), e);
        }
    }

    private String generateTypeDiffAuthid(DbDiffObject entry, String change) {
        boolean hasTableOrTypeDependents = false;
        Object query = "       SELECT OWNER          ,\nNAME                       ,\nTYPE                       ,\nREFERENCED_OWNER           ,\nREFERENCED_NAME            ,\nREFERENCED_TYPE            ,\nREFERENCED_LINK_NAME       ,\nDEPENDENCY_TYPE            \nfrom sys.all_dependencies\nwhere referenced_name='" + entry.getObjectName() + "' AND type in ('TABLE', 'TYPE', 'TYPE_SPEC', 'TYPE_BODY')";
        query = new DictionaryViews(ProjectConfig.getCurrentContext().getCurrentConnection()).translate((String)query);
        try (Statement stm = ProjectConfig.getCurrentContext().getCurrentConnection().createStatement();
             ResultSet resultSet = stm.executeQuery((String)query);){
            if (resultSet.next()) {
                hasTableOrTypeDependents = true;
            }
        }
        catch (SQLException e) {
            GeneralMessages.errorMessage(ConsoleColors.RED, StageMessages.get("CAN_NOT_RUN_SQL_QUERY"));
        }
        if (entry.getObjectType().equalsIgnoreCase("TYPE_SPEC") && ((String)change).contains("authid current_user") && !entry.getMasterFileContent().contains("authid current_user") && ((String)change).replaceAll("\\s*authid\\s+current_user\\s*", " ").replaceAll("\\s+", " ").trim().equalsIgnoreCase(entry.getMasterFileContent().replaceAll("\\s*-- sqlcl.*", "").replaceAll("\\s+", " ").trim()) && hasTableOrTypeDependents) {
            String withoutCreateOrReplace = ((String)change).replaceFirst("(?i)create or replace\\s*", "");
            change = "begin\n    execute immediate\n     'alter " + withoutCreateOrReplace.replace("'", "''").trim() + "';\nexception\nwhen others then\nDBMS_OUTPUT.PUT_LINE('Error code: ' || SQLCODE);\nDBMS_OUTPUT.PUT_LINE('Error message: ' || SQLERRM);     end;\n/";
            change = ((String)change).replaceFirst(entry.getObjectName().toLowerCase(), entry.getObjectName().toLowerCase() + " replace");
            change = ((String)change).replaceFirst("/", "");
        }
        return change;
    }

    private String generateSqlSnapshot(DbDiffObject entry, String change) throws StageProcessException {
        String sha1;
        StringBuilder sb = new StringBuilder();
        sb.append("-- sqlcl_snapshot ");
        try {
            sha1 = StageConstants.getSha1fromString(change);
        }
        catch (StageProcessException e) {
            throw new RuntimeException(e);
        }
        if (Objects.equals(entry.getAction(), "ADD")) {
            sb.append(entry.getDiffEntry().getNewPath()).append(":").append("null").append(":").append(sha1).append(":").append("create").append("\n");
        } else if (Objects.equals(entry.getAction(), "MODIFY")) {
            sb.append(entry.getDiffEntry().getNewPath()).append(":").append(entry.getMasterHash()).append(":").append(sha1).append(":").append("alter").append("\n");
        } else if (Objects.equals(entry.getAction(), "DELETE")) {
            sb.append(entry.getDiffEntry().getOldPath()).append(":").append(entry.getMasterHash()).append(":").append("null").append(":").append("drop").append("\n");
        }
        return sb.toString();
    }

    private String wrapDropSql(String stmt) {
        if (ExportCommand.isRdbmsDiffProject()) {
            return stmt;
        }
        Object sql = "/*  Uncomment drop statement after ensuring it is performing the correct actions\n";
        sql = (String)sql + stmt + "\n";
        sql = (String)sql + "*/";
        return sql;
    }

    private boolean isDrop(ParsedSql parsed) {
        for (ParseNode node : parsed.getRoot().descendants()) {
            if (!node.contains("drop_constraint_clause") && !node.contains("delete") && !node.contains("drop")) continue;
            return true;
        }
        return false;
    }

    private String genChangeLogHeader(DbDiffObject entry) {
        return "-- liquibase formatted sql\n-- changeset " + entry.getSchema() + ":" + StageConstants.getGuid() + " stripComments:false  logicalFilePath:" + entry.getLogicalPath() + "\n";
    }

    private String genOrdsChangeLogHeader(String schema) {
        String logicalPath = "ords/" + schema.toLowerCase() + "/ords.sql";
        return "-- liquibase formatted sql\n-- changeset " + schema + ":" + StageConstants.getGuid() + " stripComments:false  logicalFilePath:" + logicalPath + "\n";
    }

    private void stageValidateSqlHash(LinkedList<DbDiffObject> entries) throws NoSuchAlgorithmException, IOException, StageProcessException {
        LinkedList<DbDiffObject> fixed = new LinkedList<DbDiffObject>();
        LinkedList<DbDiffObject> invalidHashHard = new LinkedList<DbDiffObject>();
        LinkedList<DbDiffObject> newEntries = new LinkedList<DbDiffObject>(entries);
        for (DbDiffObject entry : newEntries) {
            boolean isSoftObject = entry.isSoftObject();
            String currentHash = StageConstants.getSha1fromString(entry.getBranchFileContent());
            String branchHash = entry.getBranchHash();
            if ((branchHash == null || branchHash.isEmpty()) && !isSoftObject || branchHash != null && !branchHash.equals(currentHash) && !isSoftObject) {
                invalidHashHard.add(entry);
                entries.remove(entry);
                continue;
            }
            if (branchHash == null || branchHash.isEmpty()) {
                String content = StageConstants.applyFormatting(entry.getSourceFileContent());
                entry.setSourceFileContent(DbmsMetadata.appendSxmlAndHash(null, entry.getObjectType(), entry.getObjectName(), content, null));
                entry.setBranchHash(StageConstants.getSha1fromString(entry.getSourceFileContent()));
                FileUtils.writeStringToFile((File)StageConstants.getSrcFilePath(entry).toFile(), (String)entry.getSourceFileContent(), (Charset)StandardCharsets.UTF_8);
                fixed.add(entry);
                if (!entry.getBranchHash().equals(entry.getMasterHash())) continue;
                entries.remove(entry);
                continue;
            }
            if (branchHash.equals(currentHash) || !isSoftObject) continue;
            String source = entry.getBranchFileContent();
            String ddl = StageConstants.applyFormatting(source.substring(0, source.indexOf("-- sqlcl_snapshot")).trim());
            String newHash = StageConstants.getSha1fromString(ddl);
            entry.setBranchFileContent(DbmsMetadata.appendSxmlAndHash(entry.getSchema(), entry.getObjectType(), entry.getObjectName(), ddl, null));
            entry.setBranchHash(newHash);
            FileUtils.writeStringToFile((File)StageConstants.getSrcFilePath(entry).toFile(), (String)entry.getBranchFileContent(), (Charset)StandardCharsets.UTF_8);
            fixed.add(entry);
            if (!entry.getBranchHash().equals(entry.getMasterHash())) continue;
            entries.remove(entry);
        }
        this.displayFixed(fixed);
        this.displayInvalid(invalidHashHard);
        if (!invalidHashHard.isEmpty()) {
            throw new StageProcessException("Stage process failed");
        }
    }

    private void displayFixed(List<DbDiffObject> fixed) {
        if (!fixed.isEmpty()) {
            GeneralMessages.warnMessage("The following files were updated:");
            for (DbDiffObject diff : fixed) {
                GeneralMessages.generalMessage(ConsoleColors.YELLOW, StageMessages.format("UPDATED_HASH", diff.getDestFileName()));
            }
            GeneralMessages.generalMessage("\n");
        }
    }

    private void displayInvalid(List<DbDiffObject> invalidHashHard) {
        if (!invalidHashHard.isEmpty()) {
            GeneralMessages.errorMessage("The following files failed processesing:");
            for (DbDiffObject diff : invalidHashHard) {
                GeneralMessages.generalMessage(ConsoleColors.RED, StageMessages.format("INVALID_HASH", diff.getDestFileName()));
            }
            GeneralMessages.generalMessage("\n");
        }
    }

    private boolean isValidSchemaAndType(String schema, String type) {
        return schema != null && !"null".equals(schema) && type != null && !"null".equals(type);
    }

    private void stageProcessModify(DbDiffObject entry) throws ChangelogGenerationException, SQLException, MaterializedViewLogException {
        boolean isSoftObject = entry.isSoftObject();
        List<String> schedulerTypes = Arrays.asList("SCHEDULE", "PROGRAM", "JOB", "JOB CLASS");
        if ((entry.getBranchSxml() == null || entry.getBranchSxml().isEmpty()) && (entry.getMasterSxml() == null || entry.getMasterSxml().isEmpty()) || isSoftObject) {
            if (schedulerTypes.contains(entry.getObjectType().toUpperCase())) {
                entry.objectDiff();
            } else if (entry.getObjectType().equalsIgnoreCase("REF_CONSTRAINT")) {
                entry.setRawOutput(DropDdlGenerator.getDrop(entry) + entry.getBranchFileContent());
                entry.hasDelete(true);
            } else {
                entry.setRawOutput(entry.getBranchFileContent());
                if (entry.getRawOutput() != null && entry.getRawOutput().contains("-- sqlcl_snapshot ")) {
                    entry.setRawOutput(entry.getRawOutput().substring(0, entry.getRawOutput().indexOf("-- sqlcl_snapshot")).trim());
                }
            }
        } else if (entry.getObjectType().equalsIgnoreCase("TABLE")) {
            entry.objectDiff();
        } else if (entry.getObjectType().equalsIgnoreCase("MATERIALIZED_VIEW") || entry.getObjectType().equalsIgnoreCase("MATERIALIZED_VIEW_LOG") || entry.getObjectType().equalsIgnoreCase("INDEX")) {
            entry.setRawOutput(DropDdlGenerator.getDrop(entry) + entry.getBranchFileContent());
            entry.hasDelete(true);
        } else {
            this.stageDbmsGenerateModify(entry);
        }
    }

    private void stageDbmsGenerateModify(DbDiffObject entry) throws ChangelogGenerationException, SQLException {
        Object alterDdl;
        Connection conn = StageConstants.getConnection();
        String collation = ProjectSettings.getSettingAsString("export.setTransform.collationClause") == null ? NEVER : ProjectSettings.getSettingAsString("export.setTransform.collationClause");
        try {
            alterDdl = DbmsMetaUtils.getAlterDdlWithTransform((Connection)conn, (String)entry.getMasterSxml(), (String)entry.getBranchSxml(), (String)entry.getObjectType().toUpperCase(), (String)entry.getObjectName().toUpperCase(), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.constraints")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.constraintsAsAlters")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.refConstraints")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.storage")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.segmentAttributes")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.tablespace")), (boolean)Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema")), (String)entry.getSchema(), (String)collation);
            if (entry.getObjectType().equalsIgnoreCase("AQ_QUEUE") || entry.getObjectType().equalsIgnoreCase("AQ_QUEUE_TABLE")) {
                alterDdl = ((String)alterDdl).replaceAll("(?<!SYS\\.)\\bDBMS_AQADM\\b", "SYS.DBMS_AQADM");
            }
        }
        catch (Exception e) {
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            throw new ChangelogGenerationException(Throwables.getStackTraceAsString((Throwable)e));
        }
        if (alterDdl != null && ((String)alterDdl).contains("ORA-")) {
            GeneralMessages.warnMessage(StageMessages.format("CAN_NOT_GET_ALTER_DDL", entry.getSchema(), entry.getObjectName()));
            StageConstants.debugMessageWithPrettySxmlFormat(entry.getBranchSxml(), entry.getMasterSxml(), (String)alterDdl);
            throw new ChangelogGenerationException("Error");
        }
        if (alterDdl != null) {
            alterDdl = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema")) ? ((String)alterDdl).replaceAll("(\"?)%USER_NAME%(\"?)", "$1" + entry.getSchema() + "$2") : ((String)alterDdl).replaceAll("(\"?%USER_NAME%\"?\\.?)", "");
        }
        if (entry.getObjectType().equalsIgnoreCase("SEQUENCE")) {
            alterDdl = ((String)alterDdl).replaceAll("start with (\\d*)", "/* start with $1 */");
        }
        if (entry.getObjectType().equalsIgnoreCase("TABLE") && alterDdl != null) {
            alterDdl = ((String)alterDdl).replaceAll("(?i)(?<=\\s)(blob|clob|nclob|bfile)(?=\\s)", "");
        }
        if (alterDdl == null) {
            GeneralMessages.warnMessage(StageMessages.format("FALSE_GIT_POSITIVE", entry.getDiffEntry().getOldPath()));
            alterDdl = "/* \n" + StageMessages.format("FALSE_GIT_POSITIVE", entry.getDiffEntry().getOldPath()) + "\n */";
        }
        entry.setRawOutput((String)alterDdl);
    }

    private boolean potentialTableColumnRename(StringBuilder changelog, DbDiffObject entry) {
        Pattern addPattern = Pattern.compile("(?i)ALTER\\s+TABLE\\s+(?:\"?(\\w+)\"?\\.)?\"?(\\w+)\"?\\s+ADD\\s*\\(\\s*\"?(\\w+)\"?\\s+(\\w+(?:\\([^)]*\\))?)\\s*\\)");
        Pattern dropPattern = Pattern.compile("(?i)ALTER\\s+TABLE\\s+(?:\"?(\\w+)\"?\\.)?\"?(\\w+)\"?\\s+DROP\\s*\\(\\s*\"?(\\w+)\"?\\s*\\)");
        Matcher addMatcher = addPattern.matcher(entry.getRawOutput());
        Matcher dropMatcher = dropPattern.matcher(entry.getRawOutput());
        if (addMatcher.find() && dropMatcher.find()) {
            String addSchema = addMatcher.group(1);
            String addTable = addMatcher.group(2);
            String addColumn = addMatcher.group(3);
            String dropSchema = dropMatcher.group(1);
            String dropTable = dropMatcher.group(2);
            String dropColumn = dropMatcher.group(3);
            String schema1 = addSchema == null ? "" : addSchema;
            String schema2 = dropSchema == null ? "" : dropSchema;
            boolean sameSchema = schema1.equalsIgnoreCase(schema2);
            boolean sameTable = addTable.equalsIgnoreCase(dropTable);
            boolean sameColumn = addColumn.equalsIgnoreCase(dropColumn);
            if (sameSchema && sameTable && !sameColumn) {
                changelog.append("/* This script might contain a rename case instead of a drop/add, please review and edit this file to avoid data loss */\n\n");
                return true;
            }
        }
        return false;
    }

    @Generated
    public StringBuilder getOrdsClog() {
        return this.ordsClog;
    }

    @Generated
    public ScriptRunnerContext get_ctx() {
        return this._ctx;
    }

    @Generated
    public Path getRoot() {
        return this.root;
    }

    @Generated
    public Path getDistRoot() {
        return this.distRoot;
    }

    @Generated
    public Path getUtilRoot() {
        return this.utilRoot;
    }

    @Generated
    public Path getInstallSql() {
        return this.installSql;
    }

    @Generated
    public Path getPreCheckSql() {
        return this.preCheckSql;
    }

    @Generated
    public Path getCompileSql() {
        return this.compileSql;
    }

    @Generated
    public Path getRelRoot() {
        return this.relRoot;
    }

    @Generated
    public Path getMainChangeLog() {
        return this.mainChangeLog;
    }

    @Generated
    public Path getNextRoot() {
        return this.nextRoot;
    }

    @Generated
    public Path getNextRelChangeLog() {
        return this.nextRelChangeLog;
    }

    @Generated
    public Path getApexRoot() {
        return this.apexRoot;
    }

    @Generated
    public Path getOrdsRoot() {
        return this.ordsRoot;
    }

    @Generated
    public Path getApexChangeLog() {
        return this.apexChangeLog;
    }

    @Generated
    public Path getOrdsChangeLog() {
        return this.ordsChangeLog;
    }

    @Generated
    public Path getNextCodeRoot() {
        return this.nextCodeRoot;
    }

    @Generated
    public Path getNextCodeChangeLog() {
        return this.nextCodeChangeLog;
    }

    @Generated
    public Path getStageRoot() {
        return this.stageRoot;
    }

    @Generated
    public Path getBranchRoot() {
        return this.branchRoot;
    }

    @Generated
    public Path getStageChangeLog() {
        return this.stageChangeLog;
    }

    @Generated
    public Path getCustomRoot() {
        return this.customRoot;
    }

    @Generated
    public Path getSrcRoot() {
        return this.srcRoot;
    }

    @Generated
    public Path getDbSrcRoot() {
        return this.dbSrcRoot;
    }

    @Generated
    public String getMainCLog() {
        return this.mainCLog;
    }

    @Generated
    public String getRelCLog() {
        return this.relCLog;
    }

    @Generated
    public String getStageCLog() {
        return this.stageCLog;
    }

    @Generated
    public StringBuilder getApexClog() {
        return this.apexClog;
    }

    @Generated
    public String getCodeCLog() {
        return this.codeCLog;
    }
}

