/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.subcommands;

import com.google.common.base.Throwables;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.List;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class AddCustomCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        Path root = ProjectConfig.getCurrentWorkingProjectRoot();
        if (root == null) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", "Not in project Directory"));
            return;
        }
        try {
            ProjectConfig.setupDebugVerbose(command);
            String FILE_NAME = (String)command.getOptionValue((Id)ProjectOptions.Options.FILE_NAME);
            GeneralMessages.verboseMessage(StageMessages.format("ADD_CUSTOM_COMMAND", FILE_NAME));
            StageUtils stageUtil = new StageUtils(root, ctx);
            String currentBranch = StageConstants.getGitBranch();
            GeneralMessages.verboseMessage(StageMessages.format("CURRENT_BRANCH", currentBranch));
            List<String> protectedBranched = ProjectSettings.getSettingAsList("git.protectedBranches");
            if (protectedBranched.contains(currentBranch)) {
                throw new ProjectSettingsException(StageMessages.getString("PROTECTED_BRANCH"));
            }
            stageUtil.createCustomFile(FILE_NAME);
            GeneralMessages.verboseMessage(StageMessages.format("CUSTOM_FILE_CREATED", FILE_NAME));
            GeneralMessages.successMessage(StageMessages.get("PROCESS_SUCCESS"));
        }
        catch (Exception e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getMessage()));
            GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
        }
    }
}

