/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage;

import com.google.common.base.Throwables;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.ProjectConnectionException;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.extension.project.core.utils.GitUtils;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import org.eclipse.jgit.api.Git;

public class StageCommand
implements CommandInterface {
    public static final String TOBECOMMITED = "TOBECOMMITED";
    public static final String STAGEDFORCOMMIT = "STAGEDFORCOMMIT";
    public static final String UNTRACKED = "untracked";
    public static final String SQLSTAGE = "stage.generatedFormat";
    protected static final String ERROR = "ERROR";
    protected static final String REFS_HEADS = "refs/heads/";
    Path root;

    private boolean isBranchProtected(String branch) {
        List<String> protectedBranched = ProjectSettings.getSettingAsList("git.protectedBranches");
        return protectedBranched != null && protectedBranched.contains(branch);
    }

    private String getMasterBranchName(ParsedCommand command) throws StageProcessException {
        Object dest = (String)command.getOptionValue((Id)ProjectOptions.Options.BRANCH_NAME);
        if ((dest == null || ((String)dest).isEmpty()) && ((dest = ProjectSettings.getSettingAsString("git.defaultBranch")) == null || ((String)dest).isEmpty())) {
            throw new StageProcessException(StageMessages.format("NO_DEFAULT_GIT_BRANCH", new Object[0]));
        }
        if (!((String)dest).startsWith(REFS_HEADS)) {
            dest = REFS_HEADS + (String)dest;
        }
        return dest;
    }

    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand command) {
        try {
            ProjectConfig.setupDebugVerbose(command);
            this.root = ProjectUtils.getProjectRootFolder();
            if (conn == null && ctx.getCurrentConnection() == null) {
                conn = ProjectUtils.getConnection(ctx, ProjectConfig.isVerbose());
            }
            if (conn == null) {
                throw new ProjectConnectionException(ProjectMessages.getString("NO_CONNECTION"));
            }
            GeneralMessages.verboseMessage("");
            GeneralMessages.verboseMessage(StageMessages.get("STAGE_RUN_BEGIN_MESSAGE"));
            String currentBranch = StageConstants.getGitBranch();
            if (this.isBranchProtected(currentBranch)) {
                throw new StageProcessException(StageMessages.get("PROTECTED_BRANCH"));
            }
            Object source = currentBranch;
            if (!((String)source).startsWith(REFS_HEADS)) {
                source = REFS_HEADS + (String)source;
            }
            Map<String, LinkedList<DbDiffObject>> diffs = GitUtils.diffBranches(Objects.requireNonNull(GitUtils.findGitRepo(this.root.toFile())).getRepository(), (String)source, this.getMasterBranchName(command));
            diffs.remove(ERROR);
            diffs.remove(TOBECOMMITED);
            diffs.remove(STAGEDFORCOMMIT);
            diffs.remove(UNTRACKED);
            StageUtils stageUtil = new StageUtils(this.root, ctx);
            Map<String, LinkedList<DbDiffObject>> resMap = stageUtil.stageStartProcessing(diffs, conn);
            GeneralMessages.generalMessage("");
            GeneralMessages.verboseMessage(StageMessages.format("STAGE_RUN_END_MESSAGE", stageUtil.getBranch()));
            List errors = resMap.get("errors");
            List drops = resMap.get("drops");
            if (ProjectConfig.isVerbose() && drops != null && !drops.isEmpty()) {
                GeneralMessages.warnMessage(StageMessages.get("DROP_CHANGES"));
                for (DbDiffObject obj : drops) {
                    ctx.write(obj.getDestFileName());
                    ctx.write("\t" + obj.getObjectType());
                    ctx.writeln("\t" + obj.getObjectName());
                }
            }
            if (errors != null && !errors.isEmpty()) {
                GeneralMessages.errorMessage(StageMessages.get("BAD_SRC_FILES"));
                for (DbDiffObject obj : errors) {
                    String message = obj.getObjectType() + "\t" + obj.getObjectName() + "\t" + obj.getDestFileName();
                    if (obj.getException() != null) {
                        message = message + "\n" + obj.getException().getMessage();
                    }
                    GeneralMessages.generalMessage(ConsoleColors.YELLOW, message);
                }
            }
            GeneralMessages.generalMessage("");
            GeneralMessages.successMessage(StageMessages.get("STAGE_SUCCESS"));
            GeneralMessages.generalMessage("");
            try (Git git = GitUtils.findGitRepo(this.root.toFile());){
                if (git != null) {
                    GitUtils.displayUncommited(git.getRepository(), this.root.toString(), ctx);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.handleException(ctx, e);
        }
    }

    private void handleException(ScriptRunnerContext ctx, Exception e) {
        if (ctx.getCurrentConnection() != null) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROCESSING_ERROR", e.getCause() == null ? e.getMessage() : e.getCause().getMessage()));
        }
        GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
    }
}

