/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.config.subcommand;

import java.sql.Connection;
import oracle.dbtools.extension.project.commands.Interfaces.CommandInterface;
import oracle.dbtools.extension.project.commands.ProjectMessages;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigSetCommand
implements CommandInterface {
    @Override
    public void run(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        try {
            ProjectConfig.setupDebugVerbose(parsedCommand);
            String name = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.NAME);
            String value = (String)parsedCommand.getOptionValue((Id)ProjectOptions.Options.VALUE);
            ProjectSettings.saveValue(name, value);
            ProjectSettings.writeUserSettings();
            GeneralMessages.verboseMessage(ProjectMessages.format("CONFIG_SETTING_UPDATED", name));
            GeneralMessages.successMessage(ProjectMessages.format("PROJECT_SUCCESS", new Object[0]));
        }
        catch (Exception e) {
            GeneralMessages.errorMessage(ProjectMessages.format("PROJECT_ERROR", e.getMessage()));
            GeneralMessages.debugException(e);
        }
    }
}

