/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.signing.internal;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.AuthCachingPolicy;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.KeySupplier;
import com.oracle.bmc.http.signing.internal.PEMFileRSAPrivateKeySupplier;
import com.oracle.bmc.http.signing.internal.RequestSignerImpl;
import java.beans.ConstructorProperties;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DefaultRequestSignerFactory
implements RequestSignerFactory {
    private final SigningStrategy signingStrategy;

    @Override
    public RequestSigner createRequestSigner(Service service, AbstractAuthenticationDetailsProvider abstractAuthProvider) {
        if (!(abstractAuthProvider instanceof BasicAuthenticationDetailsProvider)) {
            throw new IllegalArgumentException("Unsupported auth provider type: " + abstractAuthProvider.getClass().getName());
        }
        BasicAuthenticationDetailsProvider authProvider = (BasicAuthenticationDetailsProvider)abstractAuthProvider;
        AuthCachingPolicy policy = DefaultRequestSignerFactory.getAuthCachingPolicy(authProvider);
        Supplier<String> keyIdSupplier = this.createKeyIdSupplier(authProvider, policy);
        KeySupplier<RSAPrivateKey> keySupplier = DefaultRequestSignerFactory.createKeySupplier(authProvider, policy);
        return new RequestSignerImpl(keySupplier, this.signingStrategy, keyIdSupplier);
    }

    protected Supplier<String> createKeyIdSupplier(final BasicAuthenticationDetailsProvider authenticationDetailsProvider, AuthCachingPolicy policy) {
        boolean cacheKeyId = true;
        if (policy != null) {
            cacheKeyId = policy.cacheKeyId();
        }
        if (!cacheKeyId) {
            return new Supplier<String>(){
                final /* synthetic */ DefaultRequestSignerFactory this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String get() {
                    return authenticationDetailsProvider.getKeyId();
                }
            };
        }
        final String keyId = authenticationDetailsProvider.getKeyId();
        return new Supplier<String>(){
            final /* synthetic */ DefaultRequestSignerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public String get() {
                return keyId;
            }
        };
    }

    public static KeySupplier<RSAPrivateKey> createKeySupplier(final BasicAuthenticationDetailsProvider authenticationDetailsProvider, AuthCachingPolicy policy) {
        boolean cachePrivateKey = true;
        if (policy != null) {
            cachePrivateKey = policy.cachePrivateKey();
        }
        if (!cachePrivateKey) {
            return new KeySupplier<RSAPrivateKey>(){

                @Override
                public Optional<RSAPrivateKey> supplyKey(String keyId) {
                    return new PEMFileRSAPrivateKeySupplier(authenticationDetailsProvider.getPrivateKey(), authenticationDetailsProvider.getPassphraseCharacters()).supplyKey(keyId);
                }
            };
        }
        return new PEMFileRSAPrivateKeySupplier(authenticationDetailsProvider.getPrivateKey(), authenticationDetailsProvider.getPassphraseCharacters());
    }

    public static AuthCachingPolicy getAuthCachingPolicy(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        return authenticationDetailsProvider.getClass().getAnnotation(AuthCachingPolicy.class);
    }

    public static Map<SigningStrategy, RequestSignerFactory> createDefaultRequestSignerFactories() {
        HashMap<SigningStrategy, DefaultRequestSignerFactory> map = new HashMap<SigningStrategy, DefaultRequestSignerFactory>();
        for (SigningStrategy s : SigningStrategy.values()) {
            map.put(s, new DefaultRequestSignerFactory(s));
        }
        return Collections.unmodifiableMap(map);
    }

    @ConstructorProperties(value={"signingStrategy"})
    @InternalSdk(backwardCompatibilityRequired=true)
    public DefaultRequestSignerFactory(SigningStrategy signingStrategy) {
        this.signingStrategy = signingStrategy;
    }
}

