/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.pki;

import com.oracle.bmc.http.client.pki.Eraser;
import com.oracle.bmc.http.client.pki.Utf8;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

abstract class Text {
    private Text() {
    }

    static String of(byte[] utf8) {
        if (utf8 == null) {
            return null;
        }
        return new String(utf8, StandardCharsets.UTF_8);
    }

    static String of(Utf8 utf8) {
        if (utf8 == null) {
            return null;
        }
        return Text.of(utf8.bytes());
    }

    static byte[] bytes(String text) {
        if (text == null) {
            return null;
        }
        return text.getBytes(StandardCharsets.UTF_8);
    }

    static char[] chars(byte[] content) {
        ByteBuffer bytes = ByteBuffer.wrap(content);
        CharBuffer buffer = StandardCharsets.UTF_8.decode(bytes);
        char[] buf = buffer.array();
        int position = buffer.position();
        int limit = buffer.limit();
        int offset = buffer.arrayOffset();
        if (offset == 0 && position == 0 && limit == buf.length) {
            return buf;
        }
        char[] chars = Arrays.copyOfRange(buf, offset + position, offset + limit);
        Eraser.erase(buf);
        return chars;
    }

    static byte[] bytes(CharBuffer text) {
        if (text == null) {
            return null;
        }
        CharBuffer chars = text.asReadOnlyBuffer();
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(chars);
        byte[] buf = buffer.array();
        int position = buffer.position();
        int limit = buffer.limit();
        int offset = buffer.arrayOffset();
        if (offset == 0 && position == 0 && limit == buf.length) {
            return buf;
        }
        byte[] bytes = Arrays.copyOfRange(buf, offset + position, offset + limit);
        Eraser.erase(buf);
        return bytes;
    }
}

