/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.DefaultConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.objectstorage.ObjectStorageAsync;
import com.oracle.bmc.objectstorage.internal.http.ObjectMetadataInterceptor;
import com.oracle.bmc.objectstorage.model.ArchivalState;
import com.oracle.bmc.objectstorage.model.Bucket;
import com.oracle.bmc.objectstorage.model.BucketSummary;
import com.oracle.bmc.objectstorage.model.ListObjects;
import com.oracle.bmc.objectstorage.model.MultipartUpload;
import com.oracle.bmc.objectstorage.model.MultipartUploadPartSummary;
import com.oracle.bmc.objectstorage.model.NamespaceMetadata;
import com.oracle.bmc.objectstorage.model.ObjectLifecyclePolicy;
import com.oracle.bmc.objectstorage.model.ObjectVersionCollection;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequest;
import com.oracle.bmc.objectstorage.model.PreauthenticatedRequestSummary;
import com.oracle.bmc.objectstorage.model.PrivateEndpoint;
import com.oracle.bmc.objectstorage.model.PrivateEndpointSummary;
import com.oracle.bmc.objectstorage.model.ReplicationPolicy;
import com.oracle.bmc.objectstorage.model.ReplicationPolicySummary;
import com.oracle.bmc.objectstorage.model.ReplicationSource;
import com.oracle.bmc.objectstorage.model.RetentionRule;
import com.oracle.bmc.objectstorage.model.RetentionRuleCollection;
import com.oracle.bmc.objectstorage.model.StorageTier;
import com.oracle.bmc.objectstorage.model.WorkRequest;
import com.oracle.bmc.objectstorage.model.WorkRequestError;
import com.oracle.bmc.objectstorage.model.WorkRequestLogEntry;
import com.oracle.bmc.objectstorage.model.WorkRequestSummary;
import com.oracle.bmc.objectstorage.requests.AbortMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CancelWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.CommitMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CopyObjectRequest;
import com.oracle.bmc.objectstorage.requests.CreateBucketRequest;
import com.oracle.bmc.objectstorage.requests.CreateMultipartUploadRequest;
import com.oracle.bmc.objectstorage.requests.CreatePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.objectstorage.requests.CreateReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.CreateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.DeleteBucketRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteObjectRequest;
import com.oracle.bmc.objectstorage.requests.DeletePreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.objectstorage.requests.DeleteReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.DeleteRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetBucketRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.GetNamespaceRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.requests.GetPreauthenticatedRequestRequest;
import com.oracle.bmc.objectstorage.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.objectstorage.requests.GetReplicationPolicyRequest;
import com.oracle.bmc.objectstorage.requests.GetRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.GetWorkRequestRequest;
import com.oracle.bmc.objectstorage.requests.HeadBucketRequest;
import com.oracle.bmc.objectstorage.requests.HeadObjectRequest;
import com.oracle.bmc.objectstorage.requests.ListBucketsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadPartsRequest;
import com.oracle.bmc.objectstorage.requests.ListMultipartUploadsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectVersionsRequest;
import com.oracle.bmc.objectstorage.requests.ListObjectsRequest;
import com.oracle.bmc.objectstorage.requests.ListPreauthenticatedRequestsRequest;
import com.oracle.bmc.objectstorage.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationPoliciesRequest;
import com.oracle.bmc.objectstorage.requests.ListReplicationSourcesRequest;
import com.oracle.bmc.objectstorage.requests.ListRetentionRulesRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.objectstorage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.objectstorage.requests.MakeBucketWritableRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectLifecyclePolicyRequest;
import com.oracle.bmc.objectstorage.requests.PutObjectRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptBucketRequest;
import com.oracle.bmc.objectstorage.requests.ReencryptObjectRequest;
import com.oracle.bmc.objectstorage.requests.RenameObjectRequest;
import com.oracle.bmc.objectstorage.requests.RestoreObjectsRequest;
import com.oracle.bmc.objectstorage.requests.UpdateBucketRequest;
import com.oracle.bmc.objectstorage.requests.UpdateNamespaceMetadataRequest;
import com.oracle.bmc.objectstorage.requests.UpdateObjectStorageTierRequest;
import com.oracle.bmc.objectstorage.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.objectstorage.requests.UpdateRetentionRuleRequest;
import com.oracle.bmc.objectstorage.requests.UploadPartRequest;
import com.oracle.bmc.objectstorage.responses.AbortMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CancelWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.CommitMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CopyObjectResponse;
import com.oracle.bmc.objectstorage.responses.CreateBucketResponse;
import com.oracle.bmc.objectstorage.responses.CreateMultipartUploadResponse;
import com.oracle.bmc.objectstorage.responses.CreatePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.objectstorage.responses.CreateReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.CreateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.DeleteBucketResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteObjectResponse;
import com.oracle.bmc.objectstorage.responses.DeletePreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.objectstorage.responses.DeleteReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.DeleteRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetBucketResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.GetNamespaceResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import com.oracle.bmc.objectstorage.responses.GetPreauthenticatedRequestResponse;
import com.oracle.bmc.objectstorage.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.objectstorage.responses.GetReplicationPolicyResponse;
import com.oracle.bmc.objectstorage.responses.GetRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.GetWorkRequestResponse;
import com.oracle.bmc.objectstorage.responses.HeadBucketResponse;
import com.oracle.bmc.objectstorage.responses.HeadObjectResponse;
import com.oracle.bmc.objectstorage.responses.ListBucketsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadPartsResponse;
import com.oracle.bmc.objectstorage.responses.ListMultipartUploadsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectVersionsResponse;
import com.oracle.bmc.objectstorage.responses.ListObjectsResponse;
import com.oracle.bmc.objectstorage.responses.ListPreauthenticatedRequestsResponse;
import com.oracle.bmc.objectstorage.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationPoliciesResponse;
import com.oracle.bmc.objectstorage.responses.ListReplicationSourcesResponse;
import com.oracle.bmc.objectstorage.responses.ListRetentionRulesResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.objectstorage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.objectstorage.responses.MakeBucketWritableResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectLifecyclePolicyResponse;
import com.oracle.bmc.objectstorage.responses.PutObjectResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptBucketResponse;
import com.oracle.bmc.objectstorage.responses.ReencryptObjectResponse;
import com.oracle.bmc.objectstorage.responses.RenameObjectResponse;
import com.oracle.bmc.objectstorage.responses.RestoreObjectsResponse;
import com.oracle.bmc.objectstorage.responses.UpdateBucketResponse;
import com.oracle.bmc.objectstorage.responses.UpdateNamespaceMetadataResponse;
import com.oracle.bmc.objectstorage.responses.UpdateObjectStorageTierResponse;
import com.oracle.bmc.objectstorage.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.objectstorage.responses.UpdateRetentionRuleResponse;
import com.oracle.bmc.objectstorage.responses.UploadPartResponse;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectStorageAsyncClient
extends BaseAsyncClient
implements ObjectStorageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OBJECTSTORAGE").serviceEndpointPrefix("objectstorage").serviceEndpointTemplate("https://objectstorage.{region}.{secondLevelDomain}").addServiceEndpointTemplateForRealm("oc1", "https://{namespaceName+Dot}objectstorage.{region}.oci.customer-oci.com").endpointServiceName("objectstorage").build();
    private static final Logger LOG = LoggerFactory.getLogger(ObjectStorageAsyncClient.class);

    ObjectStorageAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    ObjectStorageAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"ObjectStorageAsyncClient", (String)"getObject"));
        }
    }

    protected ClientConfigurator getDefaultConfigurator() {
        return new DefaultConfigurator.NonBuffering();
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AbortMultipartUploadResponse> abortMultipartUpload(AbortMultipartUploadRequest request, AsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadId(), "uploadId is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        requiredParametersMap.put("uploadId", request.getUploadId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, AbortMultipartUploadResponse::builder).logger(LOG, "abortMultipartUpload").serviceDetails("ObjectStorage", "AbortMultipartUpload", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/AbortMultipartUpload").method(Method.DELETE).requestBuilder(AbortMultipartUploadRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").appendPathParam(request.getObjectName()).appendQueryParam("uploadId", (Object)request.getUploadId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", AbortMultipartUploadResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", AbortMultipartUploadResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("workRequestId", request.getWorkRequestId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ObjectStorage", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", CancelWorkRequestResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<CommitMultipartUploadResponse> commitMultipartUpload(CommitMultipartUploadRequest request, AsyncHandler<CommitMultipartUploadRequest, CommitMultipartUploadResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadId(), "uploadId is required");
        Objects.requireNonNull(request.getCommitMultipartUploadDetails(), "commitMultipartUploadDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        requiredParametersMap.put("uploadId", request.getUploadId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CommitMultipartUploadResponse::builder).logger(LOG, "commitMultipartUpload").serviceDetails("ObjectStorage", "CommitMultipartUpload", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/CommitMultipartUpload").method(Method.POST).requestBuilder(CommitMultipartUploadRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").appendPathParam(request.getObjectName()).appendQueryParam("uploadId", (Object)request.getUploadId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-client-request-id", CommitMultipartUploadResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", CommitMultipartUploadResponse.Builder::opcRequestId).handleResponseHeaderString("opc-multipart-md5", CommitMultipartUploadResponse.Builder::opcMultipartMd5).handleResponseHeaderString("opc-content-crc32c", CommitMultipartUploadResponse.Builder::opcContentCrc32c).handleResponseHeaderString("opc-multipart-sha256", CommitMultipartUploadResponse.Builder::opcMultipartSha256).handleResponseHeaderString("opc-multipart-sha384", CommitMultipartUploadResponse.Builder::opcMultipartSha384).handleResponseHeaderString("ETag", CommitMultipartUploadResponse.Builder::eTag).handleResponseHeaderDate("last-modified", CommitMultipartUploadResponse.Builder::lastModified).handleResponseHeaderString("version-id", CommitMultipartUploadResponse.Builder::versionId).callAsync(handler);
    }

    @Override
    public Future<CopyObjectResponse> copyObject(CopyObjectRequest request, AsyncHandler<CopyObjectRequest, CopyObjectResponse> handler) {
        request = ObjectMetadataInterceptor.intercept(request);
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCopyObjectDetails(), "copyObjectDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CopyObjectResponse::builder).logger(LOG, "copyObject").serviceDetails("ObjectStorage", "CopyObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/CopyObject").method(Method.POST).requestBuilder(CopyObjectRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("copyObject").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).appendHeader("opc-source-sse-customer-algorithm", request.getOpcSourceSseCustomerAlgorithm()).appendHeader("opc-source-sse-customer-key", request.getOpcSourceSseCustomerKey()).appendHeader("opc-source-sse-customer-key-sha256", request.getOpcSourceSseCustomerKeySha256()).appendHeader("opc-sse-kms-key-id", request.getOpcSseKmsKeyId()).hasBody().handleResponseHeaderString("opc-work-request-id", CopyObjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CopyObjectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", CopyObjectResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateBucketResponse> createBucket(CreateBucketRequest request, AsyncHandler<CreateBucketRequest, CreateBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBucketDetails(), "createBucketDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreateBucketResponse::builder).logger(LOG, "createBucket").serviceDetails("ObjectStorage", "CreateBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/CreateBucket").method(Method.POST).requestBuilder(CreateBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(Bucket.class, CreateBucketResponse.Builder::bucket).handleResponseHeaderString("opc-client-request-id", CreateBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", CreateBucketResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", CreateBucketResponse.Builder::eTag).handleResponseHeaderString("Location", CreateBucketResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateMultipartUploadResponse> createMultipartUpload(CreateMultipartUploadRequest request, AsyncHandler<CreateMultipartUploadRequest, CreateMultipartUploadResponse> handler) {
        request = ObjectMetadataInterceptor.intercept(request);
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateMultipartUploadDetails(), "createMultipartUploadDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreateMultipartUploadResponse::builder).logger(LOG, "createMultipartUpload").serviceDetails("ObjectStorage", "CreateMultipartUpload", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/CreateMultipartUpload").method(Method.POST).requestBuilder(CreateMultipartUploadRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).appendHeader("opc-sse-kms-key-id", request.getOpcSseKmsKeyId()).appendEnumHeader("opc-checksum-algorithm", (BmcEnum)request.getOpcChecksumAlgorithm()).hasBody().handleBody(MultipartUpload.class, CreateMultipartUploadResponse.Builder::multipartUpload).handleResponseHeaderString("opc-client-request-id", CreateMultipartUploadResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", CreateMultipartUploadResponse.Builder::opcRequestId).handleResponseHeaderString("Location", CreateMultipartUploadResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreatePreauthenticatedRequestResponse> createPreauthenticatedRequest(CreatePreauthenticatedRequestRequest request, AsyncHandler<CreatePreauthenticatedRequestRequest, CreatePreauthenticatedRequestResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePreauthenticatedRequestDetails(), "createPreauthenticatedRequestDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreatePreauthenticatedRequestResponse::builder).logger(LOG, "createPreauthenticatedRequest").serviceDetails("ObjectStorage", "CreatePreauthenticatedRequest", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PreauthenticatedRequest/CreatePreauthenticatedRequest").method(Method.POST).requestBuilder(CreatePreauthenticatedRequestRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("p").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(PreauthenticatedRequest.class, CreatePreauthenticatedRequestResponse.Builder::preauthenticatedRequest).handleResponseHeaderString("opc-client-request-id", CreatePreauthenticatedRequestResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", CreatePreauthenticatedRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request, AsyncHandler<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePrivateEndpointDetails(), "createPrivateEndpointDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreatePrivateEndpointResponse::builder).logger(LOG, "createPrivateEndpoint").serviceDetails("ObjectStorage", "CreatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PrivateEndpoint/CreatePrivateEndpoint").method(Method.POST).requestBuilder(CreatePrivateEndpointRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("pe").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreatePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreatePrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", CreatePrivateEndpointResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateReplicationPolicyResponse> createReplicationPolicy(CreateReplicationPolicyRequest request, AsyncHandler<CreateReplicationPolicyRequest, CreateReplicationPolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateReplicationPolicyDetails(), "createReplicationPolicyDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreateReplicationPolicyResponse::builder).logger(LOG, "createReplicationPolicy").serviceDetails("ObjectStorage", "CreateReplicationPolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/CreateReplicationPolicy").method(Method.POST).requestBuilder(CreateReplicationPolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("replicationPolicies").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(ReplicationPolicy.class, CreateReplicationPolicyResponse.Builder::replicationPolicy).handleResponseHeaderString("opc-request-id", CreateReplicationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", CreateReplicationPolicyResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRetentionRuleResponse> createRetentionRule(CreateRetentionRuleRequest request, AsyncHandler<CreateRetentionRuleRequest, CreateRetentionRuleResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateRetentionRuleDetails(), "createRetentionRuleDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, CreateRetentionRuleResponse::builder).logger(LOG, "createRetentionRule").serviceDetails("ObjectStorage", "CreateRetentionRule", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/RetentionRule/CreateRetentionRule").method(Method.POST).requestBuilder(CreateRetentionRuleRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("retentionRules").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(RetentionRule.class, CreateRetentionRuleResponse.Builder::retentionRule).handleResponseHeaderString("opc-request-id", CreateRetentionRuleResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", CreateRetentionRuleResponse.Builder::opcClientRequestId).handleResponseHeaderString("etag", CreateRetentionRuleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteBucketResponse> deleteBucket(DeleteBucketRequest request, AsyncHandler<DeleteBucketRequest, DeleteBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeleteBucketResponse::builder).logger(LOG, "deleteBucket").serviceDetails("ObjectStorage", "DeleteBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/DeleteBucket").method(Method.DELETE).requestBuilder(DeleteBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", DeleteBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", DeleteBucketResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteObjectResponse> deleteObject(DeleteObjectRequest request, AsyncHandler<DeleteObjectRequest, DeleteObjectResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeleteObjectResponse::builder).logger(LOG, "deleteObject").serviceDetails("ObjectStorage", "DeleteObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/DeleteObject").method(Method.DELETE).requestBuilder(DeleteObjectRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("o").appendPathParam(request.getObjectName()).appendQueryParam("versionId", (Object)request.getVersionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", DeleteObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", DeleteObjectResponse.Builder::opcRequestId).handleResponseHeaderDate("last-modified", DeleteObjectResponse.Builder::lastModified).handleResponseHeaderString("version-id", DeleteObjectResponse.Builder::versionId).handleResponseHeaderBoolean("is-delete-marker", DeleteObjectResponse.Builder::isDeleteMarker).callAsync(handler);
    }

    @Override
    public Future<DeleteObjectLifecyclePolicyResponse> deleteObjectLifecyclePolicy(DeleteObjectLifecyclePolicyRequest request, AsyncHandler<DeleteObjectLifecyclePolicyRequest, DeleteObjectLifecyclePolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeleteObjectLifecyclePolicyResponse::builder).logger(LOG, "deleteObjectLifecyclePolicy").serviceDetails("ObjectStorage", "DeleteObjectLifecyclePolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/ObjectLifecyclePolicy/DeleteObjectLifecyclePolicy").method(Method.DELETE).requestBuilder(DeleteObjectLifecyclePolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("l").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteObjectLifecyclePolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", DeleteObjectLifecyclePolicyResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePreauthenticatedRequestResponse> deletePreauthenticatedRequest(DeletePreauthenticatedRequestRequest request, AsyncHandler<DeletePreauthenticatedRequestRequest, DeletePreauthenticatedRequestResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParId(), (String)"parId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("parId", request.getParId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeletePreauthenticatedRequestResponse::builder).logger(LOG, "deletePreauthenticatedRequest").serviceDetails("ObjectStorage", "DeletePreauthenticatedRequest", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PreauthenticatedRequest/DeletePreauthenticatedRequest").method(Method.DELETE).requestBuilder(DeletePreauthenticatedRequestRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("p").appendPathParam(request.getParId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", DeletePreauthenticatedRequestResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", DeletePreauthenticatedRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request, AsyncHandler<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeName(), (String)"peName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("peName", request.getPeName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeletePrivateEndpointResponse::builder).logger(LOG, "deletePrivateEndpoint").serviceDetails("ObjectStorage", "DeletePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PrivateEndpoint/DeletePrivateEndpoint").method(Method.DELETE).requestBuilder(DeletePrivateEndpointRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("pe").appendPathParam(request.getPeName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-work-request-id", DeletePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-client-request-id", DeletePrivateEndpointResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", DeletePrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteReplicationPolicyResponse> deleteReplicationPolicy(DeleteReplicationPolicyRequest request, AsyncHandler<DeleteReplicationPolicyRequest, DeleteReplicationPolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("replicationId", request.getReplicationId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeleteReplicationPolicyResponse::builder).logger(LOG, "deleteReplicationPolicy").serviceDetails("ObjectStorage", "DeleteReplicationPolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/DeleteReplicationPolicy").method(Method.DELETE).requestBuilder(DeleteReplicationPolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("replicationPolicies").appendPathParam(request.getReplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-request-id", DeleteReplicationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", DeleteReplicationPolicyResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRetentionRuleResponse> deleteRetentionRule(DeleteRetentionRuleRequest request, AsyncHandler<DeleteRetentionRuleRequest, DeleteRetentionRuleResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRetentionRuleId(), (String)"retentionRuleId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("retentionRuleId", request.getRetentionRuleId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, DeleteRetentionRuleResponse::builder).logger(LOG, "deleteRetentionRule").serviceDetails("ObjectStorage", "DeleteRetentionRule", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/RetentionRule/DeleteRetentionRule").method(Method.DELETE).requestBuilder(DeleteRetentionRuleRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("retentionRules").appendPathParam(request.getRetentionRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", DeleteRetentionRuleResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", DeleteRetentionRuleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBucketResponse> getBucket(GetBucketRequest request, AsyncHandler<GetBucketRequest, GetBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetBucketResponse::builder).logger(LOG, "getBucket").serviceDetails("ObjectStorage", "GetBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/GetBucket").method(Method.GET).requestBuilder(GetBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.CommaSeparated).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(Bucket.class, GetBucketResponse.Builder::bucket).handleResponseHeaderString("opc-client-request-id", GetBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetBucketResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetBucketResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetNamespaceResponse> getNamespace(GetNamespaceRequest request, AsyncHandler<GetNamespaceRequest, GetNamespaceResponse> handler) {
        HashMap requiredParametersMap = new HashMap();
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetNamespaceResponse::builder).logger(LOG, "getNamespace").serviceDetails("ObjectStorage", "GetNamespace", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Namespace/GetNamespace").method(Method.GET).requestBuilder(GetNamespaceRequest::builder).basePath("/").appendPathParam("n").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(String.class, GetNamespaceResponse.Builder::value).callAsync(handler);
    }

    @Override
    public Future<GetNamespaceMetadataResponse> getNamespaceMetadata(GetNamespaceMetadataRequest request, AsyncHandler<GetNamespaceMetadataRequest, GetNamespaceMetadataResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetNamespaceMetadataResponse::builder).logger(LOG, "getNamespaceMetadata").serviceDetails("ObjectStorage", "GetNamespaceMetadata", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Namespace/GetNamespaceMetadata").method(Method.GET).requestBuilder(GetNamespaceMetadataRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(NamespaceMetadata.class, GetNamespaceMetadataResponse.Builder::namespaceMetadata).handleResponseHeaderString("opc-client-request-id", GetNamespaceMetadataResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetNamespaceMetadataResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetObjectResponse> getObject(GetObjectRequest request, AsyncHandler<GetObjectRequest, GetObjectResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetObjectResponse::builder).logger(LOG, "getObject").serviceDetails("ObjectStorage", "GetObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/GetObject").method(Method.GET).requestBuilder(GetObjectRequest::builder).interceptResponse(ObjectMetadataInterceptor::intercept).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("o").appendPathParam(request.getObjectName()).appendQueryParam("versionId", (Object)request.getVersionId()).appendQueryParam("httpResponseContentDisposition", (Object)request.getHttpResponseContentDisposition()).appendQueryParam("httpResponseCacheControl", (Object)request.getHttpResponseCacheControl()).appendQueryParam("httpResponseContentType", (Object)request.getHttpResponseContentType()).appendQueryParam("httpResponseContentLanguage", (Object)request.getHttpResponseContentLanguage()).appendQueryParam("httpResponseContentEncoding", (Object)request.getHttpResponseContentEncoding()).appendQueryParam("httpResponseExpires", (Object)request.getHttpResponseExpires()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("range", request.getRange()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).handleBody(InputStream.class, GetObjectResponse.Builder::inputStream).handleResponseHeaderString("opc-client-request-id", GetObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetObjectResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", GetObjectResponse.Builder::eTag).handleResponseHeadersMap("opc-meta-", GetObjectResponse.Builder::opcMeta).handleResponseHeaderLong("content-length", GetObjectResponse.Builder::contentLength).handleResponseHeaderRange("content-range", GetObjectResponse.Builder::contentRange).handleResponseHeaderString("content-md5", GetObjectResponse.Builder::contentMd5).handleResponseHeaderString("opc-multipart-md5", GetObjectResponse.Builder::opcMultipartMd5).handleResponseHeaderString("opc-content-crc32c", GetObjectResponse.Builder::opcContentCrc32c).handleResponseHeaderString("opc-content-sha256", GetObjectResponse.Builder::opcContentSha256).handleResponseHeaderString("opc-multipart-sha256", GetObjectResponse.Builder::opcMultipartSha256).handleResponseHeaderString("opc-content-sha384", GetObjectResponse.Builder::opcContentSha384).handleResponseHeaderString("opc-multipart-sha384", GetObjectResponse.Builder::opcMultipartSha384).handleResponseHeaderString("content-type", GetObjectResponse.Builder::contentType).handleResponseHeaderString("content-language", GetObjectResponse.Builder::contentLanguage).handleResponseHeaderString("content-encoding", GetObjectResponse.Builder::contentEncoding).handleResponseHeaderString("cache-control", GetObjectResponse.Builder::cacheControl).handleResponseHeaderString("content-disposition", GetObjectResponse.Builder::contentDisposition).handleResponseHeaderDate("last-modified", GetObjectResponse.Builder::lastModified).handleResponseHeaderEnum("storage-tier", StorageTier::create, GetObjectResponse.Builder::storageTier).handleResponseHeaderEnum("archival-state", ArchivalState::create, GetObjectResponse.Builder::archivalState).handleResponseHeaderDate("time-of-archival", GetObjectResponse.Builder::timeOfArchival).handleResponseHeaderString("version-id", GetObjectResponse.Builder::versionId).handleResponseHeaderDate("expires", GetObjectResponse.Builder::expires).callAsync(handler);
    }

    @Override
    public Future<GetObjectLifecyclePolicyResponse> getObjectLifecyclePolicy(GetObjectLifecyclePolicyRequest request, AsyncHandler<GetObjectLifecyclePolicyRequest, GetObjectLifecyclePolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetObjectLifecyclePolicyResponse::builder).logger(LOG, "getObjectLifecyclePolicy").serviceDetails("ObjectStorage", "GetObjectLifecyclePolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/ObjectLifecyclePolicy/GetObjectLifecyclePolicy").method(Method.GET).requestBuilder(GetObjectLifecyclePolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("l").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(ObjectLifecyclePolicy.class, GetObjectLifecyclePolicyResponse.Builder::objectLifecyclePolicy).handleResponseHeaderString("opc-request-id", GetObjectLifecyclePolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", GetObjectLifecyclePolicyResponse.Builder::opcClientRequestId).handleResponseHeaderString("ETag", GetObjectLifecyclePolicyResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetPreauthenticatedRequestResponse> getPreauthenticatedRequest(GetPreauthenticatedRequestRequest request, AsyncHandler<GetPreauthenticatedRequestRequest, GetPreauthenticatedRequestResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getParId(), (String)"parId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("parId", request.getParId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetPreauthenticatedRequestResponse::builder).logger(LOG, "getPreauthenticatedRequest").serviceDetails("ObjectStorage", "GetPreauthenticatedRequest", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PreauthenticatedRequest/GetPreauthenticatedRequest").method(Method.GET).requestBuilder(GetPreauthenticatedRequestRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("p").appendPathParam(request.getParId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(PreauthenticatedRequestSummary.class, GetPreauthenticatedRequestResponse.Builder::preauthenticatedRequestSummary).handleResponseHeaderString("opc-client-request-id", GetPreauthenticatedRequestResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetPreauthenticatedRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request, AsyncHandler<GetPrivateEndpointRequest, GetPrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeName(), (String)"peName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("peName", request.getPeName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetPrivateEndpointResponse::builder).logger(LOG, "getPrivateEndpoint").serviceDetails("ObjectStorage", "GetPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PrivateEndpoint/GetPrivateEndpoint").method(Method.GET).requestBuilder(GetPrivateEndpointRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("pe").appendPathParam(request.getPeName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(PrivateEndpoint.class, GetPrivateEndpointResponse.Builder::privateEndpoint).handleResponseHeaderString("opc-client-request-id", GetPrivateEndpointResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("eTag", GetPrivateEndpointResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<GetReplicationPolicyResponse> getReplicationPolicy(GetReplicationPolicyRequest request, AsyncHandler<GetReplicationPolicyRequest, GetReplicationPolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getReplicationId(), (String)"replicationId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("replicationId", request.getReplicationId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetReplicationPolicyResponse::builder).logger(LOG, "getReplicationPolicy").serviceDetails("ObjectStorage", "GetReplicationPolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/GetReplicationPolicy").method(Method.GET).requestBuilder(GetReplicationPolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("replicationPolicies").appendPathParam(request.getReplicationId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(ReplicationPolicy.class, GetReplicationPolicyResponse.Builder::replicationPolicy).handleResponseHeaderString("opc-request-id", GetReplicationPolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", GetReplicationPolicyResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRetentionRuleResponse> getRetentionRule(GetRetentionRuleRequest request, AsyncHandler<GetRetentionRuleRequest, GetRetentionRuleResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRetentionRuleId(), (String)"retentionRuleId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("retentionRuleId", request.getRetentionRuleId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetRetentionRuleResponse::builder).logger(LOG, "getRetentionRule").serviceDetails("ObjectStorage", "GetRetentionRule", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/RetentionRule/GetRetentionRule").method(Method.GET).requestBuilder(GetRetentionRuleRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("retentionRules").appendPathParam(request.getRetentionRuleId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(RetentionRule.class, GetRetentionRuleResponse.Builder::retentionRule).handleResponseHeaderString("opc-client-request-id", GetRetentionRuleResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", GetRetentionRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRetentionRuleResponse.Builder::etag).handleResponseHeaderDate("last-modified", GetRetentionRuleResponse.Builder::lastModified).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("workRequestId", request.getWorkRequestId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ObjectStorage", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", GetWorkRequestResponse.Builder::opcClientRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<HeadBucketResponse> headBucket(HeadBucketRequest request, AsyncHandler<HeadBucketRequest, HeadBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, HeadBucketResponse::builder).logger(LOG, "headBucket").serviceDetails("ObjectStorage", "HeadBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/HeadBucket").method(Method.HEAD).requestBuilder(HeadBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", HeadBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", HeadBucketResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", HeadBucketResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<HeadObjectResponse> headObject(HeadObjectRequest request, AsyncHandler<HeadObjectRequest, HeadObjectResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, HeadObjectResponse::builder).logger(LOG, "headObject").serviceDetails("ObjectStorage", "HeadObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/HeadObject").method(Method.HEAD).requestBuilder(HeadObjectRequest::builder).interceptResponse(ObjectMetadataInterceptor::intercept).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("o").appendPathParam(request.getObjectName()).appendQueryParam("versionId", (Object)request.getVersionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).handleResponseHeaderString("opc-client-request-id", HeadObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", HeadObjectResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", HeadObjectResponse.Builder::eTag).handleResponseHeadersMap("opc-meta-", HeadObjectResponse.Builder::opcMeta).handleResponseHeaderLong("content-length", HeadObjectResponse.Builder::contentLength).handleResponseHeaderString("content-md5", HeadObjectResponse.Builder::contentMd5).handleResponseHeaderString("opc-multipart-md5", HeadObjectResponse.Builder::opcMultipartMd5).handleResponseHeaderString("opc-content-crc32c", HeadObjectResponse.Builder::opcContentCrc32c).handleResponseHeaderString("opc-content-sha256", HeadObjectResponse.Builder::opcContentSha256).handleResponseHeaderString("opc-multipart-sha256", HeadObjectResponse.Builder::opcMultipartSha256).handleResponseHeaderString("opc-content-sha384", HeadObjectResponse.Builder::opcContentSha384).handleResponseHeaderString("opc-multipart-sha384", HeadObjectResponse.Builder::opcMultipartSha384).handleResponseHeaderString("content-type", HeadObjectResponse.Builder::contentType).handleResponseHeaderString("content-language", HeadObjectResponse.Builder::contentLanguage).handleResponseHeaderString("content-encoding", HeadObjectResponse.Builder::contentEncoding).handleResponseHeaderString("cache-control", HeadObjectResponse.Builder::cacheControl).handleResponseHeaderString("content-disposition", HeadObjectResponse.Builder::contentDisposition).handleResponseHeaderDate("last-modified", HeadObjectResponse.Builder::lastModified).handleResponseHeaderEnum("storage-tier", StorageTier::create, HeadObjectResponse.Builder::storageTier).handleResponseHeaderEnum("archival-state", ArchivalState::create, HeadObjectResponse.Builder::archivalState).handleResponseHeaderDate("time-of-archival", HeadObjectResponse.Builder::timeOfArchival).handleResponseHeaderString("version-id", HeadObjectResponse.Builder::versionId).callAsync(handler);
    }

    @Override
    public Future<ListBucketsResponse> listBuckets(ListBucketsRequest request, AsyncHandler<ListBucketsRequest, ListBucketsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("compartmentId", request.getCompartmentId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListBucketsResponse::builder).logger(LOG, "listBuckets").serviceDetails("ObjectStorage", "ListBuckets", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/ListBuckets").method(Method.GET).requestBuilder(ListBucketsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.CommaSeparated).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(BucketSummary.class, ListBucketsResponse.Builder::items).handleResponseHeaderString("opc-client-request-id", ListBucketsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListBucketsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBucketsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMultipartUploadPartsResponse> listMultipartUploadParts(ListMultipartUploadPartsRequest request, AsyncHandler<ListMultipartUploadPartsRequest, ListMultipartUploadPartsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadId(), "uploadId is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        requiredParametersMap.put("uploadId", request.getUploadId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListMultipartUploadPartsResponse::builder).logger(LOG, "listMultipartUploadParts").serviceDetails("ObjectStorage", "ListMultipartUploadParts", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/ListMultipartUploadParts").method(Method.GET).requestBuilder(ListMultipartUploadPartsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").appendPathParam(request.getObjectName()).appendQueryParam("uploadId", (Object)request.getUploadId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(MultipartUploadPartSummary.class, ListMultipartUploadPartsResponse.Builder::items).handleResponseHeaderString("opc-client-request-id", ListMultipartUploadPartsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListMultipartUploadPartsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMultipartUploadPartsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListMultipartUploadsResponse> listMultipartUploads(ListMultipartUploadsRequest request, AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListMultipartUploadsResponse::builder).logger(LOG, "listMultipartUploads").serviceDetails("ObjectStorage", "ListMultipartUploads", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/ListMultipartUploads").method(Method.GET).requestBuilder(ListMultipartUploadsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(MultipartUpload.class, ListMultipartUploadsResponse.Builder::items).handleResponseHeaderString("opc-client-request-id", ListMultipartUploadsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListMultipartUploadsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMultipartUploadsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListObjectVersionsResponse> listObjectVersions(ListObjectVersionsRequest request, AsyncHandler<ListObjectVersionsRequest, ListObjectVersionsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListObjectVersionsResponse::builder).logger(LOG, "listObjectVersions").serviceDetails("ObjectStorage", "ListObjectVersions", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/ListObjectVersions").method(Method.GET).requestBuilder(ListObjectVersionsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("objectversions").appendQueryParam("prefix", (Object)request.getPrefix()).appendQueryParam("start", (Object)request.getStart()).appendQueryParam("end", (Object)request.getEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("delimiter", (Object)request.getDelimiter()).appendQueryParam("fields", (Object)request.getFields()).appendQueryParam("startAfter", (Object)request.getStartAfter()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(ObjectVersionCollection.class, ListObjectVersionsResponse.Builder::objectVersionCollection).handleResponseHeaderString("opc-client-request-id", ListObjectVersionsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListObjectVersionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListObjectVersionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListObjectsResponse> listObjects(ListObjectsRequest request, AsyncHandler<ListObjectsRequest, ListObjectsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListObjectsResponse::builder).logger(LOG, "listObjects").serviceDetails("ObjectStorage", "ListObjects", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/ListObjects").method(Method.GET).requestBuilder(ListObjectsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("o").appendQueryParam("prefix", (Object)request.getPrefix()).appendQueryParam("start", (Object)request.getStart()).appendQueryParam("end", (Object)request.getEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("delimiter", (Object)request.getDelimiter()).appendQueryParam("fields", (Object)request.getFields()).appendQueryParam("startAfter", (Object)request.getStartAfter()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBody(ListObjects.class, ListObjectsResponse.Builder::listObjects).handleResponseHeaderString("opc-client-request-id", ListObjectsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListObjectsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListPreauthenticatedRequestsResponse> listPreauthenticatedRequests(ListPreauthenticatedRequestsRequest request, AsyncHandler<ListPreauthenticatedRequestsRequest, ListPreauthenticatedRequestsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListPreauthenticatedRequestsResponse::builder).logger(LOG, "listPreauthenticatedRequests").serviceDetails("ObjectStorage", "ListPreauthenticatedRequests", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PreauthenticatedRequest/ListPreauthenticatedRequests").method(Method.GET).requestBuilder(ListPreauthenticatedRequestsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("p").appendQueryParam("objectNamePrefix", (Object)request.getObjectNamePrefix()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(PreauthenticatedRequestSummary.class, ListPreauthenticatedRequestsResponse.Builder::items).handleResponseHeaderString("opc-client-request-id", ListPreauthenticatedRequestsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListPreauthenticatedRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPreauthenticatedRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request, AsyncHandler<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("compartmentId", request.getCompartmentId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListPrivateEndpointsResponse::builder).logger(LOG, "listPrivateEndpoints").serviceDetails("ObjectStorage", "ListPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PrivateEndpointSummary/ListPrivateEndpoints").method(Method.GET).requestBuilder(ListPrivateEndpointsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("pe").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.CommaSeparated).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(PrivateEndpointSummary.class, ListPrivateEndpointsResponse.Builder::items).handleResponseHeaderString("opc-client-request-id", ListPrivateEndpointsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ListPrivateEndpointsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPrivateEndpointsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListReplicationPoliciesResponse> listReplicationPolicies(ListReplicationPoliciesRequest request, AsyncHandler<ListReplicationPoliciesRequest, ListReplicationPoliciesResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListReplicationPoliciesResponse::builder).logger(LOG, "listReplicationPolicies").serviceDetails("ObjectStorage", "ListReplicationPolicies", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/ListReplicationPolicies").method(Method.GET).requestBuilder(ListReplicationPoliciesRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("replicationPolicies").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(ReplicationPolicySummary.class, ListReplicationPoliciesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListReplicationPoliciesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", ListReplicationPoliciesResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-next-page", ListReplicationPoliciesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListReplicationSourcesResponse> listReplicationSources(ListReplicationSourcesRequest request, AsyncHandler<ListReplicationSourcesRequest, ListReplicationSourcesResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListReplicationSourcesResponse::builder).logger(LOG, "listReplicationSources").serviceDetails("ObjectStorage", "ListReplicationSources", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/ListReplicationSources").method(Method.GET).requestBuilder(ListReplicationSourcesRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("replicationSources").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(ReplicationSource.class, ListReplicationSourcesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListReplicationSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", ListReplicationSourcesResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-next-page", ListReplicationSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRetentionRulesResponse> listRetentionRules(ListRetentionRulesRequest request, AsyncHandler<ListRetentionRulesRequest, ListRetentionRulesResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListRetentionRulesResponse::builder).logger(LOG, "listRetentionRules").serviceDetails("ObjectStorage", "ListRetentionRules", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/RetentionRule/ListRetentionRules").method(Method.GET).requestBuilder(ListRetentionRulesRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("retentionRules").appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBody(RetentionRuleCollection.class, ListRetentionRulesResponse.Builder::retentionRuleCollection).handleResponseHeaderString("opc-request-id", ListRetentionRulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", ListRetentionRulesResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-next-page", ListRetentionRulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("workRequestId", request.getWorkRequestId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ObjectStorage", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-client-request-id", ListWorkRequestErrorsResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("workRequestId", request.getWorkRequestId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ObjectStorage", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", ListWorkRequestLogsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("compartmentId", request.getCompartmentId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ObjectStorage", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("privateEndpointName", (Object)request.getPrivateEndpointName()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-client-request-id", ListWorkRequestsResponse.Builder::opcClientRequestId).callAsync(handler);
    }

    @Override
    public Future<MakeBucketWritableResponse> makeBucketWritable(MakeBucketWritableRequest request, AsyncHandler<MakeBucketWritableRequest, MakeBucketWritableResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, MakeBucketWritableResponse::builder).logger(LOG, "makeBucketWritable").serviceDetails("ObjectStorage", "MakeBucketWritable", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Replication/MakeBucketWritable").method(Method.POST).requestBuilder(MakeBucketWritableRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("makeBucketWritable").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-client-request-id", MakeBucketWritableResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", MakeBucketWritableResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<PutObjectResponse> putObject(PutObjectRequest request, AsyncHandler<PutObjectRequest, PutObjectResponse> handler) {
        request = ObjectMetadataInterceptor.intercept(request);
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutObjectBody(), "putObjectBody is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, PutObjectResponse::builder).logger(LOG, "putObject").serviceDetails("ObjectStorage", "PutObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/PutObject").method(Method.PUT).requestBuilder(PutObjectRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("o").appendPathParam(request.getObjectName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("Expect", request.getExpect()).appendHeader("Content-Length", (Number)request.getContentLength()).appendHeader("Content-MD5", request.getContentMD5()).appendEnumHeader("opc-checksum-algorithm", (BmcEnum)request.getOpcChecksumAlgorithm()).appendHeader("opc-content-crc32c", request.getOpcContentCrc32c()).appendHeader("opc-content-sha256", request.getOpcContentSha256()).appendHeader("opc-content-sha384", request.getOpcContentSha384()).appendHeader("Content-Type", request.getContentType()).appendHeader("Content-Language", request.getContentLanguage()).appendHeader("Content-Encoding", request.getContentEncoding()).appendHeader("Content-Disposition", request.getContentDisposition()).appendHeader("Cache-Control", request.getCacheControl()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).appendHeader("opc-sse-kms-key-id", request.getOpcSseKmsKeyId()).appendEnumHeader("storage-tier", (BmcEnum)request.getStorageTier()).appendHeaders(request.getOpcMeta()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-client-request-id", PutObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", PutObjectResponse.Builder::opcRequestId).handleResponseHeaderString("opc-content-md5", PutObjectResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-content-crc32c", PutObjectResponse.Builder::opcContentCrc32c).handleResponseHeaderString("opc-content-sha256", PutObjectResponse.Builder::opcContentSha256).handleResponseHeaderString("opc-content-sha384", PutObjectResponse.Builder::opcContentSha384).handleResponseHeaderString("ETag", PutObjectResponse.Builder::eTag).handleResponseHeaderDate("last-modified", PutObjectResponse.Builder::lastModified).handleResponseHeaderString("version-id", PutObjectResponse.Builder::versionId).callAsync(handler);
    }

    @Override
    public Future<PutObjectLifecyclePolicyResponse> putObjectLifecyclePolicy(PutObjectLifecyclePolicyRequest request, AsyncHandler<PutObjectLifecyclePolicyRequest, PutObjectLifecyclePolicyResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutObjectLifecyclePolicyDetails(), "putObjectLifecyclePolicyDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, PutObjectLifecyclePolicyResponse::builder).logger(LOG, "putObjectLifecyclePolicy").serviceDetails("ObjectStorage", "PutObjectLifecyclePolicy", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/ObjectLifecyclePolicy/PutObjectLifecyclePolicy").method(Method.PUT).requestBuilder(PutObjectLifecyclePolicyRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("l").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).hasBody().handleBody(ObjectLifecyclePolicy.class, PutObjectLifecyclePolicyResponse.Builder::objectLifecyclePolicy).handleResponseHeaderString("opc-request-id", PutObjectLifecyclePolicyResponse.Builder::opcRequestId).handleResponseHeaderString("opc-client-request-id", PutObjectLifecyclePolicyResponse.Builder::opcClientRequestId).handleResponseHeaderString("ETag", PutObjectLifecyclePolicyResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<ReencryptBucketResponse> reencryptBucket(ReencryptBucketRequest request, AsyncHandler<ReencryptBucketRequest, ReencryptBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ReencryptBucketResponse::builder).logger(LOG, "reencryptBucket").serviceDetails("ObjectStorage", "ReencryptBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/ReencryptBucket").method(Method.POST).requestBuilder(ReencryptBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("reencrypt").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).handleResponseHeaderString("opc-work-request-id", ReencryptBucketResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-client-request-id", ReencryptBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ReencryptBucketResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ReencryptObjectResponse> reencryptObject(ReencryptObjectRequest request, AsyncHandler<ReencryptObjectRequest, ReencryptObjectResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getReencryptObjectDetails(), "reencryptObjectDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, ReencryptObjectResponse::builder).logger(LOG, "reencryptObject").serviceDetails("ObjectStorage", "ReencryptObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/ReencryptObject").method(Method.POST).requestBuilder(ReencryptObjectRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("reencrypt").appendPathParam(request.getObjectName()).appendQueryParam("versionId", (Object)request.getVersionId()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-client-request-id", ReencryptObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", ReencryptObjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RenameObjectResponse> renameObject(RenameObjectRequest request, AsyncHandler<RenameObjectRequest, RenameObjectResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRenameObjectDetails(), "renameObjectDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, RenameObjectResponse::builder).logger(LOG, "renameObject").serviceDetails("ObjectStorage", "RenameObject", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/RenameObject").method(Method.POST).requestBuilder(RenameObjectRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("renameObject").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-client-request-id", RenameObjectResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", RenameObjectResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", RenameObjectResponse.Builder::eTag).handleResponseHeaderDate("last-modified", RenameObjectResponse.Builder::lastModified).handleResponseHeaderString("version-id", RenameObjectResponse.Builder::versionId).callAsync(handler);
    }

    @Override
    public Future<RestoreObjectsResponse> restoreObjects(RestoreObjectsRequest request, AsyncHandler<RestoreObjectsRequest, RestoreObjectsResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRestoreObjectsDetails(), "restoreObjectsDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, RestoreObjectsResponse::builder).logger(LOG, "restoreObjects").serviceDetails("ObjectStorage", "RestoreObjects", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/RestoreObjects").method(Method.POST).requestBuilder(RestoreObjectsRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("restoreObjects").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-client-request-id", RestoreObjectsResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", RestoreObjectsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateBucketResponse> updateBucket(UpdateBucketRequest request, AsyncHandler<UpdateBucketRequest, UpdateBucketResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBucketDetails(), "updateBucketDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UpdateBucketResponse::builder).logger(LOG, "updateBucket").serviceDetails("ObjectStorage", "UpdateBucket", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Bucket/UpdateBucket").method(Method.POST).requestBuilder(UpdateBucketRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(Bucket.class, UpdateBucketResponse.Builder::bucket).handleResponseHeaderString("opc-client-request-id", UpdateBucketResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UpdateBucketResponse.Builder::opcRequestId).handleResponseHeaderString("ETag", UpdateBucketResponse.Builder::eTag).callAsync(handler);
    }

    @Override
    public Future<UpdateNamespaceMetadataResponse> updateNamespaceMetadata(UpdateNamespaceMetadataRequest request, AsyncHandler<UpdateNamespaceMetadataRequest, UpdateNamespaceMetadataResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateNamespaceMetadataDetails(), "updateNamespaceMetadataDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UpdateNamespaceMetadataResponse::builder).logger(LOG, "updateNamespaceMetadata").serviceDetails("ObjectStorage", "UpdateNamespaceMetadata", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Namespace/UpdateNamespaceMetadata").method(Method.PUT).requestBuilder(UpdateNamespaceMetadataRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(NamespaceMetadata.class, UpdateNamespaceMetadataResponse.Builder::namespaceMetadata).handleResponseHeaderString("opc-client-request-id", UpdateNamespaceMetadataResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UpdateNamespaceMetadataResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateObjectStorageTierResponse> updateObjectStorageTier(UpdateObjectStorageTierRequest request, AsyncHandler<UpdateObjectStorageTierRequest, UpdateObjectStorageTierResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateObjectStorageTierDetails(), "updateObjectStorageTierDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UpdateObjectStorageTierResponse::builder).logger(LOG, "updateObjectStorageTier").serviceDetails("ObjectStorage", "UpdateObjectStorageTier", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/Object/UpdateObjectStorageTier").method(Method.POST).requestBuilder(UpdateObjectStorageTierRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("actions").appendPathParam("updateObjectStorageTier").accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleResponseHeaderString("opc-client-request-id", UpdateObjectStorageTierResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UpdateObjectStorageTierResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request, AsyncHandler<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPeName(), (String)"peName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePrivateEndpointDetails(), "updatePrivateEndpointDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("peName", request.getPeName());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UpdatePrivateEndpointResponse::builder).logger(LOG, "updatePrivateEndpoint").serviceDetails("ObjectStorage", "UpdatePrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/PrivateEndpoint/UpdatePrivateEndpoint").method(Method.POST).requestBuilder(UpdatePrivateEndpointRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("pe").appendPathParam(request.getPeName()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdatePrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-client-request-id", UpdatePrivateEndpointResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UpdatePrivateEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRetentionRuleResponse> updateRetentionRule(UpdateRetentionRuleRequest request, AsyncHandler<UpdateRetentionRuleRequest, UpdateRetentionRuleResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRetentionRuleId(), (String)"retentionRuleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRetentionRuleDetails(), "updateRetentionRuleDetails is required");
        HashMap<String, String> requiredParametersMap = new HashMap<String, String>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("retentionRuleId", request.getRetentionRuleId());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UpdateRetentionRuleResponse::builder).logger(LOG, "updateRetentionRule").serviceDetails("ObjectStorage", "UpdateRetentionRule", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/RetentionRule/UpdateRetentionRule").method(Method.PUT).requestBuilder(UpdateRetentionRuleRequest::builder).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("retentionRules").appendPathParam(request.getRetentionRuleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).hasBody().handleBody(RetentionRule.class, UpdateRetentionRuleResponse.Builder::retentionRule).handleResponseHeaderString("opc-client-request-id", UpdateRetentionRuleResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UpdateRetentionRuleResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateRetentionRuleResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<UploadPartResponse> uploadPart(UploadPartRequest request, AsyncHandler<UploadPartRequest, UploadPartResponse> handler) {
        Validate.notBlank((String)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBucketName(), (String)"bucketName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getObjectName(), (String)"objectName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUploadId(), "uploadId is required");
        Objects.requireNonNull(request.getUploadPartNum(), "uploadPartNum is required");
        Objects.requireNonNull(request.getUploadPartBody(), "uploadPartBody is required");
        HashMap<String, Object> requiredParametersMap = new HashMap<String, Object>();
        requiredParametersMap.put("namespaceName", request.getNamespaceName());
        requiredParametersMap.put("bucketName", request.getBucketName());
        requiredParametersMap.put("objectName", request.getObjectName());
        requiredParametersMap.put("uploadId", request.getUploadId());
        requiredParametersMap.put("uploadPartNum", request.getUploadPartNum());
        this.populateServiceParametersInEndpoint(this.getEndpoint(), requiredParametersMap);
        return this.clientCall(request, UploadPartResponse::builder).logger(LOG, "uploadPart").serviceDetails("ObjectStorage", "UploadPart", "https://docs.oracle.com/iaas/api/#/en/objectstorage/20160918/MultipartUpload/UploadPart").method(Method.PUT).requestBuilder(UploadPartRequest::builder).obmcsSigningStrategy(SigningStrategy.EXCLUDE_BODY).basePath("/").appendPathParam("n").appendPathParam(request.getNamespaceName()).appendPathParam("b").appendPathParam(request.getBucketName()).appendPathParam("u").appendPathParam(request.getObjectName()).appendQueryParam("uploadId", (Object)request.getUploadId()).appendQueryParam("uploadPartNum", (Object)request.getUploadPartNum()).accept(new String[]{"application/json"}).appendHeader("opc-client-request-id", request.getOpcClientRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("if-none-match", request.getIfNoneMatch()).appendHeader("Expect", request.getExpect()).appendHeader("Content-Length", (Number)request.getContentLength()).appendHeader("Content-MD5", request.getContentMD5()).appendEnumHeader("opc-checksum-algorithm", (BmcEnum)request.getOpcChecksumAlgorithm()).appendHeader("opc-content-crc32c", request.getOpcContentCrc32c()).appendHeader("opc-content-sha256", request.getOpcContentSha256()).appendHeader("opc-content-sha384", request.getOpcContentSha384()).appendHeader("opc-sse-customer-algorithm", request.getOpcSseCustomerAlgorithm()).appendHeader("opc-sse-customer-key", request.getOpcSseCustomerKey()).appendHeader("opc-sse-customer-key-sha256", request.getOpcSseCustomerKeySha256()).appendHeader("opc-sse-kms-key-id", request.getOpcSseKmsKeyId()).hasBinaryRequestBody().hasBody().handleResponseHeaderString("opc-client-request-id", UploadPartResponse.Builder::opcClientRequestId).handleResponseHeaderString("opc-request-id", UploadPartResponse.Builder::opcRequestId).handleResponseHeaderString("opc-content-md5", UploadPartResponse.Builder::opcContentMd5).handleResponseHeaderString("opc-content-crc32c", UploadPartResponse.Builder::opcContentCrc32c).handleResponseHeaderString("opc-content-sha256", UploadPartResponse.Builder::opcContentSha256).handleResponseHeaderString("opc-content-sha384", UploadPartResponse.Builder::opcContentSha384).handleResponseHeaderString("ETag", UploadPartResponse.Builder::eTag).callAsync(handler);
    }

    @Deprecated
    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ObjectStorageAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ObjectStorageAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ObjectStorageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ObjectStorageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ObjectStorageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ObjectStorageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ObjectStorageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ObjectStorageAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ObjectStorageAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "objectstorage";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"objectstorage");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public ObjectStorageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ObjectStorageAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

