/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.Transpiler;

public class APEXLangNumberDataType
implements APEXLangNumericDataType {
    private String data;
    private Double number;
    private String outputType;

    public APEXLangNumberDataType(String data, String outputType) {
        this.data = data;
        this.number = Double.parseDouble(data);
        this.outputType = outputType;
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        if (template == null) {
            return "";
        }
        if (this.outputType == null || this.outputType.equals("string")) {
            return Transpiler.replaceAllSafely(template, ":value", "'" + this.number + "'");
        }
        return Transpiler.replaceAllSafely(template, bindVariable, "" + this.number);
    }

    public String toString() {
        return this.data;
    }

    @Override
    public Number getNumber() {
        return this.number;
    }
}

