/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportColumn;
import com.oracle.premigration.reports.text.serialization.TextReportDisplayElement;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TextReportTable
extends TextReportField {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportTable.class.getName());
    private final Language lang = Language.getInstance();
    private List<TextReportColumn> columnList = new ArrayList<TextReportColumn>();
    private int currentRow = 0;
    private int numberOfRows = 0;

    public TextReportTable(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
        List<Map<String, String>> tableValues = this.getMapValues();
        Map<String, TextValueHint> valueHints = this.getMapHints();
        this.ingestValue(tableValues, valueHints);
    }

    @Override
    public void printText(TextReportSection section) {
        PrintWriter w = this.reportContext.getPrintWriter();
        int rowCount = 0;
        if (this.numberOfRows == 0) {
            return;
        }
        if (!this.getLabelKey().equals("<none>")) {
            w.println(section.getIndent() + this.lang.txt(this.getLabelKey()));
        }
        this.computeColumnWidths(section);
        w.print(section.getIndent());
        for (TextReportColumn textReportColumn : this.getColumnList()) {
            w.print(textReportColumn.getHeader());
        }
        w.println();
        w.print(section.getIndent());
        for (TextReportColumn textReportColumn : this.getColumnList()) {
            w.print(textReportColumn.getHeaderDecoration());
        }
        w.println();
        int numRowsToPrint = Math.min(this.numberOfRows, section.getMaxRelevantDataRows());
        while (rowCount < numRowsToPrint) {
            while (this.rowHasDataRemaining(this.currentRow)) {
                w.print(section.getIndent());
                for (TextReportColumn column : this.getColumnList()) {
                    TextReportDisplayElement displayElement = column.getValues().get(this.getCurrentRow());
                    boolean applyPadding = !column.isLast();
                    w.print(displayElement.getSomeText(column.getWidth(), applyPadding));
                    if (column.isLast()) continue;
                    w.print(" ");
                }
                w.println();
            }
            ++rowCount;
            ++this.currentRow;
        }
        if (rowCount < this.numberOfRows) {
            Integer n = this.numberOfRows - rowCount;
            w.println(section.getIndent() + this.lang.txt("CHECK_TABLE_ROWS_NOT_PRINTED", n));
        }
    }

    boolean rowHasDataRemaining(int row) {
        for (TextReportColumn column : this.columnList) {
            if (!column.hasDataRemaining(row)) continue;
            return true;
        }
        return false;
    }

    public List<Map<String, String>> getMapValues() {
        if (this.value == null) {
            return Collections.emptyList();
        }
        return (List)this.value;
    }

    public Map<String, TextValueHint> getMapHints() {
        return Collections.emptyMap();
    }

    public void ingestValue(List<Map<String, String>> tableValues, Map<String, TextValueHint> valueHints) {
        if (tableValues == null || tableValues.isEmpty()) {
            return;
        }
        Map<String, String> firstRow = tableValues.get(0);
        TextReportColumn trc = null;
        for (String string : firstRow.keySet()) {
            trc = new TextReportColumn(string);
            this.addColumn(trc);
        }
        if (trc != null) {
            trc.setLast(true);
        }
        for (Map map : tableValues) {
            ArrayList<TextReportDisplayElement> rowData = new ArrayList<TextReportDisplayElement>();
            for (Map.Entry entry : map.entrySet()) {
                TextValueHint valueHint = null;
                String header = (String)entry.getKey();
                if (valueHints != null && !valueHints.isEmpty()) {
                    valueHint = valueHints.get(header);
                }
                TextReportDisplayElement displayElement = new TextReportDisplayElement((String)map.get(header), valueHint);
                rowData.add(displayElement);
            }
            this.addRow(rowData);
        }
    }

    private void addColumn(TextReportColumn textReportColumn) {
        this.columnList.add(textReportColumn);
    }

    void addRow(List<TextReportDisplayElement> row) {
        if (row.size() != this.columnList.size()) {
            throw new IllegalArgumentException("row/column size mismatch attempting to add row to table");
        }
        for (int i = 0; i < row.size(); ++i) {
            this.columnList.get(i).addDisplayElement(row.get(i));
        }
        this.numberOfRows = this.columnList.get(0).getValues().size();
    }

    private void computeColumnWidths(TextReportSection section) {
        int reservedSpace;
        int spacesBetweenColumns = this.columnList.size() - 1;
        int totalWidth = reservedSpace = spacesBetweenColumns + section.getIndent().length();
        for (TextReportColumn reportColumn : this.columnList) {
            totalWidth += reportColumn.getWidestValue();
            reportColumn.setWidth(reportColumn.getWidestValue());
        }
        if (totalWidth <= this.reportContext.getReportWidth()) {
            return;
        }
        int availableSpace = this.reportContext.getReportWidth() - reservedSpace;
        int numColumns = this.getColumnList().size();
        int averageNeeded = availableSpace / numColumns;
        TextReportColumn neediestColumn = this.getColumnList().get(0);
        for (TextReportColumn reportColumn : this.columnList) {
            if (reportColumn.getWidestValue() > neediestColumn.getWidestValue()) {
                neediestColumn = reportColumn;
            }
            if (reportColumn.getWidth() > averageNeeded) {
                reportColumn.setWidth(averageNeeded);
            }
            availableSpace -= reportColumn.getWidth();
        }
        if (availableSpace > 0) {
            neediestColumn.setWidth(neediestColumn.getWidth() + availableSpace);
        }
    }

    public Language getLang() {
        return this.lang;
    }

    public List<TextReportColumn> getColumnList() {
        return this.columnList;
    }

    public int getCurrentRow() {
        return this.currentRow;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setColumnList(List<TextReportColumn> columnList) {
        this.columnList = columnList;
    }

    public void setCurrentRow(int currentRow) {
        this.currentRow = currentRow;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    @Override
    public String toString() {
        return "TextReportTable(lang=" + this.getLang() + ", columnList=" + this.getColumnList() + ", currentRow=" + this.getCurrentRow() + ", numberOfRows=" + this.getNumberOfRows() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportTable)) {
            return false;
        }
        TextReportTable other = (TextReportTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCurrentRow() != other.getCurrentRow()) {
            return false;
        }
        if (this.getNumberOfRows() != other.getNumberOfRows()) {
            return false;
        }
        Language this$lang = this.getLang();
        Language other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        List<TextReportColumn> this$columnList = this.getColumnList();
        List<TextReportColumn> other$columnList = other.getColumnList();
        return !(this$columnList == null ? other$columnList != null : !((Object)this$columnList).equals(other$columnList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportTable;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCurrentRow();
        result = result * 59 + this.getNumberOfRows();
        Language $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        List<TextReportColumn> $columnList = this.getColumnList();
        result = result * 59 + ($columnList == null ? 43 : ((Object)$columnList).hashCode());
        return result;
    }
}

