/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportDisplayElement;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

public final class TextReportLabeledValue
extends TextReportField {
    private final Language lang = Language.getInstance();
    private final String labelText = this.lang.txt(this.getLabelKey());
    private final int labelWidth = this.labelText != null ? this.labelText.length() : 0;
    private final TextReportDisplayElement displayElement = new TextReportDisplayElement(this.formatFieldAsString(), this.getValueHint());

    public TextReportLabeledValue(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
    }

    @Override
    public void printText(TextReportSection section) {
        if (this.getDisplayElement().getValueTypeHint() == TextValueHint.SQL_TEXT && this.getReportContext().isSqlExcluded()) {
            return;
        }
        PrintWriter w = this.reportContext.getPrintWriter();
        String indent = section.getIndent();
        int labelPadding = section.getWidestLabelWidth() + 1;
        String indentedPaddedLabel = section.getIndent() + Utilities.padRight(this.labelText, labelPadding);
        int spaceForValue = this.reportContext.getReportWidth() - indentedPaddedLabel.length();
        while (this.displayElement.hasDataRemaining()) {
            w.println(indentedPaddedLabel + this.displayElement.getSomeText(spaceForValue));
            indentedPaddedLabel = indent + Utilities.padRight("", labelPadding);
        }
    }

    private String formatFieldAsString() {
        if (this.value == null) {
            return "";
        }
        Class<?> clazz = this.value.getClass();
        if (clazz == String.class) {
            return (String)this.value;
        }
        if (clazz == Date.class) {
            return Utilities.getISODateTimeString(this.value);
        }
        if (clazz == Long.class && this.getValueHint() == TextValueHint.DURATION_SECONDS) {
            return Utilities.formatTimeInterval((Long)this.value * 1000L);
        }
        if (List.class.isAssignableFrom(clazz)) {
            ParameterizedType pType;
            Type typeArg;
            Type genericType = this.getField().getGenericType();
            if (genericType instanceof ParameterizedType && (typeArg = (pType = (ParameterizedType)genericType).getActualTypeArguments()[0]).toString().startsWith(String.class.getCanonicalName())) {
                return this.listToString((List)this.value);
            }
            return this.listToString((List)this.value);
        }
        return this.value.toString();
    }

    private String listToString(List<String> list) {
        return Utilities.join(", ", list);
    }

    public Language getLang() {
        return this.lang;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public TextReportDisplayElement getDisplayElement() {
        return this.displayElement;
    }

    @Override
    public String toString() {
        return "TextReportLabeledValue(lang=" + this.getLang() + ", labelText=" + this.getLabelText() + ", labelWidth=" + this.getLabelWidth() + ", displayElement=" + this.getDisplayElement() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportLabeledValue)) {
            return false;
        }
        TextReportLabeledValue other = (TextReportLabeledValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getLabelWidth() != other.getLabelWidth()) {
            return false;
        }
        Language this$lang = this.getLang();
        Language other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$labelText = this.getLabelText();
        String other$labelText = other.getLabelText();
        if (this$labelText == null ? other$labelText != null : !this$labelText.equals(other$labelText)) {
            return false;
        }
        TextReportDisplayElement this$displayElement = this.getDisplayElement();
        TextReportDisplayElement other$displayElement = other.getDisplayElement();
        return !(this$displayElement == null ? other$displayElement != null : !((Object)this$displayElement).equals(other$displayElement));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportLabeledValue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getLabelWidth();
        Language $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $labelText = this.getLabelText();
        result = result * 59 + ($labelText == null ? 43 : $labelText.hashCode());
        TextReportDisplayElement $displayElement = this.getDisplayElement();
        result = result * 59 + ($displayElement == null ? 43 : ((Object)$displayElement).hashCode());
        return result;
    }
}

