/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.pojos;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.helpers.Job;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStoreManager;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorePasswordInfo;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsole;
import java.util.List;
import java.util.logging.Level;

public abstract class KeystoreEntryAdder {
    protected static final Language lang = Language.getInstance();
    protected final KeyStorePasswordInfo passInfo;
    protected final List<Job> jobList;
    protected final KeyStoreManager keyStoreManager;
    protected final EnvironmentContext envCtx;

    public KeystoreEntryAdder(KeyStorePasswordInfo passInfo, List<Job> jobList, KeyStoreManager keyStoreManager, EnvironmentContext envCtx) {
        this.passInfo = passInfo;
        this.jobList = jobList;
        this.keyStoreManager = keyStoreManager;
        this.envCtx = envCtx;
    }

    public void addEntry() throws PremigrationException {
    }

    public String verifyUser() throws PremigrationException {
        String user = PasswordConsole.lookUpPasswordInfo(this.passInfo.getNameSpace().toUpperCase(), this.passInfo.getUser().toUpperCase());
        if (!" ".equalsIgnoreCase(user)) {
            Utilities.printAndLogErrorMessage(lang.txt("PWDP_DELETE_EXISTING_ALIAS", user), this.envCtx, Level.INFO);
            this.keyStoreManager.deleteAlias(PasswordConsole.getAlias(this.passInfo.getNameSpace(), user));
        }
        return user;
    }
}

