/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.dbinspector.checks.has_user_defined_objects;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_refs_to_user_objects_in_sys
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_refs_to_user_objects_in_sys.class.getName());

    public has_refs_to_user_objects_in_sys() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("NAME").objectTypeColumn("TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (exeCtx.hasOracleMaintained()) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "A.OWNER");
            String sqlQuery = "WITH USER_OBJECTS_IN_SYS AS   ( " + has_user_defined_objects.getQueryForUserObjects(Arrays.asList("SYS", "SYSTEM")) + "  ) SELECT A.OWNER, A.TYPE, A.NAME, A.REFERENCED_OWNER, A.REFERENCED_TYPE, A.REFERENCED_NAME   FROM SYS.DBA_DEPENDENCIES A, USER_OBJECTS_IN_SYS B " + whereClause + "  AND B.OWNER = A.REFERENCED_OWNER   AND B.OBJECT_NAME = A.REFERENCED_NAME UNION SELECT A.OWNER, 'SYNONYM' AS TYPE, SYNONYM_NAME AS NAME, A.TABLE_OWNER REFERENCED_OWNER, B.OBJECT_TYPE REFERENCED_TYPE, A.TABLE_NAME REFERENCED_NAME   FROM SYS.DBA_SYNONYMS A, USER_OBJECTS_IN_SYS B " + whereClause + "  AND A.TABLE_OWNER = B.OWNER   AND A.TABLE_NAME = B.OBJECT_NAME UNION ALL SELECT A.OWNER, A.TYPE, A.NAME, A.REFERENCED_OWNER, A.REFERENCED_TYPE, A.REFERENCED_NAME    FROM SYS.DBA_DEPENDENCIES A, SYS.DBA_SYNONYMS B, USER_OBJECTS_IN_SYS C " + whereClause + "  AND B.OWNER NOT IN ('SYS','SYSTEM','PUBLIC')   AND B.TABLE_OWNER IN ('SYS','SYSTEM')   AND B.OWNER = A.REFERENCED_OWNER   AND B.SYNONYM_NAME = A.REFERENCED_NAME   AND C.OWNER = B.TABLE_OWNER   AND C.OBJECT_NAME = B.TABLE_NAME ";
            this.setSqlQuery(sqlQuery);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "ORACLE_MAINTAINED", "COLUMN"));
        }
    }
}

