/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import java.io.IOException;
import java.util.Arrays;

public class has_csmig_schema
extends Check
implements Fixable {
    public has_csmig_schema() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery = "SELECT USERNAME, ACCOUNT_STATUS, CREATED FROM SYS.DBA_USERS WHERE USERNAME = 'CSMIG'";
        this.setSqlQuery("SELECT USERNAME, ACCOUNT_STATUS, CREATED FROM SYS.DBA_USERS WHERE USERNAME = 'CSMIG'");
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "remove_csmig";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("remove_csmig", locus, parentFolderPath).runAtCDBLevel(false).build();
        this.generateStaticFixup(fixupObject);
    }
}

