/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;
import java.util.List;

public abstract class gg_tables_not_supported
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(gg_tables_not_supported.class.getName());
    protected List<String> unsupportedModes;

    protected gg_tables_not_supported() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.MIGRATION_METHOD);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean isVersion12;
        boolean is19cOrHigher = Version.V19_1_0_0.compare(exeCtx.getDatabaseVersion()) <= 0;
        String baseQuery = is19cOrHigher ? "with GGSM as  (select unsupp.owner owner, unsupp.table_name object_name,    (    case       when (unsupp.gensby = 3) then      'NONE'     when (unsupp.gensby = 2) then      'PLSQL'     when (unsupp.gensby = 0) then      'ID KEY'     else 'FULL'    end    ) support_mode    from SYS.\"_DBA_OGG_ALL_TABLES\" unsupp,    sys.obj$ o,    sys.dba_users u,     sys.tab$ t    where o.owner# = u.user_id and o.obj# = t.obj# and o.name = unsupp.table_name and        u.username = unsupp.owner and unsupp.gensby != -1        /* These schemas are special to OGG */        and unsupp.owner not in            ('AURORA$JIS$UTILITY$',             'AURORA$ORB$UNAUTHENTICATED',             'DSSYS',             'OSE$HTTP$ADMIN',             'PERFSTAT',             'REPADMIN',             'TRACESVR',             'VECSYS',        /* exclude internal schemas from            system.logstdby$skip_support where action = 0 */             'ANONYMOUS',             'APPQOSSYS',             'AUDSYS',             'BI',             'CTXSYS',             'DBSFWUSER',             'DBSNMP',             'DIP',             'DMSYS',             'DVF',             'DVSYS',             'EXDSYS',             'EXFSYS',             'GGSYS',             'GSMADMIN_INTERNAL',             'GSMCATUSER',             'GSMROOTUSER',             'GSMUSER',             'LBACSYS',             'MDSYS',             'MGMT_VIEW',             'MTSSYS',             'ODM',             'ODM_MTR',             'OJVMSYS',             'OLAPSYS',             'ORACLE_OCM',             'ORDDATA',             'ORDPLUGINS',             'ORDSYS',             'OUTLN',             'REMOTE_SCHEDULER_AGENT',             'SI_INFORMTN_SCHEMA',             'SPATIAL_CSW_ADMIN',             'SPATIAL_CSW_ADMIN_USR',             'SPATIAL_WFS_ADMIN',             'SPATIAL_WFS_ADMIN_USR',             'SYS',             'SYS$UMF',             'SYSBACKUP',             'SYSDG',             'SYSKM',             'SYSMAN',             'SYSRAC',             'SYSTEM',             'TSMSYS',             'WKPROXY',             'WKSYS',             'WK_TEST',             'WMSYS',             'XDB',             'XS$NULL',             'XTISYS')        /* exclude internal tables */        and unsupp.table_name not like 'AQ$%'        and unsupp.table_name not like 'DR$%$%'        and unsupp.table_name not like 'M%_%$$'        and unsupp.table_name not like 'MLOG$%'        and unsupp.table_name not like 'OGGQT$%'        and unsupp.table_name not like 'OGG$%'        and unsupp.table_name not like 'RUPD$%'        and unsupp.table_name not like 'SYS_C%'        and unsupp.table_name not like 'MDR%_%$'        and unsupp.table_name not like 'SYS_IMPORT_TABLE%'        and unsupp.table_name not like 'ET$%'        and unsupp.table_name not like 'CMP%$%'        and unsupp.table_name not like 'DBMS_TABCOMP_TEMP_%'        and unsupp.table_name not like 'SCHEDULER$_%_ARG'        and unsupp.table_name not like 'MDXT_%$%'         and unsupp.table_name not like 'VECTOR$%'        /* Excluding DT$_ tables */        and unsupp.table_name not like 'DT$_%'        /* Exclude DM$ tables */       and t.obj# not in (select obj# from sys.modeltab$ where t.obj#=obj#)) SELECT GGSM.owner, GGSM.object_name, GGSM.support_mode  FROM GGSM" : "SELECT GGSM.OWNER, GGSM.OBJECT_NAME, GGSM.SUPPORT_MODE  FROM SYS.DBA_GOLDENGATE_SUPPORT_MODE GGSM";
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GGSM.OWNER");
        String supportModeClause = SqlUtils.createAndClause("SUPPORT_MODE", true, this.unsupportedModes);
        String sqlQuery = baseQuery + whereClause + supportModeClause;
        try {
            isVersion12 = Version.betweenInclusive(exeCtx.getDatabaseVersion(), Version.V12_1_0_1, Version.V12_2_0_2);
        }
        catch (Exception e) {
            log.severe("Exception calling Version.betweenInclusive with '" + exeCtx.getDatabaseVersion() + "'", e);
            isVersion12 = false;
        }
        if (isVersion12) {
            whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "DTC.OWNER");
            sqlQuery = sqlQuery + " UNION  SELECT DTC.OWNER, DTC.TABLE_NAME AS OBJECT_NAME, 'NONE' AS SUPPORT_MODE   FROM SYS.DBA_TAB_COLUMNS DTC " + whereClause + "   AND DTC.IDENTITY_COLUMN='YES'";
        }
        this.setSqlQuery(sqlQuery);
    }
}

