/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.tablespace;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DataFiles {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DataFiles.class.getName());
    @HtmlProperty(labelKey="SRC_DB_DF_FILE_NAME", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the database file.")
    private String fileName;
    @HtmlProperty(labelKey="SRC_DB_DF_FILE_ID", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Absolute file number of the database file .")
    private Integer fileId;
    @HtmlProperty(labelKey="SRC_DB_TBS_TABLESPACE_NAME", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the tablespace to which the file belongs.")
    private String tablespaceName;
    @HtmlProperty(labelKey="SRC_DB_DF_BYTES", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the file in GB.")
    private Double currentSizeGB;
    @HtmlProperty(labelKey="SRC_DB_DF_BLOCKS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the file in Oracle blocks.")
    private Double blocks;
    @HtmlProperty(labelKey="SRC_DB_DF_STATUS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="File status: AVAILABLE or INVALID (INVALID means that the file number is not in use, for example, a file in a tablespace that was dropped).")
    private String status;
    @HtmlProperty(labelKey="SRC_DB_DF_AUTO_EXTENSIBLE", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether data file is auto extensible.")
    private String autoExtensible;
    @HtmlProperty(labelKey="SRC_DB_DF_MAX_BYTES", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Maximum file size in bytes.")
    private Double maxBytes;
    @HtmlProperty(labelKey="SRC_DB_DF_MAX_BLOCKS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Maximum file size in blocks")
    private Double maxBlocks;
    @HtmlProperty(labelKey="SRC_DB_DF_INCREMENT_BY", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of Oracle blocks used as autoextension increment.")
    private Double incrementBy;
    @HtmlProperty(labelKey="SRC_DB_DF_USER_BYTES", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The size of the file available for user data. The actual size of the file minus the USER_BYTES value is used to store file related metadata.")
    private Double userBytes;
    @HtmlProperty(labelKey="SRC_DB_DF_USER_BLOCKS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of blocks which can be used by the data.")
    private Double userBlocks;
    @HtmlProperty(labelKey="SRC_DB_DF_ONLINE_STATUS", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Online status of the file.")
    private String onlineStatus;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DataFiles> getDataFiles(ExecutionContext exeCtx) throws SQLException {
        ArrayList<DataFiles> dataFiles = new ArrayList<DataFiles>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String dataFilesQuery = "SELECT   FILE_NAME,   FILE_ID,   TABLESPACE_NAME,   CASE     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 3)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 4) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 4)     ELSE ROUND(BYTES / 1024 / 1024 / 1024, 5)   END AS GBYTES,   BLOCKS,   STATUS,   AUTOEXTENSIBLE,   MAXBYTES,   MAXBLOCKS,   INCREMENT_BY,   USER_BYTES,   USER_BLOCKS,   ONLINE_STATUS FROM SYS.DBA_DATA_FILES";
        log.fine("Fetching data files details with query: SELECT   FILE_NAME,   FILE_ID,   TABLESPACE_NAME,   CASE     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 3)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 4) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 4)     ELSE ROUND(BYTES / 1024 / 1024 / 1024, 5)   END AS GBYTES,   BLOCKS,   STATUS,   AUTOEXTENSIBLE,   MAXBYTES,   MAXBLOCKS,   INCREMENT_BY,   USER_BYTES,   USER_BLOCKS,   ONLINE_STATUS FROM SYS.DBA_DATA_FILES");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   FILE_NAME,   FILE_ID,   TABLESPACE_NAME,   CASE     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 3)     WHEN ROUND(BYTES / 1024 / 1024 / 1024, 4) > 0 THEN ROUND(BYTES / 1024 / 1024 / 1024, 4)     ELSE ROUND(BYTES / 1024 / 1024 / 1024, 5)   END AS GBYTES,   BLOCKS,   STATUS,   AUTOEXTENSIBLE,   MAXBYTES,   MAXBLOCKS,   INCREMENT_BY,   USER_BYTES,   USER_BLOCKS,   ONLINE_STATUS FROM SYS.DBA_DATA_FILES");
            rs = stmt.executeQuery();
            while (rs.next()) {
                dataFiles.add(DataFiles.builder().fileName(rs.getString("FILE_NAME")).fileId(rs.getInt("FILE_ID")).tablespaceName(rs.getString("TABLESPACE_NAME")).currentSizeGB(rs.getDouble("GBYTES")).blocks(rs.getDouble("BLOCKS")).status(rs.getString("STATUS")).autoExtensible(rs.getString("AUTOEXTENSIBLE")).maxBytes(rs.getDouble("MAXBYTES")).maxBlocks(rs.getDouble("MAXBLOCKS")).incrementBy(rs.getDouble("INCREMENT_BY")).userBytes(rs.getDouble("USER_BYTES")).userBlocks(rs.getDouble("USER_BLOCKS")).onlineStatus(rs.getString("ONLINE_STATUS")).build());
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return dataFiles;
    }

    public static DataFilesBuilder builder() {
        return new DataFilesBuilder();
    }

    private DataFiles(String fileName, Integer fileId, String tablespaceName, Double currentSizeGB, Double blocks, String status, String autoExtensible, Double maxBytes, Double maxBlocks, Double incrementBy, Double userBytes, Double userBlocks, String onlineStatus) {
        this.fileName = fileName;
        this.fileId = fileId;
        this.tablespaceName = tablespaceName;
        this.currentSizeGB = currentSizeGB;
        this.blocks = blocks;
        this.status = status;
        this.autoExtensible = autoExtensible;
        this.maxBytes = maxBytes;
        this.maxBlocks = maxBlocks;
        this.incrementBy = incrementBy;
        this.userBytes = userBytes;
        this.userBlocks = userBlocks;
        this.onlineStatus = onlineStatus;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Integer getFileId() {
        return this.fileId;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public Double getCurrentSizeGB() {
        return this.currentSizeGB;
    }

    public Double getBlocks() {
        return this.blocks;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAutoExtensible() {
        return this.autoExtensible;
    }

    public Double getMaxBytes() {
        return this.maxBytes;
    }

    public Double getMaxBlocks() {
        return this.maxBlocks;
    }

    public Double getIncrementBy() {
        return this.incrementBy;
    }

    public Double getUserBytes() {
        return this.userBytes;
    }

    public Double getUserBlocks() {
        return this.userBlocks;
    }

    public String getOnlineStatus() {
        return this.onlineStatus;
    }

    public static class DataFilesBuilder {
        private String fileName;
        private Integer fileId;
        private String tablespaceName;
        private Double currentSizeGB;
        private Double blocks;
        private String status;
        private String autoExtensible;
        private Double maxBytes;
        private Double maxBlocks;
        private Double incrementBy;
        private Double userBytes;
        private Double userBlocks;
        private String onlineStatus;

        DataFilesBuilder() {
        }

        public DataFilesBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public DataFilesBuilder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public DataFilesBuilder tablespaceName(String tablespaceName) {
            this.tablespaceName = tablespaceName;
            return this;
        }

        public DataFilesBuilder currentSizeGB(Double currentSizeGB) {
            this.currentSizeGB = currentSizeGB;
            return this;
        }

        public DataFilesBuilder blocks(Double blocks) {
            this.blocks = blocks;
            return this;
        }

        public DataFilesBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DataFilesBuilder autoExtensible(String autoExtensible) {
            this.autoExtensible = autoExtensible;
            return this;
        }

        public DataFilesBuilder maxBytes(Double maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public DataFilesBuilder maxBlocks(Double maxBlocks) {
            this.maxBlocks = maxBlocks;
            return this;
        }

        public DataFilesBuilder incrementBy(Double incrementBy) {
            this.incrementBy = incrementBy;
            return this;
        }

        public DataFilesBuilder userBytes(Double userBytes) {
            this.userBytes = userBytes;
            return this;
        }

        public DataFilesBuilder userBlocks(Double userBlocks) {
            this.userBlocks = userBlocks;
            return this;
        }

        public DataFilesBuilder onlineStatus(String onlineStatus) {
            this.onlineStatus = onlineStatus;
            return this;
        }

        public DataFiles build() {
            return new DataFiles(this.fileName, this.fileId, this.tablespaceName, this.currentSizeGB, this.blocks, this.status, this.autoExtensible, this.maxBytes, this.maxBlocks, this.incrementBy, this.userBytes, this.userBlocks, this.onlineStatus);
        }

        public String toString() {
            return "DataFiles.DataFilesBuilder(fileName=" + this.fileName + ", fileId=" + this.fileId + ", tablespaceName=" + this.tablespaceName + ", currentSizeGB=" + this.currentSizeGB + ", blocks=" + this.blocks + ", status=" + this.status + ", autoExtensible=" + this.autoExtensible + ", maxBytes=" + this.maxBytes + ", maxBlocks=" + this.maxBlocks + ", incrementBy=" + this.incrementBy + ", userBytes=" + this.userBytes + ", userBlocks=" + this.userBlocks + ", onlineStatus=" + this.onlineStatus + ")";
        }
    }
}

