/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SecureFiles {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SecureFiles.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the secure file")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SEC_FILE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Whether the file is stored securely")
    private String secureFile;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_COMPRESSION", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The compression algorithm used for the file")
    private String compression;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_DEDUP", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Whether deduplication is enabled for the file")
    private String deduplication;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_ENCRYPT", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Whether encryption is enabled for the file")
    private String encrypt;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TOTAL", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of secure files")
    private long total;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SecureFiles> getSecureFileStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String query = "SELECT OWNER, SECUREFILE, COMPRESSION, DEDUPLICATION, ENCRYPT, COUNT(1) AS TOTAL  FROM DBA_LOBS " + whereClause + " GROUP BY OWNER, SECUREFILE, COMPRESSION, DEDUPLICATION, ENCRYPT  ORDER BY 1, 2, 3, 4, 5";
        log.fine("Fetching Secure Files stats with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SecureFiles> secureFileStats = new ArrayList<SecureFiles>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                SecureFiles secureFileStat = new SecureFiles(rs.getString("OWNER"), rs.getString("SECUREFILE"), rs.getString("COMPRESSION"), rs.getString("DEDUPLICATION"), rs.getString("ENCRYPT"), rs.getLong("TOTAL"));
                secureFileStats.add(secureFileStat);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return secureFileStats;
    }

    public static SecureFilesBuilder builder() {
        return new SecureFilesBuilder();
    }

    private SecureFiles(String owner, String secureFile, String compression, String deduplication, String encrypt, long total) {
        this.owner = owner;
        this.secureFile = secureFile;
        this.compression = compression;
        this.deduplication = deduplication;
        this.encrypt = encrypt;
        this.total = total;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSecureFile() {
        return this.secureFile;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getDeduplication() {
        return this.deduplication;
    }

    public String getEncrypt() {
        return this.encrypt;
    }

    public long getTotal() {
        return this.total;
    }

    public static class SecureFilesBuilder {
        private String owner;
        private String secureFile;
        private String compression;
        private String deduplication;
        private String encrypt;
        private long total;

        SecureFilesBuilder() {
        }

        public SecureFilesBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public SecureFilesBuilder secureFile(String secureFile) {
            this.secureFile = secureFile;
            return this;
        }

        public SecureFilesBuilder compression(String compression) {
            this.compression = compression;
            return this;
        }

        public SecureFilesBuilder deduplication(String deduplication) {
            this.deduplication = deduplication;
            return this;
        }

        public SecureFilesBuilder encrypt(String encrypt) {
            this.encrypt = encrypt;
            return this;
        }

        public SecureFilesBuilder total(long total) {
            this.total = total;
            return this;
        }

        public SecureFiles build() {
            return new SecureFiles(this.owner, this.secureFile, this.compression, this.deduplication, this.encrypt, this.total);
        }

        public String toString() {
            return "SecureFiles.SecureFilesBuilder(owner=" + this.owner + ", secureFile=" + this.secureFile + ", compression=" + this.compression + ", deduplication=" + this.deduplication + ", encrypt=" + this.encrypt + ", total=" + this.total + ")";
        }
    }
}

