/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Largest50Objects {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(Largest50Objects.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the object")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OBJECT", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the object")
    private String object;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TYPE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of the object")
    private String type;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_PART_NAME", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The partition name of the object")
    private String partitionName;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SIZE_GB", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The size of the object in gigabytes")
    private double sizeInGB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Largest50Objects> getLargest50Objects(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String query = "SELECT OWNER, OBJECT, TYPE, PARTITION_NAME, SIZE_IN_GB FROM (  SELECT OWNER, SEGMENT_NAME OBJECT, SEGMENT_TYPE TYPE, PARTITION_NAME, ROUND(BYTES/1073741824, 6) SIZE_IN_GB   FROM DBA_SEGMENTS " + whereClause + "    AND SEGMENT_TYPE NOT IN ('ROLLBACK', 'TYPE2 UNDO', 'INDEX')     AND SEGMENT_NAME NOT LIKE 'BIN$%'   GROUP BY OWNER, SEGMENT_NAME, SEGMENT_TYPE, PARTITION_NAME, BYTES   ORDER BY BYTES DESC ) WHERE ROWNUM <= 50";
        log.fine("Fetching Largest 50 Objects with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Largest50Objects> largest50Objects = new ArrayList<Largest50Objects>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Largest50Objects largest50Object = new Largest50Objects(rs.getString("OWNER"), rs.getString("OBJECT"), rs.getString("TYPE"), rs.getString("PARTITION_NAME"), rs.getDouble("SIZE_IN_GB"));
                largest50Objects.add(largest50Object);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return largest50Objects;
    }

    public static Largest50ObjectsBuilder builder() {
        return new Largest50ObjectsBuilder();
    }

    private Largest50Objects(String owner, String object, String type, String partitionName, double sizeInGB) {
        this.owner = owner;
        this.object = object;
        this.type = type;
        this.partitionName = partitionName;
        this.sizeInGB = sizeInGB;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getObject() {
        return this.object;
    }

    public String getType() {
        return this.type;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public double getSizeInGB() {
        return this.sizeInGB;
    }

    public static class Largest50ObjectsBuilder {
        private String owner;
        private String object;
        private String type;
        private String partitionName;
        private double sizeInGB;

        Largest50ObjectsBuilder() {
        }

        public Largest50ObjectsBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Largest50ObjectsBuilder object(String object) {
            this.object = object;
            return this;
        }

        public Largest50ObjectsBuilder type(String type) {
            this.type = type;
            return this;
        }

        public Largest50ObjectsBuilder partitionName(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        public Largest50ObjectsBuilder sizeInGB(double sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public Largest50Objects build() {
            return new Largest50Objects(this.owner, this.object, this.type, this.partitionName, this.sizeInGB);
        }

        public String toString() {
            return "Largest50Objects.Largest50ObjectsBuilder(owner=" + this.owner + ", object=" + this.object + ", type=" + this.type + ", partitionName=" + this.partitionName + ", sizeInGB=" + this.sizeInGB + ")";
        }
    }
}

