/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ColumnTypeDistribution {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(ColumnTypeDistribution.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the table")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_DATA_TYPE", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The data type of the column")
    private String dataType;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TOTAL", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The total number of columns with the specified data type")
    private long total;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnTypeDistribution> getColumnTypeDistributionStats(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String query = "SELECT OWNER, DATA_TYPE, COUNT(*) AS TOTAL FROM SYS.DBA_TAB_COLUMNS " + whereClause + " GROUP BY OWNER, DATA_TYPE  ORDER BY 1, 2";
        log.fine("Fetching Column Type Distribution with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<ColumnTypeDistribution> columnTypeDistributions = new ArrayList<ColumnTypeDistribution>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                ColumnTypeDistribution columnTypeDist = new ColumnTypeDistribution(rs.getString("OWNER"), rs.getString("DATA_TYPE"), rs.getLong("TOTAL"));
                columnTypeDistributions.add(columnTypeDist);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return columnTypeDistributions;
    }

    public static ColumnTypeDistributionBuilder builder() {
        return new ColumnTypeDistributionBuilder();
    }

    private ColumnTypeDistribution(String owner, String dataType, long total) {
        this.owner = owner;
        this.dataType = dataType;
        this.total = total;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getDataType() {
        return this.dataType;
    }

    public long getTotal() {
        return this.total;
    }

    public static class ColumnTypeDistributionBuilder {
        private String owner;
        private String dataType;
        private long total;

        ColumnTypeDistributionBuilder() {
        }

        public ColumnTypeDistributionBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public ColumnTypeDistributionBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public ColumnTypeDistributionBuilder total(long total) {
            this.total = total;
            return this;
        }

        public ColumnTypeDistribution build() {
            return new ColumnTypeDistribution(this.owner, this.dataType, this.total);
        }

        public String toString() {
            return "ColumnTypeDistribution.ColumnTypeDistributionBuilder(owner=" + this.owner + ", dataType=" + this.dataType + ", total=" + this.total + ")";
        }
    }
}

