/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.redo;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class RedoLogs {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoLogs.class.getName());
    @HtmlProperty(labelKey="SRC_LOGS_GROUP_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log group number.")
    private Integer groupNumber;
    @HtmlProperty(labelKey="SRC_LOGS_THREAD_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log thread number.")
    private Integer threadNumber;
    @HtmlProperty(labelKey="SRC_LOGS_SEQ_NUM", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Log sequence number.")
    private Integer sequenceNumber;
    @HtmlProperty(labelKey="SRC_LOGS_BYTES", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Size of the log (in MB).")
    private Double logSizeInMB;
    @HtmlProperty(labelKey="SRC_REDO_LOGS_BLOCK_SIZE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Block size of the log file.")
    private Integer blockSize;
    @HtmlProperty(labelKey="SRC_REDO_LOGS_MEMBERS", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Number of members in the log group.")
    private Integer members;
    @HtmlProperty(labelKey="SRC_LOGS_ARCHIVED", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Identifies whether the log is archived.")
    private String archived;
    @HtmlProperty(labelKey="SRC_LOGS_STATUS", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Identified the status of the log.")
    private String status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RedoLogs> getRedoLogs(ExecutionContext exeCtx) throws SQLException {
        ArrayList<RedoLogs> redoLogs = new ArrayList<RedoLogs>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String redoLogsQuery = "SELECT   GROUP#,   THREAD#,   SEQUENCE#,   CASE     WHEN ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   BLOCKSIZE,   MEMBERS,   ARCHIVED,   STATUS FROM V$LOG ORDER BY 1, 2, 3, 4";
        log.fine("Fetching redo log details with query: SELECT   GROUP#,   THREAD#,   SEQUENCE#,   CASE     WHEN ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   BLOCKSIZE,   MEMBERS,   ARCHIVED,   STATUS FROM V$LOG ORDER BY 1, 2, 3, 4");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT   GROUP#,   THREAD#,   SEQUENCE#,   CASE     WHEN ROUND(BYTES / 1024 / 1024, 1) > 0 THEN ROUND(BYTES / 1024 / 1024, 1)     WHEN ROUND(BYTES / 1024 / 1024, 2) > 0 THEN ROUND(BYTES / 1024 / 1024, 2)     WHEN ROUND(BYTES / 1024 / 1024, 3) > 0 THEN ROUND(BYTES / 1024 / 1024, 3)     ELSE ROUND(BYTES / 1024 / 1024, 4)   END AS MBYTES,   BLOCKSIZE,   MEMBERS,   ARCHIVED,   STATUS FROM V$LOG ORDER BY 1, 2, 3, 4");
            rs = stmt.executeQuery();
            while (rs.next()) {
                redoLogs.add(RedoLogs.builder().threadNumber(rs.getInt("THREAD#")).groupNumber(rs.getInt("GROUP#")).sequenceNumber(rs.getInt("SEQUENCE#")).logSizeInMB(rs.getDouble("MBYTES")).blockSize(rs.getInt("BLOCKSIZE")).members(rs.getInt("MEMBERS")).archived(rs.getString("ARCHIVED")).status(rs.getString("STATUS")).build());
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return redoLogs;
    }

    public static RedoLogs createEmptyRedoLogsInstance() {
        return new RedoLogs(0, 0, 0, 0.0, 0, 0, "", "");
    }

    public static RedoLogsBuilder builder() {
        return new RedoLogsBuilder();
    }

    private RedoLogs(Integer groupNumber, Integer threadNumber, Integer sequenceNumber, Double logSizeInMB, Integer blockSize, Integer members, String archived, String status) {
        this.groupNumber = groupNumber;
        this.threadNumber = threadNumber;
        this.sequenceNumber = sequenceNumber;
        this.logSizeInMB = logSizeInMB;
        this.blockSize = blockSize;
        this.members = members;
        this.archived = archived;
        this.status = status;
    }

    public Integer getGroupNumber() {
        return this.groupNumber;
    }

    public Integer getThreadNumber() {
        return this.threadNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public Double getLogSizeInMB() {
        return this.logSizeInMB;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public Integer getMembers() {
        return this.members;
    }

    public String getArchived() {
        return this.archived;
    }

    public String getStatus() {
        return this.status;
    }

    public static class RedoLogsBuilder {
        private Integer groupNumber;
        private Integer threadNumber;
        private Integer sequenceNumber;
        private Double logSizeInMB;
        private Integer blockSize;
        private Integer members;
        private String archived;
        private String status;

        RedoLogsBuilder() {
        }

        public RedoLogsBuilder groupNumber(Integer groupNumber) {
            this.groupNumber = groupNumber;
            return this;
        }

        public RedoLogsBuilder threadNumber(Integer threadNumber) {
            this.threadNumber = threadNumber;
            return this;
        }

        public RedoLogsBuilder sequenceNumber(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public RedoLogsBuilder logSizeInMB(Double logSizeInMB) {
            this.logSizeInMB = logSizeInMB;
            return this;
        }

        public RedoLogsBuilder blockSize(Integer blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public RedoLogsBuilder members(Integer members) {
            this.members = members;
            return this;
        }

        public RedoLogsBuilder archived(String archived) {
            this.archived = archived;
            return this;
        }

        public RedoLogsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public RedoLogs build() {
            return new RedoLogs(this.groupNumber, this.threadNumber, this.sequenceNumber, this.logSizeInMB, this.blockSize, this.members, this.archived, this.status);
        }

        public String toString() {
            return "RedoLogs.RedoLogsBuilder(groupNumber=" + this.groupNumber + ", threadNumber=" + this.threadNumber + ", sequenceNumber=" + this.sequenceNumber + ", logSizeInMB=" + this.logSizeInMB + ", blockSize=" + this.blockSize + ", members=" + this.members + ", archived=" + this.archived + ", status=" + this.status + ")";
        }
    }
}

