/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SupplementalLogging {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SupplementalLogging.class.getName());
    @HtmlProperty(labelKey="SRC_DB_LOGGING_MIN_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Minimum supplemental logging data.")
    private String supplementalLogDataMin;
    @HtmlProperty(labelKey="SRC_DB_LOGGING_PK_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Primary key supplemental logging data.")
    private String supplementalLogDataPK;
    @HtmlProperty(labelKey="SRC_DB_LOGGING_UK_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Unique index supplemental logging data.")
    private String supplementalLogDataUI;
    @HtmlProperty(labelKey="SRC_DB_LOGGING_FK_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Foreign key supplemental logging data.")
    private String supplementalLogDataFK;
    @HtmlProperty(labelKey="SRC_DB_LOGGING_ALL_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="All supplemental logging data.")
    private String supplementalLogDataAll;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SupplementalLogging getSupplementalLoggingSettings(ExecutionContext exeCtx) throws SQLException {
        String query = "SELECT SUPPLEMENTAL_LOG_DATA_MIN, SUPPLEMENTAL_LOG_DATA_PK, SUPPLEMENTAL_LOG_DATA_UI, SUPPLEMENTAL_LOG_DATA_FK, SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE";
        log.fine("Fetching Supplemental Logging data with query: SELECT SUPPLEMENTAL_LOG_DATA_MIN, SUPPLEMENTAL_LOG_DATA_PK, SUPPLEMENTAL_LOG_DATA_UI, SUPPLEMENTAL_LOG_DATA_FK, SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SupplementalLogging supplementalLogging = null;
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT SUPPLEMENTAL_LOG_DATA_MIN, SUPPLEMENTAL_LOG_DATA_PK, SUPPLEMENTAL_LOG_DATA_UI, SUPPLEMENTAL_LOG_DATA_FK, SUPPLEMENTAL_LOG_DATA_ALL FROM V$DATABASE");
            rs = stmt.executeQuery();
            if (rs.next()) {
                supplementalLogging = SupplementalLogging.builder().supplementalLogDataMin(rs.getString("SUPPLEMENTAL_LOG_DATA_MIN")).supplementalLogDataPK(rs.getString("SUPPLEMENTAL_LOG_DATA_PK")).supplementalLogDataUI(rs.getString("SUPPLEMENTAL_LOG_DATA_UI")).supplementalLogDataFK(rs.getString("SUPPLEMENTAL_LOG_DATA_FK")).supplementalLogDataAll(rs.getString("SUPPLEMENTAL_LOG_DATA_ALL")).build();
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return supplementalLogging;
    }

    public static SupplementalLoggingBuilder builder() {
        return new SupplementalLoggingBuilder();
    }

    private SupplementalLogging(String supplementalLogDataMin, String supplementalLogDataPK, String supplementalLogDataUI, String supplementalLogDataFK, String supplementalLogDataAll) {
        this.supplementalLogDataMin = supplementalLogDataMin;
        this.supplementalLogDataPK = supplementalLogDataPK;
        this.supplementalLogDataUI = supplementalLogDataUI;
        this.supplementalLogDataFK = supplementalLogDataFK;
        this.supplementalLogDataAll = supplementalLogDataAll;
    }

    public String getSupplementalLogDataMin() {
        return this.supplementalLogDataMin;
    }

    public String getSupplementalLogDataPK() {
        return this.supplementalLogDataPK;
    }

    public String getSupplementalLogDataUI() {
        return this.supplementalLogDataUI;
    }

    public String getSupplementalLogDataFK() {
        return this.supplementalLogDataFK;
    }

    public String getSupplementalLogDataAll() {
        return this.supplementalLogDataAll;
    }

    public static class SupplementalLoggingBuilder {
        private String supplementalLogDataMin;
        private String supplementalLogDataPK;
        private String supplementalLogDataUI;
        private String supplementalLogDataFK;
        private String supplementalLogDataAll;

        SupplementalLoggingBuilder() {
        }

        public SupplementalLoggingBuilder supplementalLogDataMin(String supplementalLogDataMin) {
            this.supplementalLogDataMin = supplementalLogDataMin;
            return this;
        }

        public SupplementalLoggingBuilder supplementalLogDataPK(String supplementalLogDataPK) {
            this.supplementalLogDataPK = supplementalLogDataPK;
            return this;
        }

        public SupplementalLoggingBuilder supplementalLogDataUI(String supplementalLogDataUI) {
            this.supplementalLogDataUI = supplementalLogDataUI;
            return this;
        }

        public SupplementalLoggingBuilder supplementalLogDataFK(String supplementalLogDataFK) {
            this.supplementalLogDataFK = supplementalLogDataFK;
            return this;
        }

        public SupplementalLoggingBuilder supplementalLogDataAll(String supplementalLogDataAll) {
            this.supplementalLogDataAll = supplementalLogDataAll;
            return this;
        }

        public SupplementalLogging build() {
            return new SupplementalLogging(this.supplementalLogDataMin, this.supplementalLogDataPK, this.supplementalLogDataUI, this.supplementalLogDataFK, this.supplementalLogDataAll);
        }

        public String toString() {
            return "SupplementalLogging.SupplementalLoggingBuilder(supplementalLogDataMin=" + this.supplementalLogDataMin + ", supplementalLogDataPK=" + this.supplementalLogDataPK + ", supplementalLogDataUI=" + this.supplementalLogDataUI + ", supplementalLogDataFK=" + this.supplementalLogDataFK + ", supplementalLogDataAll=" + this.supplementalLogDataAll + ")";
        }
    }
}

