/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class InstanceState {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(InstanceState.class.getName());
    @HtmlProperty(labelKey="SRC_IS_INSTANCE_NUM", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Unique identifier for the instance.")
    private Long instanceNumber;
    @HtmlProperty(labelKey="SRC_IS_INSTANCE_NAME", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the instance.")
    private String instanceName;
    @HtmlProperty(labelKey="SRC_IS_HOST_NAME", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Hostname where the instance is running.")
    private String hostName;
    @HtmlProperty(labelKey="SRC_IS_VERSION", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Version of the database software.")
    private String version;
    @HtmlProperty(labelKey="SRC_IS_VERSIONFULL", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Full version string of the database software (available in Oracle 12c and later).")
    private String versionFull;
    @HtmlProperty(labelKey="SRC_IS_STARTUP_TIME", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The date-time the instance was started in ISO_DATE_TIME format. e.g. 2025-02-28T17:00:00Z")
    private Date startupTime;
    @HtmlProperty(labelKey="SRC_IS_STATUS", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Current status of the instance (e.g. 'OPEN', 'MOUNTED', etc.).")
    private String status;
    @HtmlProperty(labelKey="SRC_IS_THREAD_NUMBER", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Thread number assigned to the instance.")
    private Long threadNumber;
    @HtmlProperty(labelKey="SRC_IS_INSTANCE_ROLE", section=HtmlReportSectionName.SRC_NLS_PARAMETERS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Role of the instance (e.g. 'PRIMARY', 'STANDBY', etc.).")
    private String instanceRole;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<InstanceState> getInstanceState(ExecutionContext exeCtx) throws SQLException {
        ArrayList<InstanceState> instanceStateList = new ArrayList<InstanceState>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String versionFullColumn = exeCtx.hasVInstanceVersionFull() ? ", VERSION_FULL" : ", NULL AS VERSION_FULL";
        String instanceStateQuery = "SELECT INSTANCE_NUMBER, INSTANCE_NAME, HOST_NAME, STARTUP_TIME, STATUS,  THREAD#, INSTANCE_ROLE, VERSION" + versionFullColumn + " FROM GV$INSTANCE  ORDER BY INSTANCE_NUMBER";
        log.fine("Fetching Instance State with query: " + instanceStateQuery);
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, instanceStateQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long instanceNumber = rs.getLong("INSTANCE_NUMBER");
                String instanceName = rs.getString("INSTANCE_NAME");
                String hostName = rs.getString("HOST_NAME");
                String version = rs.getString("VERSION");
                String versionFull = rs.getString("VERSION_FULL");
                java.sql.Date startupTime = rs.getDate("STARTUP_TIME");
                String status = rs.getString("STATUS");
                Long threadNumber = rs.getLong("THREAD#");
                String instanceRole = rs.getString("INSTANCE_ROLE");
                InstanceState instanceState = InstanceState.builder().instanceNumber(instanceNumber).instanceName(instanceName).hostName(hostName).version(version).versionFull(versionFull).startupTime(startupTime).status(status).threadNumber(threadNumber).instanceRole(instanceRole).build();
                instanceStateList.add(instanceState);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return instanceStateList;
    }

    public static InstanceStateBuilder builder() {
        return new InstanceStateBuilder();
    }

    private InstanceState(Long instanceNumber, String instanceName, String hostName, String version, String versionFull, Date startupTime, String status, Long threadNumber, String instanceRole) {
        this.instanceNumber = instanceNumber;
        this.instanceName = instanceName;
        this.hostName = hostName;
        this.version = version;
        this.versionFull = versionFull;
        this.startupTime = startupTime;
        this.status = status;
        this.threadNumber = threadNumber;
        this.instanceRole = instanceRole;
    }

    public Long getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionFull() {
        return this.versionFull;
    }

    public Date getStartupTime() {
        return this.startupTime;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getThreadNumber() {
        return this.threadNumber;
    }

    public String getInstanceRole() {
        return this.instanceRole;
    }

    public static class InstanceStateBuilder {
        private Long instanceNumber;
        private String instanceName;
        private String hostName;
        private String version;
        private String versionFull;
        private Date startupTime;
        private String status;
        private Long threadNumber;
        private String instanceRole;

        InstanceStateBuilder() {
        }

        public InstanceStateBuilder instanceNumber(Long instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public InstanceStateBuilder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public InstanceStateBuilder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public InstanceStateBuilder version(String version) {
            this.version = version;
            return this;
        }

        public InstanceStateBuilder versionFull(String versionFull) {
            this.versionFull = versionFull;
            return this;
        }

        public InstanceStateBuilder startupTime(Date startupTime) {
            this.startupTime = startupTime;
            return this;
        }

        public InstanceStateBuilder status(String status) {
            this.status = status;
            return this;
        }

        public InstanceStateBuilder threadNumber(Long threadNumber) {
            this.threadNumber = threadNumber;
            return this;
        }

        public InstanceStateBuilder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public InstanceState build() {
            return new InstanceState(this.instanceNumber, this.instanceName, this.hostName, this.version, this.versionFull, this.startupTime, this.status, this.threadNumber, this.instanceRole);
        }

        public String toString() {
            return "InstanceState.InstanceStateBuilder(instanceNumber=" + this.instanceNumber + ", instanceName=" + this.instanceName + ", hostName=" + this.hostName + ", version=" + this.version + ", versionFull=" + this.versionFull + ", startupTime=" + this.startupTime + ", status=" + this.status + ", threadNumber=" + this.threadNumber + ", instanceRole=" + this.instanceRole + ")";
        }
    }
}

