/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseParameter {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DatabaseParameter.class.getName());
    @HtmlProperty(labelKey="SRC_DB_PARAM_NAME", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the database parameter.")
    private String name;
    @HtmlProperty(labelKey="SRC_DB_PARAM_TYPE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The type of the database parameter.")
    private int type;
    @HtmlProperty(labelKey="SRC_DB_PARAM_VALUE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The value of the database parameter.")
    private String value;
    @HtmlProperty(labelKey="SRC_DB_PARAM_ISDEFAULT", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the parameter is set to its default value.")
    private String isDefault;
    @HtmlProperty(labelKey="SRC_DB_PARAM_ISMODIFIED", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the parameter has been modified.")
    private String isModified;
    @HtmlProperty(labelKey="SRC_DB_PARAM_ISDEPRECATED", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Indicates whether the parameter is deprecated.")
    private String isDeprecated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DatabaseParameter> getDatabaseParameters(ExecutionContext exeCtx) throws SQLException {
        ArrayList<DatabaseParameter> databaseParameters = new ArrayList<DatabaseParameter>();
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String dbParamQuery = "SELECT NAME, TYPE, NVL(VALUE, '(null)') AS VALUE, ISDEFAULT, ISMODIFIED, NVL(ISDEPRECATED, 'FALSE') AS ISDEPRECATED FROM V$PARAMETER ORDER BY NAME";
        log.fine("Fetching Database Parameters with query: SELECT NAME, TYPE, NVL(VALUE, '(null)') AS VALUE, ISDEFAULT, ISMODIFIED, NVL(ISDEPRECATED, 'FALSE') AS ISDEPRECATED FROM V$PARAMETER ORDER BY NAME");
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT NAME, TYPE, NVL(VALUE, '(null)') AS VALUE, ISDEFAULT, ISMODIFIED, NVL(ISDEPRECATED, 'FALSE') AS ISDEPRECATED FROM V$PARAMETER ORDER BY NAME");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String name = rs.getString("NAME");
                int type = rs.getInt("TYPE");
                String value = rs.getString("VALUE");
                String isDefault = rs.getString("ISDEFAULT");
                String isModified = rs.getString("ISMODIFIED");
                String isDeprecated = rs.getString("ISDEPRECATED");
                DatabaseParameter databaseParameter = DatabaseParameter.builder().name(name).type(type).value(value).isDefault(isDefault).isModified(isModified).isDeprecated(isDeprecated).build();
                databaseParameters.add(databaseParameter);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return databaseParameters;
    }

    public static DatabaseParameterBuilder builder() {
        return new DatabaseParameterBuilder();
    }

    private DatabaseParameter(String name, int type, String value, String isDefault, String isModified, String isDeprecated) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.isDefault = isDefault;
        this.isModified = isModified;
        this.isDeprecated = isDeprecated;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getIsDefault() {
        return this.isDefault;
    }

    public String getIsModified() {
        return this.isModified;
    }

    public String getIsDeprecated() {
        return this.isDeprecated;
    }

    public static class DatabaseParameterBuilder {
        private String name;
        private int type;
        private String value;
        private String isDefault;
        private String isModified;
        private String isDeprecated;

        DatabaseParameterBuilder() {
        }

        public DatabaseParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseParameterBuilder type(int type) {
            this.type = type;
            return this;
        }

        public DatabaseParameterBuilder value(String value) {
            this.value = value;
            return this;
        }

        public DatabaseParameterBuilder isDefault(String isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public DatabaseParameterBuilder isModified(String isModified) {
            this.isModified = isModified;
            return this;
        }

        public DatabaseParameterBuilder isDeprecated(String isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public DatabaseParameter build() {
            return new DatabaseParameter(this.name, this.type, this.value, this.isDefault, this.isModified, this.isDeprecated);
        }

        public String toString() {
            return "DatabaseParameter.DatabaseParameterBuilder(name=" + this.name + ", type=" + this.type + ", value=" + this.value + ", isDefault=" + this.isDefault + ", isModified=" + this.isModified + ", isDeprecated=" + this.isDeprecated + ")";
        }
    }
}

