/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.dbsize;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class DatabaseSizeDetails {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DatabaseSizeDetails.class.getName());
    @TextProperty(labelKey="SRC_DB_SIZE_0_BLOCK_SIZE_KB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_0_BLOCK_SIZE_KB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The source database block size in KB")
    private final long dbBlockSizeKB;
    @TextProperty(labelKey="SRC_DB_SIZE_1_TOTAL_SIZE_GB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_1_TOTAL_SIZE_GB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Combined amount of DATA, TEMP, LOG, and CONTROL file usage in GB")
    private final double dbTotalSizeGB;
    @TextProperty(labelKey="SRC_DB_SIZE_2_DATA_SIZE_GB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_2_DATA_SIZE_GB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The amount of DATA file usage in GB")
    private final double dbDataSizeGB;
    @TextProperty(labelKey="SRC_DB_SIZE_3_TEMP_SIZE_GB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_3_TEMP_SIZE_GB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The amount of TEMP file usage in GB")
    private final double dbTempSizeGB;
    @TextProperty(labelKey="SRC_DB_SIZE_4_LOG_SIZE_GB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_4_LOG_SIZE_GB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The amount of LOG file usage in GB")
    private final double dbLogSizeGB;
    @TextProperty(labelKey="SRC_DB_SIZE_5_CONTROL_SIZE_GB_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="SRC_DB_SIZE_5_CONTROL_SIZE_GB_LABEL", section=HtmlReportSectionName.SRC_DATABASE_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The amount of CONTROL file usage in GB")
    private final double dbControlSizeGB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatabaseSizeDetails getDatabaseSizeDetails(ExecutionContext exeCtx) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block2: {
            DatabaseSizeDetails databaseSizeDetails;
            String dbSizeQuery = "WITH  DB_BLOCK AS (SELECT VALUE BYTES FROM V$SYSTEM_PARAMETER2 WHERE NAME = 'db_block_size'),  DATA AS (SELECT SUM(BYTES) BYTES FROM V$DATAFILE),  TEMP AS (SELECT SUM(BYTES) BYTES FROM V$TEMPFILE),  LOG AS (SELECT SUM(BYTES) * MAX(MEMBERS) BYTES FROM V$LOG),  CONTROL AS (SELECT SUM(BLOCK_SIZE * FILE_SIZE_BLKS) BYTES FROM V$CONTROLFILE) SELECT DB_BLOCK.BYTES / POWER(2,10) AS DB_BLOCK_SIZE_KB,         NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES + TEMP.BYTES + LOG.BYTES + CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TOTAL_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_DATA_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((TEMP.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TEMP_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((LOG.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_LOG_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_CONTROL_SIZE_GB FROM DB_BLOCK, DATA, TEMP, LOG, CONTROL";
            conn = null;
            stmt = null;
            rs = null;
            try {
                log.fine("Fetching database size details with query: WITH  DB_BLOCK AS (SELECT VALUE BYTES FROM V$SYSTEM_PARAMETER2 WHERE NAME = 'db_block_size'),  DATA AS (SELECT SUM(BYTES) BYTES FROM V$DATAFILE),  TEMP AS (SELECT SUM(BYTES) BYTES FROM V$TEMPFILE),  LOG AS (SELECT SUM(BYTES) * MAX(MEMBERS) BYTES FROM V$LOG),  CONTROL AS (SELECT SUM(BLOCK_SIZE * FILE_SIZE_BLKS) BYTES FROM V$CONTROLFILE) SELECT DB_BLOCK.BYTES / POWER(2,10) AS DB_BLOCK_SIZE_KB,         NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES + TEMP.BYTES + LOG.BYTES + CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TOTAL_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_DATA_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((TEMP.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TEMP_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((LOG.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_LOG_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_CONTROL_SIZE_GB FROM DB_BLOCK, DATA, TEMP, LOG, CONTROL");
                conn = exeCtx.getConnection();
                stmt = SqlUtils.createPreparedStatement(conn, "WITH  DB_BLOCK AS (SELECT VALUE BYTES FROM V$SYSTEM_PARAMETER2 WHERE NAME = 'db_block_size'),  DATA AS (SELECT SUM(BYTES) BYTES FROM V$DATAFILE),  TEMP AS (SELECT SUM(BYTES) BYTES FROM V$TEMPFILE),  LOG AS (SELECT SUM(BYTES) * MAX(MEMBERS) BYTES FROM V$LOG),  CONTROL AS (SELECT SUM(BLOCK_SIZE * FILE_SIZE_BLKS) BYTES FROM V$CONTROLFILE) SELECT DB_BLOCK.BYTES / POWER(2,10) AS DB_BLOCK_SIZE_KB,         NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES + TEMP.BYTES + LOG.BYTES + CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TOTAL_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((DATA.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_DATA_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((TEMP.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_TEMP_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((LOG.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_LOG_SIZE_GB,        NVL(TRIM(TO_CHAR(ROUND((CONTROL.BYTES) / POWER(2,30), 3), 'FM999999990.000')), '0') AS DB_CONTROL_SIZE_GB FROM DB_BLOCK, DATA, TEMP, LOG, CONTROL");
                rs = stmt.executeQuery();
                if (!rs.next()) break block2;
                DatabaseSizeDetailsBuilder dbSizeDetailsBuilder = DatabaseSizeDetails.builder();
                dbSizeDetailsBuilder.dbBlockSizeKB(rs.getLong("DB_BLOCK_SIZE_KB")).dbTotalSizeGB(rs.getDouble("DB_TOTAL_SIZE_GB")).dbDataSizeGB(rs.getDouble("DB_DATA_SIZE_GB")).dbTempSizeGB(rs.getDouble("DB_TEMP_SIZE_GB")).dbLogSizeGB(rs.getDouble("DB_LOG_SIZE_GB")).dbControlSizeGB(rs.getDouble("DB_CONTROL_SIZE_GB"));
                databaseSizeDetails = dbSizeDetailsBuilder.build();
            }
            catch (Throwable throwable) {
                exeCtx.closeIfNotNull(rs, stmt, conn);
                throw throwable;
            }
            exeCtx.closeIfNotNull(rs, stmt, conn);
            return databaseSizeDetails;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return null;
    }

    DatabaseSizeDetails(long dbBlockSizeKB, double dbTotalSizeGB, double dbDataSizeGB, double dbTempSizeGB, double dbLogSizeGB, double dbControlSizeGB) {
        this.dbBlockSizeKB = dbBlockSizeKB;
        this.dbTotalSizeGB = dbTotalSizeGB;
        this.dbDataSizeGB = dbDataSizeGB;
        this.dbTempSizeGB = dbTempSizeGB;
        this.dbLogSizeGB = dbLogSizeGB;
        this.dbControlSizeGB = dbControlSizeGB;
    }

    private static DatabaseSizeDetailsBuilder builder() {
        return new DatabaseSizeDetailsBuilder();
    }

    public long getDbBlockSizeKB() {
        return this.dbBlockSizeKB;
    }

    public double getDbTotalSizeGB() {
        return this.dbTotalSizeGB;
    }

    public double getDbDataSizeGB() {
        return this.dbDataSizeGB;
    }

    public double getDbTempSizeGB() {
        return this.dbTempSizeGB;
    }

    public double getDbLogSizeGB() {
        return this.dbLogSizeGB;
    }

    public double getDbControlSizeGB() {
        return this.dbControlSizeGB;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseSizeDetails)) {
            return false;
        }
        DatabaseSizeDetails other = (DatabaseSizeDetails)o;
        if (this.getDbBlockSizeKB() != other.getDbBlockSizeKB()) {
            return false;
        }
        if (Double.compare(this.getDbTotalSizeGB(), other.getDbTotalSizeGB()) != 0) {
            return false;
        }
        if (Double.compare(this.getDbDataSizeGB(), other.getDbDataSizeGB()) != 0) {
            return false;
        }
        if (Double.compare(this.getDbTempSizeGB(), other.getDbTempSizeGB()) != 0) {
            return false;
        }
        if (Double.compare(this.getDbLogSizeGB(), other.getDbLogSizeGB()) != 0) {
            return false;
        }
        return Double.compare(this.getDbControlSizeGB(), other.getDbControlSizeGB()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dbBlockSizeKB = this.getDbBlockSizeKB();
        result = result * 59 + (int)($dbBlockSizeKB >>> 32 ^ $dbBlockSizeKB);
        long $dbTotalSizeGB = Double.doubleToLongBits(this.getDbTotalSizeGB());
        result = result * 59 + (int)($dbTotalSizeGB >>> 32 ^ $dbTotalSizeGB);
        long $dbDataSizeGB = Double.doubleToLongBits(this.getDbDataSizeGB());
        result = result * 59 + (int)($dbDataSizeGB >>> 32 ^ $dbDataSizeGB);
        long $dbTempSizeGB = Double.doubleToLongBits(this.getDbTempSizeGB());
        result = result * 59 + (int)($dbTempSizeGB >>> 32 ^ $dbTempSizeGB);
        long $dbLogSizeGB = Double.doubleToLongBits(this.getDbLogSizeGB());
        result = result * 59 + (int)($dbLogSizeGB >>> 32 ^ $dbLogSizeGB);
        long $dbControlSizeGB = Double.doubleToLongBits(this.getDbControlSizeGB());
        result = result * 59 + (int)($dbControlSizeGB >>> 32 ^ $dbControlSizeGB);
        return result;
    }

    public String toString() {
        return "DatabaseSizeDetails(dbBlockSizeKB=" + this.getDbBlockSizeKB() + ", dbTotalSizeGB=" + this.getDbTotalSizeGB() + ", dbDataSizeGB=" + this.getDbDataSizeGB() + ", dbTempSizeGB=" + this.getDbTempSizeGB() + ", dbLogSizeGB=" + this.getDbLogSizeGB() + ", dbControlSizeGB=" + this.getDbControlSizeGB() + ")";
    }

    private static class DatabaseSizeDetailsBuilder {
        private long dbBlockSizeKB;
        private double dbTotalSizeGB;
        private double dbDataSizeGB;
        private double dbTempSizeGB;
        private double dbLogSizeGB;
        private double dbControlSizeGB;

        DatabaseSizeDetailsBuilder() {
        }

        private DatabaseSizeDetailsBuilder dbBlockSizeKB(long dbBlockSizeKB) {
            this.dbBlockSizeKB = dbBlockSizeKB;
            return this;
        }

        private DatabaseSizeDetailsBuilder dbTotalSizeGB(double dbTotalSizeGB) {
            this.dbTotalSizeGB = dbTotalSizeGB;
            return this;
        }

        private DatabaseSizeDetailsBuilder dbDataSizeGB(double dbDataSizeGB) {
            this.dbDataSizeGB = dbDataSizeGB;
            return this;
        }

        private DatabaseSizeDetailsBuilder dbTempSizeGB(double dbTempSizeGB) {
            this.dbTempSizeGB = dbTempSizeGB;
            return this;
        }

        private DatabaseSizeDetailsBuilder dbLogSizeGB(double dbLogSizeGB) {
            this.dbLogSizeGB = dbLogSizeGB;
            return this;
        }

        private DatabaseSizeDetailsBuilder dbControlSizeGB(double dbControlSizeGB) {
            this.dbControlSizeGB = dbControlSizeGB;
            return this;
        }

        private DatabaseSizeDetails build() {
            return new DatabaseSizeDetails(this.dbBlockSizeKB, this.dbTotalSizeGB, this.dbDataSizeGB, this.dbTempSizeGB, this.dbLogSizeGB, this.dbControlSizeGB);
        }

        public String toString() {
            return "DatabaseSizeDetails.DatabaseSizeDetailsBuilder(dbBlockSizeKB=" + this.dbBlockSizeKB + ", dbTotalSizeGB=" + this.dbTotalSizeGB + ", dbDataSizeGB=" + this.dbDataSizeGB + ", dbTempSizeGB=" + this.dbTempSizeGB + ", dbLogSizeGB=" + this.dbLogSizeGB + ", dbControlSizeGB=" + this.dbControlSizeGB + ")";
        }
    }
}

