/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonPreferNullOverEmpty;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.SQLException;

public abstract class CloudService {
    @CpatJsonPropertyDescription(value="Name of the cloud provider where the source database is located.")
    private String cloudVendor;
    @CpatJsonPreferNullOverEmpty
    @CpatJsonPropertyDescription(value="The name of the service or what the vendor refers to as the source database.")
    private String serviceType;
    @CpatJsonIgnore
    private QueryType queryType;
    @CpatJsonIgnore
    private String code;

    public abstract void prepare();

    public boolean determineResult(ExecutionContext exeCtx) throws SQLException {
        String result = this.getQueryType().getResult(this.getCode(), exeCtx);
        return result != null && !result.isEmpty() && "Y".equalsIgnoreCase(result);
    }

    public String toString() {
        return this.cloudVendor + " (" + this.serviceType + ")";
    }

    public String getCloudVendor() {
        return this.cloudVendor;
    }

    public void setCloudVendor(String cloudVendor) {
        this.cloudVendor = cloudVendor;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @CpatJsonPreferNullOverEmpty
    public String getServiceType() {
        return this.serviceType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    @CpatJsonIgnore
    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @CpatJsonIgnore
    public String getCode() {
        return this.code;
    }

    public static enum QueryType {
        SINGLE_QUERY{

            @Override
            public String getResult(String code, ExecutionContext exeCtx) throws SQLException {
                return SqlUtils.getSingleString(code, exeCtx);
            }
        }
        ,
        PLSQL_CODE{

            @Override
            public String getResult(String code, ExecutionContext exeCtx) throws SQLException {
                return SqlUtils.getSingleStringPlSql(code, exeCtx);
            }
        };


        public abstract String getResult(String var1, ExecutionContext var2) throws SQLException;
    }
}

