/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public final class Throwables {
    public static boolean use16ThrowableSuppression = false;
    private static final Field causeField = AccessController.doPrivileged(new PrivilegedAction<Field>(){

        @Override
        public Field run() {
            Field causeField;
            try {
                causeField = Throwable.class.getDeclaredField("cause");
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            causeField.setAccessible(true);
            return causeField;
        }
    });
    private static final Method addSuppressedMethod = AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            Method m;
            try {
                m = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
            }
            catch (NoSuchMethodException ex) {
                m = null;
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (m != null) {
                m.setAccessible(true);
            }
            return m;
        }
    });
    private static final Method getSuppressedMethod = addSuppressedMethod == null ? null : AccessController.doPrivileged(new PrivilegedAction<Method>(){

        @Override
        public Method run() {
            Method m;
            try {
                m = Throwable.class.getDeclaredMethod("getSuppressed", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                m = null;
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
            if (m != null) {
                m.setAccessible(true);
            }
            return m;
        }
    });

    public static <T extends Throwable> T addSuppressed(T t, Throwable suppressed) {
        try {
            if (addSuppressedMethod == null || use16ThrowableSuppression) {
                Throwable cause = t.getCause();
                if (cause instanceof SuppressedList) {
                    ((SuppressedList)cause).add(suppressed);
                    return t;
                }
                SuppressedList newCause = new SuppressedList(cause, new Throwable[]{suppressed});
                Throwables.setCause(t, newCause);
                return t;
            }
            addSuppressedMethod.invoke(t, suppressed);
            return t;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Throwable[] getSuppressed(Throwable t) {
        try {
            if (getSuppressedMethod == null || use16ThrowableSuppression) {
                Throwable[] suppressed = (Throwable[])getSuppressedMethod.invoke((Object)t, new Object[0]);
                return suppressed;
            }
            Throwable cause = t;
            LinkedList<Throwable> suppressedList = new LinkedList<Throwable>();
            while (cause != null) {
                if (!((cause = cause.getCause()) instanceof SuppressedList)) continue;
                suppressedList.addAll(((SuppressedList)cause).getList());
            }
            return suppressedList.toArray(new Throwable[suppressedList.size()]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setCause(final Throwable rc, final Throwable cause) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        causeField.set(rc, cause);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    return null;
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Throwables() {
    }

    private static class SuppressedList
    extends Throwable {
        private static final long serialVersionUID = -5571935211817704505L;
        private final List<Throwable> suppressed = new LinkedList<Throwable>();

        private SuppressedList(Throwable cause, Throwable ... suppressed) {
            super(cause);
            this.suppressed.addAll(Arrays.asList(suppressed));
        }

        public final void add(Throwable suppressed) {
            this.suppressed.add(suppressed);
        }

        public final List<Throwable> getList() {
            return this.suppressed;
        }
    }
}

