/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.retry;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.retry.ExponentialBackoff;
import oracle.cloudstorage.api.retry.IDelayProvider;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryState;
import oracle.cloudstorage.text.Marker;
import oracle.cloudstorage.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDelayedRetry
implements IRetryStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDelayedRetry.class);
    public static int UNLIMITED = -1;
    private static final ScheduledExecutorService delayer = Executors.newSingleThreadScheduledExecutor();
    private IDelayProvider delayProvider = new ExponentialBackoff();
    private long maxElapsedMillis = -1L;
    private int maxAttempts = -1;
    private int maxEvaluations = -1;
    private static final Runnable noop = new Runnable(){

        @Override
        public void run() {
        }
    };

    @Override
    public RetryState reset() {
        return new RetryState();
    }

    protected abstract boolean isOk(Status var1);

    protected abstract boolean isRetryable(IRequestBuilder var1, Status var2, Throwable var3);

    public void modifyContextBeforeRetry() {
    }

    @Override
    public IRetryStrategy.Cue onResponse(IRequestBuilder builder, int rawHttpStatusCode, Throwable throwable, RetryState retryState) throws InterruptedException {
        Status status = Status.fromStatusCode(rawHttpStatusCode);
        if (this.isOk(status)) {
            return IRetryStrategy.Cue.success;
        }
        long remainingTime = retryState.getRemainingElapsedMillis(this.getMaxElapsedMillis());
        if (remainingTime <= 0L) {
            return IRetryStrategy.Cue.none;
        }
        long remainingAttempts = retryState.getRemainingAttempts(this.getMaxAttempts(), this.getMaxEvaluations());
        if (remainingAttempts <= 0L) {
            return IRetryStrategy.Cue.none;
        }
        if (this.isRetryable(builder, status, throwable)) {
            this.modifyContextBeforeRetry();
            this.delay(retryState);
            retryState.incrementAttempt();
            return IRetryStrategy.Cue.retry;
        }
        return IRetryStrategy.Cue.none;
    }

    public void setMaxElapsedTime(long maxElapsedTime, TimeUnit units) {
        this.maxElapsedMillis = units.toMillis(maxElapsedTime);
    }

    protected long getMaxElapsedMillis() {
        return this.maxElapsedMillis;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    protected int getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    protected int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public void setDelayProvider(IDelayProvider delayProvider) {
        this.delayProvider = delayProvider == null ? IDelayProvider.DEFAULT : delayProvider;
    }

    protected final long getDelayMillis(RetryState retryState) {
        return this.delayProvider.getDelayMillis(retryState);
    }

    protected final void delay(RetryState retryState) throws InterruptedException {
        long delay = this.getDelayMillis(retryState);
        logger.debug(Marker.retry.marker, "Delaying {} ms.  {} of {}.", new Object[]{delay, retryState, this});
        ScheduledFuture<?> future = delayer.schedule(noop, delay, TimeUnit.MILLISECONDS);
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        logger.debug(Marker.retry.marker, "Delayed {} ms.  {} of {}.", new Object[]{delay, retryState, this});
    }

    public String toString() {
        String s = this.getClass().getSimpleName() + "@" + Strings.identity(this) + " with " + (this.delayProvider == null ? " no backoff algorithm " : this.delayProvider.toString());
        return s;
    }
}

