/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.put;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.dlo.DynamicLargeObjectConfig;
import oracle.cloudstorage.api.put.ArchiveFormat;
import oracle.cloudstorage.api.put.IExtractArchiveReply;
import oracle.cloudstorage.api.put.IPutContainerReply;
import oracle.cloudstorage.api.put.IPutObjectReply;
import oracle.cloudstorage.api.put.IPutRequestBuilder;
import oracle.cloudstorage.api.put.IPutRequestProcessor;
import oracle.cloudstorage.api.request.Method;
import oracle.cloudstorage.api.request.builder.AbstractRequestBuilder;
import oracle.cloudstorage.api.request.processor.Content;
import oracle.cloudstorage.api.request.processor.IContent;
import oracle.cloudstorage.api.request.processor.ReaderContent;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.stripe.StripeSegmentConfig;

public class PutRequestBuilder
extends AbstractRequestBuilder<IPutRequestBuilder, IPutRequestProcessor>
implements IPutRequestBuilder {
    private StripeSegmentConfig stripeSegmentConfig = null;
    private DynamicLargeObjectConfig dynamicLargeObjectConfig = null;
    private int chunkSize = -1;
    private boolean skipCryptography;
    private boolean expect100ContinueEnabled = true;
    private IContent content = null;

    public PutRequestBuilder(IRequestBuilder that) {
        super(that, Method.put);
    }

    @Override
    public StripeSegmentConfig getStripeSegmentConfig() {
        return this.stripeSegmentConfig;
    }

    @Override
    public DynamicLargeObjectConfig getDynamicLargeObjectConfig() {
        return this.dynamicLargeObjectConfig;
    }

    @Override
    protected IContent getContent() {
        return this.content;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize == -1 ? this.getSession().getChunk() : this.chunkSize;
    }

    @Override
    public boolean skipCryptography() {
        return this.skipCryptography;
    }

    @Override
    public RetryStrategy root(ISession session, IPutRequestProcessor processor) {
        this.createContext(session, processor);
        return new RetryStrategy();
    }

    @Override
    public boolean isExpect100ContinueEnabled() {
        return this.expect100ContinueEnabled;
    }

    private class ObjectData
    implements IPutRequestBuilder.ObjectData {
        private ObjectData() {
        }

        @Override
        public IPutRequestBuilder.Data data(String data) {
            return this.data(new StringReader(data));
        }

        @Override
        public IPutRequestBuilder.Data data(Reader data) {
            PutRequestBuilder.this.content = new ReaderContent(data, Charset.defaultCharset(), 1024);
            return new IPutRequestBuilder.Data(){

                @Override
                public IPutObjectReply send() throws RetryException, InterruptedException {
                    IPutObjectReply reply = ((IPutRequestProcessor)PutRequestBuilder.this.getProcessor()).object();
                    return reply;
                }
            };
        }

        @Override
        public IPutRequestBuilder.Data data(InputStream data) {
            PutRequestBuilder.this.content = new Content(data, PutRequestBuilder.this.getBufferSize());
            return new IPutRequestBuilder.Data(){

                @Override
                public IPutObjectReply send() throws RetryException, InterruptedException {
                    IPutObjectReply reply = ((IPutRequestProcessor)PutRequestBuilder.this.getProcessor()).object();
                    return reply;
                }
            };
        }
    }

    private class Expect
    extends ObjectData
    implements IPutRequestBuilder.Expect {
        private Expect() {
        }

        @Override
        public IPutRequestBuilder.ObjectData enableExpect100Continue(boolean enableExpect100Continue) {
            PutRequestBuilder.this.expect100ContinueEnabled = enableExpect100Continue;
            return new ObjectData();
        }
    }

    private class SegmentPrefix
    extends Expect
    implements IPutRequestBuilder.SegmentPrefix {
        private SegmentPrefix() {
        }

        @Override
        public IPutRequestBuilder.Expect prefix(String dynamicLargeObjectSegmentPrefix) {
            PutRequestBuilder.this.dynamicLargeObjectConfig.setSegmentPrefix(dynamicLargeObjectSegmentPrefix);
            return new Expect();
        }
    }

    private class SegmentContainer
    extends SegmentPrefix
    implements IPutRequestBuilder.SegmentContainer {
        private SegmentContainer() {
        }

        @Override
        public IPutRequestBuilder.SegmentPrefix container(String dynamicLargeObjectSegmentContainer) {
            PutRequestBuilder.this.dynamicLargeObjectConfig.setSegmentContainer(dynamicLargeObjectSegmentContainer);
            return new SegmentPrefix();
        }
    }

    private class Buffer
    extends Expect
    implements IPutRequestBuilder.Buffer {
        private Buffer() {
        }

        @Override
        public IPutRequestBuilder.Expect buffer(int bytesPerStripeSegment) {
            if (PutRequestBuilder.this.stripeSegmentConfig != null) {
                PutRequestBuilder.this.stripeSegmentConfig.setBufferSize(bytesPerStripeSegment);
            }
            return new Expect();
        }
    }

    private class Segments
    extends Buffer
    implements IPutRequestBuilder.Segments {
        private Segments() {
        }

        @Override
        public IPutRequestBuilder.Buffer segments(int numberOfStripeSegmentsPerStripe) {
            if (PutRequestBuilder.this.stripeSegmentConfig != null) {
                PutRequestBuilder.this.stripeSegmentConfig.setCount(numberOfStripeSegmentsPerStripe);
            }
            return new Buffer();
        }
    }

    private class Width
    extends Segments
    implements IPutRequestBuilder.Width {
        private Width() {
        }

        @Override
        public IPutRequestBuilder.Segments width(int bytesPerStripeSegment) {
            if (PutRequestBuilder.this.stripeSegmentConfig != null) {
                PutRequestBuilder.this.stripeSegmentConfig.setWidth(bytesPerStripeSegment);
            }
            return new Segments();
        }
    }

    private class Encrypt
    extends Width
    implements IPutRequestBuilder.Encrypt {
        private Encrypt() {
        }

        @Override
        public IPutRequestBuilder.Width stripe(boolean stripe) {
            if (stripe) {
                PutRequestBuilder.this.stripeSegmentConfig = new StripeSegmentConfig();
            }
            return new Width();
        }

        @Override
        public IPutRequestBuilder.Width stripe() {
            return this.stripe(true);
        }

        @Override
        public IPutRequestBuilder.SegmentContainer segment(int dynamicLargeObjectSegmentSize) {
            PutRequestBuilder.this.dynamicLargeObjectConfig = new DynamicLargeObjectConfig(dynamicLargeObjectSegmentSize);
            return new SegmentContainer();
        }
    }

    private class Object
    extends Expect
    implements IPutRequestBuilder.Object {
        private Object() {
        }

        @Override
        public Encrypt encrypt(boolean encrypt) {
            if (encrypt) {
                PutRequestBuilder.this.getSession().validateCipher();
            }
            PutRequestBuilder.this.skipCryptography = !encrypt;
            return new Encrypt();
        }

        @Override
        public Encrypt encrypt() {
            return this.encrypt(true);
        }

        @Override
        public IPutRequestBuilder.Width stripe(boolean stripe) {
            if (stripe) {
                PutRequestBuilder.this.stripeSegmentConfig = new StripeSegmentConfig();
            }
            return new Width();
        }

        @Override
        public IPutRequestBuilder.Width stripe() {
            return this.stripe(true);
        }

        @Override
        public SegmentContainer segment(int dynamicLargeObjectSegmentSize) {
            PutRequestBuilder.this.dynamicLargeObjectConfig = new DynamicLargeObjectConfig(dynamicLargeObjectSegmentSize);
            return new SegmentContainer();
        }

        @Override
        public Archive extract(File archive) throws FileNotFoundException {
            return new Extract().extract(archive);
        }

        @Override
        public Archive extract(InputStream data, ArchiveFormat format) {
            return new Extract().extract(data, format);
        }
    }

    private class Container
    extends Extract
    implements IPutRequestBuilder.Container {
        private Container() {
        }

        @Override
        public IPutRequestBuilder.Object object(String objectId) {
            PutRequestBuilder.this.setObjectId(objectId);
            return new Object();
        }

        @Override
        public IPutContainerReply send() throws RetryException {
            IPutContainerReply reply = ((IPutRequestProcessor)PutRequestBuilder.this.getProcessor()).container();
            return reply;
        }
    }

    private class Account
    extends Extract
    implements IPutRequestBuilder.Account {
        private Account() {
        }

        @Override
        public Container container(String containerId) {
            PutRequestBuilder.this.setContainerId(containerId);
            return new Container();
        }
    }

    private class Extract
    implements IPutRequestBuilder.Extract {
        private Extract() {
        }

        @Override
        public Archive extract(File archive) throws FileNotFoundException {
            ArchiveFormat format = ArchiveFormat.from(archive);
            FileInputStream inputStream = new FileInputStream(archive);
            return this.extract(inputStream, format);
        }

        @Override
        public Archive extract(InputStream data, ArchiveFormat format) {
            PutRequestBuilder.this.content = new Content(data, PutRequestBuilder.this.getBufferSize());
            PutRequestBuilder.this.getQueryParams().put(oracle.cloudstorage.api.queryparam.QueryParam.extractArchive.provide(new java.lang.Object[]{format}));
            return new Archive();
        }
    }

    private class Archive
    implements IPutRequestBuilder.Archive {
        private Archive() {
        }

        @Override
        public IExtractArchiveReply send() throws RetryException {
            return ((IPutRequestProcessor)PutRequestBuilder.this.getProcessor()).archive();
        }
    }

    private class QueryParam
    extends Account
    implements IPutRequestBuilder.QueryParam {
        private QueryParam() {
        }

        @Override
        public QueryParam param(Iterable<? extends Map.Entry<?, ?>> paramProvider) {
            PutRequestBuilder.this.getQueryParams().put(paramProvider);
            return this;
        }

        @Override
        public Account account(String accountId) {
            PutRequestBuilder.this.setAccountId(accountId);
            return new Account();
        }
    }

    private class Header
    extends QueryParam
    implements IPutRequestBuilder.Header {
        private Header() {
        }

        @Override
        public Header header(Iterable<Map.Entry<String, String>> headerProvider) {
            PutRequestBuilder.this.addHeaders(headerProvider);
            return this;
        }
    }

    private class TransferBuffer
    extends Header
    implements IPutRequestBuilder.TransferBuffer {
        private TransferBuffer() {
        }

        @Override
        public IPutRequestBuilder.Header buffer(int bufferByteArraySize) {
            PutRequestBuilder.this.setBufferSize(bufferByteArraySize);
            return new Header();
        }
    }

    private class Chunk
    extends TransferBuffer
    implements IPutRequestBuilder.Chunk {
        private Chunk() {
        }

        @Override
        public IPutRequestBuilder.TransferBuffer chunk() {
            return this.chunk(true);
        }

        @Override
        public IPutRequestBuilder.TransferBuffer chunk(boolean chunk) {
            int chunkSize = chunk ? 0 : -2;
            return this.chunk(chunkSize);
        }

        @Override
        public IPutRequestBuilder.TransferBuffer chunk(int bytesPerChunk) {
            PutRequestBuilder.this.chunkSize = bytesPerChunk;
            return new TransferBuffer();
        }
    }

    private class ReadTimeout
    extends Chunk
    implements IPutRequestBuilder.ReadTimeout {
        private ReadTimeout() {
        }

        @Override
        public IPutRequestBuilder.Chunk read(long timeout, TimeUnit units) {
            PutRequestBuilder.this.setReadTimeout(units.toMillis(timeout));
            return new Chunk();
        }
    }

    private class ConnectTimeout
    extends ReadTimeout
    implements IPutRequestBuilder.ConnectTimeout {
        private ConnectTimeout() {
        }

        @Override
        public IPutRequestBuilder.ReadTimeout connect(long timeout, TimeUnit units) {
            PutRequestBuilder.this.setConnectTimeout(units.toMillis(timeout));
            return new ReadTimeout();
        }
    }

    private class RetryStrategy
    extends ConnectTimeout
    implements IPutRequestBuilder.RetryStrategy {
        private RetryStrategy() {
        }

        @Override
        public ConnectTimeout retry(IRetryStrategy retryStrategy) {
            PutRequestBuilder.this.setRetryStrategy(retryStrategy);
            return new ConnectTimeout();
        }
    }
}

