/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.updateconfiguration;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.rcvconf.Action;
import oracle.dbtools.extension.rcv.models.rcvconf.LogArchiveDestinationGroupAction;
import oracle.dbtools.extension.rcv.models.rcvconf.Phase;
import oracle.dbtools.extension.rcv.models.rcvconf.RcvConf;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;

public class UpdateLogArchiveDestinationsStep
implements Step {
    private Connection conn;
    private String dbUniqueName;
    private ProtectedDatabaseCache cache;
    private RcvConf rcvConf;
    private LogArchiveConfig currentLogArchiveConfig;
    private WorkflowLogger logger;

    public UpdateLogArchiveDestinationsStep(Connection conn, WorkflowLogger logger) {
        this.conn = conn;
        this.dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        this.rcvConf = ConfigurationManager.getRcvConf(this.dbUniqueName);
        this.cache = RCVCommandBase.getProtectedDatabaseCache(this.dbUniqueName);
        this.logger = logger;
    }

    public LogArchiveConfig getCurrentLogArchiveConfig() {
        if (this.currentLogArchiveConfig == null) {
            this.currentLogArchiveConfig = LogArchiveConfig.getCurrentLogArchiveConfig(this.conn);
        }
        return this.currentLogArchiveConfig;
    }

    @Override
    public Result run() {
        if (this.cache.getOcid() != null && (this.rcvConf.getPhase().equals((Object)Phase.MIGRATE) || this.rcvConf.getPhase().equals((Object)Phase.MIGRATION_CLEANUP))) {
            RecoveryClientManager recoveryClientManager = new RecoveryClientManager(this.cache.getEndpoint(), this.logger.getLogger());
            ProtectedDatabase protectedDatabase = recoveryClientManager.getProtectedDatabase(this.cache.getOcid());
            if (protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                Result updateLogArchiveConfigResult;
                Optional<LogArchiveConfig> newLogArchiveConfig = this.getUpdatedLogArchiveConfig();
                if (newLogArchiveConfig.isPresent() && (updateLogArchiveConfigResult = this.updateLogArchiveConfig(newLogArchiveConfig.get())).getStatus().equals((Object)Status.FAILED)) {
                    return updateLogArchiveConfigResult;
                }
                return this.updateLogArchiveDestinations();
            }
            return new Result(Status.SKIPPED);
        }
        return new Result(Status.SKIPPED);
    }

    public Optional<LogArchiveConfig> getUpdatedLogArchiveConfig() {
        Optional<Action<String>> actionOptional = this.rcvConf.getActions().getLogArchiveConfigAction();
        if (actionOptional.isPresent()) {
            Action<String> action = actionOptional.get();
            String opType = action.getOperationType();
            String[] payload = action.getPayload();
            if (opType.equalsIgnoreCase("ADD")) {
                return this.createNewLogArchiveConfigByAdding(payload);
            }
            if (opType.equalsIgnoreCase("REMOVE")) {
                return this.createNewLogArchiveConfigByRemoving(payload);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Result updateLogArchiveConfig(LogArchiveConfig config) {
        String sql = String.format("alter system set log_archive_config = '%s'", config);
        this.logger.log(Level.FINE, "The following sql will be executed:");
        this.logger.log(Level.FINE, "\t" + sql);
        try {
            DatabaseUtils.updateParameter(this.conn, "log_archive_config", config.toString());
        }
        catch (SQLException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.databaseSqlError(RcvMessages.getString("ERR_LOG_ARCHIVE_CONFIG_UPDATE_ERROR_MSG"));
        }
        return new Result(Status.SUCCESS);
    }

    public Optional<LogArchiveConfig> createNewLogArchiveConfigByAdding(String[] targetLogArchiveConfigs) {
        LogArchiveConfig currentLogArchiveConfig = this.getCurrentLogArchiveConfig();
        List<String> updatedDgConfigs = Stream.concat(currentLogArchiveConfig.getDgConfig().stream(), Stream.of(targetLogArchiveConfigs)).distinct().collect(Collectors.toList());
        if (updatedDgConfigs.size() != currentLogArchiveConfig.getDgConfig().size()) {
            LogArchiveConfig newLogArchiveConfig = new LogArchiveConfig(currentLogArchiveConfig);
            newLogArchiveConfig.setDgConfig(updatedDgConfigs);
            return Optional.of(newLogArchiveConfig);
        }
        return Optional.empty();
    }

    public Optional<LogArchiveConfig> createNewLogArchiveConfigByRemoving(String[] logArchiveConfigsToRemove) {
        LogArchiveConfig currentLogArchiveConfig = this.getCurrentLogArchiveConfig();
        List<String> updatedDgConfig = currentLogArchiveConfig.getDgConfig().stream().filter(dgConfig -> !List.of(logArchiveConfigsToRemove).contains(dgConfig)).collect(Collectors.toList());
        if (updatedDgConfig.size() != currentLogArchiveConfig.getDgConfig().size()) {
            LogArchiveConfig newConfig = new LogArchiveConfig(currentLogArchiveConfig);
            newConfig.setDgConfig(updatedDgConfig);
            return Optional.of(newConfig);
        }
        return Optional.empty();
    }

    public Result updateLogArchiveDestinations() {
        Optional<LogArchiveDestinationGroupAction> actionOptional = this.rcvConf.getActions().getLogArchiveDestinationGroupsAction();
        if (actionOptional.isPresent()) {
            LogArchiveDestinationGroupAction action = actionOptional.get();
            String opType = action.getOperationType();
            LogArchiveDestination[] destinations = (LogArchiveDestination[])action.getPayload();
            if (opType.equalsIgnoreCase("ADD")) {
                return this.addLogArchiveDestinations(destinations);
            }
            if (opType.equalsIgnoreCase("REMOVE")) {
                return this.removeLogArchiveDestinations(destinations);
            }
            return new Result(Status.SKIPPED);
        }
        return new Result(Status.SKIPPED);
    }

    /*
     * WARNING - void declaration
     */
    public Result addLogArchiveDestinations(LogArchiveDestination[] targetDestinations) {
        void var9_15;
        HashMap<Integer, LogArchiveDestination> currentDestinations = null;
        try {
            currentDestinations = this.getLogArchiveDestinationsByDestinationName(Arrays.stream(targetDestinations).map(LogArchiveDestination::getService).collect(Collectors.toList()));
        }
        catch (SQLException e) {
            throw Result.errInitLogDestDbException(e);
        }
        List<Object> freeDestinations = new ArrayList();
        int freeDestinationIndex = 0;
        HashMap<String, String> updatedParameters = new HashMap<String, String>();
        try {
            freeDestinations = DatabaseUtils.getFreeLogArchiveDestinations(this.conn);
        }
        catch (SQLException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_FREE_ERROR_MSG", new Object[0]));
        }
        ArrayList<Integer> destinationIds = new ArrayList<Integer>();
        LogArchiveDestination[] logArchiveDestinationArray = targetDestinations;
        int n = logArchiveDestinationArray.length;
        boolean bl = false;
        while (var9_15 < n) {
            LogArchiveDestination targetDest = logArchiveDestinationArray[var9_15];
            String targetDestDbUniqueName = targetDest.getDbUniqueName();
            String targetDestService = targetDest.getService();
            boolean foundTarget = false;
            for (int id : currentDestinations.keySet()) {
                LogArchiveDestination currentDest = currentDestinations.get(id);
                String currentDestDbUniqueName = currentDest.getDbUniqueName();
                String currentDestService = currentDest.getService();
                if (!currentDestDbUniqueName.equalsIgnoreCase(targetDestDbUniqueName) || !currentDestService.equalsIgnoreCase(targetDestService)) continue;
                foundTarget = true;
                destinationIds.add(id);
                if (targetDest.equals(currentDest)) break;
                String updateSql = "alter system set log_archive_dest_" + id + " = '" + targetDest.toString() + "'";
                this.logger.log(Level.FINE, "The following sql will be executed:");
                this.logger.log(Level.FINE, "\t" + updateSql + "\n");
                updatedParameters.put("log_archive_dest_" + id, targetDest.toString());
                break;
            }
            if (!foundTarget) {
                if (freeDestinationIndex < freeDestinations.size()) {
                    String freeDestination = (String)freeDestinations.get(freeDestinationIndex);
                    String sql = String.format("alter system set %s = '%s'", freeDestination, targetDest.toString());
                    this.logger.log(Level.FINE, "The following sql will be executed:");
                    this.logger.log(Level.FINE, "\t" + sql + "\n");
                    ++freeDestinationIndex;
                    int ui = freeDestination.lastIndexOf("_");
                    if (ui >= 0) {
                        destinationIds.add(Integer.parseInt(freeDestination.substring(ui + 1)));
                    }
                    updatedParameters.put(freeDestination, targetDest.toString());
                } else {
                    String error = "There are not enough free log archive destinations left to configure real-time redo log shipping to the Recovery Service.Please remove existing log archive destinations to free them up. You can view the list of log archive destinations by running 'show parameter log_archive_dest'";
                    throw new RuntimeException(error);
                }
            }
            ++var9_15;
        }
        HashMap<Object, Object> destinationStates = new HashMap();
        try {
            destinationStates = DatabaseUtils.getLogArchiveDestinationState(this.conn, destinationIds);
        }
        catch (SQLException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_STATE_ERROR_MSG", destinationIds));
        }
        for (String string : destinationStates.keySet()) {
            if (((String)destinationStates.get(string)).equalsIgnoreCase("ENABLE")) continue;
            this.logger.log(Level.FINE, "The following sql will be executed:");
            String sql = String.format("alter system set parameter %s = '%s'", string, "enable");
            this.logger.log(Level.FINE, "\t" + sql + "\n");
            updatedParameters.put(string, "enable");
        }
        if (!updatedParameters.keySet().isEmpty()) {
            try {
                DatabaseUtils.updateParameter(this.conn, updatedParameters);
            }
            catch (SQLException e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.databaseSqlError(RcvMessages.format("ERR_CONF_LOG_DEST_UPDATE_ERROR_MSG", destinationIds));
            }
            return new Result(Status.SUCCESS);
        }
        return new Result(Status.SKIPPED);
    }

    public Result removeLogArchiveDestinations(LogArchiveDestination[] destinationsToRemove) {
        List<String> dbrsDgConfig = Stream.of(destinationsToRemove).map(LogArchiveDestination::getDbUniqueName).collect(Collectors.toList());
        HashMap<String, String> updatedParameters = new HashMap<String, String>();
        try {
            ResultSet rs = DatabaseUtils.getLogArchiveDestinations(this.conn, dbrsDgConfig);
            if (rs != null) {
                while (rs.next()) {
                    updatedParameters.put(rs.getString("DEST_NAME"), "");
                }
            }
        }
        catch (SQLException e) {
            Workflow.logException(e, this.logger.getLogger());
            return Result.databaseSqlError(RcvMessages.format("DRR_LOG_DEST_GET_ERROR_MSG", new Object[0]));
        }
        if (!updatedParameters.keySet().isEmpty()) {
            try {
                DatabaseUtils.updateParameter(this.conn, updatedParameters);
            }
            catch (SQLException e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.databaseSqlError(RcvMessages.format("DRR_LOG_DEST_UPDATE_ERROR_MSG", new Object[0]));
            }
        } else {
            return new Result(Status.SKIPPED);
        }
        return new Result(Status.SUCCESS);
    }

    private HashMap<Integer, LogArchiveDestination> getLogArchiveDestinationsByDestinationName(List<String> destinationNames) throws SQLException {
        ResultSet rs = DatabaseUtils.getLogArchiveDestinations(this.conn, destinationNames);
        ArrayList<String> logArchiveDestinationParameters = new ArrayList<String>();
        HashMap<Integer, LogArchiveDestination> destinations = new HashMap<Integer, LogArchiveDestination>();
        if (rs != null) {
            while (rs.next()) {
                int destId = rs.getInt("DEST_ID");
                logArchiveDestinationParameters.add("log_archive_dest_" + destId);
            }
            HashMap<String, String> logArchiveDestinationMap = DatabaseUtils.getParameters(this.conn, logArchiveDestinationParameters);
            for (String parameterName : logArchiveDestinationMap.keySet()) {
                String destinationValue = logArchiveDestinationMap.get(parameterName);
                int i = (parameterName = parameterName.trim()).lastIndexOf("_");
                if (i == -1) continue;
                int id = Integer.parseInt(parameterName.substring(i + 1));
                destinations.put(id, LogArchiveDestination.createInstance(destinationValue));
            }
        }
        return destinations;
    }
}

