/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows.addprotecteddatabase;

import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.GlobalMetadata;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.LogManager;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.AddSysbackupUserWorkflow;
import oracle.dbtools.extension.rcv.workflows.ConfigureAuthenticationWorkflow;
import oracle.dbtools.extension.rcv.workflows.EnableRealtimeRedoWorkflow;
import oracle.dbtools.extension.rcv.workflows.FileLocker;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.RunChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.AutoDiscoverDatabasesUtils;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.BackupControlFileStep;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.CommandLineInput;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.ConfigureRMANStep;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.InputConfig;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.OnboardDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.RegisterDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.ScheduleTasksStep;
import oracle.dbtools.extension.rcv.workflows.addprotecteddatabase.UserDefinedInput;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateZRCVConfigurationWorkflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.utils.TNSHelper;

public class AddDatabaseWorkflow
extends Workflow {
    private ParsedCommand command;
    private GlobalMetadata globalMetadata = GlobalMetadata.load();
    private List<Connection> dbConnections = new ArrayList<Connection>();
    private HashSet<String> remoteNodes = new HashSet();
    private boolean onboardMultipleDatabases;

    public AddDatabaseWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_DATABASE, conn, ctx);
        this.command = command;
        this.onboardMultipleDatabases = command.isFlagSet((Id)RCVOptions.Options.AUTO_DISCOVER) || command.getOptionValue((Id)RCVOptions.Options.CONFIG) != null || command.isFlagSet((Id)RCVOptions.Options.GENERATE_CONFIG_ONLY);
    }

    @Override
    public Result run() {
        WorkflowLogger logger = this.getWorkflowLogger();
        this.checkOptions();
        Connection conn = this.getConnection();
        if (!this.onboardMultipleDatabases && !RCVCommandBase.isSysBackupConnection(conn)) {
            throw Result.invalidOptionException("You must either login to a database as a user with sysbackup privilege, use the -auto_discover flag to automatically register all databases to the Recovery Service, or use -config option to provide a JSON file with a list of databases you want to register to the Recovery Service.");
        }
        if (this.onboardMultipleDatabases) {
            String configFile = (String)this.command.getOptionValue((Id)RCVOptions.Options.CONFIG);
            if (configFile != null) {
                List<InputConfig> inputConfigs = InputConfig.load(configFile);
                for (InputConfig inputConfig : inputConfigs) {
                    Result result = AddSysbackupUserWorkflow.createSysbackupUser(inputConfig, logger.getLogger());
                    if (!result.getStatus().equals((Object)Status.FAILED)) continue;
                    return result;
                }
                return this.addMultipleDatabases(inputConfigs);
            }
            String oracleHome = (String)this.command.getOptionValue((Id)RCVOptions.Options.ORACLE_HOME);
            if (oracleHome == null && (oracleHome = TNSHelper.getOracleHome()) == null) {
                throw Result.missingOptionException("Please provide the path to an oracle home using -" + String.valueOf((Object)RCVOptions.Options.ORACLE_HOME));
            }
            List<DatabaseConfig> databaseConfigs = DatabaseConfig.getAll(oracleHome);
            if (databaseConfigs.isEmpty()) {
                return new Result(Status.SKIPPED, "Could not find any databases on the system.");
            }
            if (databaseConfigs.size() > 1 && this.command.getOptionValue((Id)RCVOptions.Options.DATABASE_ID) != null) {
                String error = String.format("-%s cannot be specified when onboarding multiple databases. Please remove this option and rerun the command.", new Object[]{RCVOptions.Options.DATABASE_ID});
                throw Result.invalidOptionException(error);
            }
            if (this.command.isFlagSet((Id)RCVOptions.Options.GENERATE_CONFIG_ONLY)) {
                CommandLineInput input = new CommandLineInput(this.command);
                List<InputConfig> inputConfigs = AutoDiscoverDatabasesUtils.generateInputConfigs(databaseConfigs, input);
                String jsonFile = String.join((CharSequence)File.separator, RCVCommandBase.getAgentBaseDirectory(), "add_database." + ProcessHandle.current().pid() + ".json");
                InputConfig.write(inputConfigs, jsonFile);
                logger.log(Level.INFO, "Created config JSON " + jsonFile);
                logger.log(Level.INFO, "You can onboard the databases in the JSON to the Recovery Service by running 'rcv add database -config " + jsonFile + "'");
                return new Result(Status.SUCCESS);
            }
            logger.log(Level.INFO, "The following databases will be added:");
            for (DatabaseConfig db : databaseConfigs) {
                logger.log(Level.INFO, "\t" + db.getDbUniqueName());
                logger.log(Level.INFO, "\tOracle Home: " + db.getOracleHome());
                logger.log(Level.INFO, "\tOracle SID: " + db.getOracleSid());
                logger.log(Level.INFO, "");
            }
            boolean add = Utils.confirm("Do you want to proceed with onboarding these databases to the Recovery Service? (yes/no)? ");
            if (add) {
                CommandLineInput input = new CommandLineInput(this.command);
                List<InputConfig> inputConfigs = AutoDiscoverDatabasesUtils.generateInputConfigs(databaseConfigs, input);
                for (DatabaseConfig dbConfig : databaseConfigs) {
                    Result result = AddSysbackupUserWorkflow.createSysbackupUser(dbConfig, logger.getLogger());
                    if (!result.getStatus().equals((Object)Status.FAILED)) continue;
                    return result;
                }
                return this.addMultipleDatabases(inputConfigs);
            }
            logger.log(Level.INFO, "User chose not to proceed. Exiting...");
            return new Result(Status.SKIPPED);
        }
        Database db = RCVCommandBase.getDatabase(conn);
        db.getDatabaseMetadataCache().getSshConnections(logger.getLogger());
        CommandLineInput input = new CommandLineInput(this.command);
        return this.addSingleDatabaseWithLock(input, conn, logger);
    }

    private void checkOptions() {
        String config = (String)this.command.getOptionValue((Id)RCVOptions.Options.CONFIG);
        if (config == null) {
            if (this.command.getOptionValue((Id)RCVOptions.Options.RECOVERY_SERVICE_SUBNETS) == null) {
                throw Result.missingOptionException(RcvMessages.format("WF_MISSING_REQUIRED_OPTION", RCVOptions.Options.RECOVERY_SERVICE_SUBNETS.getName().toLowerCase()));
            }
        } else {
            if (this.command.isFlagSet((Id)RCVOptions.Options.AUTO_DISCOVER)) {
                throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE3", RCVOptions.Options.CONFIG.getName().toLowerCase(), RCVOptions.Options.AUTO_DISCOVER.getName().toLowerCase()));
            }
            if (this.command.isFlagSet((Id)RCVOptions.Options.GENERATE_CONFIG_ONLY)) {
                throw Result.invalidOptionException(RcvMessages.format("WF_INVALID_MUTUALLY_EXCLUSIVE3", RCVOptions.Options.CONFIG.getName().toLowerCase(), RCVOptions.Options.GENERATE_CONFIG_ONLY.getName().toLowerCase()));
            }
        }
    }

    private Result addSingleDatabaseWithLock(UserDefinedInput input, Connection conn, WorkflowLogger logger) {
        String dbUniqueName = RCVCommandBase.getDbUniqueName(conn);
        FileLocker fl = new FileLocker(String.join((CharSequence)File.separator, FleetAgentContext.get(dbUniqueName).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.ADD_DATABASE) + ".lock"), 0);
        Optional<Result> resultOptional = fl.execute(() -> this.addSingleDatabase(input, conn, logger), otherPid -> {
            String message = String.format("Another process %d is already onboarding database %s. Exiting.", otherPid, dbUniqueName);
            logger.log(Level.INFO, message);
        });
        return resultOptional.orElseGet(() -> new Result(Status.SKIPPED, "There is another process onboarding this database."));
    }

    private Result addSingleDatabase(UserDefinedInput input, Connection conn, WorkflowLogger logger) {
        Objects.requireNonNull(conn, "connection object must not be null.");
        this.setLogger(logger);
        this.validateCache(conn);
        this.saveEndpoint(input, conn);
        this.checkAndSaveSbtLibrary(input, conn);
        this.dbConnections.add(conn);
        Database db = RCVCommandBase.getDatabase(conn);
        List<SshHelper> sshConnections = db.getDatabaseMetadataCache().getSshConnections();
        for (SshHelper sshConnection : sshConnections) {
            String remoteNode = sshConnection.getHost();
            if (this.remoteNodes.contains(remoteNode)) continue;
            ConfigureAuthenticationWorkflow.copyAuthenticationFilesToRemoteNode(sshConnection);
            this.remoteNodes.add(remoteNode);
        }
        List<Step> steps = this.generateSteps(conn, input);
        this.setSteps(steps);
        return super.run(true);
    }

    private Result addMultipleDatabases(List<InputConfig> inputConfigs) {
        Optional<Connection> sysbackupConnOptional;
        String connectionName;
        String commonLogFile = LogManager.getLogFile(String.valueOf((Object)RCVCommand.SubCommand.ADD_DATABASE));
        WorkflowLogger commonLogger = LogManager.getLogger(commonLogFile);
        ArrayList<String> failedDatabases = new ArrayList<String>();
        char[] vpcPassword = CommandLineInput.getPassword(this.command);
        for (InputConfig config : inputConfigs) {
            connectionName = FleetAgentContext.getConnectionName(config.getDbUniqueName());
            sysbackupConnOptional = NamedConnectionsManager.getConnection(connectionName);
            if (!sysbackupConnOptional.isPresent() || RCVCommandBase.getDatabase(sysbackupConnOptional.get()).getOcid() != null || config.getPassword() != null) continue;
            config.setPassword(vpcPassword);
            Database db = RCVCommandBase.getDatabase(sysbackupConnOptional.get());
            db.getDatabaseMetadataCache().getSshConnections(commonLogger.getLogger());
        }
        for (InputConfig config : inputConfigs) {
            connectionName = FleetAgentContext.getConnectionName(config.getDbUniqueName());
            sysbackupConnOptional = NamedConnectionsManager.getConnection(connectionName);
            if (sysbackupConnOptional.isPresent()) {
                Connection sysbackupConn = sysbackupConnOptional.get();
                commonLogger.log(Level.INFO, "Onboarding database " + config.getDbUniqueName());
                if (config.getSbtLibrary() == null) {
                    commonLogger.log(Level.INFO, "Failed to onboard " + config.getDbUniqueName() + ", failed to find libra.so, please provide it in the config JSON.");
                    failedDatabases.add(config.getDbUniqueName());
                    continue;
                }
                String logFile = LogManager.getLogFile(String.valueOf((Object)RCVCommand.SubCommand.ADD_DATABASE), config.getDbUniqueName());
                WorkflowLogger dbWfLogger = LogManager.getLogger(logFile);
                commonLogger.log(Level.FINE, "Log file: " + logFile);
                Result addDbResult = this.addSingleDatabaseWithLock(config, sysbackupConn, dbWfLogger);
                if (addDbResult.getStatus().equals((Object)Status.FAILED) || addDbResult.getStatus().equals((Object)Status.TIMED_OUT)) {
                    failedDatabases.add(config.getDbUniqueName());
                    if (addDbResult.getMessage() != null) {
                        dbWfLogger.log(Level.INFO, addDbResult.getMessage());
                    }
                } else if (addDbResult.getStatus().equals((Object)Status.SKIPPED)) {
                    commonLogger.log(Level.INFO, Status.SKIPPED.toString());
                }
                commonLogger.log(Level.INFO, String.valueOf('=').repeat(70));
                continue;
            }
            failedDatabases.add(config.getDbUniqueName());
            commonLogger.log(Level.FINE, "Failed to get a sysbackup connection for " + config.getDbUniqueName());
        }
        if (!failedDatabases.isEmpty()) {
            commonLogger.log(Level.FINE, "Failed to onboard the following databases to Recovery Service: " + String.join((CharSequence)", ", failedDatabases));
            return new Result(Status.FAILED, "Failed to onboard some databases to Recovery Service. See " + commonLogger.getLogFile() + " for details.");
        }
        return new Result(Status.SUCCESS);
    }

    private void validateCache(Connection conn) {
        Objects.requireNonNull(conn);
        Database db = RCVCommandBase.getDatabase(conn);
        ProtectedDatabaseCache cache = db.getFleetAgentContext().getProtectedDatabaseCache();
        if (db.getOcid() != null) {
            RecoveryClientManager recoveryClientManager;
            ProtectedDatabase protectedDatabase;
            LifecycleState lifecycleState;
            String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
            if (endpoint == null) {
                endpoint = cache.getEndpoint();
            }
            if ((lifecycleState = (protectedDatabase = (recoveryClientManager = new RecoveryClientManager(endpoint, this.getWorkflowLogger().getLogger())).getProtectedDatabase(db.getOcid())).getLifecycleState()).equals((Object)LifecycleState.Deleted) || lifecycleState.equals((Object)LifecycleState.Deleting)) {
                cache.clearCache();
            }
        }
    }

    private void saveEndpoint(UserDefinedInput input, Connection conn) {
        if (input.getEndpoint() != null) {
            Database db = RCVCommandBase.getDatabase(conn);
            ProtectedDatabaseCache cache = db.getFleetAgentContext().getProtectedDatabaseCache();
            cache.setEndpoint(input.getEndpoint());
        }
    }

    private List<Step> generateSteps(Connection conn, UserDefinedInput userDefinedInput) {
        WorkflowLogger logger = this.getWorkflowLogger();
        Database database = RCVCommandBase.getDatabase(conn);
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new RunChecksStep(conn, logger, this.getContext()));
        steps.add(new CreateMetadataDirectoryStep(database.getDbUniqueName(), logger));
        steps.add(new OnboardDatabaseStep(conn, userDefinedInput, logger));
        if (!this.command.isFlagSet((Id)RCVOptions.Options.VALIDATE)) {
            UpdateZRCVConfigurationWorkflow updateConfigWf = new UpdateZRCVConfigurationWorkflow(conn, this.getContext());
            updateConfigWf.setLogger(logger);
            steps.add(() -> {
                logger.log(Level.INFO, "Updating client configuration");
                return updateConfigWf.runWithLock(false);
            });
            steps.add(new RegisterDatabaseStep(database, logger));
            steps.add(new ConfigureRMANStep(conn, logger));
            steps.add(new BackupControlFileStep(database, logger));
            steps.add(new SaveMetadata(conn, logger));
            steps.add(new ScheduleTasksStep(conn, logger, this.getContext()));
            if (this.command.isFlagSet((Id)RCVOptions.Options.REALTIME_REDO)) {
                EnableRealtimeRedoWorkflow enableRealtimeRedoWf = new EnableRealtimeRedoWorkflow(false, conn, this.getContext());
                enableRealtimeRedoWf.setLogger(logger);
                steps.add(() -> enableRealtimeRedoWf.runWithLock(false));
            }
        }
        return steps;
    }

    @Override
    public void handleFailure() {
        if (this.dbConnections != null && !this.dbConnections.isEmpty()) {
            for (Connection conn : this.dbConnections) {
                Database database = RCVCommandBase.getDatabase(conn);
                ProtectedDatabaseCache protectedDatabaseCache = database.getFleetAgentContext().getProtectedDatabaseCache();
                if (protectedDatabaseCache == null) continue;
                try {
                    protectedDatabaseCache.save();
                }
                catch (Exception e) {
                    this.getWorkflowLogger().log(Level.SEVERE, "Failed to save database metadata: " + e.getMessage());
                }
            }
        }
        if (this.globalMetadata != null) {
            try {
                this.globalMetadata.save();
            }
            catch (Exception e) {
                this.getWorkflowLogger().log(Level.SEVERE, "Failed to save global metadata: " + e.getMessage());
            }
        }
    }

    private void checkAndSaveSbtLibrary(UserDefinedInput input, Connection conn) {
        Objects.requireNonNull(conn);
        String sbtLibrary = input.getSbtLibrary();
        Database database = RCVCommandBase.getDatabase(conn);
        if (sbtLibrary == null) {
            Optional<String> defaultSbtLibrary = AddDatabaseWorkflow.getDefaultSbtLibrary(database.getDbUniqueName());
            if (defaultSbtLibrary.isEmpty()) {
                throw Result.missingOptionException("Please provide " + String.valueOf((Object)RCVOptions.Options.SBT_LIBRARY));
            }
            sbtLibrary = defaultSbtLibrary.get();
        }
        database.getFleetAgentContext().getProtectedDatabaseCache().setLibraLocation(sbtLibrary);
    }

    public static Optional<String> getDefaultSbtLibrary(String dbUniqueName) {
        String defaultSbtLibrary = String.join((CharSequence)File.separator, DatabaseConfig.getOracleHome(dbUniqueName), "lib", "libra.so");
        if (Files.exists(Paths.get(defaultSbtLibrary, new String[0]), new LinkOption[0])) {
            return Optional.of(defaultSbtLibrary);
        }
        return Optional.empty();
    }

    public static class RunChecksStep
    implements Step {
        private WorkflowLogger logger;
        private Connection conn;
        private ScriptRunnerContext ctx;

        public RunChecksStep(Connection conn, WorkflowLogger logger, ScriptRunnerContext ctx) {
            this.logger = logger;
            this.conn = conn;
            this.ctx = ctx;
        }

        @Override
        public Result run() {
            this.logger.log(Level.INFO, "Running prechecks");
            Database database = RCVCommandBase.getDatabase(this.conn);
            if (database.getOcid() == null) {
                RunChecksWorkflow runChecksWorkflow = new RunChecksWorkflow(Group.ONBOARDING_PRECHECKS, this.conn, this.ctx);
                runChecksWorkflow.setLogger(this.logger);
                List<Check> checks = runChecksWorkflow.getChecks();
                boolean ok = runChecksWorkflow.runChecks(checks);
                if (ok) {
                    return new Result(Status.SUCCESS);
                }
                return Result.chwChecksError();
            }
            return new Result(Status.SKIPPED, "Prechecks - Skipped. Database is already onboarded");
        }
    }

    public static class CreateMetadataDirectoryStep
    implements Step {
        private String dbUniqueName;
        private WorkflowLogger logger;

        public CreateMetadataDirectoryStep(String dbUniqueName, WorkflowLogger logger) {
            this.dbUniqueName = dbUniqueName;
            this.logger = logger;
        }

        @Override
        public Result run() {
            this.logger.log(Level.INFO, "Initializing metadata directory");
            boolean updated = false;
            try {
                updated = FleetAgentContext.createDatabaseDirectory(this.dbUniqueName);
            }
            catch (IOException e) {
                throw Result.apdMetadataInit3Exception("Failed to create metadata directory: " + e.getMessage());
            }
            return updated ? new Result(Status.SUCCESS) : new Result(Status.SKIPPED);
        }
    }

    public static class SaveMetadata
    implements Step {
        private Connection conn;
        private WorkflowLogger logger;

        public SaveMetadata(Connection conn, WorkflowLogger logger) {
            this.conn = conn;
            this.logger = logger;
        }

        @Override
        public Result run() {
            this.logger.log(Level.INFO, "Saving metadata");
            Database database = RCVCommandBase.getDatabase(this.conn);
            List<SshHelper> sshConnections = database.getDatabaseMetadataCache().getSshConnections(this.logger.getLogger());
            ProtectedDatabaseCache protectedDatabaseCache = database.getFleetAgentContext().getProtectedDatabaseCache();
            try {
                protectedDatabaseCache.save();
            }
            catch (Exception e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.apdSaveMetadataError("protected database");
            }
            try {
                GlobalMetadata.load().save();
            }
            catch (Exception e) {
                Workflow.logException(e, this.logger.getLogger());
                return Result.apdSaveMetadataError("global");
            }
            if (sshConnections.isEmpty()) {
                return new Result(Status.SKIPPED);
            }
            ArrayList<String> files = new ArrayList<String>();
            files.add(protectedDatabaseCache.getMetadataFile());
            files.add(protectedDatabaseCache.getWalletLocation());
            String globalMetadataDirectory = RCVCommandBase.getGlobalMetadataDirectory();
            if (globalMetadataDirectory != null) {
                files.add(RCVCommandBase.getGlobalMetadataDirectory());
            }
            for (SshHelper sshConnection : sshConnections) {
                for (String f : files) {
                    sshConnection.copy(f, f);
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

