/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.sql.Connection;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class ProtectedDatabaseWorkflow
extends Workflow {
    public static boolean REQUIRES_CONNECTION = true;
    private String dbUniqueName;
    private Database database;
    private Connection conn;

    public ProtectedDatabaseWorkflow(RCVCommand.SubCommand rcvCommand, Connection conn, ScriptRunnerContext ctx) {
        super(rcvCommand, conn, ctx);
        this.conn = conn;
        this.database = RCVCommandBase.getDatabase(conn);
        this.dbUniqueName = this.database.getDbUniqueName();
    }

    public String getDbUniqueName() {
        return RCVCommandBase.getDbUniqueName(this.conn);
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getProtectedDatabaseOcid() {
        return this.database.getOcid();
    }

    public boolean isProtectedDatabaseOnboarded() {
        return this.getProtectedDatabaseOcid() != null;
    }

    @Override
    public boolean isApplicable() {
        if (!this.isProtectedDatabaseOnboarded()) {
            Result result = Result.pdDatabaseNotOnboarded(this.dbUniqueName);
            super.logResult(result);
            return false;
        }
        return true;
    }

    public void saveMetadata() {
        this.database.getFleetAgentContext().getProtectedDatabaseCache().save();
    }
}

