/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ProtectedDatabase;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.check.Check;
import oracle.dbtools.extension.rcv.check.Group;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.models.LogArchiveConfig;
import oracle.dbtools.extension.rcv.models.LogArchiveDestination;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseMetadataCache;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.models.systemcommands.SystemCommand;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.ConfigurationManager;
import oracle.dbtools.extension.rcv.utils.DatabaseUtils;
import oracle.dbtools.extension.rcv.utils.FleetEngine;
import oracle.dbtools.extension.rcv.utils.NamedConnectionsManager;
import oracle.dbtools.extension.rcv.utils.SshHelper;
import oracle.dbtools.extension.rcv.utils.TnsnamesHelper;
import oracle.dbtools.extension.rcv.utils.WalletManager;
import oracle.dbtools.extension.rcv.workflows.ConfigureRMANWorkflow;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.RunChecksWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.extension.rcv.workflows.configureeprotecteddatabase.UpdateProtectedDatabaseStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateConfigurationStep;
import oracle.dbtools.extension.rcv.workflows.updateconfiguration.UpdateLogArchiveDestinationsStep;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.security.pki.OracleWallet;

public class EnableRealtimeRedoWorkflow
extends ProtectedDatabaseWorkflow {
    private Connection conn;
    private ScriptRunnerContext ctx;
    private WorkflowLogger logger;
    private ProtectedDatabase protectedDatabase;
    private boolean restartDatabase = false;
    private RecoveryClientManager recoveryClientManager;
    private String walletRoot;
    private boolean localOnly;
    private List<SshHelper> sshConnections = new ArrayList<SshHelper>();
    private String dbUniqueName;
    private Database database;
    private ProtectedDatabaseCache protectedDatabaseCache;
    private boolean commandEngineUpdated = false;

    public EnableRealtimeRedoWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        this(command.isFlagSet((Id)RCVOptions.Options.LOCAL), conn, ctx);
    }

    public EnableRealtimeRedoWorkflow(boolean local, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.ADD_REALTIME_REDO, conn, ctx);
        this.localOnly = local;
        this.conn = conn;
        this.ctx = ctx;
        this.logger = this.getWorkflowLogger();
        ArrayList<Step> steps = new ArrayList<Step>();
        if (!this.localOnly) {
            steps.add(new RunChecks());
        }
        steps.add(new ConfigureWallet());
        steps.add(new ConfigureOraFiles());
        steps.add(new VerifyConnection());
        steps.add(new ConfigureLogArchiveDestinations());
        steps.add(new ConfigureRedoTransportUser());
        if (!this.localOnly) {
            steps.add(new EnableRealtimeRedoOnRemoteNodes());
            steps.add(new UpdateRMANConfiguration());
            steps.add(new NotifyControlPlane());
            steps.add(new RestartDatabase());
        }
        super.setSteps(steps);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.ADD_REALTIME_REDO) + ".lock");
    }

    @Override
    public void initState() {
        this.database = this.getDatabase();
        this.dbUniqueName = this.getDbUniqueName();
        FleetAgentContext fleetAgentContext = this.database.getFleetAgentContext();
        this.protectedDatabaseCache = fleetAgentContext.getProtectedDatabaseCache();
        this.recoveryClientManager = new RecoveryClientManager(this.protectedDatabaseCache.getEndpoint(), this.logger.getLogger());
        this.protectedDatabase = this.recoveryClientManager.getProtectedDatabase(this.database.getOcid());
        DatabaseMetadataCache dbMetadataCache = this.database.getDatabaseMetadataCache();
        this.walletRoot = dbMetadataCache.getWalletRoot();
        this.sshConnections = dbMetadataCache.getSshConnections(this.logger.getLogger());
    }

    @Override
    public void handleFailure() {
        if (!this.commandEngineUpdated) {
            new UpdateRMANConfiguration().run();
        }
    }

    private class RunChecks
    implements Step {
        private RunChecks() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Running prechecks");
            if (DatabaseUtils.isMultitenant(EnableRealtimeRedoWorkflow.this.conn) && DatabaseUtils.isPDB(EnableRealtimeRedoWorkflow.this.conn)) {
                return Result.pdCheckPdbError();
            }
            RunChecksWorkflow runChecksWorkflow = new RunChecksWorkflow(Group.REALTIME_REDO_PRECHECKS, EnableRealtimeRedoWorkflow.this.conn, EnableRealtimeRedoWorkflow.this.ctx);
            runChecksWorkflow.setLogger(EnableRealtimeRedoWorkflow.this.logger);
            List<Check> checks = runChecksWorkflow.getChecks();
            boolean ok = runChecksWorkflow.runChecks(checks);
            if (ok) {
                return new Result(Status.SUCCESS);
            }
            return Result.chwChecksError();
        }
    }

    private class ConfigureWallet
    implements Step {
        private ConfigureWallet() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring wallet");
            String serverSeps = EnableRealtimeRedoWorkflow.this.database.getDatabaseMetadataCache().getServerSeps();
            String currentWallet = EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation();
            if (serverSeps == null) {
                return new Result(Status.FAILED, "wallet_root is not set. Please set it before proceeding with realtime-redo setup.");
            }
            Path serverSepsPath = Paths.get(serverSeps, new String[0]);
            if (!currentWallet.equals(serverSeps)) {
                Path certPath;
                if (!Files.exists(serverSepsPath, new LinkOption[0])) {
                    try {
                        Files.createDirectories(serverSepsPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        EnableRealtimeRedoWorkflow.this.logException(e);
                        return Result.fileCreateDirectoryError(RcvMessages.format("ERR_CREATE_WALLET_ERROR_MSG", serverSeps));
                    }
                }
                if (Files.exists(certPath = ConfigurationManager.getCertificatePath(EnableRealtimeRedoWorkflow.this.dbUniqueName), new LinkOption[0])) {
                    OracleWallet wallet = WalletManager.createWallet(serverSeps);
                    WalletManager.addCertificate(wallet, certPath);
                }
                WalletManager.migrateWallet(currentWallet, serverSeps);
                EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.setWalletLocation(serverSeps);
                EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.save();
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED, "server_seps wallet is already configured.");
        }
    }

    private class ConfigureOraFiles
    implements Step {
        private ConfigureOraFiles() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring sqlnet and tnsnames");
            String ocid = EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getOcid();
            String tnsAdmin = EnableRealtimeRedoWorkflow.this.database.getFleetAgentContext().getTnsAdmin();
            ConfigurationManager.downloadAndUnzipConfigBundle(EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getEndpoint(), ocid, tnsAdmin);
            UpdateConfigurationStep updateConfig = new UpdateConfigurationStep(EnableRealtimeRedoWorkflow.this.dbUniqueName, EnableRealtimeRedoWorkflow.this.getProtectedDatabaseOcid(), EnableRealtimeRedoWorkflow.this.logger);
            return updateConfig.run();
        }
    }

    private class VerifyConnection
    implements Step {
        private VerifyConnection() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Verifying connection to recovery service");
            List<LogArchiveDestination> targetDestinations = List.of(ConfigurationManager.getLogArchiveDestinationGroups(EnableRealtimeRedoWorkflow.this.dbUniqueName));
            String tnsAdmin = TnsnamesHelper.getDefaultTnsAdmin(EnableRealtimeRedoWorkflow.this.dbUniqueName);
            for (LogArchiveDestination dest : targetDestinations) {
                FleetEngine.getEngineConnection(tnsAdmin, EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation(), dest.getService());
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureLogArchiveDestinations
    implements Step {
        private ConfigureLogArchiveDestinations() {
        }

        @Override
        public Result run() {
            Result updateLADResult;
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring log archive destinations");
            UpdateLogArchiveDestinationsStep step = new UpdateLogArchiveDestinationsStep(EnableRealtimeRedoWorkflow.this.conn, EnableRealtimeRedoWorkflow.this.logger);
            Optional<LogArchiveConfig> LACOptional = step.createNewLogArchiveConfigByAdding(ConfigurationManager.getLogArchiveConfig(EnableRealtimeRedoWorkflow.this.dbUniqueName));
            if (LACOptional.isPresent()) {
                Result updateConfigResult = step.updateLogArchiveConfig(LACOptional.get());
                if (updateConfigResult.getStatus().equals((Object)Status.FAILED)) {
                    return updateConfigResult;
                }
                if (updateConfigResult.getStatus().equals((Object)Status.SUCCESS)) {
                    EnableRealtimeRedoWorkflow.this.restartDatabase = true;
                }
            }
            if ((updateLADResult = step.addLogArchiveDestinations(ConfigurationManager.getLogArchiveDestinationGroups(EnableRealtimeRedoWorkflow.this.dbUniqueName))).getStatus().equals((Object)Status.SUCCESS)) {
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
            }
            return updateLADResult;
        }
    }

    private class ConfigureRedoTransportUser
    implements Step {
        private ConfigureRedoTransportUser() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring redo transport user");
            String currentRedoTransportUser = DatabaseUtils.getRedoTransportUser(EnableRealtimeRedoWorkflow.this.conn);
            String vpcUser = EnableRealtimeRedoWorkflow.this.protectedDatabase.getVpcUserName();
            if (currentRedoTransportUser != null && currentRedoTransportUser.equals(vpcUser)) {
                return new Result(Status.SKIPPED);
            }
            if (currentRedoTransportUser != null && !currentRedoTransportUser.equals("null") && !currentRedoTransportUser.equals(vpcUser)) {
                return Result.errConfRedoUserError(currentRedoTransportUser);
            }
            if (currentRedoTransportUser == null || currentRedoTransportUser.equals("null")) {
                HashMap<String, String> updatedParameters = new HashMap<String, String>();
                updatedParameters.put("redo_transport_user", vpcUser);
                try {
                    DatabaseUtils.updateParameter(EnableRealtimeRedoWorkflow.this.conn, updatedParameters);
                }
                catch (SQLException e) {
                    EnableRealtimeRedoWorkflow.this.logException(e);
                    Result.databaseSqlError(RcvMessages.format("ERR_CONF_REDO_USER_UPDATE_ERROR_MSG", new Object[0]));
                }
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, "The following sql will be executed:");
                EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, String.format("alter system set redo_transport_user='%s'", EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getVpcUserName()));
                EnableRealtimeRedoWorkflow.this.restartDatabase = true;
                return new Result(Status.SUCCESS);
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class EnableRealtimeRedoOnRemoteNodes
    implements Step {
        private EnableRealtimeRedoOnRemoteNodes() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Enabling real-time redo on remote nodes");
            FleetAgentContext fleetAgentContext = EnableRealtimeRedoWorkflow.this.database.getFleetAgentContext();
            if (EnableRealtimeRedoWorkflow.this.sshConnections.isEmpty()) {
                return new Result(Status.SKIPPED);
            }
            String connectionName = fleetAgentContext.getConnectionName();
            NamedConnectionsManager.saveConnection(EnableRealtimeRedoWorkflow.this.conn, EnableRealtimeRedoWorkflow.this.ctx, connectionName);
            if (!EnableRealtimeRedoWorkflow.this.localOnly) {
                NamedConnectionsManager.propagateNamedConnectionToRemoteNodes(connectionName, EnableRealtimeRedoWorkflow.this.sshConnections);
                RCVCommand rcvCommand = new RCVCommand(RCVCommand.SubCommand.ADD_REALTIME_REDO).addFlag(RCVOptions.Options.LOCAL);
                for (SshHelper sshConnection : EnableRealtimeRedoWorkflow.this.sshConnections) {
                    String remoteHost = sshConnection.getHost();
                    SystemCommand.ExecutionResult remoteResult = sshConnection.executeRcvCommand(connectionName, rcvCommand, fleetAgentContext.getScriptsDirectory() + File.separator + "enable_realtime_redo.sql", DatabaseUtils.getInstanceNameForHost(EnableRealtimeRedoWorkflow.this.conn, remoteHost));
                    String output = remoteResult.getOutput();
                    if (output != null) {
                        String[] outputLines;
                        EnableRealtimeRedoWorkflow.this.logger.log(Level.FINE, output);
                        for (String line : outputLines = output.split("\n")) {
                            if (!line.toLowerCase().contains("failed")) continue;
                            return new Result(Status.FAILED, "Failed to enable real-time redo on node " + remoteHost + ". See log for details.");
                        }
                    }
                    if (remoteResult.getReturnCode() == 0) continue;
                    return Result.wfRemoteCommandError(RcvMessages.format("ERR_FAILED_ADD_REMOTE_ERROR_MSG", remoteHost));
                }
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class UpdateRMANConfiguration
    implements Step {
        private UpdateRMANConfiguration() {
        }

        @Override
        public Result run() {
            ConfigureRMANWorkflow wf = new ConfigureRMANWorkflow.Builder("wallet_location", EnableRealtimeRedoWorkflow.this.protectedDatabaseCache.getWalletLocation()).build(EnableRealtimeRedoWorkflow.this.conn);
            wf.setLogger(EnableRealtimeRedoWorkflow.this.logger);
            Result result = wf.runWithLock(false);
            EnableRealtimeRedoWorkflow.this.commandEngineUpdated = result.getStatus().equals((Object)Status.SUCCESS);
            return result;
        }
    }

    private class NotifyControlPlane
    implements Step {
        private NotifyControlPlane() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Notifying control plane");
            if (!EnableRealtimeRedoWorkflow.this.protectedDatabase.getIsRedoLogsShipped().booleanValue()) {
                String endpoint = EnableRealtimeRedoWorkflow.this.getDatabase().getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
                UpdateProtectedDatabaseStep step = new UpdateProtectedDatabaseStep(endpoint, EnableRealtimeRedoWorkflow.this.getProtectedDatabaseOcid(), EnableRealtimeRedoWorkflow.this.getWorkflowLogger()).realtimeRedo(true);
                return step.run();
            }
            return new Result(Status.SKIPPED);
        }
    }

    private class RestartDatabase
    implements Step {
        private RestartDatabase() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Checking database");
            if (EnableRealtimeRedoWorkflow.this.restartDatabase) {
                EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "!! Action Required: Please restart the database to finish enabling real-time redo !!");
            }
            return new Result(Status.SUCCESS);
        }
    }

    private class ConfigureSqlnet
    implements Step {
        private ConfigureSqlnet() {
        }

        @Override
        public Result run() {
            EnableRealtimeRedoWorkflow.this.logger.log(Level.INFO, "Configuring sqlnet");
            try {
                UpdateConfigurationStep.updateRcvSqlnetOra(EnableRealtimeRedoWorkflow.this.dbUniqueName);
            }
            catch (IOException e) {
                EnableRealtimeRedoWorkflow.this.logException(e);
                String sqlnetPath = FleetAgentContext.get(EnableRealtimeRedoWorkflow.this.dbUniqueName).getSqlnetPath();
                return Result.fileWriteError(RcvMessages.format("ERR_CONFIG_SQLNET_ERROR_MSG", sqlnetPath));
            }
            return new Result(Status.SUCCESS);
        }
    }
}

