/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.models.database.Database;
import oracle.dbtools.extension.rcv.models.database.DatabaseConfig;
import oracle.dbtools.extension.rcv.models.database.FleetAgentContext;
import oracle.dbtools.extension.rcv.models.database.ProtectedDatabaseCache;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.ProtectedDatabaseWorkflow;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.ShowRMANConfigWorkflow;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureRMANEnvWorkflow
extends ProtectedDatabaseWorkflow {
    private FleetAgentContext fleetAgentContext = FleetAgentContext.get(this.getDbUniqueName());
    ProtectedDatabaseCache metadata = this.fleetAgentContext.getProtectedDatabaseCache();

    public ConfigureRMANEnvWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_RMAN_ENV, conn, ctx);
    }

    @Override
    public String getLockFileName() {
        return String.join((CharSequence)File.separator, FleetAgentContext.get(this.getDbUniqueName()).getLocksDirectory(), String.valueOf((Object)RCVCommand.SubCommand.CONFIGURE_RMAN_ENV) + ".lock");
    }

    @Override
    public Result run(boolean verbose) {
        WorkflowLogger logger = this.getWorkflowLogger();
        String shellScript = String.join((CharSequence)File.separator, this.fleetAgentContext.getMetadataDirectory(), "rman_env", "rman_env.sh");
        String rmanScript = String.join((CharSequence)File.separator, this.fleetAgentContext.getMetadataDirectory(), "rman_env", "rcv_restore_template.rman");
        this.generateEnvironmentShellScript(shellScript);
        this.generateRMANScript(rmanScript, shellScript);
        String runRMAN = "rman target / catalog /@" + this.metadata.getCredentialAlias() + " cmdfile " + rmanScript;
        logger.log(Level.INFO, "Generated a template backup script " + rmanScript);
        logger.log(Level.INFO, "Edit the script with RMAN commands to execute.");
        logger.log(Level.INFO, "To run the script, execute the following:");
        logger.log(Level.INFO, "\tsource " + shellScript);
        logger.log(Level.INFO, "\t" + runRMAN);
        return new Result(Status.SUCCESS);
    }

    private String getEnvString() {
        return String.format("ENV=(RA_WALLET='location=file:%s credential_alias=%s', RA_FORMAT=TRUE)", this.metadata.getWalletLocation(), this.metadata.getCredentialAlias());
    }

    private void generateEnvironmentShellScript(String outputFile) {
        Database database = this.getDatabase();
        String oracleSid = database.getDatabaseMetadataCache().getOracleSid();
        String tnsAdmin = database.getFleetAgentContext().getTnsAdmin();
        String oracleHome = DatabaseConfig.getOracleHome(database.getDbUniqueName());
        CharSequence[] lines = new String[]{"export ORACLE_HOME=" + oracleHome, "export PATH=$ORACLE_HOME/bin:$PATH", "export ORACLE_SID=" + oracleSid, "export TNS_ADMIN=" + tnsAdmin};
        Utils.createParentDirectoryForFile(outputFile);
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.write(String.join((CharSequence)System.lineSeparator(), lines));
            writer.write(System.lineSeparator());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to generate shell script to configure environment to connect to the recovery catalog", e);
        }
    }

    private void generateRMANScript(String outputFile, String envSourceFile) {
        Utils.createParentDirectoryForFile(outputFile);
        Map<String, String> config = ShowRMANConfigWorkflow.getRMANConfig(this.getDbUniqueName());
        String setEncryptionAlgorithm = config.containsKey("encryption_algorithm") ? String.format("set encryption algorithm '%s';", config.get("encryption_algorithm")) : "";
        String setCompressionAlgorithm = config.containsKey("compression_algorithm") ? String.format("set compression algorithm '%s';", config.get("compression_algorithm")) : "";
        String channelName = "rcv_" + this.getDbUniqueName() + "_channel";
        String format = "rcv_%d_%U";
        String envString = this.getEnvString();
        String runRman = "rman target / catalog /@" + this.metadata.getCredentialAlias() + " cmdfile " + outputFile;
        String[] lines = new String[]{"set encryption on;", setEncryptionAlgorithm, setCompressionAlgorithm, "configure controlfile autobackup on;", "run {", String.format("allocate channel %s type SBT_TAPE format '%s' parms \"SBT_LIBRARY=%s, %s\";", channelName, format, this.metadata.getLibraLocation(), envString), "# Provide RMAN Commands Here", "# To run this script:", "# source " + envSourceFile, "# " + runRman, "}"};
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

