/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.rcv.workflows;

import com.oracle.bmc.recovery.model.ChangeProtectionPolicyCompartmentDetails;
import com.oracle.bmc.recovery.model.LifecycleState;
import com.oracle.bmc.recovery.model.ProtectionPolicy;
import com.oracle.bmc.recovery.model.UpdateProtectionPolicyDetails;
import com.oracle.bmc.recovery.requests.ChangeProtectionPolicyCompartmentRequest;
import com.oracle.bmc.recovery.requests.UpdateProtectionPolicyRequest;
import com.oracle.bmc.recovery.responses.ChangeProtectionPolicyCompartmentResponse;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import oracle.dbtools.extension.rcv.commands.RCVCommand;
import oracle.dbtools.extension.rcv.commands.RCVCommandBase;
import oracle.dbtools.extension.rcv.commands.RCVOptions;
import oracle.dbtools.extension.rcv.commands.RcvMessages;
import oracle.dbtools.extension.rcv.oci.RecoveryClientManager;
import oracle.dbtools.extension.rcv.utils.Utils;
import oracle.dbtools.extension.rcv.workflows.Result;
import oracle.dbtools.extension.rcv.workflows.Status;
import oracle.dbtools.extension.rcv.workflows.Step;
import oracle.dbtools.extension.rcv.workflows.Workflow;
import oracle.dbtools.extension.rcv.workflows.WorkflowLogger;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class ConfigureProtectionPolicyWorkflow
extends Workflow {
    private static final List<String> PROPERTIES = List.of(RCVOptions.Options.RETENTION_PERIOD.getName(), RCVOptions.Options.DISPLAY_NAME.getName(), RCVOptions.Options.COMPARTMENT_ID.getName(), RCVOptions.Options.POLICY_LOCKED_DATETIME.getName());
    private WorkflowLogger logger;
    private Connection conn;
    private RecoveryClientManager recoveryClientManager;
    private String ocid;
    private int retentionPeriod = -1;
    private String compartmentId;
    private String displayName;
    private Date policyLockedDateTime;
    private ParsedCommand command;

    public ConfigureProtectionPolicyWorkflow(ParsedCommand command, Connection conn, ScriptRunnerContext ctx) {
        super(RCVCommand.SubCommand.CONFIGURE_PROTECTION_POLICY, conn, ctx);
        this.command = command;
        this.conn = conn;
        this.logger = this.getWorkflowLogger();
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new ConfigureProtectionPolicy());
        this.setSteps(steps);
    }

    @Override
    public void initState() {
        this.ocid = (String)this.command.getOptionValue((Id)RCVOptions.Options.ID);
        String endpoint = (String)this.command.getOptionValue((Id)RCVOptions.Options.ENDPOINT);
        this.policyLockedDateTime = (Date)this.command.getOptionValue((Id)RCVOptions.Options.POLICY_LOCKED_DATETIME);
        if (this.command.getOptionValue((Id)RCVOptions.Options.RETENTION_PERIOD) != null) {
            this.retentionPeriod = (Integer)this.command.getOptionValue((Id)RCVOptions.Options.RETENTION_PERIOD);
        }
        if (this.command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME) != null) {
            this.displayName = (String)this.command.getOptionValue((Id)RCVOptions.Options.DISPLAY_NAME);
        }
        if (this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID) != null) {
            this.compartmentId = (String)this.command.getOptionValue((Id)RCVOptions.Options.COMPARTMENT_ID);
        }
        if (this.retentionPeriod == -1 && this.displayName == null && this.compartmentId == null && this.policyLockedDateTime == null) {
            throw Result.missingOptionException(RcvMessages.format("WF_MISSING_PROVIDE_AT_LEAST_ONE_2", String.join((CharSequence)", ", PROPERTIES)));
        }
        if (endpoint == null && this.conn != null) {
            endpoint = RCVCommandBase.getDatabase(this.conn).getFleetAgentContext().getProtectedDatabaseCache().getEndpoint();
        }
        this.recoveryClientManager = new RecoveryClientManager(endpoint, this.logger.getLogger());
    }

    private static UpdateProtectionPolicyRequest updateProtectionPolicyRequest(String protectionPolicyId, int retentionPeriod, String displayName, Date policyLockedDateTime) {
        UpdateProtectionPolicyDetails.Builder builder = new UpdateProtectionPolicyDetails.Builder();
        if (retentionPeriod != -1) {
            builder = builder.backupRetentionPeriodInDays(Integer.valueOf(retentionPeriod));
        }
        if (displayName != null) {
            builder = builder.displayName(displayName);
        }
        if (policyLockedDateTime != null) {
            builder = builder.policyLockedDateTime(Utils.getRFC3339Format(policyLockedDateTime));
        }
        return new UpdateProtectionPolicyRequest.Builder().body$(builder.build()).protectionPolicyId(protectionPolicyId).build();
    }

    private static ChangeProtectionPolicyCompartmentRequest changeProtectionPolicyCompartmentRequest(String protectionPolicyId, String compartmentId) {
        if (compartmentId == null) {
            return null;
        }
        ChangeProtectionPolicyCompartmentDetails details = new ChangeProtectionPolicyCompartmentDetails.Builder().compartmentId(compartmentId).build();
        return new ChangeProtectionPolicyCompartmentRequest.Builder().body$(details).protectionPolicyId(protectionPolicyId).build();
    }

    private class ConfigureProtectionPolicy
    implements Step {
        private ConfigureProtectionPolicy() {
        }

        @Override
        public Result run() {
            LifecycleState state;
            ChangeProtectionPolicyCompartmentResponse response;
            ChangeProtectionPolicyCompartmentRequest request;
            ProtectionPolicy protectionPolicy = ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicy(ConfigureProtectionPolicyWorkflow.this.ocid);
            if (protectionPolicy.getIsPredefinedPolicy().booleanValue()) {
                String error = String.format("Cannot update the specified protection policy (%s) because it is a default policy.", protectionPolicy.getDisplayName());
                return new Result(Status.FAILED, error);
            }
            if (ConfigureProtectionPolicyWorkflow.this.compartmentId != null) {
                request = ConfigureProtectionPolicyWorkflow.changeProtectionPolicyCompartmentRequest(ConfigureProtectionPolicyWorkflow.this.ocid, ConfigureProtectionPolicyWorkflow.this.compartmentId);
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.FINE, request.toString());
                response = ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.changeProtectionPolicyCompartment(request);
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.FINE, response.toString());
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.INFO, "Changing policy compartment");
                state = ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicy(ConfigureProtectionPolicyWorkflow.this.ocid).getLifecycleState());
                if (state.equals((Object)LifecycleState.Updating)) {
                    return Result.updResourceStatusTmt("protection policy", ConfigureProtectionPolicyWorkflow.this.ocid);
                }
                if (!state.equals((Object)LifecycleState.Active)) {
                    return Result.verifyLifecycleStatusError("protection policy", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Updating.getValue());
                }
            }
            if (ConfigureProtectionPolicyWorkflow.this.retentionPeriod != -1 || ConfigureProtectionPolicyWorkflow.this.displayName != null || ConfigureProtectionPolicyWorkflow.this.policyLockedDateTime != null) {
                request = ConfigureProtectionPolicyWorkflow.updateProtectionPolicyRequest(ConfigureProtectionPolicyWorkflow.this.ocid, ConfigureProtectionPolicyWorkflow.this.retentionPeriod, ConfigureProtectionPolicyWorkflow.this.displayName, ConfigureProtectionPolicyWorkflow.this.policyLockedDateTime);
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.FINE, request.toString());
                response = ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.updateProtectionPolicy((UpdateProtectionPolicyRequest)request);
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.FINE, response.toString());
                ConfigureProtectionPolicyWorkflow.this.logger.log(Level.INFO, "Waiting for policy to be updated");
                state = ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.waitForResourceUpdate(600, 20, () -> ConfigureProtectionPolicyWorkflow.this.recoveryClientManager.getProtectionPolicy(ConfigureProtectionPolicyWorkflow.this.ocid).getLifecycleState());
                if (state.equals((Object)LifecycleState.Updating)) {
                    return Result.updResourceStatusTmt("protection policy", ConfigureProtectionPolicyWorkflow.this.ocid);
                }
                if (!state.equals((Object)LifecycleState.Active)) {
                    return Result.verifyLifecycleStatusError("protection policy", state.getValue(), LifecycleState.Active.getValue(), LifecycleState.Updating.getValue());
                }
            }
            return new Result(Status.SUCCESS);
        }
    }
}

